# Use Cases - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* [**Background**](background.md)
* **Use Cases**

## Use Cases

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Although the initial focus for this implementation guide is on supporting the prior-authorization questionnaire use case, the content and guidance presented here is intended to be usable across clinical reasoning use cases with FHIR in the US Realm. Existing known use cases are documented here, and additional use cases are intended to be supported in future versions of this implementation guide, including DaVinci Clinical Data Exchange (CDeX).

* [Prior Authorization Questionnaire Use Case](use-case-pa.md)
* [Quality Measurement and Reporting](use-case-cqm.md)
* [Clinical Decision Support](use-case-cds.md)
* [Clinical Guidelines](use-case-cpg.md)
* [Public Health Case Reporting](use-case-ph.md)

For additional documentation on the CDex Attachment Use Case, see the following [Sequence Diagram](https://confluence.hl7.org/pages/viewpage.action?pageId=161060105).

