# Coverage Patterns - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* [**Authoring Documentation**](authoring.md)
* [**Patterns**](patterns.md)
* **Coverage Patterns**

## Coverage Patterns

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

USCore defines the [USCore Coverage](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-coverage.html)

### Modifier Elements

The base Coverage resource defines the following **modifier** elements:

* status

In general, applications should ensure that the `status` element for a Coverage resource is appropriately set for their use case. Note that for many applications, such as prior-authorization, Coverage resources would be expected to have a status of `active` in order to be considered.

The US Core Coverage profile does not introduce any modifier extensions.

### Search Parameters

In general, the Coverage under consideration will be established by application context, so although US Core does define search parameters for Coverage based on Patient, no special considerations are discussed here.

### Cross-Version Considerations

There are no significant backwards-compatibility issues between versions for the Coverage profile.

### Common Elements and Functions

#### Member or Subscriber ID

The USCore Coverage Profile defines a slice on identifier called `memberid` that can be used to access the patient's member id

```
define "Covered Member ID":
  Coverage.memberId()

```

In addition, the profile defines an invariant that either the `memberId` slice or `subscriberId` must be present.

