# Cumulative Medication Duration Tests - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cumulative Medication Duration Tests**

## Library: Cumulative Medication Duration Tests (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cql/Library/CumulativeMedicationDurationTests | *Version*:1.0.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:CumulativeMedicationDurationTests |

 
This library provides tests for the cumulative medication duration calculation logic for use with FHIR medication prescription, administration, and dispensing resources. 

* Metadata: Title
  * ?: Cumulative Medication Duration Tests
* Metadata: Version
  * ?: 1.0.0
* Metadata: Experimental
  * ?: true
* Metadata: Jurisdiction
  * ?: United States of America
* Metadata: Topic
  * ?: FHIR
* Metadata: Topic
  * ?: CQL
* Metadata: Topic
  * ?: Medication
* Metadata: Topic
  * ?: Cumulative Medication Duration
* Metadata: Topic
  * ?: Unit Tests
* Metadata: Steward (Publisher)
  * ?: HL7 International / Clinical Decision Support
* Metadata: Description
  * ?: This library provides tests for the cumulative medication duration calculation logic for use with FHIR medication prescription, administration, and dispensing resources.
* Metadata: Type
  * ?: logic-library from[http://terminology.hl7.org/CodeSystem/library-type](http://terminology.hl7.org/6.5.0/CodeSystem-library-type.html)
* Metadata: Dependency
  * ?: **Description**: Library FHIRHelpers**Resource**:[http://hl7.org/fhir/uv/cql/Library/FHIRHelpers|4.0.1](http://hl7.org/fhir/uv/cql/STU2/Library-FHIRHelpers.html)**Canonical URL**:http://hl7.org/fhir/uv/cql/Library/FHIRHelpers|4.0.1
* Metadata: Dependency
  * ?: **Description**: Library CMD**Resource**:[Cumulative Medication Duration](Library-CumulativeMedicationDuration.md)**Canonical URL**:http://hl7.org/fhir/us/cql/Library/CumulativeMedicationDuration
* Metadata: Data Requirement
  * ?: **Type**: MedicationRequest**Profile(s)**:[MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html)
* Metadata: Data Requirement
  * ?: **Type**: MedicationDispense**Profile(s)**:[MedicationDispense](http://hl7.org/fhir/R4/medicationdispense.html)
* Metadata: Parameters
* Metadata: 
  * ?: 
| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| **Name** | **Use** | **Card.** | **Type** | Documentation |
| Patient | Out | 0..1 | Patient |  |
| Prescriptions | Out | 0..* | MedicationRequest |  |
| Dispenses | Out | 0..* | MedicationDispense |  |
| PrescriptionPeriods | Out | 0..* | Period |  |
| DispensePeriods | Out | 0..* | Period |  |
| CumulativeDuration | Out | 0..1 | integer |  |
| CumulativeMedicationDuration | Out | 0..1 | integer |  |

* Metadata: Library Content
* Metadata: CQL Content
  * ?: ````library CumulativeMedicationDurationTests using FHIR version '4.0.1' include hl7.fhir.uv.cql.FHIRHelpers version '4.0.1' include CumulativeMedicationDuration called CMD context Patient /* # Example 1: MedicationRequest 2 tabs 3x/day #180/2 * dosage = 2 * frequency = 3x /day (i.e., repeats / period = day) * supply = 180 * daysSupplied = 30 days * refills = 2 derived daysSupplied = [supply (180) / ((dosage (2) x frequency (3))] = 30 daysSuppliedWithRefills = [supply (180) x (1 + refills (2)) / ((dosage (2) x frequency (3))] = 30 x 3 = 90 days */ /* ## Example 1a - boundsPeriod specified ## Example 1b - expectedSupplyDuration specified ## Example 1c - Calculated from dosing information */ /* # Example 2: MedicationDispense 2 tabs 3x/day #180/2* * dosage = 2 * frequency = 3x /day (i.e., repeats / period = day) * supply = 180 * daysSupplied = 30 days * refills = n/a derived daysSupplied = [supply (180) / ((dosage (2) x frequency (3))] = 30 */ /* ## Example 2a - daysSupply Specified ## Example 2b - Calculated from dosing information */ /* # Example 3: MedicationRequest ½ tab 2x/day #30/2 * dosage = 1/2 * frequency = 2x /day (i.e., repeats / period = day) * supply = 30 * daysSupplied = 30 * refills = 2 derived daysSupplied = [supply (30) / ((dosage (1/2) x frequency (2))] = 30 daysSuppliedWithRefills = [supply (30) x (1 + refills (2)) / ((dosage (1/2) x frequency (2) = 30 x 3 = 90 days */ /* ## Example 3a - boundsPeriod specified ## Example 3b - expectedSupplyDuration specified ## Example 3c - Calculated from dosing information */ /*4 # Example 4: MedicationDispense ½ tab 2x/day #30/2* * dosage = 1/2 * frequency = 2x /day (i.e., repeats / period = day) * supply = 30 * daysSupplied = 30 * refills = n/a derived daysSupplied = [supply (30) / ((dosage (1/2) x frequency (2))] = 30 */ /* ## Example 4a - daysSupply Specified ## Example 4b - Calculated from dosing information */ /* # Example 5: MedicationRequest 5 ml 3x/day #150 ml/0 * dosage = 5 ml * frequency = 3x /day (i.e., repeats / period = day) * supply = 150 ml * daysSupplied = 10 * refills = 0 derived daysSupplied = [supply (150 ml) / ((dosage (5 ml) x frequency (3)) = 10 days daysSuppliedWithRefills = [supply (150 ml) x (1 + refills (0)) / ((dosage (5 ml) x frequency (3)) = 10 days */ /* # Example 6: MedicationDispense 5 ml 3x/day #150 ml/0* * dosage = 5 ml * frequency = 3x /day (i.e., repeats / period = day) * supply = 150 ml * daysSupplied = 10 * refills = n/a * CMD calculated for “Medication, Dispensed” does not use the number of refills; rather, the days covered by each dispensing event must be retrieved and added. */ define Prescriptions: [MedicationRequest] define Dispenses: [MedicationDispense] define PrescriptionPeriods: Prescriptions P return CMD.MedicationRequestPeriod(P) define DispensePeriods: Dispenses D return CMD.MedicationDispensePeriod(D) define CumulativeDuration: CMD.CumulativeDuration(PrescriptionPeriods union DispensePeriods) // TODO: Debug this define CumulativeMedicationDuration: CMD.CumulativeMedicationDuration( Prescriptions union Dispenses )````
* Metadata: ELM XML Content
  * ?: ````Encoded data````
* Metadata: ELM JSON Content
  * ?: ````Encoded data````
* Metadata: Generated using version 0.5.3-cibuild of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "CumulativeMedicationDurationTests",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "http://hl7.org/fhir/us/cql/Library/CumulativeMedicationDurationTests",
  "version" : "1.0.0",
  "name" : "CumulativeMedicationDurationTests",
  "title" : "Cumulative Medication Duration Tests",
  "status" : "active",
  "experimental" : true,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "logic-library"
      }
    ]
  },
  "date" : "2025-10-22T20:47:38+00:00",
  "publisher" : "HL7 International / Clinical Decision Support",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss"
        }
      ]
    }
  ],
  "description" : "This library provides tests for the cumulative medication duration calculation logic for use with FHIR medication prescription, administration, and dispensing resources.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "topic" : [
    {
      "text" : "FHIR"
    },
    {
      "text" : "CQL"
    },
    {
      "text" : "Medication"
    },
    {
      "text" : "Cumulative Medication Duration"
    },
    {
      "text" : "Unit Tests"
    }
  ],
  "relatedArtifact" : [
    {
      "type" : "depends-on",
      "display" : "Library FHIRHelpers",
      "resource" : "http://hl7.org/fhir/uv/cql/Library/FHIRHelpers|4.0.1"
    },
    {
      "type" : "depends-on",
      "display" : "Library CMD",
      "resource" : "http://hl7.org/fhir/us/cql/Library/CumulativeMedicationDuration"
    }
  ],
  "parameter" : [
    {
      "name" : "Patient",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "type" : "Patient"
    },
    {
      "name" : "Prescriptions",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "type" : "MedicationRequest"
    },
    {
      "name" : "Dispenses",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "type" : "MedicationDispense"
    },
    {
      "name" : "PrescriptionPeriods",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "type" : "Period"
    },
    {
      "name" : "DispensePeriods",
      "use" : "out",
      "min" : 0,
      "max" : "*",
      "type" : "Period"
    },
    {
      "name" : "CumulativeDuration",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "type" : "integer"
    },
    {
      "name" : "CumulativeMedicationDuration",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "type" : "integer"
    }
  ],
  "dataRequirement" : [
    {
      "type" : "MedicationRequest",
      "profile" : ["http://hl7.org/fhir/StructureDefinition/MedicationRequest"]
    },
    {
      "type" : "MedicationDispense",
      "profile" : ["http://hl7.org/fhir/StructureDefinition/MedicationDispense"]
    }
  ],
  "content" : [
    {
      "contentType" : "text/cql",
      "data" : "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"
    },
    {
      "contentType" : "application/elm+xml",
      "data" : "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"
    },
    {
      "contentType" : "application/elm+json",
      "data" : "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"
    }
  ]
}

```
