# hl7.fhir.us.cql#1.0.0: Common CQL Artifacts for FHIR (US-Based)

## Pages

* [Home](index.md)
* [Architectural Guidance](architectural-guidance.md)
* [Artifacts Summary](artifacts.md)
* [Authoring Documentation](authoring.md)
* [Background](background.md)
* [Changes](changes.md)
* [Downloads](downloads.md)
* [Examples](examples.md)
* [License](license.md)
* [Allergy Patterns](patterns-allergy.md)
* [Condition Patterns](patterns-condition.md)
* [Coverage Patterns](patterns-coverage.md)
* [Lab Patterns](patterns-lab.md)
* [Medication Patterns](patterns-medication.md)
* [Overall Patterns](patterns-overall.md)
* [Patient Patterns](patterns-patient.md)
* [Service Patterns](patterns-service.md)
* [Patterns](patterns.md)
* [Query Management](query-management.md)
* [Testing](testing.md)
* [Tooling Support](tooling-support.md)
* [Usage](usage.md)
* [US Core Model Information](uscore-modelinfo.md)
* [Clinical Decision Support](use-case-cds.md)
* [Clinical Guidelines](use-case-cpg.md)
* [Quality Measurement and Reporting](use-case-cqm.md)
* [Prior Authorization Questionnaire Use Case](use-case-pa.md)
* [Public Health Case Reporting](use-case-ph.md)
* [Use Cases](use-cases.md)

## Resources

### ImplementationGuides

* [Common CQL Artifacts for FHIR (US-Based)](index.md)

### Libraries

* [Cumulative Medication Duration](Library-CumulativeMedicationDuration.md)
* [Cumulative Medication Duration Tests](Library-CumulativeMedicationDurationTests.md)
* [Expression Library for the Example Patient And Coverage Questionnaire](Library-ExamplePatientAndCoverageInitialExpressions.md)
* [Expression Library for the Genetic/Molecular testing preauthorization Example](Library-GMTPInitialExpressions.md)
* [Expression Library for the Medical Benefit Outpatient Drug Authorization Example](Library-MBODAInitialExpressions.md)
* [Expression Library for the Medical Necessity For Authorization Of Catheters Example](Library-MNACInitialExpressions.md)
* [Expression Library for the Uniform Pharmacy Prior Authorization Request Form Example](Library-UPPARFInitialExpressions.md)
* [US Core Model Information](Library-USCore-ModelInfo.md)
* [US Core Common](Library-USCoreCommon.md)
* [US Core Common Tests](Library-USCoreCommonTests.md)
* [US Core Elements](Library-USCoreElements.md)
* [US Core Tests](Library-USCoreTests.md)

### Parameters

* [manifest](Parameters-manifest.md)
* [uscore-7-0-0-modelinfo-settings](Parameters-uscore-7-0-0-modelinfo-settings.md)

### Questionnaires

* [Example Patient and Coverage Questionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md)
* [Example Genetic/Molecular Testing Preauthorization Questionnaire](Questionnaire-GMTPQuestionnaire.md)
* [Example Medical Benefit Outpatient Drug Authorization Questionnaire](Questionnaire-MBODAQuestionnaire.md)
* [Example Medical Necessity For Authorization Of Catheters Questionnaire](Questionnaire-MNACQuestionnaire.md)
* [Example Uniform Pharmacy Prior Authorization Request Form](Questionnaire-UPPARFQuestionnaire.md)
