# Home - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cql/ImplementationGuide/hl7.fhir.us.cql | *Version*:1.0.0 | |
| *IG Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 3 | *Computable Name*:CQLUSCommon |

### Introduction

This implementation guide contains architectural guidance and re-usable libraries that facilitate the use of [Clinical Quality Language (CQL)](http://cql.hl7.org) with FHIR in the US Realm, with an initial use case of Prior Authorization Support Questionnaires as described in the [DaVinci Documentation Templates and Rules (DTR)](https://hl7.org/fhir/us/davinci-dtr/) implementation guide. Much of the guidance and content presented here is built on work done in the quality measurement domain, including patterns established by measure developers as part of testing and developing quality measures for use with FHIR. These patterns have been generalized to support US Core as well as harmonized to be usable across use cases.

The content in this implementation guide is provided for reuse and proposed to help streamline implementation and development of CQL-based knowledge artifacts in the US Realm. The guidance here is published informative and the IG imposes no conformance expectations on systems that make use of it. However, the content in this implementation guide is still stable as of publication versions, and will use semantic versioning to communicate change impact across publication versions, as described in the [CRMI IG versioning](https://hl7.org/fhir/uv/crmi/artifact-lifecycle.html#artifact-versioning) topic.

### Scope of Use

This guide is a [Content Implementation Guide](https://hl7.org/fhir/uv/crmi/introduction.html#content-igs) that supports the use of CQL with FHIR in the US Realm by:

* Providing architectural guidance for the evaluation of CQL expressions in the context of artifacts such as questionnaires, quality measures, and decision support rules.
* Providing re-usable libraries of CQL expressions to retrieve data for common use cases in the US Realm
* Providing guidance for managing CQL expressions that may involve retrieval of data from multiple versions of the US Core implementation guide
* Gathering requirements for tooling to simplify the authoring of questionnaires that use CQL

The term [**artifact**](https://hl7.org/fhir/uv/crmi/index.html#artifacts) here refers to a FHIR resource that is definitional in nature or use such as a Questionnaire, or a Library (as opposed to a FHIR resource that is representing instance-specific data, such as an Observation). This implementation guide provides common artifacts that support the use of CQL with FHIR in the US Realm. The artifacts support a broad range of use cases across the healthcare domain, including prior-authorization, quality measurement and reporting, clinical decision support, computable guidelines, and public health case reporting. Any use of CQL within the US Realm could benefit from the artifacts provided here, as well as provide feedback to these artifacts, both in the form of proposed changes to existing artifacts, as well as proposing new artifacts that could be re-used across use cases.

Providing standardized CQL libraries will reduce burden by establishing best practices and reusable expressions for common questions across questionnaires, both currently and into the future. As well, these shared CQL artifacts will support a user with deep clinical knowledge but limited technical knowledge to be able to build and maintain CQL-based questionnaires. Open questionnaire authoring environments (i.e., LHC forms builder) exist and will enable the growth of CQL artifacts (see the [Tooling Support](tooling-support.md) page for further discussion).

> NOTE: Although the current guidance has been developed based on the prior-authorization questionnaires as the first use case, the intent is to capture common patterns, guidance, and artifacts that are usable across use-cases.

The artifacts provided by this implementation guide fall into three general categories:

1. Common CQL: Libraries of re-usable CQL expressions, such as US Core Common and US Core Elements, that are intended to be used in production systems as shared artifacts
1. Example Artifacts: Example content, such as the example Questionnaires, that are intended to illustrate how the shared artifacts may be used
1. Tests: Test content that demonstrates expected behavior of the CQL and Example artifacts

#### Out of Scope

This implementation guide does not:

* Define or mandate the use of any particular subsets of CQL
* Define functions for the retrieval of simple elements from already retrieved FHIR resources (e.g. Patient.birthDate)
* Define expectations for certification that require the use of any of the helper libraries provided in this implementation guide

### How to Read This Guide

#### Target Audiences

This implementation guide is targeted at two main audiences:

* **Authors**: Persons involved in the development of CQL-based FHIR Knowledge Artifacts that are authoring CQL, either directly or with tooling assistance
* **Integrators**: Persons involved in the development of systems that support authoring, publishing, distributing, and implementing CQL-based FHIR Knowledge Artifacts

This Guide is divided into several pages which are listed at the top of each page in the menu bar:

* **[Home](index.md)**
* **Background** 
* **[Background](background.md)**
* **[Use Cases](use-cases.md)**
 
* **Guidance** 
* **[Architectural Guidance](architectural-guidance.md)**
* **[Query Management](query-management.md)**
* **[Testing](testing.md)**
 
* **Authoring** 
* **[Authoring](authoring.md)**
* **[Patterns](patterns.md)**
* **[Examples](examples.md)**
* **[Usage](usage.md)**
* **[Tooling Support](tooling-support.md)**
 
* **CQL Artifacts** 
* **[US Core Common](Library-USCoreCommon.md)**
* **[US Core Elements](Library-USCoreElements.md)**
* **[US Core Model Information](uscore-modelinfo.md)**
* **[Cumulative Medication Duration](Library-CumulativeMedicationDuration.md)**
 
* **[FHIR Artifacts](artifacts.md)**
* **Support** 
* **[Downloads](downloads.md)**
* **[License](license.md)**
 
* **[Changes](changes.md)**

> NOTE: This implementation guide is informative, and therefore does not include a "Specification" topic like many other implementation guides do.

### Roadmap

Implementers of this content are encouraged to provide feedback through the usual mechanisms for feedback on HL7 FHIR Implementation Guides, by submitting an [issue](https://jira.hl7.org/secure/CreateIssueDetails!init.jspa?pid=10405&issuetype=10600&customfield_11302=FHIR-us-cql). To see the current status of the feedback for this specification, see the [US CQL Specification Dashboard](https://jira.hl7.org/secure/Dashboard.jspa?selectPageId=17807). For more information on how to submit feedback, refer to the [Specification Feedback](https://confluence.hl7.org/spaces/HL7/pages/19136736/Specification+Feedback) page in the HL7 confluence.

Feedback submitted to this implementation guide is discussed and resolved in the [Clinical Decision Support](https://confluence.hl7.org/spaces/CDS/pages/40742690/Meeting+Index) weekly meeting.

This implementation guide will be published for a two-year implementation period, during which time we will seek implementer feedback, applying as needed. The next ballot of this material will take place when the community indicates sufficient feedback and/or need for an updated release.

### Acknowledgements

This Implementation Guide was made possible by the thoughtful contributions of the following people and organizations:

* [The DaVinci Project Member Organizations](https://www.hl7.org/about/davinci/index.cfm?ref=common)
* Raj Godavarthi, MCG Health
* Mike Gould, Zeomega
* Yan Heras, Optimum eHealth
* Kyle Johnsen, Epic
* Crystal Kallem, Point of Care Partners
* Lloyd McKenzie, Dogwood Consulting
* Viet Nguyen, HL7
* Rob Reynolds, Smile Digital Health
* Brenin Rhodes, Smile Digital Health
* Bryn Rhodes, Smile Digital Health
* Raleigh Thompson, Smile Digital Health

### Dependencies

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.cql.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.cql.r4b)](package.r4b.tgz) are available.

### Global Profiles

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [CQLUSCommon](index.md), [CumulativeMedicationDuration](Library-CumulativeMedicationDuration.md)...Show 16 more,[CumulativeMedicationDurationTests](Library-CumulativeMedicationDurationTests.md),[ExamplePatientAndCoverageInitialExpressions](Library-ExamplePatientAndCoverageInitialExpressions.md),[ExamplePatientAndCoverageQuestionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md),[GMTPInitialExpressions](Library-GMTPInitialExpressions.md),[GMTPQuestionnaire](Questionnaire-GMTPQuestionnaire.md),[MBODAInitialExpressions](Library-MBODAInitialExpressions.md),[MBODAQuestionnaire](Questionnaire-MBODAQuestionnaire.md),[MNACInitialExpressions](Library-MNACInitialExpressions.md),[MNACQuestionnaire](Questionnaire-MNACQuestionnaire.md),[UPPARFInitialExpressions](Library-UPPARFInitialExpressions.md),[UPPARFQuestionnaire](Questionnaire-UPPARFQuestionnaire.md),[USCore](Library-USCore-ModelInfo.md),[USCoreCommon](Library-USCoreCommon.md),[USCoreCommonTests](Library-USCoreCommonTests.md),[USCoreElements](Library-USCoreElements.md)and[USCoreTests](Library-USCoreTests.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [MBODAQuestionnaire](Questionnaire-MBODAQuestionnaire.md) and [MNACQuestionnaire](Questionnaire-MNACQuestionnaire.md)


* These codes are excerpted from ASTM Standard, E1762-95(2013) - Standard Guide for Electronic Authentication of Health Care Information, Copyright by ASTM International, 100 Barr Harbor Drive, West Conshohocken, PA 19428. Copies of this standard are available through the ASTM Web Site at www.astm.org.

* [Signature Type Codes](http://hl7.org/fhir/R4/codesystem-signature-type.html): [MBODAQuestionnaire](Questionnaire-MBODAQuestionnaire.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [USCoreElements](Library-USCoreElements.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [DataAbsentReason](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html): [ExamplePatientAndCoverageQuestionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md)
* [LibraryType](http://terminology.hl7.org/6.5.0/CodeSystem-library-type.html): [CumulativeMedicationDuration](Library-CumulativeMedicationDuration.md), [CumulativeMedicationDurationTests](Library-CumulativeMedicationDurationTests.md)...Show 10 more,[ExamplePatientAndCoverageInitialExpressions](Library-ExamplePatientAndCoverageInitialExpressions.md),[GMTPInitialExpressions](Library-GMTPInitialExpressions.md),[MBODAInitialExpressions](Library-MBODAInitialExpressions.md),[MNACInitialExpressions](Library-MNACInitialExpressions.md),[UPPARFInitialExpressions](Library-UPPARFInitialExpressions.md),[USCore](Library-USCore-ModelInfo.md),[USCoreCommon](Library-USCoreCommon.md),[USCoreCommonTests](Library-USCoreCommonTests.md),[USCoreElements](Library-USCoreElements.md)and[USCoreTests](Library-USCoreTests.md)
* [AdministrativeGender](http://terminology.hl7.org/6.5.0/CodeSystem-v3-AdministrativeGender.html): [ExamplePatientAndCoverageQuestionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md)
* [NullFlavor](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html): [ExamplePatientAndCoverageQuestionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md)


Many of the examples in this implementation guide are informed by prior-authorization forms freely available on the internet and used with permission.

