# Background - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* **Background**

## Background

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Medical evidence-based guidelines and payer policies each have consistencies across healthcare that are opportunities to standardize, streamline, and scale for efficiency. As an example to illustrate, medical guidelines and payer policies may require that radiographs be obtained before CT or MRI imaging that may provide necessary additional detail appropriate to diagnosis and treatment. Providers or payers with the necessity to have CT or MRI imaging performed for a patient may launch queries to ensure prerequisite radiographs were performed and what the impressions or findings were. Actors launching such queries may have the same or similar query parameters that may be standardized, streamlined, or shared across healthcare. By establishing common, reusable queries for accessing data, providers and payers can relieve the burden of reauthoring the same queries each time a query is needed. Although specific queries may become more complex and intricate, standardizing and sharing initial, high-volume basic queries may serve as a consistent and efficient foundation for health information querying.

[Clinical Quality Language](http://cql.hl7.org) (CQL) is an established standard for querying clinical data in repeatable and reproducible ways. Although CQL has been used in quality data exchange, many providers and payers have not had motivation to adopt it and build capabilities with CQL for other use cases where it may be beneficial, for example in formulating queries of clinical data to support medical necessity and payer administrative policy requirements. With the release of the [CMS Interoperability and Prior Authorization final rule (CMS-0057-F)](https://www.cms.gov/newsroom/fact-sheets/cms-interoperability-and-prior-authorization-final-rule-cms-0057-f), although not specifically required in the provisions of the rule, standardized libraries of CQL will likely give providers and payers a streamlined support for the required exchange of data via FHIR APIs called for by the CMS final rule. By establishing best practices and reusable expressions for common questionnaires, a standard library of CQL statements may form a foundation for automation that can reduce the effort payers would expend in creating the starting point for questionnaires and providers would have a more predictable approach to payer requirements for patient data.

In addition, providing standardized CQL libraries will reduce burden by establishing best practices and reusable expressions not only for common questions across questionnaires, but for common concepts across different types of artifacts, such as questionnaires, decision support rules, quality measures, case reports and others, both currently and into the future.

