# Authoring Documentation - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* **Authoring Documentation**

## Authoring Documentation

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The following topics provide tools and guidance for authoring CQL-based knowledge artifacts.

### Content Implementation Guide Authoring

Content implementation guides allow for CQL-based knowledge artifacts to be authored, validated, tested, and published as part of FHIR implementation guides. The primary tool that supports this use case is the FHIR Implementation Guide publisher itself.

In particular, the publisher supports processing and validation of CQL libraries through [Binary Adjunct Files](https://build.fhir.org/ig/FHIR/ig-guidance/binaries.html#cql-processing). The source for these libraries can be edited alongside the other source for the rest of the IG, using tools such as the [CQFramework CQL Plugin for Visual Studio Code](https://github.com/cqframework/vscode-cql/wiki/User-Guide).

For a walkthrough of how to build and maintain a content implementation guide, refer to the [Colorectal Cancer Screening Walkthrough](https://github.com/cqframework/cqf-ccc/blob/master/WALKTHROUGH.md). This walkthrough covers the creation of a content implementation guide that has a simple decision support and quality measure related to colorectal cancer screening.

### CDS Connect Authoring Tool - Community Edition

For authoring Clinical Decision Support Rules, as well as general CQL Libraries, the [CDS Connect Authoring Tool - Community Edition](https://foundry.hl7.org/products/2b9a2b2b-6956-4825-8737-6f72f8f78935) is an easy-to-use, stand-alone visual editor for Clinical Quality Language-based knowledge artifacts. In addition to support the CDS and Data Elements Library use cases, this tool is being actively evolved by a community of stakeholders to support other use CQL-based knowledge artifact use cases. For prior-authorization questionnaires, this tool was evaluated for supporting questionnaire authoring. See the [Tooling Support](tooling-support.md) page for more information.

### LHC Forms Builder

For authoring questionnaires specifically, the [LHC Forms Builder](https://formbuilder.nlm.nih.gov/) provides a user-friendly tool for building and validating FHIR Structured Data Capture Questionnaires. For prior-authorization questionnaires, this tool was evaluated to determine what would be needed to expand it to support CQL-based population and form behavior expressions. See the [Tooling Support](tooling-support.md) page for more information.

### Steps for Adding New Questionnaires

Adding new content to this IG involves several steps. There are multiple ways to complete many of these steps, and this guide highlights one path for adding a new Questionnaire:

1. Select a questionnaire form (e.g. a prior authorization form), which typically is in a non-computable format such as the PDF form[Medical Necessity For Authorization Of Catheters](https://www.hca.wa.gov/assets/billers-and-providers/13-760.pdf)
1. Manually translate the PDF content into a FHIR Questionnaire (this can optionally be done first in[FSH](http://hl7.org/fhir/uv/shorthand)format but ultimately must be present as an XML or JSON FHIR resource located at the path`input/resources/questionnaire`). An example for the form in #1 can be found[here](https://github.com/HL7/us-cql-ig/blob/master/input/resources/questionnaire/MNACQuestionnaire.json).
1. Add the extension`http://hl7.org/fhir/StructureDefinition/cqf-library`to the Questionnaire with the canonical value of the related CQL library.
1. Setup a launch context extension`sdc-questionnaire-launchContext`for the Patient and any parameters the CQL Library has.
1. For each Questionnaire item that should ultimately have an**initial**value assigned, add the extension`http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression`with an expression title that will later be used as a link to the related CQL definitions that are responsible for determining the content of the initial value for this item.
* If there is a group item that repeats or if multiple items are being populated from the same Resource, the extension `http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext` can be used in combination with the initial expression extension. Details on how to use this expression can be found in the [SDC IG](http://hl7.org/fhir/uv/sdc/STU3/populate.html#expression-based-population).

1. Create a CQL file located at`input/cql`and remember to name it the same as the end of the canonical URL defined in step #3. An example for the MNAC form can be found[here](https://github.com/HL7/us-cql-ig/blob/master/input/cql/MNACInitialExpressions.cql).
1. For each unique initial expression present in the FHIR Questionnaire file, create a definition with the same title in the CQL file created in step #5, and fill those expressions with CQL content.
1. The[CQL VS Code extension](https://marketplace.visualstudio.com/items?itemName=cqframework.cql)allows for right-clicking`Execute CQL`. To successfully investigate if a certain definition results in the desired output, some test resources need to be provided and located in a folder at the following path:`input/tests/library/YOUR-CQL-LIBRARY-NAME`. Sub-folders can define multiple patients filled with multiple resource files. The MNAC test folder with resources of a Patient called**example**can be found[here](https://github.com/HL7/us-cql-ig/tree/master/input/tests/library/MNACInitialExpressions/example).
1. Execute the`_refresh`script (`.sh`or`.bat`as appropriate), and watch multiple things happening automatically:
* In `bundles/questionnaires`, a new folder with the Questionnaire name is create, which includes a bundle containing the FHIR Library with the CQL content and the related dependency libraries.
* In the Library's test folder, a test bundle appears that contains all test resources in one file.

1. Start a local instance of the[Clinical Reasoning enabled HAPI JPA Server Starter](https://github.com/hapifhir/hapi-fhir-jpaserver-starter?tab=readme-ov-file#enabling-clinical-reasoning)(e.g. by using Docker) or use a publicly available FHIR server that supports CQL processing and the[SDC`$populate`operation](http://hl7.org/fhir/uv/sdc/STU3/OperationDefinition-Questionnaire-populate.html).
1. Use a REST tool such as Postman to POST the two bundles described in step #9.
1. Test and see if the operation`$populate`for your questionnaire results in the expected initial values for each item. A complete sample Postman collection for a different Questionnaire can be found[here](https://github.com/HL7/us-cql-ig/blob/main/postman/USCoreGMTPQuestionnaire.postman_collection.json). This collection also contains automated tests to highlight what to look for.

#### Frequent Errors

* When refreshing the IG (by executing `sh _refresh.sh`), sometimes errors in the Questionnaire or CQL cause the new content to be ignored and no output bundle being created. A frequent error is that a wrong or non-existent library name is defined within the Questionnaire.json element **cql-library** extension.
* Special Characters in CQL expression titles: The engine will not be able to resolve special characters within CQL expression titles. E.g. `define "Practitioner's phone"` will fail and must be renamed to `define "Practitioner phone"`.

