# Artifacts Summary - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Knowledge Artifacts: Libraries 

These define logic, asset collections and other libraries as part of content in this implementation guide.

| | |
| :--- | :--- |
| [Cumulative Medication Duration](Library-CumulativeMedicationDuration.md) | This library provides cumulative medication duration calculation logic for use with FHIR medication prescription, administration, and dispensing resources. The logic here follows the guidance provided as part of the 5.6 version of Quality Data Model. |
| [Cumulative Medication Duration Tests](Library-CumulativeMedicationDurationTests.md) | This library provides tests for the cumulative medication duration calculation logic for use with FHIR medication prescription, administration, and dispensing resources. |
| [Expression Library for the Example Patient And Coverage Questionnaire](Library-ExamplePatientAndCoverageInitialExpressions.md) | This library defines initial expressions for use in populating answers to questions in the Example Patient And Coverage questionnaire. |
| [Expression Library for the Genetic/Molecular testing preauthorization Example](Library-GMTPInitialExpressions.md) | Initial expressions for use in populating answers to questions in the Genetic/Molecular testing preauthorization example questionnaire. |
| [Expression Library for the Medical Benefit Outpatient Drug Authorization Example](Library-MBODAInitialExpressions.md) | Initial expressions for use in populating answers to questions in the Medical Benefit Outpatient Drug Authorization example questionnaire. |
| [Expression Library for the Medical Necessity For Authorization Of Catheters Example](Library-MNACInitialExpressions.md) | This library defines initial expressions for use in populating answers to questions in the Medical Necessity For Authorization Of Catheters example questionnaire. |
| [Expression Library for the Uniform Pharmacy Prior Authorization Request Form Example](Library-UPPARFInitialExpressions.md) | Initial expressions for use in populating answers to questions in the Example Uniform Pharmacy Prior Authorization Request Form example questionnaire. |
| [US Core Common](Library-USCoreCommon.md) | This library defines functions to expose extensions defined in USCore as fluent functions in CQL, as well as common terminology and functions used in writing CQL with FHIR and USCore profiles. |
| [US Core Common Tests](Library-USCoreCommonTests.md) | Tests for the expressions and functions defined in the US Core Common library. |
| [US Core Elements](Library-USCoreElements.md) | A library of expressions, functions, and terminology declarations for use with FHIR in the US Realm. |
| [US Core Model Information](Library-USCore-ModelInfo.md) | CQL model information for the US Core version 7.0.0 implementation guide. |
| [US Core Tests](Library-USCoreTests.md) | This is a testing library used to validate capability of the CQL-to-ELM translator using the US Core model info. |

### Structures: Questionnaires 

These define forms used by systems conforming to this implementation guide to capture or expose data to end users.

| | |
| :--- | :--- |
| [Example Genetic/Molecular Testing Preauthorization Questionnaire](Questionnaire-GMTPQuestionnaire.md) | This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form. |
| [Example Medical Benefit Outpatient Drug Authorization Questionnaire](Questionnaire-MBODAQuestionnaire.md) | This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form. |
| [Example Medical Necessity For Authorization Of Catheters Questionnaire](Questionnaire-MNACQuestionnaire.md) | This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form. |
| [Example Patient and Coverage Questionnaire](Questionnaire-ExamplePatientAndCoverageQuestionnaire.md) | For the Prior Authorization Questionnaire Use Case, this type of in-context information is expected to be known already so it wouldn't typically be in a Questionnaire. This example illustrates how to get this information if it is needed. |
| [Example Uniform Pharmacy Prior Authorization Request Form](Questionnaire-UPPARFQuestionnaire.md) | This is an example of a prior authorization questionnaire developed based on an existing industry prior-authorization form. |

### Other 

These are resources that are used within this implementation guide that do not fit into one of the other categories.

| | |
| :--- | :--- |
| [Input Expansion Parameters](Parameters-manifest.md) | The input expansion parameters resource for this implementation guide, specifying SNOMED Edition and version. This resource will be contained within the published implementation guide with all pinned references. |
| [USCore700ModelInfoSettings](Parameters-uscore-7-0-0-modelinfo-settings.md) | US Core 7.0.0 Model Information Settings |

