# US Core Model Information - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* [**Authoring Documentation**](authoring.md)
* [**Patterns**](patterns.md)
* **US Core Model Information**

## US Core Model Information

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This implementation guide includes the model information for the US Core specification, [USCore-ModelInfo](Library-USCore-ModelInfo.md), version 7.0.0. The following table lists the available classes, the base resource type which they represent, and the [primary code path](https://cql.hl7.org/02-authorsguide.html#filtering-with-terminology) established for each class:

| | |
| :--- | :--- |
| [AllergyIntolerance Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-allergyintolerance.html) | code |
| [Average Blood Pressure Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-average-blood-pressure.html) | code |
| [BMI Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-bmi.html) | code |
| [Blood Pressure Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-blood-pressure.html) | code |
| [Body Height Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-body-height.html) | code |
| [Body Temperature Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-body-temperature.html) | code |
| [Body Weight Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-body-weight.html) | code |
| [Care Experience Preference Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-care-experience-preference.html) | code |
| [CarePlan Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-careplan.html) | category |
| [CareTeam Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-careteam.html) | category |
| [Condition Encounter Diagnosis Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-encounter-diagnosis.html) | code |
| [Condition Problems and Health Concerns Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-problems-health-concerns.html) | code |
| [Coverage Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-coverage.html) | type |
| [DiagnosticReport Profile for Laboratory Results Reporting](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-diagnosticreport-lab.html) | code |
| [DiagnosticReport Profile for Report and Note Exchange](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-diagnosticreport-note.html) | code |
| [DocumentReference Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-documentreference.html) | code |
| [Encounter Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-encounter.html) | type |
| [Goal Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-goal.html) | category |
| [Head Circumference Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-head-circumference.html) | code |
| [Heart Rate Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-heart-rate.html) | code |
| [Immunization Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-immunization.html) | vaccineCode |
| [Implantable Device Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-implantable-device.html) | type |
| [Laboratory Result Observation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-lab.html) | code |
| [Location Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-location.html) | type |
| [Medication Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-medication.html) | code |
| [MedicationDispense Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-medicationdispense.html) | medication |
| [MedicationRequest Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-medicationrequest.html) | medication |
| [Observation Clinical Result Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-clinical-result.html) | code |
| [Observation Occupation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-occupation.html) | code |
| [Observation Pregnancy Intent Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-pregnancyintent.html) | code |
| [Observation Pregnancy Status Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-pregnancystatus.html) | code |
| [Observation Screening Assessment Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-screening-assessment.html) | code |
| [Observation Sexual Orientation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-sexual-orientation.html) | code |
| [Organization Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-organization.html) | N/A |
| [Patient Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-patient.html) | N/A |
| [Pediatric BMI for Age Observation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-pediatric-bmi-for-age.html) | code |
| [Pediatric Head Occipital Frontal Circumference Percentile Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-head-occipital-frontal-circumference-percentile.html) | code |
| [Pediatric Weight for Height Observation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-pediatric-weight-for-height.html) | code |
| [Practitioner Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-practitioner.html) | code |
| [PractitionerRole Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-practitionerrole.html) | code |
| [Procedure Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-procedure.html) | code |
| [Provenance Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-provenance.html) | code |
| [Pulse Oximetry Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-pulse-oximetry.html) | code |
| [QuestionnaireResponse Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-questionnaireresponse.html) | name |
| [RelatedPerson Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-relatedperson.html) | relationship |
| [Respiratory Rate Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-respiratory-rate.html) | code |
| [ServiceRequest Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-servicerequest.html) | type |
| [Simple Observation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-simple-observation.html) | code |
| [Smoking Status Observation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-smokingstatus.html) | code |
| [Specimen Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-specimen.html) | type |
| [Treatment Intervention Preference Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-treatment-intervention-preference.html) | code |
| [Vital Signs Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-vital-signs.html) | code |

> Previous versions of the USCore-ModelInfo library (3.1.1 and 6.1.0) were included as embedded resources in the CQL-to-ELM translator (referenced without a namespace and using the version of the implementation guide). This is the 7.0.0 version of the US Core Model Information file. As of version 8.0.0, the US Core implementation guide now includes[model information](https://hl7.org/fhir/us/core/Library-uscore-8.0.0-model-definition.html).

> Previous version of the USCore-ModelInfo were generated using[Profile-informed authoring](https://hl7.org/fhir/uv/cql/using-modelinfo.html#profile-informed-modelinfo). However, as of 7.0.0, based on authoring and implementer feedback, the model information file is generated as a Derived model info:

> This model information file was generated with the[uscore-7-0-0-modelinfo-settings](Parameters-uscore-7-0-0-modelinfo-settings.md)parameters, using the process described in[Derived Model Info](http://hl7.org/fhir/uv/cql/STU2using-modelinfo.html#derived-modelinfo).

