# Patterns - Common CQL Artifacts for FHIR (US-Based) v1.0.0

* [**Table of Contents**](toc.md)
* [**Authoring Documentation**](authoring.md)
* **Patterns**

## Patterns

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This topic provides best-practices and patterns for authoring CQL expressions for each type of data accessed in CQL-based questionnaires:

### Methodology

US Core is the baseline for expected interoperability; this implementation guide builds CQL authoring patterns on top of US Core. To establishe a new set of patterns, the following methodology is used:

1. Choose a[US Core profile](http://hl7.org/fhir/us/core/STU7/index.html#us-core-profiles)to start with.
1. Review the narrative, elements, and search parameters, building a list of what would commonly be used and benefit from having an authoring pattern defined.
1. Compare those patterns with[QI Core Authoring Patterns](https://github.com/cqframework/CQL-Formatting-and-Usage-Wiki/wiki/Authoring-Patterns-QICore-v6.0.0)to see if we can align.
1. Evaluate if our[libraries](artifacts.md#knowledge-artifacts-libraries)already support the pattern or if more functions need to be added.
1. Add the patterns to a local copy of this implementation guide, with pages split out by US Core profile. For each include a CQL example ([ex:](patterns-patient.md)).
1. Evaluate if there are any differences with older versions of US Core that should be called out (at time of writing, most systems are on 3.1.1, working on moving to 6.1.0 by Jan 1st 2026, and planning for 7.0.0 by Jan 1st, 2028).
1. Submit the proposed patterns and underlying profile as a change request JIRA tracker to this implementation guide.

Note that things like community calls, ballot feedback, JIRA issues, and trying to support example questionnaires can also feed into adding more patterns outside of this methodology.

Overall patterns are discussed here:

[Overall](patterns-overall.md)

The following table lists the patterns page for each profile:

| | |
| :--- | :--- |
| [USCore AllergyIntolerance](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-allergyintolerance.html) | [AllergyIntolerance Patterns](patterns-allergy.md) |
| [USCore Condition](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-condition-problems-health-concerns.html) | [Condition Patterns](patterns-condition.md) |
| [USCore Coverage](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-coverage.html) | [Coverage Patterns](patterns-coverage.md) |
| [USCore Medication](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-medication.html) | [Medication Patterns](patterns-medication.md) |
| [USCore Observation Lab](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-lab.html) | [Observation Lab Patterns](patterns-lab.md) |
| [USCore Patient](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-patient.html) | [Patient Patterns](patterns-patient.md) |
| [USCore Service](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-servicerequest.html) | [Service Patterns](patterns-service.md) |

Elements from current example questionnaires:

* DiagnosticReport - Query for and attach to response, but not necessarily drive any particular questions out of the contents
* Laboratory Results
* Clinical Tests
* Family History - including age at diagnosis, availability for testing (e.g., family member deceased, refused testing or patient not in contact with affected family member) and any genetic testing performed on family member (attach pedigree, if available)
* Patient History
* Is Test Part of a Clinical Trial
* ServiceRequest
* MedicationRequest
* Associated Procedures for a Request (given a particular prior auth there will sometimes be additional associated prior authorizations required) 
* for example, given an allergy appointment, you're probably gonna have additional testing
 

