# Detailed Specification - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Detailed Specification**

## Detailed Specification

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This section defines the specific requirements for systems wishing to conform to actors specified in this Central Cancer Registry Reporting Content IG. The specification focuses on using the eCR Now App (or a vendor developed solution) to report cancer data to central cancer registries.

### Context

#### Pre-reading

Before reading this formal specification, implementers should first be familiar with these sections of the specification:

* The [Use Cases](usecases.md) page provides the business context and general process flow enabled by the formal specification.

#### Conventions

This implementation guide uses RFC-2119 terminology to flag statements that have relevance for the evaluation of conformance with the guide:

§

* **SHALL** indicates requirements that must be met to be conformant with the specification. §
* **SHOULD** indicates behaviors that are strongly recommended (and which may result in interoperability issues or sub-optimal behavior if not adhered to), but which do not, for this version of the specification, affect the determination of specification conformance.
* **MAY** describes optional behaviors that are free to consider but where there is no recommendation for or against adoption.

#### Claiming Conformance

Actors and Systems asserting conformance to this implementation guide have to implement the requirements outlined in the corresponding capability statements. The following definition of MUST SUPPORT is to be used in the implementation of the requirements.

##### MUST SUPPORT Definition

§

* Systems **SHALL** be capable of populating data elements as specified by the profiles and data elements are returned using the specified APIs in the capability statement.
* Systems **SHALL** be capable of processing resource instances containing the MUST SUPPORT data elements without generating an error or causing the application to fail. In other words, Systems SHOULD be capable of displaying the data elements for human use or storing it for other purposes.
* Systems SHOULD be capable of displaying the Must Support data elements for human use or storing them for other purposes.
* In situations where information on a particular data element is not present and the reason for absence is unknown, Systems **SHALL NOT** include the data elements in the resource instance returned from executing the API requests.
* When accessing Central Cancer Registry Reporting data, Systems **SHALL** interpret missing data elements within resource instances returned from API requests as data not present.
* When data is not available for any of the mandatory elements specified in the IG, a data absent reason extension should be added to satisfy the requirement along with an appropriate value from the [data-absent-reason value set](http://hl7.org/fhir/ValueSet/data-absent-reason). §

#### Profiles and Other IGs Usage

This specification makes significant use of [FHIR profiles](http://hl7.org/fhir/R4/profiling.html), search parameter definitions, and terminology artifacts to describe the content to be shared as part of Central Cancer Registry Reporting Content IG workflows. The implementation guide is based on [FHIR R4](http://hl7.org/fhir/R4/) and profiles are listed for each interaction.

The full set of profiles defined in this implementation guide can be found by following the links on the [FHIR Artifacts](artifacts.md) page.

##### US Core Usage

This IG leverages the following [US Core](http://hl7.org/fhir/us/core/STU6.1) profiles defined by HL7 for sharing non-veterinary EMR individual health data in the U.S. Where US Core profiles exist, this IG either leverages them directly or uses them as a base for any additional constraints needed to support the cancer use cases.

* [US Core CarePlan Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-careplan.html)
* [US Core Condition Encounter Diagnosis Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-condition-encounter-diagnosis.html)
* [US Core Condition Problems and Health Concerns Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-condition-problems-health-concerns.html)
* [US Core DiagnosticReport Profile for Laboratory Results Reporting](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-lab.html)
* [US Core DiagnosticReport Profile for Report and Note Exchange](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-note.html)
* [US Core DocumentReference Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-documentreference.html)
* [US Core Encounter Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html)
* [US Core Laboratory Result Observation Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-observation-lab.html)
* [US Core Medication Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-medication.html)
* [US Core Patient Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)
* [US Core Practitioner Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)
* [US Core PractitionerRole Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitionerrole.html)
* [US Core Procedure Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-procedure.html)
* [US Core ServiceRequest Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-servicerequest.html)
* [US Core Smoking Status Observation Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-smokingstatus.html)
* [US Core Vital Signs Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-vital-signs.html)

##### mCode FHIR IG Usage

This IG leverages the [mCode FHIR IG](http://hl7.org/fhir/us/mcode/STU4/index.html) for exchanging cancer specific information which includes the following profiles:

* [mCODE Primary Cancer Condition Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-primary-cancer-condition.html)
* [mCODE Secondary Cancer Condition Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-secondary-cancer-condition.html)
* [mCODE TNM Stage Group Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-tnm-stage-group.html)
* [mCODE TNM Distant Metastases Category Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-tnm-distant-metastases-category.html)
* [mCODE TNM Primary Tumor Category Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-tnm-primary-tumor-category.html)
* [mCODE TNM Regional Nodes Category Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-tnm-regional-nodes-category.html)
* [mCODE Cancer-Related Medication Request Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-cancer-related-medication-request.html)
* [mCODE Cancer-Related Medication Administration Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-cancer-related-medication-administration.html)
* [mCODE Radiotherapy Course Summary Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-radiotherapy-course-summary.html)

Implementers **SHOULD** use the [mCode Disease characterization guidance](http://hl7.org/fhir/us/mcode/STU4/group-disease.html) and [mCode Treatment guidance](http://hl7.org/fhir/us/mcode/STU4/group-treatment.html) when using the above profiles.

##### Cancer Pathology Data Sharing IG Usage

This IG leverages the following profiles from the [Cancer Pathology Data Sharing IG](http://hl7.org/fhir/us/cancer-reporting/STU2/index.html) for the extraction of Cancer Pathology Reports from the EHR and inclusion of them in the Central Cancer Registry Content Bundle.

* [US Pathology Diagnostic Report Profile](http://hl7.org/fhir/us/cancer-reporting/STU2/StructureDefinition-us-pathology-diagnostic-report.html)

##### Occupational Data for Health (ODH) IG Usage

This IG leverages the [ODH FHIR IG](http://hl7.org/fhir/us/odh/STU1.3/index.html) for exchanging occupational data for health which includes the following profile:

* [Occupation Data for Health Usual Work Profile](http://hl7.org/fhir/us/odh/STU1.3/StructureDefinition-odh-UsualWork.html)

##### Subscriptions Backport IG Usage

This IG leverages the [Subscriptions Backport IG](http://hl7.org/fhir/uv/subscriptions-backport/STU1.1/index.html) defined by HL7 Infrastructure WG for automating reporting workflows using subscriptions when desired in implementations.

#### Implementation Requirements

##### SMART App Launch IG Usage

When utilizing the eCR Now App approach for this use case - this IG leverages the [SMART App Launch IG](http://hl7.org/fhir/smart-app-launch/STU2.2/index.html) defined by HL7 Infrastructure WG for enabling authentication and authorization between various actors involved in the workflows. This IG leverages Substitutable Medical Applications, Reusable Technologies (SMART) on FHIR Backend Services Authorization requirements.

##### SMART on FHIR Backend Services Requirements

This section outlines how the SMART on FHIR Backend Services Authorization will be used by this IG.

* The system actors namely Data Source, Data Submitter, and the Data Receiver are required to use the SMART on FHIR Backend Services Authorization mechanisms as outlined below for the following interactions:

§ * When the Data Submitter is not packaged within the Data Source, the Data Submitter **SHALL** use the SMART on FHIR Backend Service Authorization to access data from the Data Source
 * Data Submitter posting data to the Data Receiver **SHALL** use the SMART on FHIR Backend Services Authorization to submit the data.

* System actors acting as servers (i.e, Data Source and Data Receiver) **SHALL** advertise conformance to SMART on FHIR Backend Services by hosting Well-Known Uniform Resource Identifiers (URIs) as defined in the [SMART App Launch IG Backend Services](http://hl7.org/fhir/smart-app-launch/STU2.2/backend-services.html) specification.
* System actors acting as servers (i.e, Data Source and Data Receiver) **SHALL** include token_endpoint, scopes_supported, token_endpoint_auth_methods_supported and token_endpoint_auth_signing_alg_values_supported as defined in the [SMART App Launch IG Backend Services](http://hl7.org/fhir/smart-app-launch/STU2.2/backend-services.html) specification.
* When System actors act as clients (i.e, Data Submitter), they **SHALL** share their JSON Web Key Set (JWKS) with the server System actors (i.e, Data Source and Data Receiver) using Uniform Resource Locators (URLs) as defined in the [SMART App Launch IG Backend Services](http://hl7.org/fhir/smart-app-launch/STU2.2/backend-services.html) specification.
* System actors acting as clients **SHALL** obtain the access token as defined in the [SMART App Launch IG Backend Services](http://hl7.org/fhir/smart-app-launch/STU2.2/backend-services.html) specification.
* For the Central Cancer Registry Reporting (CCRR) use case, Data Sources **SHALL** support the system/*.read scopes.
* The Data Receiver **SHALL** support the system/**.read and system/**.write scopes.
* The health care organization's existing processes along with the Data Source's authorization server **SHALL** verify any organizational policy requirements (for example, registration of the Data Submitter, authorizing requested scopes, testing and verification of Data Submitter implementation in sandbox environment prior to production) before allowing the Data Submitter to access the data to be included in the CCRR report. §

#### Data Source Requirements

* The Data Source **SHALL** support the requirements as outlined in the [Central Cancer Registry Reporting Data Source Capability Statement](CapabilityStatement-central-cancer-registry-reporting-ehr.md).

##### Authorization Requirements

* The Data Source **SHALL** support the [SMART on FHIR Backend Services Authorization](spec.md#smart-on-fhir-backend-services-requirements) outlined above as a Server.

##### Subscription Requirements

The requirements in this sub-section are only applicable if when the Data Submitter is not packaged as part of the Data Source.

* The Data Source **SHALL** support the creation of Subscriptions for the following named events described at [US Public Health Profiles Library IG Trigger Events](http://hl7.org/fhir/us/ph-library/STU1/ValueSet-us-ph-valueset-triggerdefinition-namedevent.html).
* The Data Source **SHALL** support [`rest-hook`](http://hl7.org/fhir/R4/subscription.html#2.46.7.1) Subscription channel to notify the Data Submitter.
* The Data Source **SHALL** support Notification Bundles with [`full resource payload`](http://hl7.org/fhir/uv/subscriptions-backport/STU1.1/payloads.html#full-resource) as outlined in the Backport Subscriptions IG.
* For the CCRR IG, the Data Source **SHALL** include the Encounter resource which was started or closed as part of the Notification Bundle.
* The Data Source **SHALL** support operations and APIs for Subscription, Notification Bundle, Subscription status resources as outlined in the [Central Cancer Registry Reporting Data Source Capability Statement](CapabilityStatement-central-cancer-registry-reporting-ehr.md).

##### Data API Requirements

* The Data Source **SHALL** support the [US Core Server APIs](http://hl7.org/fhir/us/core/STU6.1/CapabilityStatement-us-core-server.html) and APIs as outlined in the [Central Cancer Registry Reporting Data Source Capability Statement](CapabilityStatement-central-cancer-registry-reporting-ehr.md) for the Data Submitter to access patient data.

#### Data Submitter Requirements

##### Authorization Requirements

* The Data Submitter **SHALL** support the [SMART on FHIR Backend Services Authorization](spec.md#smart-on-fhir-backend-services-requirements) outlined above as a client.

##### Subscription Requirements

The requirements in this sub-section are only applicable if the Data Submitter is not packaged, as part of the Data Source.

* The Data Submitter **SHALL** be capable of creating Subscriptions for the [encounter-close and encounter-start trigger events](http://hl7.org/fhir/us/ph-library/STU1/ValueSet-us-ph-valueset-triggerdefinition-namedevent.html).
* The Data Submitter **SHALL** support [`rest-hook`](http://hl7.org/fhir/R4/subscription.html#2.46.7.1) Subscription channel to receive notifications from the Data Source.

##### Subscription Notification API

* The Data Submitter **SHALL** support a POST API "receive-notification" with a payload of the Subscription Notification Bundle to receive the notifications from the Data Source.
* The Data Submitter **SHALL** ensure no duplicate reports are submitted for the same patient and encounter occurring within a health care organization.

##### Data API Requirements

* The Data Submitter acting as a client **SHALL** use the [US Core Server APIs](http://hl7.org/fhir/us/core/STU6.1/CapabilityStatement-us-core-server.html) and [Central Cancer Registry Reporting Data Source Capability Statement](CapabilityStatement-central-cancer-registry-reporting-ehr.md) to access patient data from the Data Source.

##### Report Generation Requirements

* The Data Submitter **SHALL** be capable of interpreting [Central Cancer Registry Reporting PlanDefinition](StructureDefinition-ccrr-plandefinition.md) to process the encounter-start and encounter-close trigger events and determine if a CCRR report needs to be generated and submitted.
* The Data Submitter **SHALL** create a CCRR Report following the constraints identified in [Central Cancer Registry Reporting Content Bundle](StructureDefinition-ccrr-content-bundle.md).
* The Data Submitter **SHALL** package the CCRR report following the constraints identified in [Central Cancer Registry Reporting Bundle](StructureDefinition-ccrr-reporting-bundle.md).
* The Data Submitter **SHALL** submit the message containing the CCRR Report to the identified endpoint using either FHIR Messaging $process-message endpoint or POST a Bundle using the Bundle endpoint.

#### Data Receiver Requirements

##### Message Receiving and Processing Requirements

* The Data Receiver **SHALL** support multiple methods to receive data from the Data Submitter as follows
* The Data Receiver **SHALL** implement the $process-message operation on the ROOT URL of the FHIR Server to receive reports from the Data Submitter using the POST operation.
* The Data Receiver **SHALL** implement the Bundle endpoint to receive [Central Cancer Registry Reporting Content Bundle](StructureDefinition-ccrr-content-bundle.md) from a Data Submitter.
* Upon receipt of the message, the Data Receiver **SHALL** validate the data before accepting the data for downstream processing.
* When there are validation failures, the Data Receiver **SHALL** return an Operation Outcome response with the details of the validations as part of the POST response.

§

