# Central Cancer Registry Reporting Content IG Home - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Central Cancer Registry Reporting Content IG Home**

## Central Cancer Registry Reporting Content IG Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/hl7.fhir.us.central-cancer-registry-reporting | *Version*:2.0.0-ballot | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CentralCancerRegistryReporting |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40 | | |

### Introduction

 The Central Cancer Registry Reporting Content Implementation Guide (IG) specifies how to enable clinical sites and cancer registries to implement [Central Cancer Reporting Use Cases](usecases.md). This standard facilitates automated, standardized exchange of cancer surveillance data from ambulatory healthcare provider EHR systems to central cancer registries. The goal of this IG is to leverage existing technology frameworks and standards (e.g., minimal Common Oncology Data Elements (mCODE)), facilitate automated electronic collection and exchange, reduce reporting burden on data providers, augment secure transfers, and enhance data completeness, timeliness, and accuracy of cancer surveillance data using modern IT standards. 

### Technical Overview

 The main sections of this IG are: 

*  [Use Cases](usecases.md) - The use cases provide clinical context for this IG as well as information implementers should know before reading the remainder of the IG. The **Use Case Triggers and Reporting** section provides critically important details for implementers developing their own solution. 
*  [Detailed Specification](spec.md) - The formal specification identifying the requirements for the implementers. 
*  [Downloads](downloads.md) - Allows downloading a copy of this implementation guide and other useful information. 

