# Artifacts Summary - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Central Cancer Registry Reporting Data Source Capability Statement](CapabilityStatement-central-cancer-registry-reporting-ehr.md) | This profile defines the expected capabilities of the ''Data Source'' actor when conforming to the Central Cancer Registry Reporting Content IG. This role is responsible for allowing creation, modification and deletion of Subscriptions and allows searching and retrieval of resources using US Core APIs. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Central Cancer Registry Reporting Bundle](StructureDefinition-ccrr-reporting-bundle.md) | Bundle Resource profile for exchanging a cancer report with the Central Cancer Registry. This bundle contains the MessageHeader resource used for routing and the Content Bundle specifying the content. |
| [Central Cancer Registry Reporting Composition](StructureDefinition-ccrr-composition.md) | This Composition profile is used to organize the central cancer registry report content. |
| [Central Cancer Registry Reporting Content Bundle](StructureDefinition-ccrr-content-bundle.md) | This profile is used to represent the Central Cancer Registry Report Content. The content bundle is represented using a bundle of type Document using the Composition resource. |
| [Central Cancer Registry Reporting Encounter](StructureDefinition-central-cancer-registry-reporting-encounter.md) | This profile represents the encounter related to the cancer event. It is based on US Core Encounter. |
| [Central Cancer Registry Reporting Message Header](StructureDefinition-central-cancer-registry-reporting-messageheader.md) | This is the MessageHeader Resource profile for the IG. |
| [Central Cancer Registry Reporting Organization](StructureDefinition-central-cancer-registry-reporting-organization.md) | This profile represents the organization related to the cancer event. It is based on the US Core Organization. |
| [Central Cancer Registry Reporting Patient](StructureDefinition-central-cancer-registry-reporting-patient.md) | This profile represents the patient related to the cancer event. It is based on the US Public Health Patient profile with further restrictions on identifiers. |
| [Central Cancer Registry Reporting PlanDefinition](StructureDefinition-ccrr-plandefinition.md) | This PlanDefinition profile defines the logic and rules around determining whether or not a cancer report should be generated and sent to a cancer registry. If the cancer condition is reportable, the PlanDefinition gives timing information, next steps and instructions for sending the cancer report to the cancer registry. The rules for determining reportability described by the Central Cancer Registry Reporting specification involve the use of triggering codes to determine potentially reportable events, and optionally locally evaluated rules for determining suspected reportable events. |
| [Central Cancer Registry Reporting Primary Cancer Condition](StructureDefinition-central-cancer-registry-primary-cancer-condition.md) | This is the Primary Cancer Condition Resource profile for the IG. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Cancer Status Evidence Type Extension](StructureDefinition-cancer-status-evidence-type.md) | Categorization of the kind of evidence contributing to a clinical judgment on cancer progression. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Cancer Core Reportability Codes](ValueSet-cancer-core-reportability-codes.md) | The valueset contains SNOMED-CT and ICD-10-CM codes for Cancer Core Reportability determination. These are just sample codes and the actual value set will be published by the Central Cancer Registry. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [CCRR Composition - Example](Composition-ccrr-composition-example.md) | An example showing a CCRR Composition |
| [CCRR PlanDefinition - Example](PlanDefinition-plandefinition-central-cancer-registry-reporting-example.md) | An example showing a PlanDefintion for CCRR |
| [CCRR Reporting Bundle - Example](Bundle-reporting-bundle-example.md) | An example showing a CCRR Reporting bundle |
| [CCRR Specification Bundle - Example](Bundle-central-cancer-registry-reporting-specification-bundle-example.md) | An example showing a CCRR Specification Bundle or Knowledge Artifact |
| [Cancer Related Medication Administration - Example](MedicationAdministration-cancer-med-admin-docetaxel-example.md) | An example showing a Cancer-related MedicationAdministration |
| [Cancer-related Surgical Procedure - Example](Procedure-cancer-related-surgical-procedure-lumpectomy.md) | An example showing a Cancer-related Surgical Procedure |
| [Central Cancer Registry Endpoint - Example](Endpoint-example-ph-endpoint.md) | An example showing an Central Cancer Registry Endpoint |
| [Central Cancer Registry Reporting Encounter - Example](Encounter-encounter-cancer-example.md) | An example showing a Cancer Encounter |
| [Central Cancer Registry Reporting Encounter for Radiation - Example](Encounter-encounter-cancer-example-radiation.md) | An example showing a Cancer Encounter for Radiation |
| [Central Cancer Registry Reporting Encounter for Surgery - Example](Encounter-encounter-cancer-example-surgery.md) | An example showing a Cancer Encounter for Surgery |
| [Central Cancer Registry Reporting Message Header - Example](MessageHeader-messageheader-example-reportheader.md) | An example showing a Central Cancer Registry Reporting Message Header resource |
| [Central Cancer Registry Reporting Organization - Example](Organization-example-cancer-org.md) | An example showing a Cancer Organization |
| [Central Cancer Registry Reporting Patient - Example](Patient-example.md) | An example showing a Cancer Patient |
| [Central Cancer Registry Reporting Primary Cancer Condition - Example](Condition-primary-cancer-condition-breast.md) | An example showing a CCRR Primary Cancer Condition |
| [Encounter based CCRR Content Bundle - Example](Bundle-ccrr-encounter-based-content-bundle-example.md) | An example showing a Encounter based CCRR Content bundle |
| [Healthcare Organization Endpoint - Example](Endpoint-example-healthcare-endpoint.md) | An example showing an Healthcare Organization Endpoint |
| [Initial CCRR Content Bundle - Example](Bundle-ccrr-content-bundle-example.md) | An example showing an Initial CCRR Content bundle |
| [Non Encounter based CCRR Content Bundle - Example](Bundle-ccrr-non-encounter-based-content-bundle-example.md) | An example showing a non Encounter based CCRR Content bundle |
| [ODH - Example](Observation-odh-usual-work.md) | An example showing a ODH Observation |
| [PHA Organization - Example](Organization-example-pha-org.md) | An example showing a PHA Organization |
| [Practitioner - Example](Practitioner-1.md) | An example showing a Practitioner |
| [Problem List Condition - Example](Condition-problem-list-diabetes.md) | An example showing a Problem List Condition |
| [Smoking Status - Example](Observation-non-smoker.md) | An example showing Smoking Status |
| [mCODE Cancer Stage Group - Example](Observation-cancer-stage-group-example.md) | An example showing an mCODE Cancer Stage Group |
| [mCODE Radiotherapy Course Summary - Example](Procedure-radiotherapy-example.md) | An example showing an mCODE Radiotherapy Course Summary |
| [mCODE TNM Clinical Distant Metastases Category - Example](Observation-tnm-clinical-distant-metastases-category-cM0.md) | An example showing an mCODE TNM Clinical Distant Metastases Category |
| [mCODE TNM Clinical Primary Tumor Category - Example](Observation-tnm-clinical-primary-tumor-category-cT2.md) | An example showing an mCODE TNM Clinical Primary Tumor Category |
| [mCODE TNM Clinical Regional Nodes Category - Example](Observation-tnm-clinical-regional-nodes-category-cN0.md) | An example showing an mCODE TNM Clinical Regional Nodes Category |

