# Central Cancer Registry Reporting Patient - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Patient**

## Resource Profile: Central Cancer Registry Reporting Patient 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-patient | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CentralCancerRegistryReportingPatient |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40.42.8 | | |

 
This profile represents the patient related to the cancer event. It is based on the US Public Health Patient profile with further restrictions on identifiers. 

**Usages:**

* Refer to this Profile: [Central Cancer Registry Reporting Composition](StructureDefinition-ccrr-composition.md) and [Central Cancer Registry Reporting Encounter](StructureDefinition-central-cancer-registry-reporting-encounter.md)
* Examples for this Profile: [Patient/example](Patient-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.central-cancer-registry-reporting|current/StructureDefinition/central-cancer-registry-reporting-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-central-cancer-registry-reporting-patient.csv), [Excel](StructureDefinition-central-cancer-registry-reporting-patient.xlsx), [Schematron](StructureDefinition-central-cancer-registry-reporting-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "central-cancer-registry-reporting-patient",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2025-08-11T02:41:12.847+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-patient",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.40.42.8"
    }
  ],
  "version" : "2.0.0-ballot",
  "name" : "CentralCancerRegistryReportingPatient",
  "title" : "Central Cancer Registry Reporting Patient",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15T16:01:21+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "This profile represents the patient related to the cancer event. It is based on the US Public Health Patient profile with further restrictions on identifiers.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-patient|1.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "Central Cancer Registry Reporting Patient",
        "definition" : "This profile is based on the Patient resource and establishes the core elements, extensions, vocabularies and value sets for representing a patient for central cancer registry reporting."
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type.coding.system"
            },
            {
              "type" : "value",
              "path" : "type.coding.code"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicareIdentifier",
        "path" : "Patient.identifier",
        "sliceName" : "MedicareIdentifier",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicareIdentifier.type",
        "path" : "Patient.identifier.type",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicareIdentifier.type.coding",
        "path" : "Patient.identifier.type.coding",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicareIdentifier.type.coding.system",
        "path" : "Patient.identifier.type.coding.system",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicareIdentifier.type.coding.code",
        "path" : "Patient.identifier.type.coding.code",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "MC",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicaidIdentifier",
        "path" : "Patient.identifier",
        "sliceName" : "MedicaidIdentifier",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicaidIdentifier.type",
        "path" : "Patient.identifier.type",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicaidIdentifier.type.coding",
        "path" : "Patient.identifier.type.coding",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicaidIdentifier.type.coding.system",
        "path" : "Patient.identifier.type.coding.system",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MedicaidIdentifier.type.coding.code",
        "path" : "Patient.identifier.type.coding.code",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "MA",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MR",
        "path" : "Patient.identifier",
        "sliceName" : "MR",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MR.type",
        "path" : "Patient.identifier.type",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MR.type.coding",
        "path" : "Patient.identifier.type.coding",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MR.type.coding.system",
        "path" : "Patient.identifier.type.coding.system",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:MR.type.coding.code",
        "path" : "Patient.identifier.type.coding.code",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "MR",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:SSNIdentifier",
        "path" : "Patient.identifier",
        "sliceName" : "SSNIdentifier",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:SSNIdentifier.type",
        "path" : "Patient.identifier.type",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:SSNIdentifier.type.coding",
        "path" : "Patient.identifier.type.coding",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:SSNIdentifier.type.coding.system",
        "path" : "Patient.identifier.type.coding.system",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:SSNIdentifier.type.coding.code",
        "path" : "Patient.identifier.type.coding.code",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "SS",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.family.extension:data-absent-reason",
        "path" : "Patient.name.family.extension",
        "sliceName" : "data-absent-reason",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.given.extension:data-absent-reason",
        "path" : "Patient.name.given.extension",
        "sliceName" : "data-absent-reason",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.address.state",
        "path" : "Patient.address.state",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.address.state.extension:data-absent-reason",
        "path" : "Patient.address.state.extension",
        "sliceName" : "data-absent-reason",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.maritalStatus",
        "path" : "Patient.maritalStatus",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.managingOrganization",
        "path" : "Patient.managingOrganization",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-organization"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
