# Central Cancer Registry Reporting Message Header - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Message Header**

## Resource Profile: Central Cancer Registry Reporting Message Header 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-messageheader | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CentralCancerRegistryReportingMessageHeader |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40.42.4 | | |

 
This is the MessageHeader Resource profile for the IG. 

**Usages:**

* Use this Profile: [Central Cancer Registry Reporting Bundle](StructureDefinition-ccrr-reporting-bundle.md)
* Examples for this Profile: [MessageHeader/messageheader-example-reportheader](MessageHeader-messageheader-example-reportheader.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.central-cancer-registry-reporting|current/StructureDefinition/central-cancer-registry-reporting-messageheader)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-central-cancer-registry-reporting-messageheader.csv), [Excel](StructureDefinition-central-cancer-registry-reporting-messageheader.xlsx), [Schematron](StructureDefinition-central-cancer-registry-reporting-messageheader.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "central-cancer-registry-reporting-messageheader",
  "meta" : {
    "versionId" : "10",
    "lastUpdated" : "2022-07-12T02:03:11.293+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-messageheader",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.40.42.4"
    }
  ],
  "version" : "2.0.0-ballot",
  "name" : "CentralCancerRegistryReportingMessageHeader",
  "title" : "Central Cancer Registry Reporting Message Header",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-09-01",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "This is the MessageHeader Resource profile for the IG.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MessageHeader",
  "baseDefinition" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-messageheader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MessageHeader",
        "path" : "MessageHeader",
        "short" : "Central Cancer Registry Reporting MessageHeader",
        "definition" : "Sets expectations for supported capabilities for MessageHeader resource for Central Cancer Registry Reporting.",
        "mustSupport" : false
      },
      {
        "id" : "MessageHeader.source.name",
        "path" : "MessageHeader.source.name",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MessageHeader.source.software",
        "path" : "MessageHeader.source.software",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MessageHeader.source.version",
        "path" : "MessageHeader.source.version",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      }
    ]
  }
}

```
