# Central Cancer Registry Reporting Encounter - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Encounter**

## Resource Profile: Central Cancer Registry Reporting Encounter 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-encounter | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CentralCancerRegistryReportingEncounter |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40.42.6 | | |

 
This profile represents the encounter related to the cancer event. It is based on US Core Encounter. 

**Usages:**

* Refer to this Profile: [Central Cancer Registry Reporting Composition](StructureDefinition-ccrr-composition.md)
* Examples for this Profile: [Encounter/encounter-cancer-example-radiation](Encounter-encounter-cancer-example-radiation.md), [Encounter/encounter-cancer-example-surgery](Encounter-encounter-cancer-example-surgery.md) and [Encounter/encounter-cancer-example](Encounter-encounter-cancer-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.central-cancer-registry-reporting|current/StructureDefinition/central-cancer-registry-reporting-encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-central-cancer-registry-reporting-encounter.csv), [Excel](StructureDefinition-central-cancer-registry-reporting-encounter.xlsx), [Schematron](StructureDefinition-central-cancer-registry-reporting-encounter.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "central-cancer-registry-reporting-encounter",
  "meta" : {
    "versionId" : "21",
    "lastUpdated" : "2021-07-01T02:41:12.847+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-encounter",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.40.42.6"
    }
  ],
  "version" : "2.0.0-ballot",
  "name" : "CentralCancerRegistryReportingEncounter",
  "title" : "Central Cancer Registry Reporting Encounter",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15T16:01:21+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "This profile represents the encounter related to the cancer event. It is based on US Core Encounter.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter",
        "short" : "Central Cancer Registry Reporting Encounter",
        "definition" : "This profile is based on US Core and establishes the core elements, extensions, vocabularies and value sets for central cancer registry reporting encounters."
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "definition" : "The provider in charge of care and the facility in which care was provided during the encounter",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant:sliceResponsibleProvider",
        "path" : "Encounter.participant",
        "sliceName" : "sliceResponsibleProvider",
        "short" : "Responsible provider",
        "definition" : "The provider in charge of care and the facility in which care was provided during the encounter",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant:sliceResponsibleProvider.type",
        "path" : "Encounter.participant.type",
        "short" : "Responsible provider",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "ATND"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant:sliceResponsibleProvider.period",
        "path" : "Encounter.participant.period",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.participant:sliceResponsibleProvider.individual",
        "path" : "Encounter.participant.individual",
        "short" : "Responsible Provider",
        "definition" : "The provider in charge of care and the facility in which care was provided during the encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.reasonReference",
        "path" : "Encounter.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-primary-cancer-condition",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|6.1.0",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.diagnosis",
        "path" : "Encounter.diagnosis",
        "short" : "Encounter diagnosis",
        "definition" : "Encounter diagnosis",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.diagnosis.condition",
        "path" : "Encounter.diagnosis.condition",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0",
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-primary-cancer-condition"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Encounter.diagnosis.use",
        "path" : "Encounter.diagnosis.use",
        "mustSupport" : true
      },
      {
        "id" : "Encounter.location",
        "path" : "Encounter.location",
        "short" : "Public health encounter location",
        "definition" : "Location of the facility in which the public health encounter took place",
        "max" : "*",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Encounter.location.location",
        "path" : "Encounter.location.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Encounter.serviceProvider",
        "path" : "Encounter.serviceProvider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-organization"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
