# Central Cancer Registry Reporting Primary Cancer Condition - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Primary Cancer Condition**

## Resource Profile: Central Cancer Registry Reporting Primary Cancer Condition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-primary-cancer-condition | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CentralCancerRegistryReportingPrimaryCancerCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40.42.5 | | |

 
This is the Primary Cancer Condition Resource profile for the IG. 

**Usages:**

* Refer to this Profile: [Central Cancer Registry Reporting Composition](StructureDefinition-ccrr-composition.md) and [Central Cancer Registry Reporting Encounter](StructureDefinition-central-cancer-registry-reporting-encounter.md)
* Examples for this Profile: [Condition/primary-cancer-condition-breast](Condition-primary-cancer-condition-breast.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.central-cancer-registry-reporting|current/StructureDefinition/central-cancer-registry-primary-cancer-condition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-central-cancer-registry-primary-cancer-condition.csv), [Excel](StructureDefinition-central-cancer-registry-primary-cancer-condition.xlsx), [Schematron](StructureDefinition-central-cancer-registry-primary-cancer-condition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "central-cancer-registry-primary-cancer-condition",
  "meta" : {
    "versionId" : "10",
    "lastUpdated" : "2022-07-12T02:03:11.293+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-primary-cancer-condition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.40.42.5"
    }
  ],
  "version" : "2.0.0-ballot",
  "name" : "CentralCancerRegistryReportingPrimaryCancerCondition",
  "title" : "Central Cancer Registry Reporting Primary Cancer Condition",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-09-01",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "This is the Primary Cancer Condition Resource profile for the IG.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition",
        "short" : "Central Cancer Registry Reporting Primary Cancer Condition",
        "definition" : "Sets expectations for supported capabilities for Primary Cancer Condition in Central Cancer Registry Reporting use cases.",
        "mustSupport" : true
      },
      {
        "id" : "Condition.extension",
        "path" : "Condition.extension",
        "min" : 2,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Condition.extension:assertedDate",
        "path" : "Condition.extension",
        "sliceName" : "assertedDate",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/condition-assertedDate|5.2.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.extension:histologyMorphologyBehavior",
        "path" : "Condition.extension",
        "sliceName" : "histologyMorphologyBehavior",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-histology-morphology-behavior"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.extension:cancer-status-evidence-type",
        "path" : "Condition.extension",
        "sliceName" : "cancer-status-evidence-type",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/cancer-status-evidence-type"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.bodySite",
        "path" : "Condition.bodySite",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Condition.bodySite.extension",
        "path" : "Condition.bodySite.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        },
        "definition" : "Defines extensions for the bodySite element.",
        "mustSupport" : true
      },
      {
        "id" : "Condition.bodySite.extension:locationQualifier",
        "path" : "Condition.bodySite.extension",
        "sliceName" : "locationQualifier",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-body-location-qualifier"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.bodySite.extension:lateralityQualifier",
        "path" : "Condition.bodySite.extension",
        "sliceName" : "lateralityQualifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-laterality-qualifier"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.bodySite.extension:data-absent-reason",
        "path" : "Condition.bodySite.extension",
        "sliceName" : "data-absent-reason",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|5.2.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.stage.assessment",
        "path" : "Condition.stage.assessment",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-tnm-stage-group",
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-cancer-stage"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
