# Central Cancer Registry Reporting PlanDefinition - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting PlanDefinition**

## Resource Profile: Central Cancer Registry Reporting PlanDefinition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-plandefinition | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CentralCancerRegistryReportingPlanDefinition |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40.42.9 | | |

 
This PlanDefinition profile defines the logic and rules around determining whether or not a cancer report should be generated and sent to a cancer registry. If the cancer condition is reportable, the PlanDefinition gives timing information, next steps and instructions for sending the cancer report to the cancer registry. The rules for determining reportability described by the Central Cancer Registry Reporting specification involve the use of triggering codes to determine potentially reportable events, and optionally locally evaluated rules for determining suspected reportable events. 

### Introduction

This profile is used to represent the PlanDefinition instance which is an integral part of the Central Cancer Registry Reporting Knowledge Artifact.

#### Requirements of the Knowledge Artifact

* The Central Cancer Registry Reporting PlanDefinition is triggered by an encounter-close event.
* The PlanDefinition specifies a mechanism to run scheduled jobs at specified intervals when the reason for the encounter/visit is to diagnose, evaluate, and/or treat an active cancer and create a cancer report.
* The PlanDefinition specifies a mechanism to run scheduled jobs at least every 6 months for the patient and create a cancer report.
* The PlanDefinition specifies a mechanism to run scheduled jobs once every 12 months until the patient is deceased or there is no updates to the record for 24 months and create a cancer report.

**Usages:**

* Examples for this Profile: [CentralCancerRegistryReportingExample](PlanDefinition-plandefinition-central-cancer-registry-reporting-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.central-cancer-registry-reporting|current/StructureDefinition/ccrr-plandefinition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ccrr-plandefinition.csv), [Excel](StructureDefinition-ccrr-plandefinition.xlsx), [Schematron](StructureDefinition-ccrr-plandefinition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ccrr-plandefinition",
  "meta" : {
    "versionId" : "35",
    "lastUpdated" : "2021-11-17T04:21:04.742+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-plandefinition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.40.42.9"
    }
  ],
  "version" : "2.0.0-ballot",
  "name" : "CentralCancerRegistryReportingPlanDefinition",
  "title" : "Central Cancer Registry Reporting PlanDefinition",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15T16:01:21+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "This PlanDefinition profile defines the logic and rules around determining whether or not a cancer report should be generated and sent to a cancer registry. If the cancer condition is reportable, the PlanDefinition gives timing information, next steps and instructions for sending the cancer report to the cancer registry. The rules for determining reportability described by the Central Cancer Registry Reporting specification involve the use of triggering codes to determine potentially reportable events, and optionally locally evaluated rules for determining suspected reportable events. ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PlanDefinition",
  "baseDefinition" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-plandefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PlanDefinition",
        "path" : "PlanDefinition",
        "short" : "ccrr-Central Cancer Registry Reporting",
        "definition" : "Defines the logic and rules around determining: whether or not a cancer condition is reportable to a Central Cancer Registry, which jurisdiction(s) is/are responsible, which jurisdiction(s) need to be notified, and if the condition is reportable, gives timing information, next steps and condition information to the clinician.",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action",
        "path" : "PlanDefinition.action",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "id"
            }
          ],
          "ordered" : true,
          "rules" : "open"
        },
        "min" : 2,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action.code",
        "path" : "PlanDefinition.action.code",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "The set of actions that can be used to create plan definition",
          "valueSet" : "http://hl7.org/fhir/us/ph-library/ValueSet/us-ph-valueset-plandefinition-action"
        }
      },
      {
        "id" : "PlanDefinition.action.input",
        "path" : "PlanDefinition.action.input"
      },
      {
        "id" : "PlanDefinition.action:encounterClose",
        "path" : "PlanDefinition.action",
        "sliceName" : "encounterClose",
        "short" : "Encounter Close Action",
        "definition" : "Defines the \"startr\" action",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:encounterClose.id",
        "path" : "PlanDefinition.action.id",
        "min" : 1,
        "fixedString" : "start-workflow",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:encounterClose.description",
        "path" : "PlanDefinition.action.description",
        "short" : "Starts the workflow",
        "definition" : "Description of the start workflow action.",
        "min" : 1,
        "fixedString" : "This action represents the start of the reporting workflow in response to the encounter-close event",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:encounterClose.textEquivalent",
        "path" : "PlanDefinition.action.textEquivalent",
        "short" : "Text equivalent of the start workflow action.",
        "definition" : "Text equivalent of the start workflow action.",
        "min" : 1,
        "fixedString" : "Start the reporting workflow in response to an encounter-close event",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:encounterClose.code",
        "path" : "PlanDefinition.action.code",
        "short" : "Code for the \"start\" action.",
        "definition" : "The US-PH-PlanDefinition-Action code for the \"start\" action.",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "initiate-reporting-workflow"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:encounterClose.trigger",
        "path" : "PlanDefinition.action.trigger",
        "short" : "When the \"start\" action should be triggered.",
        "definition" : "When the \"start\" action should be triggered.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:encounterClose.trigger.extension",
        "path" : "PlanDefinition.action.trigger.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "description" : "Extensions are always sliced by (at least) url",
          "rules" : "open"
        },
        "short" : "Additional content defined by implementations",
        "definition" : "May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
        "comment" : "There can be no stigma associated with the use of extensions by any application, project, or standard - regardless of the institution or jurisdiction that uses or defines the extensions.  The use of extensions is what allows the FHIR specification to retain a core level of simplicity for everyone.",
        "alias" : ["extensions", "user content"],
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "Element.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension"
          }
        ],
        "isModifier" : false,
        "isSummary" : false,
        "mapping" : [
          {
            "identity" : "rim",
            "map" : "n/a"
          }
        ]
      },
      {
        "id" : "PlanDefinition.action:encounterClose.trigger.extension:namedEventType",
        "path" : "PlanDefinition.action.trigger.extension",
        "sliceName" : "namedEventType",
        "short" : "Indicates the types of named events to subscribe to from the EHR.",
        "definition" : "Indicates the types of named events to subscribe to from the EHR.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "Element.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-named-eventtype-extension"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false,
        "isSummary" : false
      },
      {
        "id" : "PlanDefinition.action:encounterClose.trigger.type",
        "path" : "PlanDefinition.action.trigger.type",
        "fixedCode" : "named-event"
      },
      {
        "id" : "PlanDefinition.action:encounterClose.trigger.name",
        "path" : "PlanDefinition.action.trigger.name",
        "definition" : "The name of the event, encounter-close in this case. For any action invoked as a result of this trigger, the triggering encounter is accessible via the context variable `%encounter`",
        "fixedString" : "encounter-close"
      },
      {
        "id" : "PlanDefinition.action:encounterClose.relatedAction",
        "path" : "PlanDefinition.action.relatedAction",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:encounterClose.relatedAction.actionId",
        "path" : "PlanDefinition.action.relatedAction.actionId",
        "fixedId" : "check-reportable"
      },
      {
        "id" : "PlanDefinition.action:encounterClose.relatedAction.relationship",
        "path" : "PlanDefinition.action.relatedAction.relationship",
        "fixedCode" : "before-start"
      },
      {
        "id" : "PlanDefinition.action:encounterClose.relatedAction.offsetDuration",
        "path" : "PlanDefinition.action.relatedAction.offsetDuration",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Duration"
          }
        ],
        "example" : [
          {
            "label" : "Wait 72 hour before next action.",
            "valueDuration" : {
              "value" : 72,
              "unit" : "h"
            }
          }
        ]
      },
      {
        "id" : "PlanDefinition.action:checkReportable",
        "path" : "PlanDefinition.action",
        "sliceName" : "checkReportable",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.id",
        "path" : "PlanDefinition.action.id",
        "min" : 1,
        "fixedString" : "check-reportable",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.description",
        "path" : "PlanDefinition.action.description",
        "short" : "Check if the Encounter qualifies as check-reportable",
        "definition" : "Check if the Encounter qualifies as check-reportable.",
        "fixedString" : "This action represents the check for suspected reportability of the cancer data."
      },
      {
        "id" : "PlanDefinition.action:checkReportable.code",
        "path" : "PlanDefinition.action.code",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "execute-reporting-workflow"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action",
        "path" : "PlanDefinition.action.action",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "id"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action.condition",
        "path" : "PlanDefinition.action.action.condition",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action.input",
        "path" : "PlanDefinition.action.action.input",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action.output",
        "path" : "PlanDefinition.action.action.output",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action.relatedAction",
        "path" : "PlanDefinition.action.action.relatedAction",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable",
        "path" : "PlanDefinition.action.action",
        "sliceName" : "isEncounterReportable",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.id",
        "path" : "PlanDefinition.action.action.id",
        "min" : 1,
        "fixedString" : "is-encounter-reportable",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.code",
        "path" : "PlanDefinition.action.action.code",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "check-trigger-codes"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.condition",
        "path" : "PlanDefinition.action.action.condition",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.condition.kind",
        "path" : "PlanDefinition.action.action.condition.kind",
        "fixedCode" : "applicability"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.condition.expression",
        "path" : "PlanDefinition.action.action.condition.expression",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.condition.expression.language",
        "path" : "PlanDefinition.action.action.condition.expression.language",
        "fixedCode" : "text/fhirpath"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.input",
        "path" : "PlanDefinition.action.action.input",
        "definition" : "Defines input data requirements for the action. Required data is accessible via a context variable named `%[id]` using the `id` of the input data requirement",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.input.id",
        "path" : "PlanDefinition.action.action.input.id",
        "definition" : "The id of the input requirement, allowing the data to be referenced via a context variable named `%[id]`",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.relatedAction",
        "path" : "PlanDefinition.action.action.relatedAction"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.relatedAction.actionId",
        "path" : "PlanDefinition.action.action.relatedAction.actionId",
        "fixedId" : "report-cancer-data"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:isEncounterReportable.relatedAction.relationship",
        "path" : "PlanDefinition.action.action.relatedAction.relationship",
        "fixedCode" : "before-start"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting",
        "path" : "PlanDefinition.action.action",
        "sliceName" : "shouldContinueReporting",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.id",
        "path" : "PlanDefinition.action.action.id",
        "min" : 1,
        "fixedString" : "should-continue-reporting",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.code",
        "path" : "PlanDefinition.action.action.code",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "evaluate-condition"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.condition",
        "path" : "PlanDefinition.action.action.condition"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.condition.kind",
        "path" : "PlanDefinition.action.action.condition.kind",
        "fixedCode" : "applicability"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.condition.expression",
        "path" : "PlanDefinition.action.action.condition.expression",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.condition.expression.language",
        "path" : "PlanDefinition.action.action.condition.expression.language",
        "fixedCode" : "text/fhirpath"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.relatedAction",
        "path" : "PlanDefinition.action.action.relatedAction"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.relatedAction.actionId",
        "path" : "PlanDefinition.action.action.relatedAction.actionId",
        "fixedId" : "check-reportable"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.relatedAction.relationship",
        "path" : "PlanDefinition.action.action.relatedAction.relationship",
        "fixedCode" : "before-start"
      },
      {
        "id" : "PlanDefinition.action:checkReportable.action:shouldContinueReporting.relatedAction.offsetDuration",
        "path" : "PlanDefinition.action.action.relatedAction.offsetDuration",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Duration"
          }
        ],
        "example" : [
          {
            "label" : "Wait 6 months before next action.",
            "valueDuration" : {
              "value" : 6,
              "unit" : "mo"
            }
          }
        ]
      },
      {
        "id" : "PlanDefinition.action:reportCancerData",
        "path" : "PlanDefinition.action",
        "sliceName" : "reportCancerData",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.id",
        "path" : "PlanDefinition.action.id",
        "min" : 1,
        "fixedString" : "report-cancer-data",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.description",
        "path" : "PlanDefinition.action.description",
        "fixedString" : "This action represents the creation, validation and submission of the cancer report."
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.code",
        "path" : "PlanDefinition.action.code",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "execute-reporting-workflow"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action",
        "path" : "PlanDefinition.action.action",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "id"
            }
          ],
          "ordered" : true,
          "rules" : "open"
        },
        "min" : 3,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action.condition",
        "path" : "PlanDefinition.action.action.condition",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action.input",
        "path" : "PlanDefinition.action.action.input",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action.output",
        "path" : "PlanDefinition.action.action.output",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action.relatedAction",
        "path" : "PlanDefinition.action.action.relatedAction",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:createCancerReport",
        "path" : "PlanDefinition.action.action",
        "sliceName" : "createCancerReport",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:createCancerReport.id",
        "path" : "PlanDefinition.action.action.id",
        "min" : 1,
        "fixedString" : "create-cancer-report",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:createCancerReport.description",
        "path" : "PlanDefinition.action.action.description",
        "fixedString" : "This action represents the creation of the cancer report."
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:createCancerReport.code",
        "path" : "PlanDefinition.action.action.code",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "create-report"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:validateCancerReport",
        "path" : "PlanDefinition.action.action",
        "sliceName" : "validateCancerReport",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:validateCancerReport.id",
        "path" : "PlanDefinition.action.action.id",
        "min" : 1,
        "fixedString" : "validate-cancer-report",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:validateCancerReport.description",
        "path" : "PlanDefinition.action.action.description",
        "fixedString" : "This action represents the validation of the cancer report."
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:validateCancerReport.code",
        "path" : "PlanDefinition.action.action.code",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "validate-report"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:routeAndSendCancerReport",
        "path" : "PlanDefinition.action.action",
        "sliceName" : "routeAndSendCancerReport",
        "short" : "Route and send cancer report",
        "definition" : "Defines the routing and sending of the cancer report.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:routeAndSendCancerReport.id",
        "path" : "PlanDefinition.action.action.id",
        "min" : 1,
        "fixedString" : "route-and-send-cancer-report",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:routeAndSendCancerReport.description",
        "path" : "PlanDefinition.action.action.description",
        "short" : "Description of the route and send action.",
        "definition" : "Description of the route and send action.",
        "min" : 1,
        "fixedString" : "This action represents the routing and sending of the cancer report.",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:routeAndSendCancerReport.textEquivalent",
        "path" : "PlanDefinition.action.action.textEquivalent",
        "min" : 1,
        "fixedString" : "Route and send cancer report",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:reportCancerData.action:routeAndSendCancerReport.code",
        "path" : "PlanDefinition.action.action.code",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "submit-report"
            }
          ]
        }
      }
    ]
  }
}

```
