# Cancer Status Evidence Type Extension - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cancer Status Evidence Type Extension**

## Extension: Cancer Status Evidence Type Extension 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/cancer-status-evidence-type | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CancerStatusEvidenceType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.15.42.5 | | |

Categorization of the kind of evidence contributing to a clinical judgment on cancer progression.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Central Cancer Registry Reporting Primary Cancer Condition](StructureDefinition-central-cancer-registry-primary-cancer-condition.md)
* Examples for this Extension: [Bundle/ccrr-encounter-based-content-bundle-example](Bundle-ccrr-encounter-based-content-bundle-example.md), [Bundle/ccrr-non-encounter-based-content-bundle-example](Bundle-ccrr-non-encounter-based-content-bundle-example.md) and [Condition/primary-cancer-condition-breast](Condition-primary-cancer-condition-breast.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.central-cancer-registry-reporting|current/StructureDefinition/cancer-status-evidence-type)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cancer-status-evidence-type.csv), [Excel](StructureDefinition-cancer-status-evidence-type.xlsx), [Schematron](StructureDefinition-cancer-status-evidence-type.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cancer-status-evidence-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/cancer-status-evidence-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.15.42.5"
    }
  ],
  "version" : "2.0.0-ballot",
  "name" : "CancerStatusEvidenceType",
  "title" : "Cancer Status Evidence Type Extension",
  "status" : "active",
  "date" : "2025-09-11T20:00:57+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "Categorization of the kind of evidence contributing to a clinical judgment on cancer progression.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Observation"
    },
    {
      "type" : "element",
      "expression" : "Condition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Cancer Status Evidence Type Extension",
        "definition" : "Categorization of the kind of evidence contributing to a clinical judgment on cancer progression."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/cancer-status-evidence-type"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/mcode/ValueSet/mcode-cancer-disease-status-evidence-type-vs"
        }
      }
    ]
  }
}

```
