# mCODE TNM Clinical Distant Metastases Category - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **mCODE TNM Clinical Distant Metastases Category - Example**

## Example Observation: mCODE TNM Clinical Distant Metastases Category - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [mCODE TNM Distant Metastases Category](https://hl7.org/fhir/us/mcode/StructureDefinition-mcode-tnm-distant-metastases-category.html)

**Observation:** TNM Clinical Distant Metastases Category (cM0)

**Status:** final

**Category:** Imaging

**Code:** cM category (SNOMED CT: 399387003)

**Subject:** [Patient-example: Amy Shaw](Patient-example.md)

**Effective Date:** 2023-03-21

**Performer:** [Dr. Joseph Nichols (Practitioner/1)](Practitioner-1.md)

**Value:** cM0 - 1229901006 (American Joint Committee on Cancer cM0 qualifier)

**Method:** American Joint Commission on Cancer, Cancer Staging Manual, 8th edition neoplasm staging system (tumor staging) (SNOMED CT: 897275008)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "tnm-clinical-distant-metastases-category-cM0",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-tnm-distant-metastases-category"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "imaging",
          "display" : "Imaging"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "399387003",
        "display" : "cM category"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-03-21",
  "performer" : [
    {
      "reference" : "Practitioner/1"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1229901006",
        "display" : "American Joint Committee on Cancer cM0 (qualifier value)"
      }
    ]
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "897275008",
        "display" : "American Joint Committee on Cancer, Cancer Staging Manual, 8th edition tumor staging system"
      }
    ]
  }
}

```
