# ODH - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ODH - Example**

## Example Observation: ODH - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [ODH Usual Work](https://hl7.org/fhir/us/odh/StructureDefinition/odh-UsualWork.html)

**Subject:** [Patient-example: Amy Shaw](Patient-example.md)

**Start Date:**2010-01-01

**Industry Code/Value:**1570 / Carpet and rug mills

**Occupation Code/Value:**6240 / Carpet, floor, and tile installers and finishers



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "odh-usual-work",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/odh/StructureDefinition/odh-UsualWork"
    ]
  },
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "21843-8",
        "display" : "History of Usual occupation"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "effectivePeriod" : {
    "start" : "2010-01-01"
  },
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "urn:oid:2.16.840.1.114222.4.5.314",
        "code" : "3600",
        "display" : "Nursing, psychiatric, and home health aides"
      },
      {
        "system" : "urn:oid:2.16.840.1.114222.4.5.327",
        "code" : "31-1014.00.007136",
        "display" : "Certified Nursing Assistant (CNA) [Nursing Assistants]"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "21844-6",
            "display" : "History of Usual industry"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/PHIndustryCDCCensus2010",
            "code" : "8270",
            "display" : "Nursing care facilities"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/PHOccupationalDataForHealthODH",
            "code" : "621610.008495",
            "display" : "Home nursing services"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "74163-7",
            "display" : "Usual occupation duration"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 21,
        "unit" : "a",
        "system" : "http://unitsofmeasure.org",
        "code" : "a"
      }
    }
  ]
}

```
