# Smoking Status - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smoking Status - Example**

## Example Observation: Smoking Status - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [US Core Smoking Status](https://hl7.org/fhir/us/core/StructureDefinition-us-core-smokingstatus.html)

**category**: Social History

**code**: Tobacco smoking status

**subject**: [Amy V. Shaw](Patient-example.md)

**issued**: 2023-03-21 

**value**: Never smoked tobacco (finding)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "non-smoker",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|6.1.0"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "72166-2",
        "display" : "Tobacco smoking status"
      }
    ],
    "text" : "Tobacco smoking status"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-03-21",
  "issued" : "2023-03-21T05:27:04Z",
  "performer" : [
    {
      "reference" : "Practitioner/1"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "266919005"
      }
    ],
    "text" : "Never smoked tobacco (finding)"
  }
}

```
