# Cancer Related Medication Administration - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cancer Related Medication Administration - Example**

## Example MedicationAdministration: Cancer Related Medication Administration - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [mCODE Cancer Related Medication Administration](https://hl7.org/fhir/us/mcode/StructureDefinition-mcode-cancer-related-medication-administration.html)

**status:** completed

**category:** Outpatient

**medication:** rxnorm 72962 docetaxel

**subject:** [Patient-example: Amy Shaw](Patient-example.md)

**start date:** 2023-04-10

**Performer:** Joseph Nichols

**reasonReference:** Condition-primary-cancer-condition-breast

**authoredOn:** 2023-04-10

**note:** Chemotherapy regimen of docetaxel, carboplatin, adriamycin, cyclophosphamide, and paclitaxel administered by continuous infusion. Patient tolerated infusion without side effects.

**Route:** SNOMED 47625008 Intravenous route (qualifier value)



## Resource Content

```json
{
  "resourceType" : "MedicationAdministration",
  "id" : "cancer-med-admin-docetaxel-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-cancer-related-medication-administration"
    ]
  },
  "status" : "completed",
  "category" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medication-admin-category",
        "code" : "outpatient"
      }
    ]
  },
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "72962",
        "display" : "docetaxel"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-04-10",
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/1"
      }
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "408643008",
          "display" : "Infiltrating duct carcinoma of breast (disorder)"
        }
      ]
    }
  ],
  "reasonReference" : [
    {
      "reference" : "Condition/primary-cancer-condition-breast"
    }
  ],
  "note" : [
    {
      "authorReference" : {
        "reference" : "Practitioner/1"
      },
      "time" : "2023-04-10",
      "text" : "docetaxel administered by continuous infusion. Patient tolerated infusion without side effects."
    }
  ],
  "dosage" : {
    "route" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "47625008",
          "display" : "Intravenous route (qualifier value)"
        }
      ]
    },
    "dose" : {
      "value" : 60,
      "unit" : "mg",
      "system" : "http://unitsofmeasure.org",
      "code" : "mg"
    }
  }
}

```
