# Central Cancer Registry Reporting Encounter for Radiation - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Encounter for Radiation - Example**

## Example Encounter: Central Cancer Registry Reporting Encounter for Radiation - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [Central Cancer Registry Reporting Encounter](StructureDefinition-central-cancer-registry-reporting-encounter.md)

**Encounter:** Radiation Therapy

**Identifier:** 9937014

**Status:** finished

**Class:** Ambulatory (AMB)

**Type:** Encounter for problem (procedure) [SNOMED CT: 185347001]

**Patient:** [Patient-example: Amy Shaw](Patient-example.md)

**Period:** January 31, 2024, 5:00 PM – March 31, 2024, 8:00 PM (EST)

**Reason for Encounter:** Radiotherapy course of treatment (regime/therapy) [SNOMED CT: 1217123003]

**Associated Diagnosis:** [Primary Cancer Condition – Breast](Condition-primary-cancer-condition-breast.md)

**Service Provider:** [Cancer Organization](Organization-example-cancer-org.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "encounter-cancer-example-radiation",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-encounter"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org",
      "value" : "9937014"
    }
  ],
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "185347001",
          "display" : "Encounter for problem (procedure)"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "period" : {
    "start" : "2024-01-31T17:00:14-05:00",
    "end" : "2024-03-31T20:00:14-05:00"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "1217123003",
          "display" : "Radiotherapy course of treatment (regime/therapy)"
        }
      ]
    }
  ],
  "diagnosis" : [
    {
      "condition" : {
        "reference" : "Condition/primary-cancer-condition-breast"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/example-cancer-org",
    "display" : "Cancer Organization"
  }
}

```
