# Problem List Condition - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Problem List Condition - Example**

## Example Condition: Problem List Condition - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [US Core Condition Problems and Health Concerns](https://hl7.org/fhir/us/core/StructureDefinition-us-core-condition-problems-health-concerns.html)

**Condition:** Type 2 diabetes mellitus

**Clinical Status:** Active

**Verification Status:** Confirmed

**Category:** Problem List Item

**Code:** ICD-10 E11 — Type 2 diabetes mellitus

**Subject:** [Amy V. Shaw](Patient-example.md)

**Recorded Date:** 2016-08-10



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "problem-list-diabetes",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
      "valueDateTime" : "2016-08-10"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ],
    "text" : "Active"
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ],
    "text" : "Confirmed"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "problem-list-item",
          "display" : "Problem List Item"
        }
      ],
      "text" : "Problem List Item"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10",
        "code" : "E11",
        "display" : "Type 2 diabetes mellitus"
      }
    ],
    "text" : "Type 2 diabetes mellitus"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy V. Shaw"
  },
  "recordedDate" : "2016-08-10T07:15:07-08:00"
}

```
