# Central Cancer Registry Reporting Primary Cancer Condition - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Primary Cancer Condition - Example**

## Example Condition: Central Cancer Registry Reporting Primary Cancer Condition - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [Central Cancer Registry Primary Cancer Condition](StructureDefinition-central-cancer-registry-primary-cancer-condition.md)

**Condition:** Primary Breast Cancer

**Clinical Status:** Active

**Verification Status:** Confirmed

**Category:** Encounter Diagnosis

**Code:** Infiltrating duct carcinoma of breast (SNOMED CT: 408643008)

**Histology/Morphology/Behavior:** Infiltrating duct carcinoma (morphologic abnormality) (SNOMED CT: 82711006)

**Body Site:** Left breast structure (SNOMED CT: 80248007)

**Laterality:** Left (qualifier value) (SNOMED CT: 7771000)

**Subject:** [Patient-example: Amy Shaw](Patient-example.md)

**Asserter:** [Dr. Joseph Nichols](Practitioner-1.md)

**Asserted Date:** 2023-03-21

**Stage Summary:** American Joint Committee on Cancer stage IIA (qualifier value) (SNOMED CT: 1222766008)

**Evidence Type:** Histologic test (procedure) (SNOMED CT: 714797009)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "primary-cancer-condition-breast",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-primary-cancer-condition"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
      "valueDateTime" : "2023-03-21"
    },
    {
      "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-histology-morphology-behavior",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "82711006",
            "display" : "Infiltrating duct carcinoma (morphologic abnormality)"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/cancer-status-evidence-type",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "714797009",
            "display" : "Histologic test (procedure)"
          }
        ]
      }
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "encounter-diagnosis",
          "display" : "Encounter Diagnosis"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "408643008",
        "display" : "Infiltrating duct carcinoma of breast (disorder)"
      }
    ]
  },
  "bodySite" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-laterality-qualifier",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "7771000",
                "display" : "Left (qualifier value)"
              }
            ]
          }
        }
      ],
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "80248007",
          "display" : "Left breast structure (body structure)"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/example"
  },
  "asserter" : {
    "reference" : "Practitioner/1"
  },
  "stage" : [
    {
      "summary" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "1222766008",
            "display" : "American Joint Committee on Cancer stage IIA (qualifier value)"
          }
        ]
      },
      "assessment" : [
        {
          "reference" : "Observation/cancer-stage-group-example"
        }
      ]
    }
  ]
}

```
