# Central Cancer Registry Reporting Data Source Capability Statement - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Data Source Capability Statement**

## CapabilityStatement: Central Cancer Registry Reporting Data Source Capability Statement 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/CapabilityStatement/central-cancer-registry-reporting-ehr | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CentralCancerRegistryReportingEHRCapabilityStatement |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40.13.1 | | |

 
This profile defines the expected capabilities of the ''Data Source'' actor when conforming to the Central Cancer Registry Reporting Content IG. This role is responsible for allowing creation, modification and deletion of Subscriptions and allows searching and retrieval of resources using US Core APIs. 

 [Raw OpenAPI-Swagger Definition file](central-cancer-registry-reporting-ehr.openapi.json) | [Download](central-cancer-registry-reporting-ehr.openapi.json) 

## Data Source

(Requirements Definition Capability Statement)

Canonical URL: http://hl7.org/fhir/us/central-cancer-registry-reporting/CapabilityStatement/central-cancer-registry-reporting-ehr

Published by: **HL7 International - Public Health Work Group** 

This profile defines the expected capabilities of the Data Source actor to support the central cancer registry reporting use cases. Data Sources can be implemented and deployed with Data Submitter capability bundled together also identified as Data Source with Data Submitter functionality. Data Sources may be implemented with an external Data Submitter identified as Data Source with External Data Submitter. The conformance requirements for these different DataSources with and without Data Submitter functionality is different and outlined below. 

## General

* FHIR Version:: Supported formats:
  * 4.0.1: json

## REST Behavior

###  Data Source with Data Submitter functionality bundled together

The primary focus of the Data Source actor is to create the Central Cancer Registry (CCR) Report and send it to the Data Receiver (i.e., Central Cancer Registry).

Data Sources (with built-in Data Submitter functionality) **SHALL** meet the general security requirements documented in FHIR [Security guidance](http://hl7.org/fhir/security.html).

Data Sources (with built-in Data Submitter functionality) **SHALL** be capable of generating the Central Cancer Registry Reporting Bundle in response to a encounter-close and encounter-start trigger events

Data Sources (with built-in Data Submitter functionality) **SHOULD** be capable of submitting the Central Cancer Registry Reporting Bundle to the Data Receiver using $process-message operation.

Data Sources (with built-in Data Submitter functionality) **SHOULD** be capable of submitting the Central Cancer Registry Reporting Content Bundle to the Data Receiver by posting a Bundle to the /Bundle endpoint.

Data Sources (with built-in Data Submitter functionality) **SHALL** support either POSTING a Central Cancer Registry Reporting Bundle to the $process-message operation or POSTING a Central Cancer Registry Reporting Content Bundle to the /Bundle endpoint.

Data Sources (with built-in Data Submitter functionality) **SHALL** use SMART on FHIR Backend Services to authenticate and authorize with the Data Receiver to submit the entral Cancer Registry Report.

### Data Source supporting an External Data Submitter Application

The primary focus of the Data Source actor is to allow the creation, modification and deletion of Subscriptions, notify subscribers based on subscriptions, and support US Core APIs.

The rest of the requirements identified below in this capability statement only apply Data Sources supporting external Data Submitter Applications.

 **Security Requirements:** 

Data Sources supporting external Data Submitter applications must meet the general security requirements documented in FHIR [Security guidance](http://hl7.org/fhir/security.html).

In addition the Data Source supporting external Data Submitter applications needs to meet the security requirements as outlined in the [Formal Specification - SMART on FHIR Backend Services Requirements.](spec.md#smart-on-fhir-backend-services-requirements)

### US Core Support

 The Data Source supporting external Data Submitter (e.g EHR) **SHALL** implement the [US Core Server capability statement](http://hl7.org/fhir/us/core/STU6.1/CapabilityStatement-us-core-server.html) as foundational FHIR APIs needed by the Central Cancer Registry Reporting IG. 

### mCode Support

 The Data Source **SHALL** implement the [mCode profiles](spec.md#mcode-fhir-ig-usage) outlined to support the Central Cancer Registry Reporting IG. 

### Resource summary for Data Sources supporting external Data Submitter applications

* [Backported Subscription](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/StructureDefinition-backport-subscription.html): Encounter Close and Encounter Start Subscription Topics
  * : 
  * [SHALL](#Subscription-read): [SHALL](#Subscription-read)
  * : 
  * : 
  * : 
  * [SHALL](#Subscription-create): [SHALL](#Subscription-create)
  * [SHALL](#Subscription-update): [SHALL](#Subscription-update)
  * [SHALL](#Subscription-delete): [SHALL](#Subscription-delete)
  * [$topic-list](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/OperationDefinition-backport-subscriptiontopic-list.html)[$status](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/OperationDefinition-backport-subscription-status.html): 
* [Backported Subscription](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/StructureDefinition-backport-subscription.html): [Backport Subscription Notification Bundle](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/StructureDefinition-backport-subscription-notification.html)
  * : 
  * [SHALL](#Subscription-read): 
  * : 
  * : 
  * : 
  * [SHALL](#Subscription-create): [SHALL](#Notification-Bundle-create)
  * [SHALL](#Subscription-update): 
  * [SHALL](#Subscription-delete): 
  * [$topic-list](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/OperationDefinition-backport-subscriptiontopic-list.html)[$status](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/OperationDefinition-backport-subscription-status.html): 
* [Backported Subscription](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/StructureDefinition-backport-subscription.html): [Backport Subscription Status](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/StructureDefinition-backport-subscriptionstatus.html)
  * : 
  * [SHALL](#Subscription-read): [SHALL](#Subscription-Status-read)
  * : 
  * : 
  * : 
  * [SHALL](#Subscription-create): 
  * [SHALL](#Subscription-update): 
  * [SHALL](#Subscription-delete): 
  * [$topic-list](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/OperationDefinition-backport-subscriptiontopic-list.html)[$status](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/OperationDefinition-backport-subscription-status.html): 
* [Backported Subscription](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/StructureDefinition-backport-subscription.html): US Core APIs
  * : [SHALL](#USCore-search-type)
  * [SHALL](#Subscription-read): [SHALL](#USCore-read)
  * : 
  * : 
  * : 
  * [SHALL](#Subscription-create): 
  * [SHALL](#Subscription-update): 
  * [SHALL](#Subscription-delete): 
  * [$topic-list](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/OperationDefinition-backport-subscriptiontopic-list.html)[$status](http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/OperationDefinition-backport-subscription-status.html): 

###  Subscription (Includes Subscriptions for encounter-start and encounter-close Subscription Topic) 

Profile: http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/StructureDefinition-backport-subscription.html 

#### Interactions

*  read:  create
  * Allows retrieval of a specific Subscription instance.: Allows creation of Subscription instances
*  read:  update
  * Allows retrieval of a specific Subscription instance.: Allows Update of Subscription instances
*  read:  delete
  * Allows retrieval of a specific Subscription instance.: Allows deletion of Subscription instances

###  Bundle (Notification Bundle for Subscriptions) 

Profile: http://build.fhir.org/ig/HL7/fhir-subscription-backport-ig/StructureDefinition-backport-subscription-notification.html) 

#### Interactions


###  Parameters (Parameters Profile to retrieve Subscription Status) 

Profile: "subscriptionstatus profile from Subscription-backport Implementation Guide" 

#### Interactions


###  US Core APIs 

Profile: All US Core profiles 

#### Interactions

*  search:  read
  * Allows searching of specific US Core resource profile instances.: Allows retrieval of specific US Core resource profile instances



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "central-cancer-registry-reporting-ehr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    }
  ],
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/CapabilityStatement/central-cancer-registry-reporting-ehr",
  "version" : "2.0.0-ballot",
  "name" : "CentralCancerRegistryReportingEHRCapabilityStatement",
  "title" : "Central Cancer Registry Reporting Data Source Capability Statement",
  "status" : "draft",
  "date" : "2020-12-06",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "This profile defines the expected capabilities of the ''Data Source'' actor when conforming to the Central Cancer Registry Reporting Content IG.     This role is responsible for allowing creation, modification and deletion of Subscriptions and allows searching and retrieval of resources using US Core APIs.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json"],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "The focus of the Data Source is to allow creation, modification and deletion of Subscriptions and allows searching and retrieval of resources using US Core APIs. ",
      "security" : {
        "description" : "Implementations must meet the general security requirements documented in the security section of the implementation guide."
      },
      "resource" : [
        {
          "type" : "Subscription",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read",
              "documentation" : "Allows retrieval of a specific Subscription instance."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "create",
              "documentation" : "Allows creation of a Subscription resource instance."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "update",
              "documentation" : "Allows update of a Subscription resource instance."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "code" : "delete",
              "documentation" : "Allows deletion of a Subscription resource instance."
            }
          ]
        }
      ]
    }
  ]
}

```
