# CCRR Reporting Bundle - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCRR Reporting Bundle - Example**

## Example Bundle: CCRR Reporting Bundle - Example



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "reporting-bundle-example",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2020-11-29T02:03:28.045+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-reporting-bundle"
    ]
  },
  "type" : "message",
  "timestamp" : "2020-11-20T11:15:33-10:00",
  "entry" : [
    {
      "fullUrl" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/MessageHeader/messageheader-example-reportheader",
      "resource" : {
        "resourceType" : "MessageHeader",
        "id" : "messageheader-example-reportheader",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2020-11-29T02:03:28.045+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-messageheader"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MessageHeader_messageheader-example-reportheader\"> </a>\n            <p>Reporting Data</p> \n          </div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-data-encrypted-extension",
            "valueBoolean" : false
          },
          {
            "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-message-processing-category-extension",
            "valueCode" : "consequence"
          }
        ],
        "eventCoding" : {
          "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-message-types",
          "code" : "cancer-report-message"
        },
        "destination" : [
          {
            "name" : "PHA endpoint",
            "endpoint" : "http://example.pha.org/fhir"
          }
        ],
        "sender" : {
          "reference" : "Organization/example-cancer-org"
        },
        "source" : {
          "name" : "Cancer Organization",
          "software" : "Backend Service App",
          "version" : "3.1.45.AABB",
          "contact" : {
            "system" : "phone",
            "value" : "+1 (917) 123 4567"
          },
          "endpoint" : "http://example.healthcare.org/fhir"
        },
        "reason" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-triggerdefinition-namedevents",
              "code" : "encounter-close"
            }
          ]
        },
        "focus" : [
          {
            "reference" : "Bundle/content-bundle-example"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/Bundle/content-bundle-example",
      "resource" : {
        "resourceType" : "Bundle",
        "id" : "content-bundle-example",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2020-11-29T02:03:28.045+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-content-bundle"
          ]
        },
        "type" : "collection",
        "timestamp" : "2020-11-20T11:15:33-10:00",
        "entry" : [
          {
            "fullUrl" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/Composition/ccrr-composition-content-example",
            "resource" : {
              "resourceType" : "Composition",
              "id" : "ccrr-composition-content-example",
              "meta" : {
                "versionId" : "23",
                "lastUpdated" : "2021-08-19T22:06:32.441+00:00",
                "profile" : [
                  "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-composition"
                ]
              },
              "text" : {
                "status" : "extensions",
                "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n\t\t\t\t\t\t\t\t\t<p>Amy Shaw data for Cancer </p>\n\t\t\t\t\t\t\t\t</div>"
              },
              "identifier" : {
                "value" : "c03eab8c-11e8-4d0c-ad2a-b385395e27db"
              },
              "status" : "final",
              "type" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "72134-0"
                  }
                ]
              },
              "subject" : {
                "reference" : "Patient/example",
                "display" : "Amy Shaw"
              },
              "encounter" : {
                "reference" : "Encounter/encounter-cancer-example",
                "display" : "Patient encounter procedure"
              },
              "date" : "2023-01-02T22:13:23Z",
              "author" : [
                {
                  "reference" : "Practitioner/1",
                  "display" : "Nicholas Joseph"
                }
              ],
              "title" : "Central Cancer Registry Report",
              "section" : [
                {
                  "title" : "Primary Cancer Condition Section",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://snomed.info/sct",
                        "code" : "363346000",
                        "display" : "Malignant neoplastic disease (disorder)"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n\t\t\t\t\t\t\t\t\t\t<p>Primary Cancer Condition Section</p>\n\t\t\t\t\t\t\t\t\t</div>"
                  },
                  "entry" : [
                    {
                      "reference" : "Condition/primary-cancer-condition-breast"
                    }
                  ]
                },
                {
                  "title" : "Cancer Stage Group section",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "21908-9",
                        "display" : "Stage group.clinical Cancer"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n\t\t\t\t\t\t\t\t\t\t<p>Cancer Stage Group</p>\n\t\t\t\t\t\t\t\t\t</div>"
                  },
                  "entry" : [
                    {
                      "reference" : "Observation/cancer-stage-group-example"
                    }
                  ]
                },
                {
                  "title" : "Cancer Radio Therapy Course Summary section",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://snomed.info/sct",
                        "code" : "1217123003",
                        "display" : "Radiotherapy course of treatment"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n\t\t\t\t\t\t\t\t\t\t<p>Cancer Radio Therapy Course Summary</p>\n\t\t\t\t\t\t\t\t\t</div>"
                  },
                  "entry" : [
                    {
                      "reference" : "Procedure/radiotherapy-example"
                    }
                  ]
                },
                {
                  "title" : "Medications Section",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "10160-0",
                        "display" : "History of Medication use Narrative"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n\t\t\t\t\t\t\t\t\t\t<p>Medications section: cancer-related medication</p>\n\t\t\t\t\t\t\t\t\t</div>"
                  },
                  "entry" : [
                    {
                      "reference" : "MedicationAdministration/cancer-med-admin-docetaxel-example"
                    }
                  ]
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/Organization/example-cancer-org",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "example-cancer-org",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_example-cancer-org\"> </a>\n  <p><b>Profile: </b> <a href=\"StructureDefinition-central-cancer-registry-reporting-organization.html\"> Central Cancer Registry Reporting Organization</a></p>\n  <p><b>Organization:</b> Cancer Organization</p>\n    <p><b>Status:</b> Active</p>\n  <p><b>Identifier (NPI):</b> 1063494177</p>\n   <p><b>Address:</b> 1234 Main Street, Tulsa, OK 74126</p>\n  <p><b>Phone:</b> (917)932-2000</p>\n </div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "1063494177"
          }
        ],
        "active" : true,
        "name" : "Cancer Organization",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "(917)932-2000",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "text" : "1234 Main Street, Tulsa OK 74126",
            "line" : ["1234 Main Street"],
            "city" : "Tulsa",
            "state" : "OK",
            "postalCode" : "74126"
          }
        ]
      }
    }
  ]
}

```
