# CCRR Specification Bundle - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCRR Specification Bundle - Example**

## Example Bundle: CCRR Specification Bundle - Example



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "central-cancer-registry-reporting-specification-bundle-example",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2020-11-29T02:03:28.045+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-specification-bundle"
    ]
  },
  "type" : "collection",
  "timestamp" : "2020-11-20T11:15:33-10:00",
  "entry" : [
    {
      "fullUrl" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ValueSet/cancer-core-reportability-codes-example",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "cancer-core-reportability-codes-example",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_cancer-core-reportability-codes-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet cancer-core-reportability-codes-example</b></p><p>This value set includes codes based on the following rules:</p><ul><li>Include these codes as defined in <a href=\"http://www.snomed.org/\"><code>http://snomed.info/sct</code></a><table class=\"none\"><tr><td style=\"white-space:nowrap\"><b>Code</b></td><td><b>Display</b></td></tr><tr><td><a href=\"http://snomed.info/id/281566005\">281566005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403901001\">403901001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254654004\">254654004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413389003\">413389003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783771003\">783771003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/822969007\">822969007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/822970008\">822970008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126949007\">126949007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/2961000119106\">2961000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/16594841000119106\">16594841000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764856008\">764856008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254732008\">254732008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/789051005\">789051005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278453007\">278453007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277604002\">277604002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91855006\">91855006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91854005\">91854005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721308005\">721308005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371012000\">371012000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91857003\">91857003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91856007\">91856007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12301000132103\">12301000132103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277602003\">277602003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277601005\">277601005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698646006\">698646006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413441006\">413441006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91858008\">91858008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413442004\">413442004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766045006\">766045006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766048008\">766048008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766046007\">766046007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721305008\">721305008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91860005\">91860005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764855007\">764855007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/734522002\">734522002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838355002\">838355002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/780844005\">780844005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/359648001\">359648001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426124006\">426124006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445448008\">445448008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763309005\">763309005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733598001\">733598001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/725390002\">725390002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444911000\">444911000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/359640008\">359640008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/61321000119106\">61321000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91861009\">91861009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/359631009\">359631009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/61311000119104\">61311000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285839005\">285839005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/110005000\">110005000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/427658007\">427658007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109991003\">109991003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285769009\">285769009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/110004001\">110004001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425869007\">425869007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/433067002\">433067002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307609003\">307609003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/101371000119101\">101371000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423595004\">423595004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/29421000119105\">29421000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/99741000119100\">99741000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254890008\">254890008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838352004\">838352004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/29431000119108\">29431000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764845008\">764845008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423607006\">423607006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413445002\">413445002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255110003\">255110003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/865954003\">865954003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413446001\">413446001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254887002\">254887002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/408644002\">408644002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123845008\">123845008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276803003\">276803003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/765741003\">765741003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/441535001\">441535001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/304545002\">304545002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254988008\">254988008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/408645001\">408645001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15956341000119105\">15956341000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/408646000\">408646000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/787091002\">787091002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449153001\">449153001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254626006\">254626006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424078005\">424078005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424632001\">424632001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424454009\">424454009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424993006\">424993006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838349007\">838349007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423106003\">423106003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255017003\">255017003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/700423003\">700423003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423746001\">423746001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764846009\">764846009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255016007\">255016007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399490008\">399490008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425178004\">425178004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254582000\">254582000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15956381000119100\">15956381000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447800002\">447800002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/301756000\">301756000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424440001\">424440001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/408647009\">408647009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/309245001\">309245001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763063001\">763063001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763064007\">763064007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254987003\">254987003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423318000\">423318000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423615009\">423615009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422833009\">422833009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423189008\">423189008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254619006\">254619006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254711000\">254711000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/385478001\">385478001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764847000\">764847000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/765740002\">765740002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447390000\">447390000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254888007\">254888007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403902008\">403902008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404067008\">404067008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255035007\">255035007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/281562007\">281562007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188729005\">188729005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/110007008\">110007008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721762007\">721762007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/240531002\">240531002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/397008008\">397008008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721310007\">721310007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404136008\">404136008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716655008\">716655008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302856006\">302856006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426217000\">426217000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188728002\">188728002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426248008\">426248008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/770402000\">770402000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188748009\">188748009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188741003\">188741003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/127961000119108\">127961000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/715950008\">715950008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109982002\">109982002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123313007\">123313007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/25050002\">25050002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404053004\">404053004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404056007\">404056007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276751004\">276751004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403485001\">403485001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/439891000\">439891000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277461004\">277461004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/82501000119102\">82501000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/370987005\">370987005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424151006\">424151006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448212009\">448212009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/703626001\">703626001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404134006\">404134006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/830055006\">830055006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/830151004\">830151004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/738770003\">738770003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255031003\">255031003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404135007\">404135007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255102004\">255102004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413537009\">413537009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403977003\">403977003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447757002\">447757002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109844006\">109844006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254794007\">254794007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/16091171000119106\">16091171000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187821001\">187821001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402910001\">402910001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447886005\">447886005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403949007\">403949007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403742006\">403742006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/762457009\">762457009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254938000\">254938000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/107581000119103\">107581000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/99131000119108\">99131000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254948003\">254948003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/440422002\">440422002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277589003\">277589003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307341004\">307341004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/20991001\">20991001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/778006008\">778006008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/771309000\">771309000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838346000\">838346000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838344002\">838344002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838343008\">838343008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838342003\">838342003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838340006\">838340006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723889003\">723889003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838341005\">838341005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403922007\">403922007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/45019006\">45019006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307592006\">307592006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/350951000119101\">350951000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/351211000119104\">351211000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722953004\">722953004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722954005\">722954005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277619001\">277619001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/788874003\">788874003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275269004\">275269004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/838304009\">838304009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724171006\">724171006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91959004\">91959004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91960009\">91960009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91962001\">91962001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92030004\">92030004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92029009\">92029009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189162003\">189162003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92047003\">92047003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92048008\">92048008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92050000\">92050000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92051001\">92051001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92052008\">92052008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92071005\">92071005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92072003\">92072003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/34041000119108\">34041000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92099001\">92099001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92114009\">92114009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92122002\">92122002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92136007\">92136007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/429691007\">429691007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/429765002\">429765002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109913001\">109913001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92247009\">92247009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92253009\">92253009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92255002\">92255002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92256001\">92256001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92257005\">92257005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254977002\">254977002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92276007\">92276007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92294001\">92294001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92296004\">92296004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/271479005\">271479005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/135884009\">135884009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92405007\">92405007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/427939000\">427939000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/8551000119100\">8551000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/429306002\">429306002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92406008\">92406008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92427003\">92427003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92451008\">92451008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92453006\">92453006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92474007\">92474007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447655002\">447655002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425868004\">425868004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448135004\">448135004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254981002\">254981002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254943007\">254943007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255200003\">255200003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254970000\">254970000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404052009\">404052009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403484002\">403484002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399929008\">399929008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/398679002\">398679002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/400118002\">400118002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399990001\">399990001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399911003\">399911003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/398831006\">398831006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313351009\">313351009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783541009\">783541009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404115006\">404115006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713897006\">713897006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118617000\">118617000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188512009\">188512009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188515006\">188515006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188511002\">188511002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188513004\">188513004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188514005\">188514005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188517003\">188517003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188516007\">188516007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92516002\">92516002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92511007\">92511007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92512000\">92512000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92513005\">92513005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/395099008\">395099008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373795004\">373795004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373798002\">373798002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373794000\">373794000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373796003\">373796003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373799005\">373799005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373800009\">373800009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373797007\">373797007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254841008\">254841008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92546004\">92546004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423987006\">423987006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/778066006\">778066006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253003009\">253003009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253002004\">253002004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425318003\">425318003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254627002\">254627002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254613007\">254613007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713306000\">713306000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276808007\">276808007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275395000\">275395000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286896005\">286896005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255086002\">255086002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254989000\">254989000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425127006\">425127006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109355002\">109355002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254428001\">254428001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254432007\">254432007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254544008\">254544008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92523001\">92523001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92524007\">92524007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92525008\">92525008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92526009\">92526009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92527000\">92527000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92528005\">92528005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92529002\">92529002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92530007\">92530007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92531006\">92531006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722713005\">722713005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92532004\">92532004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254510001\">254510001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254460009\">254460009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92534003\">92534003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254406001\">254406001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254409008\">254409008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255132007\">255132007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92535002\">92535002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92536001\">92536001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92537005\">92537005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92538000\">92538000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92539008\">92539008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92540005\">92540005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92541009\">92541009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189258000\">189258000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189255002\">189255002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92542002\">92542002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92543007\">92543007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92544001\">92544001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92545000\">92545000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92547008\">92547008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92548003\">92548003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92549006\">92549006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92550006\">92550006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92768006\">92768006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189336000\">189336000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92551005\">92551005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92557009\">92557009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189262006\">189262006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92552003\">92552003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92553008\">92553008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92554002\">92554002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92555001\">92555001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92556000\">92556000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92558004\">92558004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92560002\">92560002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189263001\">189263001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92559007\">92559007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92562005\">92562005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92563000\">92563000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92565007\">92565007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92566008\">92566008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92567004\">92567004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92568009\">92568009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92569001\">92569001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92570000\">92570000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702712006\">702712006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92571001\">92571001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92572008\">92572008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189256001\">189256001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92573003\">92573003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189253009\">189253009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189257005\">189257005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92574009\">92574009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92575005\">92575005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109850001\">109850001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449802004\">449802004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92576006\">92576006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92577002\">92577002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255144005\">255144005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255138006\">255138006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92578007\">92578007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92579004\">92579004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92580001\">92580001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92581002\">92581002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92582009\">92582009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255146007\">255146007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92583004\">92583004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92584005\">92584005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92585006\">92585006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92586007\">92586007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92587003\">92587003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92588008\">92588008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92589000\">92589000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92590009\">92590009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92591008\">92591008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92593006\">92593006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92594000\">92594000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92595004\">92595004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254418005\">254418005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254394005\">254394005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254403009\">254403009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254399000\">254399000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92597007\">92597007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92598002\">92598002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92599005\">92599005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92600008\">92600008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92601007\">92601007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92602000\">92602000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92603005\">92603005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92604004\">92604004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92605003\">92605003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92606002\">92606002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92607006\">92607006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189243008\">189243008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92608001\">92608001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92609009\">92609009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92610004\">92610004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92611000\">92611000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92612007\">92612007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92613002\">92613002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92614008\">92614008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92617001\">92617001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92618006\">92618006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92619003\">92619003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92620009\">92620009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92621008\">92621008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92622001\">92622001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92623006\">92623006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92624000\">92624000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92625004\">92625004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92626003\">92626003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422607004\">422607004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92628002\">92628002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422893006\">422893006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92629005\">92629005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92630000\">92630000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92631001\">92631001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92632008\">92632008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92633003\">92633003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92634009\">92634009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92636006\">92636006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92637002\">92637002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92638007\">92638007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92639004\">92639004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92640002\">92640002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254564003\">254564003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92642005\">92642005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92643000\">92643000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92644006\">92644006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/271525004\">271525004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254446007\">254446007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92645007\">92645007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92646008\">92646008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255137001\">255137001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254455005\">254455005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189267000\">189267000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92647004\">92647004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92648009\">92648009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92649001\">92649001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254639005\">254639005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92650001\">92650001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92651002\">92651002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92652009\">92652009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92653004\">92653004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92654005\">92654005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92655006\">92655006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92656007\">92656007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92657003\">92657003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255139003\">255139003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189266009\">189266009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92658008\">92658008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92659000\">92659000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92660005\">92660005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92661009\">92661009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92662002\">92662002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92663007\">92663007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255140001\">255140001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/416921001\">416921001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92664001\">92664001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92665000\">92665000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92666004\">92666004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722664004\">722664004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/785798002\">785798002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255131000\">255131000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92668003\">92668003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92669006\">92669006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92670007\">92670007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92672004\">92672004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92673009\">92673009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92674003\">92674003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92675002\">92675002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92676001\">92676001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92677005\">92677005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92678000\">92678000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92679008\">92679008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92680006\">92680006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92681005\">92681005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92682003\">92682003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92683008\">92683008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92684002\">92684002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92685001\">92685001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92686000\">92686000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254514005\">254514005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92687009\">92687009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92688004\">92688004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92689007\">92689007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92690003\">92690003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92596003\">92596003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92691004\">92691004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255149000\">255149000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92692006\">92692006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92693001\">92693001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92694007\">92694007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92695008\">92695008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92696009\">92696009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189231007\">189231007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92697000\">92697000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255142009\">255142009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189251006\">189251006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92698005\">92698005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92699002\">92699002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92700001\">92700001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92701002\">92701002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92702009\">92702009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92703004\">92703004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92704005\">92704005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189212001\">189212001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109827007\">109827007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189292002\">189292002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189291009\">189291009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92705006\">92705006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92706007\">92706007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92707003\">92707003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92708008\">92708008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92749008\">92749008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92709000\">92709000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92710005\">92710005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189279000\">189279000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92712002\">92712002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92713007\">92713007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92714001\">92714001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92715000\">92715000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92716004\">92716004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92717008\">92717008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92718003\">92718003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92719006\">92719006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92720000\">92720000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189280002\">189280002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92722008\">92722008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92723003\">92723003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189277003\">189277003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92724009\">92724009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92725005\">92725005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92726006\">92726006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92727002\">92727002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92728007\">92728007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92729004\">92729004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92730009\">92730009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92731008\">92731008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189289001\">189289001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92732001\">92732001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92734000\">92734000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189317005\">189317005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92735004\">92735004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92736003\">92736003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92737007\">92737007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723164006\">723164006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92738002\">92738002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92739005\">92739005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92740007\">92740007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92741006\">92741006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189288009\">189288009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92742004\">92742004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92743009\">92743009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92744003\">92744003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92745002\">92745002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92746001\">92746001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189308005\">189308005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92747005\">92747005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92748000\">92748000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92750008\">92750008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92751007\">92751007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92752000\">92752000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92753005\">92753005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189246000\">189246000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92754004\">92754004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189229003\">189229003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92756002\">92756002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92757006\">92757006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92758001\">92758001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92759009\">92759009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92760004\">92760004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92761000\">92761000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255145006\">255145006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92762007\">92762007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92763002\">92763002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92764008\">92764008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254540004\">254540004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92766005\">92766005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189252004\">189252004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92767001\">92767001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254413001\">254413001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92769003\">92769003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92671006\">92671006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92770002\">92770002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92771003\">92771003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92772005\">92772005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92773000\">92773000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92774006\">92774006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189272009\">189272009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189271002\">189271002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92775007\">92775007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254442009\">254442009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92776008\">92776008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92777004\">92777004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255136005\">255136005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189265008\">189265008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92778009\">92778009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92779001\">92779001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92780003\">92780003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92781004\">92781004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92782006\">92782006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92783001\">92783001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92784007\">92784007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92785008\">92785008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92786009\">92786009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255150000\">255150000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92787000\">92787000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92564006\">92564006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92788005\">92788005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92789002\">92789002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92790006\">92790006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92791005\">92791005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92792003\">92792003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92793008\">92793008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92794002\">92794002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92795001\">92795001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92796000\">92796000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92797009\">92797009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189259008\">189259008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92798004\">92798004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92799007\">92799007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92800006\">92800006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92801005\">92801005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92802003\">92802003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92803008\">92803008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275492001\">275492001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254451001\">254451001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286887005\">286887005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254543002\">254543002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254609000\">254609000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285310000\">285310000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254427006\">254427006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275396004\">275396004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448315008\">448315008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448992002\">448992002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/312111009\">312111009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276876007\">276876007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/271943005\">271943005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255108000\">255108000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363368005\">363368005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254557000\">254557000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255068000\">255068000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448989001\">448989001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254838004\">254838004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286897001\">286897001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286894008\">286894008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286893002\">286893002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286895009\">286895009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254553001\">254553001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255081007\">255081007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/708921005\">708921005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254535007\">254535007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285432005\">285432005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254889004\">254889004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447949005\">447949005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269533000\">269533000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425213009\">425213009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422581008\">422581008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422375001\">422375001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422985007\">422985007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254404003\">254404003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449073009\">449073009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/312113007\">312113007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254570009\">254570009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372098004\">372098004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254612002\">254612002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/840573001\">840573001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372138000\">372138000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372100004\">372100004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372101000\">372101000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449211009\">449211009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276870001\">276870001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447782002\">447782002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449156009\">449156009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254909003\">254909003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254417000\">254417000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254393004\">254393004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254402004\">254402004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254398008\">254398008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254555008\">254555008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449054005\">449054005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372140005\">372140005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286899003\">286899003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255066001\">255066001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254904008\">254904008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372103002\">372103002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254567005\">254567005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254434008\">254434008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/326072005\">326072005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/312114001\">312114001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449253005\">449253005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276975007\">276975007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254431000\">254431000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254563009\">254563009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254423005\">254423005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269515006\">269515006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255069008\">255069008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254445006\">254445006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254425003\">254425003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254454009\">254454009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286890004\">286890004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372111007\">372111007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254551004\">254551004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448993007\">448993007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372120003\">372120003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372096000\">372096000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449487002\">449487002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449077005\">449077005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254549003\">254549003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275397008\">275397008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448990005\">448990005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422758009\">422758009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449417005\">449417005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448988009\">448988009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424600001\">424600001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424486004\">424486004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423480004\">423480004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423274005\">423274005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372142002\">372142002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254462001\">254462001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372116002\">372116002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372106005\">372106005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447781009\">447781009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449254004\">449254004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448863000\">448863000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254900004\">254900004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254559002\">254559002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254561006\">254561006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448215006\">448215006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254457002\">254457002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372121004\">372121004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716593008\">716593008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285312008\">285312008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449416001\">449416001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286891000\">286891000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372125008\">372125008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372127000\">372127000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372129002\">372129002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448664009\">448664009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254435009\">254435009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448314007\">448314007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/312115000\">312115000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372143007\">372143007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372104008\">372104008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254466003\">254466003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254465004\">254465004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372105009\">372105009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363369002\">363369002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269544008\">269544008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254539001\">254539001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448216007\">448216007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423349005\">423349005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275490009\">275490009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/312112002\">312112002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254441002\">254441002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254424004\">254424004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254450000\">254450000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286889008\">286889008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448994001\">448994001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254547001\">254547001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448864006\">448864006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448954003\">448954003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425066001\">425066001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425231005\">425231005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423973006\">423973006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/446022000\">446022000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254436005\">254436005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254893005\">254893005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254390001\">254390001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254389005\">254389005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372141009\">372141009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447882007\">447882007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275394001\">275394001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402813000\">402813000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307593001\">307593001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255121007\">255121007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/836274002\">836274002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404092006\">404092006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15930941000119108\">15930941000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764951002\">764951002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764952009\">764952009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15930861000119100\">15930861000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702368000\">702368000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15930901000119106\">15930901000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404087009\">404087009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723173003\">723173003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702369008\">702369008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444869007\">444869007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404129007\">404129007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404128004\">404128004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404130002\">404130002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404131003\">404131003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404126000\">404126000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404127009\">404127009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404026003\">404026003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721535002\">721535002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716592003\">716592003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126948004\">126948004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126947009\">126947009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189164002\">189164002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403951006\">403951006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/439776006\">439776006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/454721000124105\">454721000124105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404653000\">404653000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/705061009\">705061009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188737002\">188737002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/312104005\">312104005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443520009\">443520009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447792005\">447792005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/830196006\">830196006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/446939001\">446939001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/130891000119106\">130891000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/833285007\">833285007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/130911000119108\">130911000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447730004\">447730004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/833295000\">833295000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188188009\">188188009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254870004\">254870004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448401007\">448401007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733471003\">733471003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92812005\">92812005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123781000119107\">123781000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92811003\">92811003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/725437002\">725437002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277549009\">277549009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122961000119105\">122961000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92813000\">92813000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92814006\">92814006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722955006\">722955006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188745007\">188745007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122881000119107\">122881000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92818009\">92818009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413842007\">413842007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413843002\">413843002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/92817004\">92817004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/127225006\">127225006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109993000\">109993000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413847001\">413847001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699704002\">699704002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/765328000\">765328000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/762690000\">762690000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763131005\">763131005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254915003\">254915003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1081571000119102\">1081571000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1081581000119104\">1081581000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403940006\">403940006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/734015000\">734015000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254652000\">254652000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733470002\">733470002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/274902006\">274902006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277573001\">277573001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/840518004\">840518004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/840516000\">840516000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/860982007\">860982007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/840515001\">840515001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/840513008\">840513008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/190030009\">190030009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402559007\">402559007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702446006\">702446006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254958004\">254958004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189179009\">189179009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254748009\">254748009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254771006\">254771006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404047004\">404047004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277613000\">277613000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254916002\">254916002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314191009\">314191009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/235966007\">235966007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/703387000\">703387000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126361000119107\">126361000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/98791000119102\">98791000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126371000119101\">126371000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404072004\">404072004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/20224008\">20224008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276799004\">276799004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448296006\">448296006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447710003\">447710003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404010004\">404010004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404009009\">404009009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404008001\">404008001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/830015009\">830015009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/780822000\">780822000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403924008\">403924008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/389216001\">389216001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449220000\">449220000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277626001\">277626001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/11471000224106\">11471000224106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404148006\">404148006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724647003\">724647003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/734066005\">734066005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/840423002\">840423002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/840424008\">840424008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/770628008\">770628008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277616008\">277616008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302842009\">302842009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277632006\">277632006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307624007\">307624007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277628000\">277628000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277629008\">277629008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188674006\">188674006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277526007\">277526007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713718006\">713718006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109962001\">109962001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/68261000119102\">68261000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/68271000119108\">68271000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/456911000124108\">456911000124108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/68291000119109\">68291000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449177007\">449177007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449221001\">449221001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448560008\">448560008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449176003\">449176003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448867004\">448867004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448319002\">448319002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449065000\">449065000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448468003\">448468003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448609001\">448609001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448213004\">448213004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449217008\">449217008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449216004\">449216004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448663003\">448663003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448465000\">448465000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449173006\">449173006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448607004\">448607004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188679001\">188679001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109966003\">109966003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109969005\">109969005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109965004\">109965004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109968002\">109968002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109967007\">109967007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109964000\">109964000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/708971008\">708971008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369748008\">369748008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254709009\">254709009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285645000\">285645000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/720587009\">720587009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/737169005\">737169005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/87211000119104\">87211000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254874008\">254874008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276809004\">276809004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722956007\">722956007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/608874000\">608874000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/400173004\">400173004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403939009\">403939009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254708001\">254708001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254872007\">254872007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/734065009\">734065009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404051002\">404051002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716648006\">716648006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254945000\">254945000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254954002\">254954002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123842006\">123842006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447760009\">447760009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254876005\">254876005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254878006\">254878006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/732201008\">732201008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699356008\">699356008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278060005\">278060005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254852002\">254852002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277654008\">277654008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/238476000\">238476000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/715901002\">715901002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443643007\">443643007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254939008\">254939008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/107561000119107\">107561000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/147121000119104\">147121000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/101571000119107\">101571000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254949006\">254949006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/427038005\">427038005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426964009\">426964009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254800003\">254800003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403981003\">403981003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/860831008\">860831008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404045007\">404045007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404038007\">404038007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/782827000\">782827000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/609515005\">609515005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/60620005\">60620005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716586009\">716586009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716788007\">716788007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404114005\">404114005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93451002\">93451002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426642002\">426642002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109994006\">109994006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/78411000119107\">78411000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91041000119104\">91041000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307608006\">307608006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447951009\">447951009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/683991000119103\">683991000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/782672006\">782672006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254727007\">254727007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188718006\">188718006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/768926005\">768926005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445269007\">445269007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/414166008\">414166008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716649003\">716649003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404080006\">404080006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404079008\">404079008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/860832001\">860832001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404077005\">404077005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373888000\">373888000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716787002\">716787002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702375004\">702375004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/726019003\">726019003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/715414009\">715414009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/765202001\">765202001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/786038001\">786038001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716657000\">716657000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/715412008\">715412008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/717736007\">717736007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/720950009\">720950009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721314003\">721314003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254703005\">254703005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253018005\">253018005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448139005\">448139005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187822008\">187822008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254820002\">254820002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404147001\">404147001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/84811000119107\">84811000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/84831000119102\">84831000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277618009\">277618009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721555001\">721555001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277624003\">277624003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277625002\">277625002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404109006\">404109006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447711004\">447711004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/308121000\">308121000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702977001\">702977001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702786004\">702786004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448666006\">448666006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448995000\">448995000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448561007\">448561007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449419008\">449419008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448672006\">448672006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354851000119101\">354851000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449219006\">449219006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448231003\">448231003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449063007\">449063007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449307001\">449307001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448217003\">448217003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448865007\">448865007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448317000\">448317000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449222008\">449222008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449418000\">449418000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449058008\">449058008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449059000\">449059000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109972003\">109972003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109971005\">109971005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109970006\">109970006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188672005\">188672005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255028004\">255028004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448148000\">448148000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254962005\">254962005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448563005\">448563005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109984001\">109984001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/782680004\">782680004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/116381000119105\">116381000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733926004\">733926004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/771474005\">771474005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276811008\">276811008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/7021009\">7021009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449072004\">449072004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369702004\">369702004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/860828007\">860828007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/860830009\">860830009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/420120006\">420120006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/446124001\">446124001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/446925001\">446925001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445737002\">445737002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445736006\">445736006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404121005\">404121005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/429565004\">429565004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/787125004\">787125004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/767444009\">767444009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/417570003\">417570003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254631008\">254631008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404016005\">404016005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699659007\">699659007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766930002\">766930002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254936001\">254936001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254946004\">254946004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/393563007\">393563007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276828006\">276828006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/147131000119101\">147131000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276829003\">276829003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/393564001\">393564001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444545003\">444545003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724807008\">724807008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254947008\">254947008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/782722002\">782722002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/431911000124102\">431911000124102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254960002\">254960002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/67771000119102\">67771000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/90831000119105\">90831000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404155008\">404155008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404112009\">404112009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118613001\">118613001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93151007\">93151007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277568007\">277568007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277369003\">277369003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/237714006\">237714006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/237720007\">237720007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/39795003\">39795003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/68979007\">68979007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93468003\">93468003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277522009\">277522009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109843000\">109843000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699657009\">699657009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445406001\">445406001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/427685000\">427685000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/718220008\">718220008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/717003001\">717003001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764961009\">764961009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716859000\">716859000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/715561008\">715561008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/771080008\">771080008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369767007\">369767007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/100721000119109\">100721000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277617004\">277617004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699358009\">699358009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277643003\">277643003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/773775004\">773775004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/773774000\">773774000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783737007\">783737007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307650006\">307650006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109988003\">109988003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/190955000\">190955000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315058005\">315058005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118605002\">118605002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118599009\">118599009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402882001\">402882001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426071002\">426071002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93528000\">93528000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93520007\">93520007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93521006\">93521006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93522004\">93522004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93523009\">93523009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93524003\">93524003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93525002\">93525002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93526001\">93526001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93527005\">93527005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118610003\">118610003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93492006\">93492006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188587006\">188587006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188591001\">188591001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188586002\">188586002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188589009\">188589009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93487009\">93487009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426885008\">426885008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188585003\">188585003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93488004\">93488004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188590000\">188590000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93489007\">93489007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188593003\">188593003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188592008\">188592008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307633009\">307633009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307634003\">307634003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277609007\">277609007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93501005\">93501005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93493001\">93493001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93494007\">93494007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93495008\">93495008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188558005\">188558005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93496009\">93496009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188554007\">188554007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93497000\">93497000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188559002\">188559002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93498005\">93498005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188562004\">188562004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93500006\">93500006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118609008\">118609008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93510002\">93510002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188577007\">188577007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188580008\">188580008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188576003\">188576003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188578002\">188578002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93505001\">93505001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188575004\">188575004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93506000\">93506000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188579005\">188579005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93507009\">93507009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188582000\">188582000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93509007\">93509007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307635002\">307635002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277612005\">277612005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277610002\">277610002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277611003\">277611003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118608000\">118608000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93519001\">93519001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188567005\">188567005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188570009\">188570009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188566001\">188566001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188568000\">188568000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93514006\">93514006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188565002\">188565002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93515007\">93515007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188569008\">188569008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93516008\">93516008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188572001\">188572001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93518009\">93518009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118602004\">118602004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93537000\">93537000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188536008\">188536008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93530003\">93530003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93531004\">93531004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188537004\">188537004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93532006\">93532006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93533001\">93533001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188538009\">188538009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93534007\">93534007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188541000\">188541000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93536009\">93536009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93546006\">93546006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188529007\">188529007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188524002\">188524002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93541001\">93541001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93542008\">93542008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93543003\">93543003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188531003\">188531003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118606001\">118606001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93555009\">93555009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93547002\">93547002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93548007\">93548007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93549004\">93549004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188547001\">188547001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93550004\">93550004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93551000\">93551000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188548006\">188548006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93552007\">93552007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188551004\">188551004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93554008\">93554008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/417181009\">417181009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/427492003\">427492003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722103009\">722103009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/431396003\">431396003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423158009\">423158009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763719001\">763719001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/393573009\">393573009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278189009\">278189009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403274000\">403274000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404110001\">404110001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/230791000\">230791000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783150002\">783150002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285420006\">285420006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285422003\">285422003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285421005\">285421005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/127071007\">127071007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275524009\">275524009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/427374007\">427374007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109985000\">109985000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402557009\">402557009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/441313008\">441313008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/70910003\">70910003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783565007\">783565007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403996004\">403996004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722958008\">722958008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15635761000119103\">15635761000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/408643008\">408643008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448952004\">448952004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080101000119105\">1080101000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/823017009\">823017009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080181000119102\">1080181000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080091000119100\">1080091000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080171000119100\">1080171000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422399001\">422399001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422479008\">422479008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423114009\">423114009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424229006\">424229006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080111000119108\">1080111000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080191000119104\">1080191000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080121000119101\">1080121000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080201000119101\">1080201000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080131000119103\">1080131000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080211000119103\">1080211000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080151000119109\">1080151000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080231000119108\">1080231000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080161000119106\">1080161000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080241000119104\">1080241000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278054005\">278054005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080261000119100\">1080261000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080341000119105\">1080341000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369741002\">369741002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254840009\">254840009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404017001\">404017001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764940002\">764940002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/715664005\">715664005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285776004\">285776004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445513004\">445513004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302820008\">302820008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/417619001\">417619001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254935002\">254935002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15636951000119108\">15636951000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109889007\">109889007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1079811000119104\">1079811000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1079821000119106\">1079821000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/473419009\">473419009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403878007\">403878007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403876006\">403876006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403874009\">403874009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403875005\">403875005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403877002\">403877002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403879004\">403879004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403873003\">403873003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403880001\">403880001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/400066006\">400066006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/767544007\">767544007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109842005\">109842005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/768934004\">768934004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/416351002\">416351002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403985007\">403985007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713609000\">713609000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733834006\">733834006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/780821007\">780821007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399394000\">399394000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399527001\">399527001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/446945009\">446945009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423829008\">423829008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277587001\">277587001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445227008\">445227008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/788972003\">788972003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/72891000119103\">72891000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403979000\">403979000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403978008\">403978008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109385007\">109385007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/420524008\">420524008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/703625002\">703625002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255114007\">255114007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255115008\">255115008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/231835006\">231835006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109389001\">109389001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109390005\">109390005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109391009\">109391009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109392002\">109392002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109388009\">109388009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109386008\">109386008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188029000\">188029000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/414553000\">414553000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698011002\">698011002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253017000\">253017000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/359987004\">359987004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313427003\">313427003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/65399007\">65399007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404160007\">404160007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707431006\">707431006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/417152008\">417152008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707432004\">707432004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118614007\">118614007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/129000002\">129000002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724649000\">724649000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866098005\">866098005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277637000\">277637000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702785000\">702785000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12235561000119105\">12235561000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254629004\">254629004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424938000\">424938000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423050000\">423050000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424970000\">424970000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423600008\">423600008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12235601000119105\">12235601000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698200003\">698200003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/441962003\">441962003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277569004\">277569004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276810009\">276810009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443719001\">443719001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447707005\">447707005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449055006\">449055006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763771009\">763771009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447804006\">447804006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/770559003\">770559003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448229007\">448229007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699355007\">699355007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447706001\">447706001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716651004\">716651004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447785000\">447785000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447389009\">447389009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302836005\">302836005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302837001\">302837001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423278008\">423278008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/66074005\">66074005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93141006\">93141006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93133006\">93133006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93134000\">93134000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93135004\">93135004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93136003\">93136003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93137007\">93137007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93138002\">93138002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93139005\">93139005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93140007\">93140007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93143009\">93143009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93142004\">93142004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314408000\">314408000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/236512004\">236512004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314418005\">314418005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423032007\">423032007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404156009\">404156009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404122003\">404122003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404124002\">404124002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404123008\">404123008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404152006\">404152006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404153001\">404153001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404139001\">404139001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404154007\">404154007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404151004\">404151004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93152000\">93152000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93144003\">93144003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93145002\">93145002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93146001\">93146001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188648000\">188648000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188645002\">188645002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188649008\">188649008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93150008\">93150008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373604002\">373604002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277579002\">277579002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/55006001\">55006001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721629005\">721629005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15863451000119107\">15863451000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254828009\">254828009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448554008\">448554008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254993006\">254993006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/143411000119109\">143411000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109841003\">109841003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15952981000119103\">15952981000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109888004\">109888004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354341000119108\">354341000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354471000119108\">354471000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314976006\">314976006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314973003\">314973003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314955001\">314955001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314952003\">314952003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314970000\">314970000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314965007\">314965007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314960002\">314960002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314962005\">314962005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314967004\">314967004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314963000\">314963000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314954002\">314954002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314964006\">314964006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314969001\">314969001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314966008\">314966008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314975005\">314975005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314974009\">314974009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314961003\">314961003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314953008\">314953008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314951005\">314951005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314968009\">314968009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255191003\">255191003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404120006\">404120006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082701000112100\">1082701000112100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369766003\">369766003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/100731000119107\">100731000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277615007\">277615007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699357004\">699357004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/429408002\">429408002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428960009\">428960009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428753007\">428753007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428964000\">428964000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428965004\">428965004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/68571000119106\">68571000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/90811000119100\">90811000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277642008\">277642008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404088004\">404088004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/457311000124106\">457311000124106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403986008\">403986008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255119002\">255119002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118607005\">118607005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866109006\">866109006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764938007\">764938007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403952004\">403952004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109976000\">109976000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188725004\">188725004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122951000119108\">122951000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93169003\">93169003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399600009\">399600009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448555009\">448555009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447806008\">447806008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449075002\">449075002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/133751000119102\">133751000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447658000\">447658000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447805007\">447805007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276815004\">276815004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/236513009\">236513009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448269008\">448269008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449053004\">449053004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448553002\">448553002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447766003\">447766003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447656001\">447656001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/232075002\">232075002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422853008\">422853008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449218003\">449218003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449074003\">449074003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/30440004\">30440004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/89487002\">89487002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/76422004\">76422004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/5701003\">5701003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/56944001\">56944001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/112241002\">112241002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/75339006\">75339006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/44255004\">44255004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/74053007\">74053007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/84633001\">84633001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/66445009\">66445009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277570003\">277570003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/239940004\">239940004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/239297008\">239297008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/31047003\">31047003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404103007\">404103007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404104001\">404104001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404105000\">404105000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404106004\">404106004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404111002\">404111002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/836486002\">836486002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404149003\">404149003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277466009\">277466009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122491000119108\">122491000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/771073006\">771073006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122511000119103\">122511000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122531000119108\">122531000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122521000119105\">122521000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122501000119101\">122501000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254290004\">254290004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277606000\">277606000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188498009\">188498009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188487008\">188487008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188502002\">188502002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188505000\">188505000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188501009\">188501009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188503007\">188503007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188500005\">188500005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188504001\">188504001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188507008\">188507008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188506004\">188506004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/190817009\">190817009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253011004\">253011004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443961001\">443961001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713290004\">713290004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254973003\">254973003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307603002\">307603002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/788876001\">788876001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445238008\">445238008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/192681000119104\">192681000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123721000119108\">123721000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/726653000\">726653000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123731000119106\">123731000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/726654006\">726654006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123701000119104\">123701000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123761000119103\">123761000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/192701000119101\">192701000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123751000119100\">123751000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713574000\">713574000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123741000119102\">123741000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123661000119106\">123661000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/143401000119106\">143401000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713573006\">713573006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/709517003\">709517003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/709830006\">709830006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/726652005\">726652005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403943008\">403943008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/233647007\">233647007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403941005\">403941005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403942003\">403942003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722688002\">722688002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449472007\">449472007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733144006\">733144006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448665005\">448665005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448214005\">448214005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783155007\">783155007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254650008\">254650008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254849005\">254849005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402873007\">402873007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443250000\">443250000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443439001\">443439001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254996003\">254996003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404014008\">404014008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447708000\">447708000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/773283006\">773283006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/773284000\">773284000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866080006\">866080006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/10737911000119105\">10737911000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713293002\">713293002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447705002\">447705002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/10737861000119101\">10737861000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/770686005\">770686005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254869000\">254869000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713646001\">713646001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276826005\">276826005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424276002\">424276002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/87151000119105\">87151000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/87121000119102\">87121000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/87091000119101\">87091000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/234941000119100\">234941000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/87111000119109\">87111000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276827001\">276827001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404041003\">404041003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702405001\">702405001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254995004\">254995004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254797000\">254797000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/127070008\">127070008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118612006\">118612006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404169008\">404169008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93190006\">93190006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93182006\">93182006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93183001\">93183001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93184007\">93184007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188641006\">188641006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93185008\">93185008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93186009\">93186009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188642004\">188642004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93187000\">93187000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93188005\">93188005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93189002\">93189002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/827162007\">827162007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109980005\">109980005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188691005\">188691005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713189001\">713189001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278055006\">278055006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118600007\">118600007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307625008\">307625008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/274905008\">274905008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307623001\">307623001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188676008\">188676008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188675007\">188675007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302841002\">302841002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/427141003\">427141003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278052009\">278052009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93199007\">93199007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93191005\">93191005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93192003\">93192003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93193008\">93193008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/127220001\">127220001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93194002\">93194002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93195001\">93195001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93196000\">93196000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93197009\">93197009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93198004\">93198004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277664004\">277664004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/420519005\">420519005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278051002\">278051002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307647008\">307647008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307637005\">307637005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/303017006\">303017006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/303055001\">303055001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/303056000\">303056000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/303057009\">303057009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371134001\">371134001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307646004\">307646004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307636001\">307636001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/789689004\">789689004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/789690008\">789690008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118615008\">118615008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93200005\">93200005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93201009\">93201009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93202002\">93202002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93203007\">93203007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93204001\">93204001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93205000\">93205000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/416901002\">416901002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372244006\">372244006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402556000\">402556000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402558004\">402558004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402562005\">402562005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254734009\">254734009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254733003\">254733003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/108101000119101\">108101000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/97051000119105\">97051000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707350007\">707350007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188073001\">188073001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276821000\">276821000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188033007\">188033007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188049009\">188049009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/310498001\">310498001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188050009\">188050009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698045009\">698045009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188051008\">188051008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313248004\">313248004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188038003\">188038003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255021005\">255021005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255015006\">255015006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255004001\">255004001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188032002\">188032002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721627007\">721627007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698285005\">698285005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188034001\">188034001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/274087000\">274087000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/231834005\">231834005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188064009\">188064009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698043002\">698043002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188075008\">188075008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188062008\">188062008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188040008\">188040008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707361004\">707361004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188077000\">188077000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188052001\">188052001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698287002\">698287002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188063003\">188063003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269578002\">269578002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188074007\">188074007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188068007\">188068007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255012009\">255012009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188070003\">188070003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866082003\">866082003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866079008\">866079008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080941000119109\">1080941000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188030005\">188030005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188072006\">188072006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269581007\">269581007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698288007\">698288007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277530005\">277530005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783736003\">783736003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403927001\">403927001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698040004\">698040004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188046002\">188046002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403926005\">403926005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866072004\">866072004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866073009\">866073009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698286006\">698286006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698044008\">698044008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93209006\">93209006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188054000\">188054000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188071004\">188071004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276822007\">276822007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423673009\">423673009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080981000119104\">1080981000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188045003\">188045003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188044004\">188044004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188060000\">188060000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93655004\">93655004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93210001\">93210001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93211002\">93211002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447712006\">447712006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93213004\">93213004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93214005\">93214005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93215006\">93215006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93216007\">93216007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423280002\">423280002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93217003\">93217003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93218008\">93218008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93219000\">93219000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93220006\">93220006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93221005\">93221005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93222003\">93222003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93223008\">93223008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93224002\">93224002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93225001\">93225001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93226000\">93226000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93227009\">93227009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93228004\">93228004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93229007\">93229007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93230002\">93230002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93636004\">93636004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93637008\">93637008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93638003\">93638003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1081021000119109\">1081021000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352201000119105\">352201000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93640008\">93640008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423447006\">423447006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449636007\">449636007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93641007\">93641007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424302003\">424302003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93642000\">93642000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93643005\">93643005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448298007\">448298007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93644004\">93644004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93645003\">93645003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352001000119100\">352001000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/351961000119109\">351961000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93646002\">93646002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448273006\">448273006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93647006\">93647006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93648001\">93648001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93649009\">93649009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93650009\">93650009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93651008\">93651008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93652001\">93652001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449637003\">449637003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423494003\">423494003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93653006\">93653006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424487008\">424487008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448300007\">448300007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93654000\">93654000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402561003\">402561003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707362006\">707362006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188042000\">188042000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188069004\">188069004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188065005\">188065005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188076009\">188076009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698042007\">698042007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269579005\">269579005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188055004\">188055004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424190005\">424190005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188061001\">188061001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269580008\">269580008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698041000\">698041000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254896002\">254896002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/830150003\">830150003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713327005\">713327005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254975005\">254975005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866070007\">866070007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866071006\">866071006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109383000\">109383000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254645002\">254645002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/432131000124100\">432131000124100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/789721005\">789721005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425225007\">425225007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/708054009\">708054009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422282000\">422282000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188366002\">188366002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371964008\">371964008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371965009\">371965009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449260004\">449260004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449578008\">449578008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449223003\">449223003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443488001\">443488001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449034009\">449034009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187681002\">187681002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449224009\">449224009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188242006\">188242006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187843009\">187843009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187833006\">187833006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702467006\">702467006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448248006\">448248006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372094002\">372094002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188156001\">188156001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188281006\">188281006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187631006\">187631006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371972005\">371972005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428281000\">428281000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372108006\">372108006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/271467005\">271467005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187900002\">187900002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371974006\">371974006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428061005\">428061005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363473003\">363473003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373080008\">373080008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373081007\">373081007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373082000\">373082000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373083005\">373083005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449259009\">449259009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187967002\">187967002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/310599006\">310599006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187733001\">187733001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187734007\">187734007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187857006\">187857006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447883002\">447883002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187943005\">187943005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187944004\">187944004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187938003\">187938003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187940008\">187940008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187937008\">187937008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187941007\">187941007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187942000\">187942000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187939006\">187939006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255090000\">255090000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187987001\">187987001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187829004\">187829004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187853005\">187853005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363477002\">363477002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372062007\">372062007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188151006\">188151006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448218008\">448218008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449420002\">449420002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188313000\">188313000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188282004\">188282004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188312005\">188312005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363474009\">363474009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188295009\">188295009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188315007\">188315007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363471001\">363471001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/429033009\">429033009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188280007\">188280007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188183000\">188183000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187916000\">187916000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/712750007\">712750007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371979001\">371979001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187957007\">187957007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/781382000\">781382000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188015001\">188015001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188016000\">188016000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188010006\">188010006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188020001\">188020001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187996001\">187996001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188004006\">188004006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187994003\">187994003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188006008\">188006008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187995002\">187995002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188000002\">188000002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187999008\">187999008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188021002\">188021002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188003000\">188003000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188019007\">188019007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188022009\">188022009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188002005\">188002005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/871843002\">871843002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187992004\">187992004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188001003\">188001003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188009001\">188009001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187997005\">187997005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188005007\">188005007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187991006\">187991006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187993009\">187993009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188017009\">188017009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188013008\">188013008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448274000\">448274000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188268004\">188268004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188190005\">188190005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188301005\">188301005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188283009\">188283009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188189001\">188189001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187925006\">187925006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187926007\">187926007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187844003\">187844003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188265001\">188265001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187845002\">187845002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448675008\">448675008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187633009\">187633009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443648003\">443648003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187798008\">187798008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188159008\">188159008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188168005\">188168005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188176007\">188176007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188177003\">188177003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372097009\">372097009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371982006\">371982006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188192002\">188192002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187682009\">187682009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372099007\">372099007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188269007\">188269007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363461003\">363461003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188261005\">188261005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372064008\">372064008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187949009\">187949009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187977000\">187977000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187945003\">187945003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187973001\">187973001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188293002\">188293002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187701005\">187701005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187948001\">187948001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187976009\">187976009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363467004\">363467004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188191009\">188191009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188208002\">188208002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428905002\">428905002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/430556008\">430556008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/271468000\">271468000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188285002\">188285002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187683004\">187683004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188211001\">188211001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423691004\">423691004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269467007\">269467007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187784000\">187784000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188289008\">188289008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187932002\">187932002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187773007\">187773007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187969004\">187969004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448882009\">448882009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187776004\">187776004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187777008\">187777008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188195000\">188195000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187666008\">187666008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187685006\">187685006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363446004\">363446004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363447008\">363447008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188273005\">188273005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187970003\">187970003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448868009\">448868009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188241004\">188241004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/271323007\">271323007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93870000\">93870000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187767006\">187767006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449628003\">449628003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449627008\">449627008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313250007\">313250007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187613005\">187613005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187604008\">187604008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187869003\">187869003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724059003\">724059003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187870002\">187870002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724056005\">724056005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/430621000\">430621000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188153009\">188153009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188155002\">188155002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187918004\">187918004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372065009\">372065009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187903000\">187903000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372095001\">372095001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448668007\">448668007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448299004\">448299004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448558006\">448558006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187968007\">187968007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188296005\">188296005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363370001\">363370001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187810005\">187810005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187809000\">187809000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187811009\">187811009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255091001\">255091001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/405945003\">405945003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188297001\">188297001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187865009\">187865009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187866005\">187866005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187635002\">187635002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187854004\">187854004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188193007\">188193007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402636006\">402636006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187828007\">187828007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187830009\">187830009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188274004\">188274004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/240163000\">240163000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187972006\">187972006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372063002\">372063002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188147009\">188147009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188163001\">188163001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363470000\">363470000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188308004\">188308004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363421004\">363421004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187906008\">187906008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188256008\">188256008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448674007\">448674007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363469001\">363469001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449067008\">449067008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187952001\">187952001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449377002\">449377002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187803004\">187803004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188326001\">188326001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188327005\">188327005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188325002\">188325002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188321006\">188321006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188322004\">188322004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188324003\">188324003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188323009\">188323009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187978005\">187978005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187950009\">187950009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188339002\">188339002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188298006\">188298006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448670003\">448670003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187709007\">187709007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188243001\">188243001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187738005\">187738005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/96981000119102\">96981000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187760008\">187760008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449096009\">449096009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187804005\">187804005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187920001\">187920001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724060008\">724060008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188204000\">188204000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187956003\">187956003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188103003\">188103003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188102008\">188102008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187929000\">187929000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188266000\">188266000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187946002\">187946002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187974007\">187974007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/712525007\">712525007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443679004\">443679004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372130007\">372130007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372122006\">372122006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188110009\">188110009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188090007\">188090007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188107002\">188107002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188095002\">188095002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188089003\">188089003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188091006\">188091006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423425006\">423425006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443136000\">443136000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188122007\">188122007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188138001\">188138001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188135003\">188135003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188133005\">188133005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372124007\">372124007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188099008\">188099008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188132000\">188132000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/311779007\">311779007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449309003\">449309003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188100000\">188100000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188125009\">188125009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372126009\">372126009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188121000\">188121000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372128005\">372128005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269469005\">269469005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448669004\">448669004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187786003\">187786003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188318009\">188318009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188317004\">188317004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363476006\">363476006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188319001\">188319001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188184006\">188184006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402871009\">402871009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/709031009\">709031009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188302003\">188302003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187988006\">187988006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363468009\">363468009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188287005\">188287005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187814001\">187814001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187947006\">187947006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187975008\">187975008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428100006\">428100006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187917009\">187917009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372018003\">372018003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188361007\">188361007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187846001\">187846001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187637005\">187637005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188290004\">188290004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313249007\">313249007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372131006\">372131006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187601000\">187601000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187861000\">187861000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724058006\">724058006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187862007\">187862007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269464000\">269464000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449066004\">449066004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188152004\">188152004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188154003\">188154003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448233000\">448233000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428322007\">428322007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371973000\">371973000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188209005\">188209005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449308006\">449308006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187927003\">187927003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187989003\">187989003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188247000\">188247000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188157005\">188157005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188180002\">188180002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187757001\">187757001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187824009\">187824009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188478004\">188478004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363346000\">363346000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713572001\">713572001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/10745291000119103\">10745291000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/10749871000119100\">10749871000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866068003\">866068003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866069006\">866069006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866096009\">866096009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866097000\">866097000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866094007\">866094007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866095008\">866095008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866093001\">866093001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/133531000119104\">133531000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278044006\">278044006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/710195004\">710195004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/710196003\">710196003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404664002\">404664002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/703429003\">703429003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/405546008\">405546008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/761958009\">761958009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404037002\">404037002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277782009\">277782009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/21851000119103\">21851000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254844000\">254844000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/788979007\">788979007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/816205008\">816205008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255087006\">255087006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/123631000119103\">123631000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363420003\">363420003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/416842003\">416842003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278043000\">278043000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254860001\">254860001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/700488005\">700488005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254726003\">254726003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254707006\">254707006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189847002\">189847002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/417554000\">417554000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278042005\">278042005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448250003\">448250003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448559003\">448559003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/416769008\">416769008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/417417007\">417417007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444596001\">444596001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404040002\">404040002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187708004\">187708004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187724003\">187724003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254980001\">254980001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187694000\">187694000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363355002\">363355002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363417006\">363417006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363352004\">363352004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254586002\">254586002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254509006\">254509006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187652003\">187652003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254459004\">254459004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363360003\">363360003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187634003\">187634003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254408000\">254408000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187640005\">187640005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187700006\">187700006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363490009\">363490009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363411007\">363411007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363487003\">363487003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363412000\">363412000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363502009\">363502009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363376007\">363376007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363415003\">363415003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188244007\">188244007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187791002\">187791002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188230001\">188230001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187742008\">187742008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363396004\">363396004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254837009\">254837009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363493006\">363493006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363386008\">363386008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187732006\">187732006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363350007\">363350007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187722004\">187722004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363354003\">363354003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363466008\">363466008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188292007\">188292007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188263008\">188263008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363491008\">363491008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363406005\">363406005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363374005\">363374005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363463000\">363463000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363464006\">363464006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276420005\">276420005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276419004\">276419004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188307009\">188307009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188340000\">188340000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255096006\">255096006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363409003\">363409003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255077007\">255077007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363403002\">363403002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255073006\">255073006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188220005\">188220005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363436001\">363436001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254611009\">254611009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255093003\">255093003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363452003\">363452003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363402007\">363402007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255078002\">255078002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363426009\">363426009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187834000\">187834000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255088001\">255088001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277156006\">277156006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363416002\">363416002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/231829006\">231829006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363501002\">363501002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363444001\">363444001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363488008\">363488008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363514001\">363514001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276797002\">276797002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363385007\">363385007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363450006\">363450006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187641009\">187641009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302815008\">302815008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187614004\">187614004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187608006\">187608006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363427000\">363427000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187741001\">187741001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363353009\">363353009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363451005\">363451005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187841006\">187841006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269460009\">269460009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363382005\">363382005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363387004\">363387004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255056009\">255056009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363419009\">363419009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363435002\">363435002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363407001\">363407001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363399006\">363399006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188286001\">188286001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363405009\">363405009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363357005\">363357005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254503007\">254503007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254478004\">254478004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254520006\">254520006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363508008\">363508008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188264002\">188264002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187794005\">187794005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363404008\">363404008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187644001\">187644001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363518003\">363518003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188250002\">188250002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187622006\">187622006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/280959007\">280959007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188272000\">188272000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363510005\">363510005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363431006\">363431006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254526000\">254526000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363429002\">363429002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187653008\">187653008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255075004\">255075004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363398003\">363398003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269459004\">269459004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363377003\">363377003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363348004\">363348004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275399006\">275399006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187660002\">187660002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363384006\">363384006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/271568003\">271568003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187662005\">187662005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363504005\">363504005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187727005\">187727005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363358000\">363358000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254625005\">254625005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269475001\">269475001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363378008\">363378008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363515000\">363515000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363424007\">363424007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363425008\">363425008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187752007\">187752007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363494000\">363494000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363497007\">363497007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254824006\">254824006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363359008\">363359008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269463006\">269463006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187726001\">187726001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254481009\">254481009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363485006\">363485006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363495004\">363495004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363437005\">363437005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363422006\">363422006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255074000\">255074000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363423001\">363423001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363506007\">363506007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254474002\">254474002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187831008\">187831008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187692001\">187692001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363489000\">363489000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402876004\">402876004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254969001\">254969001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187698002\">187698002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363498002\">363498002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254972008\">254972008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254974009\">254974009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363505006\">363505006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363462005\">363462005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363392002\">363392002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363443007\">363443007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363390005\">363390005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363418001\">363418001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187793004\">187793004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254530002\">254530002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363481002\">363481002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363460002\">363460002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363379000\">363379000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363484005\">363484005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188253000\">188253000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363516004\">363516004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254986007\">254986007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363492001\">363492001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187801002\">187801002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187697007\">187697007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363507003\">363507003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363483004\">363483004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255112006\">255112006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363482009\">363482009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363433009\">363433009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363400004\">363400004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254513004\">254513004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254484001\">254484001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/303012000\">303012000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187693006\">187693006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187688008\">187688008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399068003\">399068003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187740000\">187740000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187736009\">187736009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363401000\">363401000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363414004\">363414004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363351006\">363351006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188252005\">188252005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363457009\">363457009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363465007\">363465007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363391009\">363391009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255072001\">255072001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363454002\">363454002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188234005\">188234005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363410008\">363410008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254908006\">254908006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276750003\">276750003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363509000\">363509000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363388009\">363388009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363496003\">363496003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/310526005\">310526005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363440005\">363440005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363439008\">363439008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302816009\">302816009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363364007\">363364007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363441009\">363441009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363366009\">363366009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363363001\">363363001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363365008\">363365008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372011009\">372011009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363453008\">363453008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363428005\">363428005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363475005\">363475005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424549003\">424549003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424334007\">424334007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254983004\">254983004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363499005\">363499005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363413005\">363413005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363349007\">363349007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363430007\">363430007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363381003\">363381003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363380002\">363380002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187842004\">187842004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254517003\">254517003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187792009\">187792009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363449006\">363449006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187723009\">187723009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363434003\">363434003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363478007\">363478007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254412006\">254412006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363375006\">363375006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363393007\">363393007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363394001\">363394001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187675005\">187675005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363432004\">363432004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363408006\">363408006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188239000\">188239000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188235006\">188235006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187836003\">187836003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187835004\">187835004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188219004\">188219004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255052006\">255052006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187659007\">187659007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363383000\">363383000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187606005\">187606005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187661003\">187661003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363503004\">363503004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187725002\">187725002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363456000\">363456000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363458004\">363458004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188245008\">188245008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363459007\">363459007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254934003\">254934003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399326009\">399326009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/419052002\">419052002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363517008\">363517008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363389001\">363389001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363445000\">363445000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363395000\">363395000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188240003\">188240003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/421249001\">421249001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363373004\">363373004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363372009\">363372009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363438000\">363438000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187658004\">187658004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363486007\">363486007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363367000\">363367000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187716008\">187716008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402652009\">402652009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277543005\">277543005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404150003\">404150003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443487006\">443487006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/116871000119103\">116871000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/441559006\">441559006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447100004\">447100004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/450521000124109\">450521000124109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/116711000119103\">116711000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/116841000119105\">116841000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/116691000119101\">116691000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/116741000119104\">116741000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448165009\">448165009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/110002002\">110002002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404172001\">404172001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/397009000\">397009000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/397011009\">397011009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188665009\">188665009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188662007\">188662007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188666005\">188666005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188669003\">188669003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188668006\">188668006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402560002\">402560002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/421418009\">421418009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255032005\">255032005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443333004\">443333004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277505007\">277505007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/715903004\">715903004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/818967003\">818967003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763796007\">763796007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188754005\">188754005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94148006\">94148006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277527003\">277527003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254979004\">254979004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/717968005\">717968005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/103511000119103\">103511000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/127330008\">127330008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315230006\">315230006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315036008\">315036008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722689005\">722689005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109278005\">109278005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109280004\">109280004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109274007\">109274007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109270003\">109270003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109296001\">109296001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1080911000119105\">1080911000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109272006\">109272006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109294003\">109294003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109282007\">109282007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109268007\">109268007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109288006\">109288006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352121000119105\">352121000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352191000119107\">352191000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352161000119100\">352161000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109276009\">109276009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109292004\">109292004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109266006\">109266006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109286005\">109286005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189324006\">189324006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109284008\">109284008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109290007\">109290007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/312941005\">312941005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404039004\">404039004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722795004\">722795004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/446531000124106\">446531000124106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254978007\">254978007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/414666009\">414666009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253001006\">253001006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/135931000119106\">135931000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/133841000119105\">133841000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352071000119105\">352071000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/133881000119100\">133881000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/133851000119107\">133851000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/351461000119100\">351461000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/133861000119109\">133861000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/133891000119102\">133891000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/133871000119103\">133871000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/788982002\">788982002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109378008\">109378008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109856007\">109856007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109858008\">109858008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109854005\">109854005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109855006\">109855006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109853004\">109853004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763479005\">763479005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314987003\">314987003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314991008\">314991008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314995004\">314995004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314990009\">314990009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315004001\">315004001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315005000\">315005000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315008003\">315008003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314992001\">314992001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314998002\">314998002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315003007\">315003007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315001009\">315001009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314996003\">314996003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315000005\">315000005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315006004\">315006004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314999005\">314999005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314994000\">314994000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314997007\">314997007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314988008\">314988008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314989000\">314989000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315002002\">315002002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315007008\">315007008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/315009006\">315009006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/314993006\">314993006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285643007\">285643007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285640005\">285640005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285618001\">285618001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285641009\">285641009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285634003\">285634003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285603002\">285603002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285611007\">285611007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/275266006\">275266006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285642002\">285642002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/303194003\">303194003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285606005\">285606005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285639008\">285639008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285610008\">285610008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1691000119104\">1691000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285613005\">285613005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1661000119106\">1661000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285604008\">285604008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1681000119102\">1681000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1671000119100\">1671000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285644001\">285644001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285607001\">285607001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/303201005\">303201005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255123005\">255123005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285637005\">285637005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285614004\">285614004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255124004\">255124004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285616002\">285616002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285605009\">285605009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285612000\">285612000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285617006\">285617006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285631006\">285631006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285609003\">285609003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285633009\">285633009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285615003\">285615003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285608006\">285608006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285598005\">285598005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285635002\">285635002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285638000\">285638000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285619009\">285619009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307226002\">307226002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/705176003\">705176003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/459381000124106\">459381000124106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/459411000124109\">459411000124109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/459371000124108\">459371000124108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/458581000124106\">458581000124106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/459391000124109\">459391000124109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443493003\">443493003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402563000\">402563000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722671009\">722671009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722707001\">722707001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/359782004\">359782004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/359785002\">359785002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/359780007\">359780007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/241861008\">241861008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/19090001000004101\">19090001000004101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/704152002\">704152002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/414676007\">414676007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/457721000124104\">457721000124104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/459401000124106\">459401000124106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/459421000124101\">459421000124101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702392008\">702392008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443144000\">443144000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713425003\">713425003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403906006\">403906006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/458321000124102\">458321000124102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254712007\">254712007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253010003\">253010003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/737058005\">737058005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735385007\">735385007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403920004\">403920004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764694005\">764694005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94686001\">94686001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94687005\">94687005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94688000\">94688000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94690004\">94690004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722523004\">722523004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444604002\">444604002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866052009\">866052009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403954003\">403954003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255030002\">255030002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866050001\">866050001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254941009\">254941009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254951005\">254951005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443937008\">443937008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716647001\">716647001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278491007\">278491007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254961003\">254961003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403950007\">403950007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188744006\">188744006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277623009\">277623009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445964006\">445964006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307340003\">307340003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/61493004\">61493004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424944001\">424944001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94291000119103\">94291000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444712000\">444712000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254851009\">254851009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/785879009\">785879009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866048009\">866048009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254714008\">254714008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764990003\">764990003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423793008\">423793008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423708008\">423708008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254713002\">254713002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423424005\">423424005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/414780005\">414780005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444597005\">444597005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277622004\">277622004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/816204007\">816204007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403888008\">403888008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363500001\">363500001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109989006\">109989006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94704006\">94704006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402564006\">402564006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/414785000\">414785000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403905005\">403905005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118618005\">118618005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94715001\">94715001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94707004\">94707004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94708009\">94708009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94709001\">94709001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94710006\">94710006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94711005\">94711005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94712003\">94712003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188627002\">188627002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94714002\">94714002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404116007\">404116007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109995007\">109995007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277597005\">277597005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/445738007\">445738007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447596005\">447596005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/738527001\">738527001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188732008\">188732008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724644005\">724644005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122901000119109\">122901000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94716000\">94716000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724642009\">724642009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94719007\">94719007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94718004\">94718004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/32278006\">32278006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188768003\">188768003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307651005\">307651005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/400175006\">400175006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253042009\">253042009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404046008\">404046008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404069006\">404069006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449248000\">449248000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126972009\">126972009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126977003\">126977003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/387891008\">387891008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/387893006\">387893006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126952004\">126952004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126961004\">126961004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126963001\">126963001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126951006\">126951006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126960003\">126960003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126959008\">126959008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126958000\">126958000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126953009\">126953009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126966009\">126966009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/127025000\">127025000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126954003\">126954003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126978008\">126978008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713739004\">713739004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126965008\">126965008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126950007\">126950007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126957005\">126957005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126969002\">126969002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126967000\">126967000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/395505000\">395505000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/395502002\">395502002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126956001\">126956001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126984006\">126984006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/127026004\">127026004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/127024001\">127024001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713747004\">713747004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126962006\">126962006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126964007\">126964007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126955002\">126955002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/712858005\">712858005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126971002\">126971002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126970001\">126970001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94722009\">94722009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94723004\">94723004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94725006\">94725006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94767002\">94767002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189484008\">189484008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94766006\">94766006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94782007\">94782007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94784008\">94784008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94786005\">94786005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94787001\">94787001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94788006\">94788006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94789003\">94789003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94807005\">94807005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94808000\">94808000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94847003\">94847003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109914007\">109914007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94963005\">94963005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94968001\">94968001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94969009\">94969009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94970005\">94970005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94971009\">94971009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94986003\">94986003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95002008\">95002008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95004009\">95004009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95108005\">95108005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95109002\">95109002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95126008\">95126008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95148002\">95148002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95150005\">95150005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95171000\">95171000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189488006\">189488006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189487001\">189487001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/126976007\">126976007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302849000\">302849000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082321000119100\">1082321000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082331000119102\">1082331000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/432328008\">432328008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/281560004\">281560004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/734099007\">734099007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253000007\">253000007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/870355006\">870355006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/717916003\">717916003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716653001\">716653001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403925009\">403925009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307617006\">307617006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/726721002\">726721002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277627005\">277627005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269476000\">269476000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95194004\">95194004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95186006\">95186006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95187002\">95187002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95188007\">95188007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188612002\">188612002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188609000\">188609000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188613007\">188613007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95192000\">95192000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95193005\">95193005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302848008\">302848008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302845006\">302845006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254731001\">254731001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/442537007\">442537007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/116811000119106\">116811000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/116821000119104\">116821000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118601006\">118601006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448220006\">448220006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448254007\">448254007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447989004\">447989004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448354009\">448354009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448372003\">448372003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352791000119108\">352791000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448371005\">448371005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448384001\">448384001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448386004\">448386004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448376000\">448376000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449318001\">449318001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448447004\">448447004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448738008\">448738008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448709005\">448709005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448387008\">448387008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449292003\">449292003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448774004\">448774004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707705008\">707705008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/461511000124101\">461511000124101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/789695003\">789695003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277580004\">277580004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/107691000119101\">107691000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424132000\">424132000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425048006\">425048006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422968005\">422968005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423121009\">423121009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254637007\">254637007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/703228009\">703228009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/703230006\">703230006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/440173001\">440173001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783143001\">783143001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277574007\">277574007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254633006\">254633006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722712000\">722712000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/134312002\">134312002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422886007\">422886007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443936004\">443936004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254940005\">254940005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/107571000119101\">107571000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/104981000119104\">104981000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254950006\">254950006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254976006\">254976006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/414950005\">414950005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/13048006\">13048006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307576001\">307576001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/870318006\">870318006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/82761000119108\">82761000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733064004\">733064004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425657001\">425657001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422782004\">422782004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109267002\">109267002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109366009\">109366009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109847004\">109847004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109879008\">109879008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109347009\">109347009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109348004\">109348004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109912006\">109912006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109911004\">109911004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109371002\">109371002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109838007\">109838007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/96281000119107\">96281000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109835005\">109835005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109948008\">109948008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109886000\">109886000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109878000\">109878000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109830000\">109830000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109821008\">109821008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109384006\">109384006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109368005\">109368005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109358000\">109358000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109369002\">109369002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109822001\">109822001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109833003\">109833003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109824000\">109824000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109887009\">109887009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109874003\">109874003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109374005\">109374005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109951001\">109951001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109367000\">109367000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255070009\">255070009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109832008\">109832008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109831001\">109831001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109848009\">109848009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109875002\">109875002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109919002\">109919002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109839004\">109839004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109851002\">109851002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109264009\">109264009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109837002\">109837002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109349007\">109349007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109836006\">109836006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109823006\">109823006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/110013004\">110013004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109870007\">109870007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109880006\">109880006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109885001\">109885001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354621000119105\">354621000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353661000119102\">353661000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353671000119108\">353671000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713038003\">713038003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707628004\">707628004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707430007\">707430007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707429002\">707429002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707529004\">707529004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443261008\">443261008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/236811000119101\">236811000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404119000\">404119000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403946000\">403946000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447738006\">447738006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254898001\">254898001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/274084007\">274084007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254638002\">254638002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278065000\">278065000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/792907004\">792907004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721594000\">721594000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254917006\">254917006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733608000\">733608000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/870327007\">870327007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255029007\">255029007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/717734005\">717734005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/789004008\">789004008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/281565009\">281565009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783056006\">783056006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699317002\">699317002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255037004\">255037004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404107008\">404107008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/736322001\">736322001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/281564008\">281564008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/400092004\">400092004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402911002\">402911002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307216009\">307216009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403947009\">403947009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/865951006\">865951006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/708504008\">708504008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/253096008\">253096008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254764001\">254764001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277653002\">277653002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277651000\">277651000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109977009\">109977009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/117091000119108\">117091000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/117211000119105\">117211000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/117061000119101\">117061000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/117111000119100\">117111000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302835009\">302835009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449386007\">449386007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449108003\">449108003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/714251006\">714251006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425688002\">425688002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/398670003\">398670003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763865009\">763865009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277507004\">277507004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307610008\">307610008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277508009\">277508009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/715904005\">715904005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/359619007\">359619007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/767448007\">767448007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/608817003\">608817003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/788757008\">788757008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254956000\">254956000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/237719001\">237719001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254955001\">254955001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783008000\">783008000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254965007\">254965007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/264906008\">264906008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254964006\">254964006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254963000\">254963000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254655003\">254655003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95210003\">95210003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/122981000119101\">122981000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95209008\">95209008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/415110002\">415110002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/415111003\">415111003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724648008\">724648008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/415112005\">415112005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404071006\">404071006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/762260000\">762260000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/398903003\">398903003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404054005\">404054005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707670009\">707670009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707671008\">707671008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707672001\">707672001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707673006\">707673006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404108003\">404108003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109992005\">109992005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/762316003\">762316003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423038006\">423038006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/134871000119100\">134871000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/717921000\">717921000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/871541008\">871541008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/871540009\">871540009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277572006\">277572006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425941003\">425941003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404137004\">404137004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/420890002\">420890002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/421246008\">421246008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/421696004\">421696004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277614006\">277614006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707409003\">707409003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707590006\">707590006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707386008\">707386008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707337006\">707337006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721718003\">721718003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/184741000119107\">184741000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/681601000119101\">681601000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721695008\">721695008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733354000\">733354000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/681621000119105\">681621000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/681631000119108\">681631000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721630000\">721630000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/184781000119102\">184781000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91161000119101\">91161000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721546004\">721546004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1701000119104\">1701000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721559007\">721559007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721558004\">721558004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/681651000119102\">681651000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721699002\">721699002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733355004\">733355004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/128041000119107\">128041000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/208041000119100\">208041000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721547008\">721547008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721628002\">721628002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707342003\">707342003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/99101000119101\">99101000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707343008\">707343008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/9541000119105\">9541000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/681721000119103\">681721000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707395000\">707395000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724536000\">724536000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/99111000119103\">99111000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724537009\">724537009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721549006\">721549006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/184801000119103\">184801000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1078881000119102\">1078881000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1078931000119107\">1078931000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721617001\">721617001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707451005\">707451005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707339009\">707339009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721561003\">721561003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721623006\">721623006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721560002\">721560002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/184861000119102\">184861000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707402007\">707402007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721606002\">721606002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721624000\">721624000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721669006\">721669006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721633003\">721633003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723879002\">723879002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721556000\">721556000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1651000119109\">1651000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721568009\">721568009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733362008\">733362008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721557009\">721557009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/184871000119108\">184871000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721725005\">721725005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721632008\">721632008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/184881000119106\">184881000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/79281000119106\">79281000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/184891000119109\">184891000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707344002\">707344002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707479004\">707479004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/737308008\">737308008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/737309000\">737309000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707475005\">707475005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721696009\">721696009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1078901000119100\">1078901000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1078961000119104\">1078961000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721622001\">721622001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733136006\">733136006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721569001\">721569001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/99121000119105\">99121000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91131000119109\">91131000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721562005\">721562005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707539005\">707539005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707466008\">707466008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/7391000119103\">7391000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707484005\">707484005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707425008\">707425008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/107791000119107\">107791000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707485006\">707485006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707405009\">707405009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707583001\">707583001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707393007\">707393007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707424007\">707424007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721540005\">721540005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/773624006\">773624006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721576006\">721576006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721575005\">721575005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707397008\">707397008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707486007\">707486007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707423001\">707423001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707580003\">707580003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707481002\">707481002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707662004\">707662004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707454002\">707454002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707579001\">707579001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707390005\">707390005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766935007\">766935007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707587000\">707587000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707345001\">707345001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707346000\">707346000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707349007\">707349007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/187769009\">187769009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707347009\">707347009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707348004\">707348004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707596000\">707596000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307649006\">307649006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276836002\">276836002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713325002\">713325002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721716004\">721716004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735678002\">735678002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723844004\">723844004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723845003\">723845003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723847006\">723847006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735679005\">735679005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723843005\">723843005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91081000119109\">91081000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91061000119100\">91061000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723846002\">723846002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91031000119108\">91031000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721603005\">721603005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/711414003\">711414003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707401000\">707401000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707471001\">707471001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/866176003\">866176003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707453008\">707453008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707389001\">707389001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721709000\">721709000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/773995001\">773995001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402881008\">402881008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/128875000\">128875000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/788674000\">788674000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/765136002\">765136002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404144008\">404144008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735332000\">735332000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404143002\">404143002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733627006\">733627006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404141000\">404141000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402880009\">402880009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/400001003\">400001003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404140004\">404140004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404142007\">404142007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/400122007\">400122007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707589002\">707589002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/772992009\">772992009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/713516007\">713516007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/714463003\">714463003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721602000\">721602000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/762458004\">762458004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707588005\">707588005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723854000\">723854000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723855004\">723855004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723856003\">723856003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723853006\">723853006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723887001\">723887001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/87131000119104\">87131000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724650000\">724650000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735757008\">735757008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707487003\">707487003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707660007\">707660007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707392002\">707392002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722445001\">722445001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722444002\">722444002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/684911000119105\">684911000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716652006\">716652006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722685004\">722685004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707592003\">707592003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721595004\">721595004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/420788006\">420788006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/45221000119105\">45221000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722524005\">722524005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424779008\">424779008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423807009\">423807009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722514002\">722514002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722513008\">722513008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721578007\">721578007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722516000\">722516000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722515001\">722515001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721577002\">721577002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722684000\">722684000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707491008\">707491008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707360003\">707360003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707584007\">707584007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707493006\">707493006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/421283008\">421283008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763477007\">763477007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/147101000119108\">147101000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/107771000119106\">107771000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724554001\">724554001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722529000\">722529000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707674000\">707674000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/145831000119103\">145831000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/87101000119106\">87101000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/96291000119105\">96291000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722543005\">722543005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723281005\">723281005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722665003\">722665003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721563000\">721563000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722718001\">722718001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721643000\">721643000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/107751000119102\">107751000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372087000\">372087000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/148911000119107\">148911000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371962007\">371962007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93657007\">93657007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93658002\">93658002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93659005\">93659005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93660000\">93660000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93661001\">93661001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93662008\">93662008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93663003\">93663003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371963002\">371963002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93665005\">93665005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371966005\">371966005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93667002\">93667002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371967001\">371967001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93669004\">93669004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93670003\">93670003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93671004\">93671004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93672006\">93672006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371968006\">371968006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93674007\">93674007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93675008\">93675008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93676009\">93676009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93677000\">93677000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371969003\">371969003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93679002\">93679002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93680004\">93680004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93681000\">93681000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/128466006\">128466006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93683002\">93683002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93684008\">93684008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372092003\">372092003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353421000119109\">353421000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353501000119104\">353501000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93686005\">93686005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93687001\">93687001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15635801000119106\">15635801000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371970002\">371970002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93689003\">93689003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93714009\">93714009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93690007\">93690007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93692004\">93692004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93693009\">93693009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93694003\">93694003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93695002\">93695002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93696001\">93696001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93697005\">93697005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93698000\">93698000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93699008\">93699008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93700009\">93700009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93701008\">93701008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/400074007\">400074007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93703006\">93703006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93704000\">93704000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93705004\">93705004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93706003\">93706003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93707007\">93707007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93708002\">93708002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93709005\">93709005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93710000\">93710000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93711001\">93711001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93712008\">93712008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399884001\">399884001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93713003\">93713003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93715005\">93715005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93716006\">93716006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93717002\">93717002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371971003\">371971003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93725000\">93725000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93720005\">93720005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93721009\">93721009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354651000119102\">354651000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354641000119104\">354641000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93722002\">93722002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354681000119109\">354681000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354671000119106\">354671000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93723007\">93723007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93724001\">93724001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371975007\">371975007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15635721000119108\">15635721000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93727008\">93727008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93726004\">93726004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109834009\">109834009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372137005\">372137005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373090000\">373090000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373091001\">373091001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373089009\">373089009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373088001\">373088001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082901000112103\">1082901000112103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93728003\">93728003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93734005\">93734005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93729006\">93729006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93730001\">93730001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93731002\">93731002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93732009\">93732009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93733004\">93733004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371976008\">371976008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93737003\">93737003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93738008\">93738008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93739000\">93739000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93740003\">93740003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93741004\">93741004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93742006\">93742006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93743001\">93743001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371977004\">371977004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93744007\">93744007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93745008\">93745008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353441000119103\">353441000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353521000119108\">353521000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93746009\">93746009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93747000\">93747000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93748005\">93748005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93749002\">93749002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371978009\">371978009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93751003\">93751003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93753000\">93753000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93754006\">93754006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93755007\">93755007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93756008\">93756008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93757004\">93757004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371980003\">371980003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109840002\">109840002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93759001\">93759001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93760006\">93760006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93761005\">93761005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371981004\">371981004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93763008\">93763008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93764002\">93764002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93766000\">93766000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93767009\">93767009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93768004\">93768004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93769007\">93769007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93770008\">93770008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109876001\">109876001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93771007\">93771007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93772000\">93772000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447416008\">447416008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449803009\">449803009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93773005\">93773005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93775003\">93775003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/415177008\">415177008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93776002\">93776002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93777006\">93777006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93778001\">93778001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93779009\">93779009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371983001\">371983001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93781006\">93781006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93782004\">93782004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93783009\">93783009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93784003\">93784003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722533007\">722533007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371984007\">371984007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93786001\">93786001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93787005\">93787005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93788000\">93788000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93789008\">93789008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/33581000119109\">33581000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/446189008\">446189008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371986009\">371986009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93792007\">93792007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93793002\">93793002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371987000\">371987000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371988005\">371988005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93796005\">93796005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93797001\">93797001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353431000119107\">353431000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353511000119101\">353511000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93798006\">93798006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93799003\">93799003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93800004\">93800004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93801000\">93801000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93802007\">93802007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93803002\">93803002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93804008\">93804008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93806005\">93806005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93807001\">93807001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93808006\">93808006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93809003\">93809003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109882003\">109882003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372139008\">372139008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/363745004\">363745004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93812000\">93812000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371989002\">371989002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93814004\">93814004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93815003\">93815003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93816002\">93816002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93817006\">93817006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93818001\">93818001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371990006\">371990006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93820003\">93820003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93821004\">93821004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371991005\">371991005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93824007\">93824007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372119009\">372119009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93825008\">93825008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93826009\">93826009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93827000\">93827000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93828005\">93828005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93829002\">93829002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93830007\">93830007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93831006\">93831006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/98981000119103\">98981000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93832004\">93832004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93833009\">93833009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109357005\">109357005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109359008\">109359008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93834003\">93834003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93835002\">93835002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93836001\">93836001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93837005\">93837005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371992003\">371992003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93839008\">93839008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447109003\">447109003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93841009\">93841009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93842002\">93842002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93843007\">93843007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93844001\">93844001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93845000\">93845000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93846004\">93846004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93848003\">93848003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93849006\">93849006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93850006\">93850006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93851005\">93851005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721548003\">721548003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735918005\">735918005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423195009\">423195009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371993008\">371993008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423005002\">423005002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93854002\">93854002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371994002\">371994002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109370001\">109370001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93857009\">93857009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93858004\">93858004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371995001\">371995001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93860002\">93860002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93861003\">93861003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93862005\">93862005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93863000\">93863000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/350921000119109\">350921000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369513003\">369513003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354351000119105\">354351000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354491000119109\">354491000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369522002\">369522002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93865007\">93865007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93867004\">93867004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93868009\">93868009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371996000\">371996000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95214007\">95214007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93871001\">93871001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93872008\">93872008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371997009\">371997009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93874009\">93874009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449635006\">449635006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93875005\">93875005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93864006\">93864006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372110008\">372110008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93876006\">93876006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371998004\">371998004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93878007\">93878007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93879004\">93879004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93880001\">93880001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93882009\">93882009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93883004\">93883004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93884005\">93884005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93885006\">93885006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93886007\">93886007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93887003\">93887003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93888008\">93888008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93889000\">93889000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93890009\">93890009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93891008\">93891008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109915008\">109915008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93892001\">93892001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93893006\">93893006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93894000\">93894000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/371999007\">371999007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372000001\">372000001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93898002\">93898002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93913006\">93913006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93899005\">93899005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93900000\">93900000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93901001\">93901001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93902008\">93902008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93903003\">93903003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93904009\">93904009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93905005\">93905005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93906006\">93906006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93907002\">93907002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93908007\">93908007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93909004\">93909004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93910009\">93910009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93911008\">93911008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93912001\">93912001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93914000\">93914000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93915004\">93915004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93916003\">93916003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93917007\">93917007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93918002\">93918002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/226521000119108\">226521000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93920004\">93920004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93922007\">93922007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93923002\">93923002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93924008\">93924008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93925009\">93925009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93926005\">93926005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93927001\">93927001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93928006\">93928006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735917000\">735917000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93929003\">93929003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93930008\">93930008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94090003\">94090003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93931007\">93931007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372001002\">372001002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93932000\">93932000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93933005\">93933005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93934004\">93934004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372002009\">372002009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93936002\">93936002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372003004\">372003004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93939009\">93939009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93940006\">93940006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93941005\">93941005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93942003\">93942003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93943008\">93943008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93944002\">93944002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93945001\">93945001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93946000\">93946000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93947009\">93947009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93948004\">93948004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372004005\">372004005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93950007\">93950007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93951006\">93951006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372115003\">372115003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93952004\">93952004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93953009\">93953009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372005006\">372005006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93955002\">93955002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93956001\">93956001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93957005\">93957005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/446807009\">446807009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422736007\">422736007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109921007\">109921007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109918005\">109918005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109943004\">109943004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109925003\">109925003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109923005\">109923005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109939003\">109939003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109937001\">109937001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109927006\">109927006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109945006\">109945006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109933002\">109933002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109941002\">109941002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109947003\">109947003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109931000\">109931000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93958000\">93958000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93959008\">93959008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93960003\">93960003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93961004\">93961004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93962006\">93962006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93963001\">93963001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93964007\">93964007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721567004\">721567004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93966009\">93966009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93967000\">93967000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93968005\">93968005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93969002\">93969002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93970001\">93970001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93971002\">93971002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93972009\">93972009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372006007\">372006007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93973004\">93973004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93974005\">93974005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93975006\">93975006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93976007\">93976007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93977003\">93977003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93978008\">93978008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93979000\">93979000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93980002\">93980002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93981003\">93981003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93982005\">93982005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93983000\">93983000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93984006\">93984006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93985007\">93985007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93986008\">93986008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93987004\">93987004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372007003\">372007003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93989001\">93989001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94092006\">94092006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93990005\">93990005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372107001\">372107001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/350861000119106\">350861000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369520005\">369520005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354361000119107\">354361000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93991009\">93991009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/354591000119108\">354591000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93992002\">93992002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369529006\">369529006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93994001\">93994001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93995000\">93995000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93996004\">93996004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109828002\">109828002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372008008\">372008008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93997008\">93997008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93998003\">93998003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372009000\">372009000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94000008\">94000008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94001007\">94001007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369487007\">369487007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94002000\">94002000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94003005\">94003005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94004004\">94004004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94005003\">94005003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94006002\">94006002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94047004\">94047004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724866001\">724866001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372123001\">372123001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94007006\">94007006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94008001\">94008001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94010004\">94010004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94011000\">94011000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94012007\">94012007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94013002\">94013002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94014008\">94014008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94015009\">94015009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94016005\">94016005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94017001\">94017001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94018006\">94018006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94019003\">94019003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94020009\">94020009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94021008\">94021008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94022001\">94022001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94023006\">94023006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94024000\">94024000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94025004\">94025004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94026003\">94026003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94027007\">94027007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94028002\">94028002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94029005\">94029005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94030000\">94030000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94032008\">94032008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449634005\">449634005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94033003\">94033003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94034009\">94034009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94035005\">94035005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94036006\">94036006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94037002\">94037002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94038007\">94038007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94039004\">94039004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94040002\">94040002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94041003\">94041003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94042005\">94042005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94043000\">94043000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94044006\">94044006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94045007\">94045007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94046008\">94046008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94048009\">94048009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94049001\">94049001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352321000119107\">352321000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352231000119103\">352231000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352311000119100\">352311000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352301000119103\">352301000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372010005\">372010005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94050001\">94050001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94051002\">94051002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94052009\">94052009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94053004\">94053004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94054005\">94054005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94055006\">94055006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94056007\">94056007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94057003\">94057003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94058008\">94058008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94059000\">94059000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94060005\">94060005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94061009\">94061009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94062002\">94062002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94063007\">94063007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372012002\">372012002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372013007\">372013007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94066004\">94066004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94067008\">94067008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94068003\">94068003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94069006\">94069006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94071006\">94071006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94072004\">94072004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94073009\">94073009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372014001\">372014001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94075002\">94075002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94076001\">94076001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94077005\">94077005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94078000\">94078000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94079008\">94079008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94080006\">94080006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94081005\">94081005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94082003\">94082003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94083008\">94083008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94084002\">94084002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94085001\">94085001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94086000\">94086000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94087009\">94087009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372015000\">372015000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94089007\">94089007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372016004\">372016004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94093001\">94093001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94094007\">94094007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372017008\">372017008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372019006\">372019006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94096009\">94096009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94097000\">94097000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94098005\">94098005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94099002\">94099002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94101009\">94101009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372020000\">372020000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94102002\">94102002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94103007\">94103007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94104001\">94104001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94105000\">94105000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372021001\">372021001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94107008\">94107008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94108003\">94108003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94109006\">94109006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94110001\">94110001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94111002\">94111002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94112009\">94112009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94113004\">94113004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/310504009\">310504009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109356001\">109356001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93682007\">93682007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372022008\">372022008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94115006\">94115006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94116007\">94116007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372133009\">372133009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/93993007\">93993007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94117003\">94117003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94118008\">94118008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372023003\">372023003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94120006\">94120006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94121005\">94121005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94122003\">94122003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94123008\">94123008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94124002\">94124002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94125001\">94125001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94126000\">94126000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372024009\">372024009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/10708511000119108\">10708511000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94128004\">94128004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94129007\">94129007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372025005\">372025005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94131003\">94131003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94132005\">94132005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94133000\">94133000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94134006\">94134006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94135007\">94135007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372026006\">372026006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372027002\">372027002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372028007\">372028007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94138009\">94138009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94139001\">94139001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94140004\">94140004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372030009\">372030009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94142007\">94142007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94143002\">94143002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94144008\">94144008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94145009\">94145009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722518004\">722518004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722517009\">722517009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733351008\">733351008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733163007\">733163007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733162002\">733162002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721673009\">721673009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/130381000119103\">130381000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733353006\">733353006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721636006\">721636006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722527003\">722527003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721635005\">721635005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/130371000119101\">130371000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721698005\">721698005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733348001\">733348001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721644006\">721644006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721626003\">721626003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/737313007\">737313007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/737312002\">737312002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/130351000119105\">130351000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722528008\">722528008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735735001\">735735001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/762665002\">762665002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721637002\">721637002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721700001\">721700001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721670007\">721670007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721634009\">721634009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733350009\">733350009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735920008\">735920008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735919002\">735919002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735921007\">735921007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735916009\">735916009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724806004\">724806004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735450006\">735450006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724805000\">724805000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721541009\">721541009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444910004\">444910004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277523004\">277523004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722677008\">722677008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722681008\">722681008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707468009\">707468009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707404008\">707404008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721672004\">721672004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722679006\">722679006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707452003\">707452003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707400004\">707400004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733361001\">733361001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707473003\">707473003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707470000\">707470000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733356003\">733356003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722687007\">722687007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707595001\">707595001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707383000\">707383000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733352001\">733352001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733347006\">733347006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733349009\">733349009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733346002\">733346002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707406005\">707406005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722714004\">722714004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707465007\">707465007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707591005\">707591005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707379000\">707379000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707464006\">707464006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707586009\">707586009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707378008\">707378008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721580001\">721580001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723077004\">723077004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723076008\">723076008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721640002\">721640002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721639004\">721639004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722683006\">722683006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721697000\">721697000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721645007\">721645007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721625004\">721625004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721642005\">721642005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721641003\">721641003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721701002\">721701002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721671006\">721671006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721638007\">721638007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716588005\">716588005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707469001\">707469001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/388871003\">388871003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/735680008\">735680008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723849009\">723849009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723851008\">723851008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/860923004\">860923004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723852001\">723852001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723848001\">723848001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723850009\">723850009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/440397000\">440397000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707396004\">707396004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707411007\">707411007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707399006\">707399006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707472008\">707472008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707482009\">707482009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707426009\">707426009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707455001\">707455001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707581004\">707581004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707391009\">707391009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707458004\">707458004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707398003\">707398003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724552002\">724552002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707460002\">707460002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/718200007\">718200007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722512003\">722512003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721574009\">721574009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722509001\">722509001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722510006\">722510006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722511005\">722511005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707627009\">707627009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707467004\">707467004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707380002\">707380002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707593008\">707593008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1081711000119104\">1081711000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722519007\">722519007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722229001\">722229001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1081751000119103\">1081751000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424849005\">424849005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1081781000119105\">1081781000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1081811000119107\">1081811000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722680009\">722680009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722686003\">722686003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707407001\">707407001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276738009\">276738009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707377003\">707377003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722682001\">722682001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/67811000119102\">67811000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/67821000119109\">67821000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/67831000119107\">67831000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/67841000119103\">67841000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/440525003\">440525003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707408006\">707408006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707410008\">707410008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707384006\">707384006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722832009\">722832009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707457009\">707457009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707394001\">707394001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91141000119100\">91141000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707489000\">707489000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707422006\">707422006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707582006\">707582006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707495004\">707495004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707353009\">707353009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722542000\">722542000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707537007\">707537007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723265000\">723265000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722672002\">722672002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707531008\">707531008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91151000119103\">91151000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722112006\">722112006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733359005\">733359005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707359008\">707359008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707356001\">707356001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707664003\">707664003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707697002\">707697002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707492001\">707492001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733357007\">733357007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722666002\">722666002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707357005\">707357005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707358000\">707358000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707535004\">707535004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082071000119102\">1082071000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722673007\">722673007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733344004\">733344004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721620009\">721620009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707354003\">707354003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722676004\">722676004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721619003\">721619003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/440527006\">440527006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723182009\">723182009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707528007\">707528007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733343005\">733343005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707585008\">707585008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721605003\">721605003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721621008\">721621008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721604004\">721604004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724467001\">724467001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/18121000119104\">18121000119104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733134009\">733134009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722674001\">722674001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722530005\">722530005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733345003\">733345003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707703001\">707703001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707686002\">707686002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707532001\">707532001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707704007\">707704007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733358002\">733358002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082191000119100\">1082191000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082101000119106\">1082101000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082221000119106\">1082221000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707355002\">707355002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707576008\">707576008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/737311009\">737311009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/737310005\">737310005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707575007\">707575007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/105111000119109\">105111000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707388009\">707388009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/24111000119105\">24111000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721618006\">721618006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/107591000119100\">107591000119100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722678003\">722678003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707538002\">707538002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/242951000119108\">242951000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722828003\">722828003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722827008\">722827008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721579004\">721579004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722670005\">722670005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/107601000119107\">107601000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733360000\">733360000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707483004\">707483004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707421004\">707421004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707456000\">707456000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721607006\">721607006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724553007\">724553007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707385007\">707385007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91421000119103\">91421000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91171000119107\">91171000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724468006\">724468006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733135005\">733135005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707490009\">707490009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707427000\">707427000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/707494000\">707494000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699028006\">699028006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766248004\">766248004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766247009\">766247009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/134209002\">134209002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254792006\">254792006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/110006004\">110006004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307622006\">307622006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/712849003\">712849003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/96901000119105\">96901000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307601000\">307601000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189815007\">189815007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/28122003\">28122003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403714009\">403714009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403711001\">403711001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403713003\">403713003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/398768004\">398768004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403729006\">403729006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/82546001\">82546001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/830060005\">830060005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722425009\">722425009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/722957003\">722957003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1098981000119101\">1098981000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/452241000124100\">452241000124100</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/461371000124103\">461371000124103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1081551000119106\">1081551000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1081561000119108\">1081561000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/71111000119109\">71111000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/719052006\">719052006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12311000132101\">12311000132101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12291000132102\">12291000132102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109996008\">109996008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/398623004\">398623004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/110000005\">110000005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/415283002\">415283002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/415284008\">415284008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109998009\">109998009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721302006\">721302006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189509003\">189509003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/415285009\">415285009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/415286005\">415286005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/461311000124107\">461311000124107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399374009\">399374009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254912000\">254912000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/452291000124109\">452291000124109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12281000132104\">12281000132104</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/415287001\">415287001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/830057003\">830057003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702391001\">702391001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15636991000119103\">15636991000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/717735006\">717735006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/765095002\">765095002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/373168002\">373168002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/420302007\">420302007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95224004\">95224004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95225003\">95225003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95226002\">95226002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188492005\">188492005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188489006\">188489006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188493000\">188493000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95230004\">95230004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95231000\">95231000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/312949007\">312949007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/370967009\">370967009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307219002\">307219002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302847003\">302847003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278024000\">278024000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763408003\">763408003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423610004\">423610004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763409006\">763409006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254994000\">254994000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277550009\">277550009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399660006\">399660006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/770682007\">770682007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404070007\">404070007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95264000\">95264000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188632001\">188632001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188635004\">188635004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188631008\">188631008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95260009\">95260009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188634000\">188634000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188637007\">188637007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/95263006\">95263006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/281561000\">281561000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783183009\">783183009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424413001\">424413001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448435005\">448435005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447784001\">447784001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448711001\">448711001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278046008\">278046008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448710000\">448710000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255067005\">255067005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448378004\">448378004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449100005\">449100005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/278050001\">278050001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448436006\">448436006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449268006\">449268006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449208008\">449208008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449293008\">449293008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/446643000\">446643000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447266004\">447266004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/687981000119106\">687981000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448449001\">448449001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448712008\">448712008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448221005\">448221005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423812005\">423812005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449207003\">449207003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254918001\">254918001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254601002\">254601002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448388003\">448388003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448257000\">448257000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449267001\">449267001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448258005\">448258005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448450001\">448450001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699354006\">699354006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423627007\">423627007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449497006\">449497006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447885009\">447885009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/447783007\">447783007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448259002\">448259002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448775003\">448775003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449269003\">449269003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448377009\">448377009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449294002\">449294002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449295001\">449295001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424952003\">424952003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449101009\">449101009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449206007\">449206007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448408001\">448408001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254877001\">254877001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448776002\">448776002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254897006\">254897006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448451002\">448451002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404093001\">404093001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/688131000119108\">688131000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426510004\">426510004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254839007\">254839007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404068003\">404068003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307599002\">307599002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/231833004\">231833004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15956181000119102\">15956181000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91281000119103\">91281000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/108211000119108\">108211000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/286902000\">286902000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255118005\">255118005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94152006\">94152006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94153001\">94153001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94154007\">94154007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94155008\">94155008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94156009\">94156009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94157000\">94157000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94158005\">94158005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94159002\">94159002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94160007\">94160007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94161006\">94161006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94162004\">94162004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94163009\">94163009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94164003\">94164003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94165002\">94165002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94166001\">94166001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94167005\">94167005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94168000\">94168000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94169008\">94169008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94170009\">94170009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94171008\">94171008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94172001\">94172001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94173006\">94173006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94175004\">94175004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94176003\">94176003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94177007\">94177007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/128465005\">128465005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94179005\">94179005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94180008\">94180008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94181007\">94181007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/372093008\">372093008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94182000\">94182000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94183005\">94183005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94184004\">94184004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12246561000119101\">12246561000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12246601000119101\">12246601000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94185003\">94185003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94186002\">94186002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94211009\">94211009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94187006\">94187006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94189009\">94189009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94190000\">94190000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94191001\">94191001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94192008\">94192008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94193003\">94193003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94194009\">94194009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94195005\">94195005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94196006\">94196006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94197002\">94197002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94198007\">94198007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/400058002\">400058002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94200001\">94200001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94201002\">94201002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94202009\">94202009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94203004\">94203004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94204005\">94204005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94205006\">94205006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94206007\">94206007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94207003\">94207003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94208008\">94208008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94209000\">94209000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399969009\">399969009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94210005\">94210005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94212002\">94212002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94213007\">94213007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94214001\">94214001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94215000\">94215000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94222008\">94222008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94217008\">94217008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94218003\">94218003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94219006\">94219006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94220000\">94220000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94221001\">94221001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94225005\">94225005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188462001\">188462001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94224009\">94224009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94226006\">94226006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94227002\">94227002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94233006\">94233006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94228007\">94228007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94229004\">94229004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94230009\">94230009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94231008\">94231008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94232001\">94232001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94234000\">94234000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94236003\">94236003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94237007\">94237007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94238002\">94238002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94239005\">94239005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94240007\">94240007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94241006\">94241006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94242004\">94242004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94235004\">94235004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94243009\">94243009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94244003\">94244003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94245002\">94245002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94246001\">94246001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94247005\">94247005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94248000\">94248000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94249008\">94249008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94250008\">94250008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188469005\">188469005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94252000\">94252000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94253005\">94253005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94254004\">94254004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94255003\">94255003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94256002\">94256002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94257006\">94257006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94258001\">94258001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94259009\">94259009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94260004\">94260004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/781076008\">781076008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94261000\">94261000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94262007\">94262007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94263002\">94263002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94265009\">94265009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94266005\">94266005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94267001\">94267001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94268006\">94268006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94269003\">94269003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94270002\">94270002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94271003\">94271003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94272005\">94272005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94273000\">94273000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94275007\">94275007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94276008\">94276008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94277004\">94277004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94278009\">94278009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94279001\">94279001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94280003\">94280003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94281004\">94281004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94282006\">94282006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94283001\">94283001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188471005\">188471005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94284007\">94284007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94285008\">94285008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94286009\">94286009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94287000\">94287000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94288005\">94288005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94289002\">94289002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94290006\">94290006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94291005\">94291005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94292003\">94292003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94293008\">94293008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94294002\">94294002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94295001\">94295001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94296000\">94296000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94297009\">94297009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94298004\">94298004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94299007\">94299007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94300004\">94300004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94301000\">94301000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94302007\">94302007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94303002\">94303002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94304008\">94304008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94305009\">94305009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94306005\">94306005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94308006\">94308006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94309003\">94309003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94310008\">94310008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94311007\">94311007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94312000\">94312000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94313005\">94313005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94314004\">94314004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94315003\">94315003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94316002\">94316002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94317006\">94317006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94318001\">94318001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94319009\">94319009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94320003\">94320003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94321004\">94321004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94322006\">94322006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94323001\">94323001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94324007\">94324007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94326009\">94326009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94325008\">94325008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94327000\">94327000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94328005\">94328005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94329002\">94329002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94330007\">94330007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94331006\">94331006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94332004\">94332004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94333009\">94333009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94334003\">94334003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94335002\">94335002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94336001\">94336001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94337005\">94337005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94338000\">94338000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94339008\">94339008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94340005\">94340005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94341009\">94341009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94342002\">94342002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94343007\">94343007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94344001\">94344001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94345000\">94345000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94346004\">94346004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94347008\">94347008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94348003\">94348003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94349006\">94349006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94350006\">94350006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94351005\">94351005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94352003\">94352003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94353008\">94353008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94354002\">94354002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94355001\">94355001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94356000\">94356000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94357009\">94357009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94358004\">94358004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94359007\">94359007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94360002\">94360002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94361003\">94361003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94362005\">94362005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/418529003\">418529003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94364006\">94364006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423384009\">423384009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94365007\">94365007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94366008\">94366008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94367004\">94367004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94368009\">94368009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94369001\">94369001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94370000\">94370000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94371001\">94371001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94372008\">94372008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94373003\">94373003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94374009\">94374009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369514009\">369514009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94375005\">94375005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353741000119106\">353741000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369523007\">369523007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94376006\">94376006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94378007\">94378007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94379004\">94379004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94380001\">94380001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94381002\">94381002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94382009\">94382009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94383004\">94383004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94384005\">94384005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94385006\">94385006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449632009\">449632009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94386007\">94386007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94387003\">94387003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94388008\">94388008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94389000\">94389000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/709285002\">709285002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94390009\">94390009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94391008\">94391008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94392001\">94392001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/16260631000119101\">16260631000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94393006\">94393006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94394000\">94394000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94395004\">94395004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94396003\">94396003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94397007\">94397007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/13351431000119102\">13351431000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94398002\">94398002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94399005\">94399005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94400003\">94400003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94401004\">94401004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94402006\">94402006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94403001\">94403001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94404007\">94404007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94405008\">94405008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94406009\">94406009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94407000\">94407000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94408005\">94408005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94409002\">94409002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94410007\">94410007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94411006\">94411006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94412004\">94412004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94413009\">94413009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94414003\">94414003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94415002\">94415002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94416001\">94416001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94417005\">94417005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94432003\">94432003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94418000\">94418000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94419008\">94419008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94420002\">94420002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94421003\">94421003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94422005\">94422005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94423000\">94423000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94424006\">94424006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94425007\">94425007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94426008\">94426008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94427004\">94427004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94428009\">94428009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94429001\">94429001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94430006\">94430006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94431005\">94431005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94433008\">94433008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94434002\">94434002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94435001\">94435001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94436000\">94436000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94437009\">94437009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/242862004\">242862004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94439007\">94439007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94441008\">94441008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94442001\">94442001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94443006\">94443006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94444000\">94444000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94445004\">94445004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94446003\">94446003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94447007\">94447007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94448002\">94448002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94449005\">94449005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94450005\">94450005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94451009\">94451009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94626004\">94626004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94452002\">94452002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94453007\">94453007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94454001\">94454001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94455000\">94455000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94456004\">94456004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94457008\">94457008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94459006\">94459006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94460001\">94460001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94461002\">94461002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94462009\">94462009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94463004\">94463004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94464005\">94464005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94465006\">94465006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94466007\">94466007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94467003\">94467003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94468008\">94468008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94469000\">94469000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94470004\">94470004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94471000\">94471000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94472007\">94472007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94473002\">94473002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94474008\">94474008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94475009\">94475009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94476005\">94476005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94477001\">94477001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94478006\">94478006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94479003\">94479003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94480000\">94480000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94481001\">94481001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94482008\">94482008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94483003\">94483003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94484009\">94484009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94485005\">94485005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94627008\">94627008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94486006\">94486006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94487002\">94487002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94488007\">94488007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94489004\">94489004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94490008\">94490008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94491007\">94491007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94492000\">94492000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94493005\">94493005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94494004\">94494004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94495003\">94495003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94496002\">94496002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94497006\">94497006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94498001\">94498001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94499009\">94499009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94500000\">94500000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94501001\">94501001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94307001\">94307001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94502008\">94502008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94503003\">94503003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94504009\">94504009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94505005\">94505005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94506006\">94506006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94507002\">94507002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94508007\">94508007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94509004\">94509004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94510009\">94510009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94511008\">94511008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94512001\">94512001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94513006\">94513006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94514000\">94514000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269473008\">269473008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94515004\">94515004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94516003\">94516003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94517007\">94517007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94518002\">94518002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94519005\">94519005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94628003\">94628003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188445006\">188445006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94520004\">94520004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94521000\">94521000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369521009\">369521009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94522007\">94522007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/353561000119103\">353561000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94523002\">94523002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369530001\">369530001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94524008\">94524008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94525009\">94525009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94526005\">94526005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94527001\">94527001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94528006\">94528006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94440009\">94440009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94529003\">94529003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94530008\">94530008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94531007\">94531007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94532000\">94532000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94533005\">94533005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369488002\">369488002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94534004\">94534004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94535003\">94535003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94536002\">94536002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94537006\">94537006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94538001\">94538001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94579000\">94579000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94539009\">94539009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94540006\">94540006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94542003\">94542003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94543008\">94543008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94544002\">94544002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94545001\">94545001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94546000\">94546000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94547009\">94547009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94548004\">94548004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94549007\">94549007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94550007\">94550007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94551006\">94551006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94552004\">94552004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94553009\">94553009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94554003\">94554003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94555002\">94555002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94556001\">94556001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94557005\">94557005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94558000\">94558000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94559008\">94559008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94560003\">94560003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188454009\">188454009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94561004\">94561004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/827186009\">827186009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94562006\">94562006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94564007\">94564007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449630001\">449630001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94565008\">94565008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94566009\">94566009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94567000\">94567000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94568005\">94568005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94569002\">94569002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94570001\">94570001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94571002\">94571002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188458007\">188458007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94572009\">94572009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94573004\">94573004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94574005\">94574005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94575006\">94575006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94576007\">94576007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449631002\">449631002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94577003\">94577003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94578008\">94578008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94580002\">94580002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94581003\">94581003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94264008\">94264008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94582005\">94582005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94583000\">94583000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94584006\">94584006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94585007\">94585007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94586008\">94586008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94587004\">94587004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94588009\">94588009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94589001\">94589001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94590005\">94590005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94591009\">94591009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94592002\">94592002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94593007\">94593007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94594001\">94594001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94595000\">94595000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94596004\">94596004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94597008\">94597008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94598003\">94598003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94599006\">94599006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94600009\">94600009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94601008\">94601008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94603006\">94603006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94604000\">94604000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94605004\">94605004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94606003\">94606003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94607007\">94607007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94608002\">94608002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94609005\">94609005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94610000\">94610000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94611001\">94611001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94612008\">94612008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94613003\">94613003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94614009\">94614009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94615005\">94615005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94616006\">94616006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94617002\">94617002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94618007\">94618007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94619004\">94619004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94620005\">94620005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94621009\">94621009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94622002\">94622002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94623007\">94623007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94624001\">94624001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94625000\">94625000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94629006\">94629006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94630001\">94630001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94631002\">94631002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94274006\">94274006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94632009\">94632009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94633004\">94633004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94634005\">94634005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94635006\">94635006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94636007\">94636007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94637003\">94637003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94638008\">94638008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94458003\">94458003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94639000\">94639000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94640003\">94640003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94641004\">94641004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94642006\">94642006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94643001\">94643001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94644007\">94644007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94645008\">94645008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94646009\">94646009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94647000\">94647000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94648005\">94648005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94649002\">94649002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94650002\">94650002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94651003\">94651003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/274088005\">274088005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449633004\">449633004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94652005\">94652005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94653000\">94653000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94654006\">94654006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94655007\">94655007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94656008\">94656008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94657004\">94657004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94658009\">94658009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94659001\">94659001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94660006\">94660006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94661005\">94661005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94662003\">94662003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94663008\">94663008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94664002\">94664002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94665001\">94665001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94666000\">94666000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94667009\">94667009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94668004\">94668004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94669007\">94669007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94670008\">94670008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94671007\">94671007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94672000\">94672000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94673005\">94673005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94674004\">94674004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94675003\">94675003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94602001\">94602001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94676002\">94676002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94677006\">94677006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082601000112109\">1082601000112109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94678001\">94678001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94679009\">94679009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94680007\">94680007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94681006\">94681006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94682004\">94682004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/94683009\">94683009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/128462008\">128462008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369535006\">369535006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/369536007\">369536007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/135091000119106\">135091000119106</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/388872005\">388872005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/108201000119105\">108201000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/788758003\">788758003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/443675005\">443675005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313429000\">313429000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255107005\">255107005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423816008\">423816008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423645007\">423645007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422679002\">422679002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423697000\">423697000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313428008\">313428008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783706007\">783706007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/789044001\">789044001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254850005\">254850005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/308879003\">308879003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/308860001\">308860001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/118611004\">118611004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188633006\">188633006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/438946002\">438946002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/440501006\">440501006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/439478008\">439478008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403903003\">403903003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424750001\">424750001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/11010461000119101\">11010461000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424052001\">424052001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/108131000119108\">108131000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91251000119105\">91251000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254632001\">254632001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/770601003\">770601003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/396198006\">396198006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403944002\">403944002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/718604008\">718604008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404138009\">404138009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352411000119109\">352411000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/352251000119109\">352251000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/430338009\">430338009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/413587002\">413587002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/826978004\">826978004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/786710002\">786710002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721596003\">721596003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/782697005\">782697005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426336007\">426336007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/778046002\">778046002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254957009\">254957009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189167009\">189167009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404073009\">404073009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403923002\">403923002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/788756004\">788756004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404055006\">404055006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254653005\">254653005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403900000\">403900000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763884007\">763884007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277551008\">277551008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/763666008\">763666008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404117003\">404117003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402815007\">402815007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/189565007\">189565007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/871635009\">871635009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254656002\">254656002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/406103009\">406103009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/91181000119105\">91181000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422676009\">422676009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255084004\">255084004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402816008\">402816008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423700001\">423700001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422599000\">422599000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255111004\">255111004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422378004\">422378004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254622008\">254622008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313353007\">313353007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313354001\">313354001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313355000\">313355000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313356004\">313356004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/313357008\">313357008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254437001\">254437001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254886006\">254886006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422572002\">422572002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766981007\">766981007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255003007\">255003007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255008003\">255008003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764737005\">764737005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/408648004\">408648004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276804009\">276804009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/770602005\">770602005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423506005\">423506005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/231831002\">231831002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276954004\">276954004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403895004\">403895004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403893006\">403893006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766978002\">766978002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276953005\">276953005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403896003\">403896003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716659002\">716659002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/405822008\">405822008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12240951000119107\">12240951000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255071008\">255071008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/770684008\">770684008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254634000\">254634000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423295000\">423295000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423468007\">423468007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425230006\">425230006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425376008\">425376008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/307502000\">307502000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/418372008\">418372008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/419240004\">419240004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402817004\">402817004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424260006\">424260006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422691006\">422691006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448930008\">448930008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/419842002\">419842002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423464009\">423464009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276962007\">276962007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403468003\">403468003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/408649007\">408649007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/399590005\">399590005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766979005\">766979005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/12240991000119102\">12240991000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403891008\">403891008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276860003\">276860003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448931007\">448931007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254651007\">254651007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285309005\">285309005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403894000\">403894000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403892001\">403892001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403898002\">403898002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285308002\">285308002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423284006\">423284006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403899005\">403899005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/285307007\">285307007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/764735002\">764735002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766980008\">766980008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425148008\">425148008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/423896007\">423896007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276952000\">276952000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254620000\">254620000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403897007\">403897007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/105121000119102\">105121000119102</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254895003\">254895003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403890009\">403890009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425303004\">425303004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/276878008\">276878008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/723301009\">723301009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/62497000\">62497000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302855005\">302855005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/427056005\">427056005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188726003\">188726003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/426370008\">426370008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188746008\">188746008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188736006\">188736006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/425749006\">425749006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/188770007\">188770007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404133000\">404133000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/449799008\">449799008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404015009\">404015009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254730000\">254730000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254966008\">254966008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277456001\">277456001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699318007\">699318007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444327002\">444327002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/302851001\">302851001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404118008\">404118008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721311006\">721311006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/397016004\">397016004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/397015000\">397015000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277575008\">277575008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/427642009\">427642009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422172005\">422172005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277545003\">277545003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/724645006\">724645006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/699818003\">699818003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402879006\">402879006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109978004\">109978004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277567002\">277567002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255106001\">255106001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/716855006\">716855006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/721306009\">721306009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/762315004\">762315004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/702476004\">702476004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/281563002\">281563002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/771511005\">771511005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444231005\">444231005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424887002\">424887002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254959007\">254959007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/281702006\">281702006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/269516007\">269516007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/274085008\">274085008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/448509007\">448509007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/255109008\">255109008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/785807007\">785807007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/408642003\">408642003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15959061000119101\">15959061000119101</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082281000119105\">1082281000119105</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082291000119108\">1082291000119108</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/15959101000119103\">15959101000119103</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082301000119109\">1082301000119109</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/1082311000119107\">1082311000119107</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/300988009\">300988009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403929003\">403929003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/277185000\">277185000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/706970001\">706970001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/733603009\">733603009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254942002\">254942002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254968009\">254968009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/237721006\">237721006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254982009\">254982009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/444374006\">444374006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/109975001\">109975001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403955002\">403955002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766758001\">766758001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/783704005\">783704005</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/770685009\">770685009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/697993003\">697993003</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/422541001\">422541001</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/254856004\">254856004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766757006\">766757006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/424954002\">424954002</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/698048006\">698048006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/370511006\">370511006</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/439890004\">439890004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/428089008\">428089008</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403889000\">403889000</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/403904009\">403904009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/402912009\">402912009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/766759009\">766759009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/190818004\">190818004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/717922007\">717922007</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/789694004\">789694004</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/405843009\">405843009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/21412009\">21412009</a></td><td/></tr><tr><td><a href=\"http://snomed.info/id/404081005\">404081005</a></td><td/></tr></table></li><li>Include these codes as defined in <a><code>http://hl7.org/fhir/sid/icd-10-cm</code></a><table class=\"none\"><tr><td style=\"white-space:nowrap\"><b>Code</b></td><td><b>Display</b></td></tr><tr><td>C00</td><td style=\"color: #cccccc\">Malignant neoplasm of lip</td></tr><tr><td>C00.0</td><td style=\"color: #cccccc\">Malignant neoplasm of external upper lip</td></tr><tr><td>C00.1</td><td style=\"color: #cccccc\">Malignant neoplasm of external lower lip</td></tr><tr><td>C00.2</td><td style=\"color: #cccccc\">Malignant neoplasm of external lip, unspecified</td></tr><tr><td>C00.3</td><td style=\"color: #cccccc\">Malignant neoplasm of upper lip, inner aspect</td></tr><tr><td>C00.4</td><td style=\"color: #cccccc\">Malignant neoplasm of lower lip, inner aspect</td></tr><tr><td>C00.5</td><td style=\"color: #cccccc\">Malignant neoplasm of lip, unspecified, inner aspect</td></tr><tr><td>C00.6</td><td style=\"color: #cccccc\">Malignant neoplasm of commissure of lip, unspecified</td></tr><tr><td>C00.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of lip</td></tr><tr><td>C00.9</td><td style=\"color: #cccccc\">Malignant neoplasm of lip, unspecified</td></tr><tr><td>C01</td><td style=\"color: #cccccc\">Malignant neoplasm of base of tongue</td></tr><tr><td>C02</td><td style=\"color: #cccccc\">Malignant neoplasm of other and unspecified parts of tongue</td></tr><tr><td>C02.1</td><td style=\"color: #cccccc\">Malignant neoplasm of border of tongue</td></tr><tr><td>C02.2</td><td style=\"color: #cccccc\">Malignant neoplasm of ventral surface of tongue</td></tr><tr><td>C02.3</td><td style=\"color: #cccccc\">Malignant neoplasm of anterior two-thirds of tongue, part unspecified</td></tr><tr><td>C02.4</td><td style=\"color: #cccccc\">Malignant neoplasm of lingual tonsil</td></tr><tr><td>C02.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of tongue</td></tr><tr><td>C02.9</td><td style=\"color: #cccccc\">Malignant neoplasm of tongue, unspecified</td></tr><tr><td>C03</td><td style=\"color: #cccccc\">Malignant neoplasm of gum</td></tr><tr><td>C03.0</td><td style=\"color: #cccccc\">Malignant neoplasm of upper gum</td></tr><tr><td>C03.1</td><td style=\"color: #cccccc\">Malignant neoplasm of lower gum</td></tr><tr><td>C03.9</td><td style=\"color: #cccccc\">Malignant neoplasm of gum, unspecified</td></tr><tr><td>C04</td><td style=\"color: #cccccc\">Malignant neoplasm of floor of mouth</td></tr><tr><td>C04.0</td><td style=\"color: #cccccc\">Malignant neoplasm of anterior floor of mouth</td></tr><tr><td>C04.1</td><td style=\"color: #cccccc\">Malignant neoplasm of lateral floor of mouth</td></tr><tr><td>C04.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of floor of mouth</td></tr><tr><td>C04.9</td><td style=\"color: #cccccc\">Malignant neoplasm of floor of mouth, unspecified</td></tr><tr><td>C05</td><td style=\"color: #cccccc\">Malignant neoplasm of palate</td></tr><tr><td>C05.0</td><td style=\"color: #cccccc\">Malignant neoplasm of hard palate</td></tr><tr><td>C05.1</td><td style=\"color: #cccccc\">Malignant neoplasm of soft palate</td></tr><tr><td>C05.2</td><td style=\"color: #cccccc\">Malignant neoplasm of uvula</td></tr><tr><td>C05.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of palate</td></tr><tr><td>C05.9</td><td style=\"color: #cccccc\">Malignant neoplasm of palate, unspecified</td></tr><tr><td>C06</td><td style=\"color: #cccccc\">Malignant neoplasm of other and unspecified parts of mouth</td></tr><tr><td>C06.0</td><td style=\"color: #cccccc\">Malignant neoplasm of cheek mucosa</td></tr><tr><td>C06.1</td><td style=\"color: #cccccc\">Malignant neoplasm of vestibule of mouth</td></tr><tr><td>C06.2</td><td style=\"color: #cccccc\">Malignant neoplasm of retromolar area</td></tr><tr><td>C06.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of other and unspecified parts of mouth</td></tr><tr><td>C06.80</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of unspecified parts of mouth</td></tr><tr><td>C06.89</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of other parts of mouth</td></tr><tr><td>C06.9</td><td style=\"color: #cccccc\">Malignant neoplasm of mouth, unspecified</td></tr><tr><td>C07</td><td style=\"color: #cccccc\">Malignant neoplasm of parotid gland</td></tr><tr><td>C08</td><td style=\"color: #cccccc\">Malignant neoplasm of other and unspecified major salivary glands</td></tr><tr><td>C08.0</td><td style=\"color: #cccccc\">Malignant neoplasm of submandibular gland</td></tr><tr><td>C08.1</td><td style=\"color: #cccccc\">Malignant neoplasm of sublingual gland</td></tr><tr><td>C08.9</td><td style=\"color: #cccccc\">Malignant neoplasm of major salivary gland, unspecified</td></tr><tr><td>C09</td><td style=\"color: #cccccc\">Malignant neoplasm of tonsil</td></tr><tr><td>C09.0</td><td style=\"color: #cccccc\">Malignant neoplasm of tonsillar fossa</td></tr><tr><td>C09.1</td><td style=\"color: #cccccc\">Malignant neoplasm of tonsillar pillar (anterior) (posterior)</td></tr><tr><td>C09.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of tonsil</td></tr><tr><td>C09.9</td><td style=\"color: #cccccc\">Malignant neoplasm of tonsil, unspecified</td></tr><tr><td>C10</td><td style=\"color: #cccccc\">Malignant neoplasm of oropharynx</td></tr><tr><td>C10.0</td><td style=\"color: #cccccc\">Malignant neoplasm of vallecula</td></tr><tr><td>C10.1</td><td style=\"color: #cccccc\">Malignant neoplasm of anterior surface of epiglottis</td></tr><tr><td>C10.2</td><td style=\"color: #cccccc\">Malignant neoplasm of lateral wall of oropharynx</td></tr><tr><td>C10.3</td><td style=\"color: #cccccc\">Malignant neoplasm of posterior wall of oropharynx</td></tr><tr><td>C10.4</td><td style=\"color: #cccccc\">Malignant neoplasm of branchial cleft</td></tr><tr><td>C10.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of oropharynx</td></tr><tr><td>C10.9</td><td style=\"color: #cccccc\">Malignant neoplasm of oropharynx, unspecified</td></tr><tr><td>C11</td><td style=\"color: #cccccc\">Malignant neoplasm of nasopharynx</td></tr><tr><td>C11.0</td><td style=\"color: #cccccc\">Malignant neoplasm of superior wall of nasopharynx</td></tr><tr><td>C11.1</td><td style=\"color: #cccccc\">Malignant neoplasm of posterior wall of nasopharynx</td></tr><tr><td>C11.2</td><td style=\"color: #cccccc\">Malignant neoplasm of lateral wall of nasopharynx</td></tr><tr><td>C11.3</td><td style=\"color: #cccccc\">Malignant neoplasm of anterior wall of nasopharynx</td></tr><tr><td>C11.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of nasopharynx</td></tr><tr><td>C11.9</td><td style=\"color: #cccccc\">Malignant neoplasm of nasopharynx, unspecified</td></tr><tr><td>C12</td><td style=\"color: #cccccc\">Malignant neoplasm of pyriform sinus</td></tr><tr><td>C13</td><td style=\"color: #cccccc\">Malignant neoplasm of hypopharynx</td></tr><tr><td>C13.0</td><td style=\"color: #cccccc\">Malignant neoplasm of postcricoid region</td></tr><tr><td>C13.1</td><td style=\"color: #cccccc\">Malignant neoplasm of aryepiglottic fold, hypopharyngeal aspect</td></tr><tr><td>C13.2</td><td style=\"color: #cccccc\">Malignant neoplasm of posterior wall of hypopharynx</td></tr><tr><td>C13.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of hypopharynx</td></tr><tr><td>C13.9</td><td style=\"color: #cccccc\">Malignant neoplasm of hypopharynx, unspecified</td></tr><tr><td>C14</td><td style=\"color: #cccccc\">Malignant neoplasm of other and ill-defined sites in the lip, oral cavity and pharynx</td></tr><tr><td>C14.0</td><td style=\"color: #cccccc\">Malignant neoplasm of pharynx, unspecified</td></tr><tr><td>C14.2</td><td style=\"color: #cccccc\">Malignant neoplasm of Waldeyer's ring</td></tr><tr><td>C14.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of lip, oral cavity and pharynx</td></tr><tr><td>C15</td><td style=\"color: #cccccc\">Malignant neoplasm of esophagus</td></tr><tr><td>C15.3</td><td style=\"color: #cccccc\">Malignant neoplasm of upper third of esophagus</td></tr><tr><td>C15.4</td><td style=\"color: #cccccc\">Malignant neoplasm of middle third of esophagus</td></tr><tr><td>C15.5</td><td style=\"color: #cccccc\">Malignant neoplasm of lower third of esophagus</td></tr><tr><td>C15.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of esophagus</td></tr><tr><td>C15.9</td><td style=\"color: #cccccc\">Malignant neoplasm of esophagus, unspecified</td></tr><tr><td>C16</td><td style=\"color: #cccccc\">Malignant neoplasm of stomach</td></tr><tr><td>C16.0</td><td style=\"color: #cccccc\">Malignant neoplasm of cardia</td></tr><tr><td>C16.1</td><td style=\"color: #cccccc\">Malignant neoplasm of fundus of stomach</td></tr><tr><td>C16.2</td><td style=\"color: #cccccc\">Malignant neoplasm of body of stomach</td></tr><tr><td>C16.3</td><td style=\"color: #cccccc\">Malignant neoplasm of pyloric antrum</td></tr><tr><td>C16.4</td><td style=\"color: #cccccc\">Malignant neoplasm of pylorus</td></tr><tr><td>C16.5</td><td style=\"color: #cccccc\">Malignant neoplasm of lesser curvature of stomach, unspecified</td></tr><tr><td>C16.6</td><td style=\"color: #cccccc\">Malignant neoplasm of greater curvature of stomach, unspecified</td></tr><tr><td>C16.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of stomach</td></tr><tr><td>C16.9</td><td style=\"color: #cccccc\">Malignant neoplasm of stomach, unspecified</td></tr><tr><td>C17</td><td style=\"color: #cccccc\">Malignant neoplasm of small intestine</td></tr><tr><td>C17.0</td><td style=\"color: #cccccc\">Malignant neoplasm of duodenum</td></tr><tr><td>C17.1</td><td style=\"color: #cccccc\">Malignant neoplasm of jejunum</td></tr><tr><td>C17.2</td><td style=\"color: #cccccc\">Malignant neoplasm of ileum</td></tr><tr><td>C17.3</td><td style=\"color: #cccccc\">Meckel's diverticulum, malignant</td></tr><tr><td>C17.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of small intestine</td></tr><tr><td>C17.9</td><td style=\"color: #cccccc\">Malignant neoplasm of small intestine, unspecified</td></tr><tr><td>C18</td><td style=\"color: #cccccc\">Malignant neoplasm of colon</td></tr><tr><td>C18.0</td><td style=\"color: #cccccc\">Malignant neoplasm of cecum</td></tr><tr><td>C18.1</td><td style=\"color: #cccccc\">Malignant neoplasm of appendix</td></tr><tr><td>C18.2</td><td style=\"color: #cccccc\">Malignant neoplasm of ascending colon</td></tr><tr><td>C18.3</td><td style=\"color: #cccccc\">Malignant neoplasm of hepatic flexure</td></tr><tr><td>C18.4</td><td style=\"color: #cccccc\">Malignant neoplasm of transverse colon</td></tr><tr><td>C18.5</td><td style=\"color: #cccccc\">Malignant neoplasm of splenic flexure</td></tr><tr><td>C18.6</td><td style=\"color: #cccccc\">Malignant neoplasm of descending colon</td></tr><tr><td>C18.7</td><td style=\"color: #cccccc\">Malignant neoplasm of sigmoid colon</td></tr><tr><td>C18.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of colon</td></tr><tr><td>C18.9</td><td style=\"color: #cccccc\">Malignant neoplasm of colon, unspecified</td></tr><tr><td>C19</td><td style=\"color: #cccccc\">Malignant neoplasm of rectosigmoid junction</td></tr><tr><td>C20</td><td style=\"color: #cccccc\">Malignant neoplasm of rectum</td></tr><tr><td>C21</td><td style=\"color: #cccccc\">Malignant neoplasm of anus and anal canal</td></tr><tr><td>C21.0</td><td style=\"color: #cccccc\">Malignant neoplasm of anus, unspecified</td></tr><tr><td>C21.1</td><td style=\"color: #cccccc\">Malignant neoplasm of anal canal</td></tr><tr><td>C21.2</td><td style=\"color: #cccccc\">Malignant neoplasm of cloacogenic zone</td></tr><tr><td>C21.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of rectum, anus and anal canal</td></tr><tr><td>C22</td><td style=\"color: #cccccc\">Malignant neoplasm of liver and intrahepatic bile ducts</td></tr><tr><td>C22.1</td><td style=\"color: #cccccc\">Intrahepatic bile duct carcinoma</td></tr><tr><td>C22.2</td><td style=\"color: #cccccc\">Hepatoblastoma</td></tr><tr><td>C22.3</td><td style=\"color: #cccccc\">Angiosarcoma of liver</td></tr><tr><td>C22.4</td><td style=\"color: #cccccc\">Other sarcomas of liver</td></tr><tr><td>C22.7</td><td style=\"color: #cccccc\">Other specified carcinomas of liver</td></tr><tr><td>C22.8</td><td style=\"color: #cccccc\">Malignant neoplasm of liver, primary, unspecified as to type</td></tr><tr><td>C22.9</td><td style=\"color: #cccccc\">Malignant neoplasm of liver, not specified as primary or secondary</td></tr><tr><td>C23</td><td style=\"color: #cccccc\">Malignant neoplasm of gallbladder</td></tr><tr><td>C24</td><td style=\"color: #cccccc\">Malignant neoplasm of other and unspecified parts of biliary tract</td></tr><tr><td>C24.0</td><td style=\"color: #cccccc\">Malignant neoplasm of extrahepatic bile duct</td></tr><tr><td>C24.1</td><td style=\"color: #cccccc\">Malignant neoplasm of ampulla of Vater</td></tr><tr><td>C24.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of biliary tract</td></tr><tr><td>C24.9</td><td style=\"color: #cccccc\">Malignant neoplasm of biliary tract, unspecified</td></tr><tr><td>C25</td><td style=\"color: #cccccc\">Malignant neoplasm of pancreas</td></tr><tr><td>C25.0</td><td style=\"color: #cccccc\">Malignant neoplasm of head of pancreas</td></tr><tr><td>C25.1</td><td style=\"color: #cccccc\">Malignant neoplasm of body of pancreas</td></tr><tr><td>C25.2</td><td style=\"color: #cccccc\">Malignant neoplasm of tail of pancreas</td></tr><tr><td>C25.3</td><td style=\"color: #cccccc\">Malignant neoplasm of pancreatic duct</td></tr><tr><td>C25.4</td><td style=\"color: #cccccc\">Malignant neoplasm of endocrine pancreas</td></tr><tr><td>C25.7</td><td style=\"color: #cccccc\">Malignant neoplasm of other parts of pancreas</td></tr><tr><td>C25.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of pancreas</td></tr><tr><td>C25.9</td><td style=\"color: #cccccc\">Malignant neoplasm of pancreas, unspecified</td></tr><tr><td>C26</td><td style=\"color: #cccccc\">Malignant neoplasm of other and ill-defined digestive organs</td></tr><tr><td>C26.0</td><td style=\"color: #cccccc\">Malignant neoplasm of intestinal tract, part unspecified</td></tr><tr><td>C26.1</td><td style=\"color: #cccccc\">Malignant neoplasm of spleen</td></tr><tr><td>C26.9</td><td style=\"color: #cccccc\">Malignant neoplasm of ill-defined sites within the digestive system</td></tr><tr><td>C30</td><td style=\"color: #cccccc\">Malignant neoplasm of nasal cavity and middle ear</td></tr><tr><td>C30.0</td><td style=\"color: #cccccc\">Malignant neoplasm of nasal cavity</td></tr><tr><td>C30.1</td><td style=\"color: #cccccc\">Malignant neoplasm of middle ear</td></tr><tr><td>C31</td><td style=\"color: #cccccc\">Malignant neoplasm of accessory sinuses</td></tr><tr><td>C31.0</td><td style=\"color: #cccccc\">Malignant neoplasm of maxillary sinus</td></tr><tr><td>C31.1</td><td style=\"color: #cccccc\">Malignant neoplasm of ethmoidal sinus</td></tr><tr><td>C31.2</td><td style=\"color: #cccccc\">Malignant neoplasm of frontal sinus</td></tr><tr><td>C31.3</td><td style=\"color: #cccccc\">Malignant neoplasm of sphenoid sinus</td></tr><tr><td>C31.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of accessory sinuses</td></tr><tr><td>C31.9</td><td style=\"color: #cccccc\">Malignant neoplasm of accessory sinus, unspecified</td></tr><tr><td>C32</td><td style=\"color: #cccccc\">Malignant neoplasm of larynx</td></tr><tr><td>C32.0</td><td style=\"color: #cccccc\">Malignant neoplasm of glottis</td></tr><tr><td>C32.1</td><td style=\"color: #cccccc\">Malignant neoplasm of supraglottis</td></tr><tr><td>C32.2</td><td style=\"color: #cccccc\">Malignant neoplasm of subglottis</td></tr><tr><td>C32.3</td><td style=\"color: #cccccc\">Malignant neoplasm of laryngeal cartilage</td></tr><tr><td>C32.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of larynx</td></tr><tr><td>C32.9</td><td style=\"color: #cccccc\">Malignant neoplasm of larynx, unspecified</td></tr><tr><td>C33</td><td style=\"color: #cccccc\">Malignant neoplasm of trachea</td></tr><tr><td>C34</td><td style=\"color: #cccccc\">Malignant neoplasm of bronchus and lung</td></tr><tr><td>C34.0</td><td style=\"color: #cccccc\">Malignant neoplasm of main bronchus</td></tr><tr><td>C34.00</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified main bronchus</td></tr><tr><td>C34.01</td><td style=\"color: #cccccc\">Malignant neoplasm of right main bronchus</td></tr><tr><td>C34.02</td><td style=\"color: #cccccc\">Malignant neoplasm of left main bronchus</td></tr><tr><td>C34.1</td><td style=\"color: #cccccc\">Malignant neoplasm of upper lobe, bronchus or lung</td></tr><tr><td>C34.10</td><td style=\"color: #cccccc\">Malignant neoplasm of upper lobe, unspecified bronchus or lung</td></tr><tr><td>C34.11</td><td style=\"color: #cccccc\">Malignant neoplasm of upper lobe, right bronchus or lung</td></tr><tr><td>C34.12</td><td style=\"color: #cccccc\">Malignant neoplasm of upper lobe, left bronchus or lung</td></tr><tr><td>C34.2</td><td style=\"color: #cccccc\">Malignant neoplasm of middle lobe, bronchus or lung</td></tr><tr><td>C34.3</td><td style=\"color: #cccccc\">Malignant neoplasm of lower lobe, bronchus or lung</td></tr><tr><td>C34.30</td><td style=\"color: #cccccc\">Malignant neoplasm of lower lobe, unspecified bronchus or lung</td></tr><tr><td>C34.31</td><td style=\"color: #cccccc\">Malignant neoplasm of lower lobe, right bronchus or lung</td></tr><tr><td>C34.32</td><td style=\"color: #cccccc\">Malignant neoplasm of lower lobe, left bronchus or lung</td></tr><tr><td>C34.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of bronchus and lung</td></tr><tr><td>C34.80</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of unspecified bronchus and lung</td></tr><tr><td>C34.81</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of right bronchus and lung</td></tr><tr><td>C34.82</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of left bronchus and lung</td></tr><tr><td>C34.9</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified part of bronchus or lung</td></tr><tr><td>C34.90</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified part of unspecified bronchus or lung</td></tr><tr><td>C34.91</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified part of right bronchus or lung</td></tr><tr><td>C34.92</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified part of left bronchus or lung</td></tr><tr><td>C37</td><td style=\"color: #cccccc\">Malignant neoplasm of thymus</td></tr><tr><td>C38</td><td style=\"color: #cccccc\">Malignant neoplasm of heart, mediastinum and pleura</td></tr><tr><td>C38.0</td><td style=\"color: #cccccc\">Malignant neoplasm of heart</td></tr><tr><td>C38.1</td><td style=\"color: #cccccc\">Malignant neoplasm of anterior mediastinum</td></tr><tr><td>C38.2</td><td style=\"color: #cccccc\">Malignant neoplasm of posterior mediastinum</td></tr><tr><td>C38.3</td><td style=\"color: #cccccc\">Malignant neoplasm of mediastinum, part unspecified</td></tr><tr><td>C38.4</td><td style=\"color: #cccccc\">Malignant neoplasm of pleura</td></tr><tr><td>C38.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of heart, mediastinum and pleura</td></tr><tr><td>C39</td><td style=\"color: #cccccc\">Malignant neoplasm of other and ill-defined sites in the respiratory system and intrathoracic organs</td></tr><tr><td>C39.0</td><td style=\"color: #cccccc\">Malignant neoplasm of upper respiratory tract, part unspecified</td></tr><tr><td>C39.9</td><td style=\"color: #cccccc\">Malignant neoplasm of lower respiratory tract, part unspecified</td></tr><tr><td>C40</td><td style=\"color: #cccccc\">Malignant neoplasm of bone and articular cartilage of limbs</td></tr><tr><td>C40.0</td><td style=\"color: #cccccc\">Malignant neoplasm of scapula and long bones of upper limb</td></tr><tr><td>C40.00</td><td style=\"color: #cccccc\">Malignant neoplasm of scapula and long bones of unspecified upper limb</td></tr><tr><td>C40.01</td><td style=\"color: #cccccc\">Malignant neoplasm of scapula and long bones of right upper limb</td></tr><tr><td>C40.02</td><td style=\"color: #cccccc\">Malignant neoplasm of scapula and long bones of left upper limb</td></tr><tr><td>C40.1</td><td style=\"color: #cccccc\">Malignant neoplasm of short bones of upper limb</td></tr><tr><td>C40.10</td><td style=\"color: #cccccc\">Malignant neoplasm of short bones of unspecified upper limb</td></tr><tr><td>C40.11</td><td style=\"color: #cccccc\">Malignant neoplasm of short bones of right upper limb</td></tr><tr><td>C40.12</td><td style=\"color: #cccccc\">Malignant neoplasm of short bones of left upper limb</td></tr><tr><td>C40.2</td><td style=\"color: #cccccc\">Malignant neoplasm of long bones of lower limb</td></tr><tr><td>C40.20</td><td style=\"color: #cccccc\">Malignant neoplasm of long bones of unspecified lower limb</td></tr><tr><td>C40.21</td><td style=\"color: #cccccc\">Malignant neoplasm of long bones of right lower limb</td></tr><tr><td>C40.22</td><td style=\"color: #cccccc\">Malignant neoplasm of long bones of left lower limb</td></tr><tr><td>C40.3</td><td style=\"color: #cccccc\">Malignant neoplasm of short bones of lower limb</td></tr><tr><td>C40.30</td><td style=\"color: #cccccc\">Malignant neoplasm of short bones of unspecified lower limb</td></tr><tr><td>C40.31</td><td style=\"color: #cccccc\">Malignant neoplasm of short bones of right lower limb</td></tr><tr><td>C40.32</td><td style=\"color: #cccccc\">Malignant neoplasm of short bones of left lower limb</td></tr><tr><td>C40.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of bone and articular cartilage of limb</td></tr><tr><td>C40.80</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of bone and articular cartilage of unspecified limb</td></tr><tr><td>C40.81</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of bone and articular cartilage of right limb</td></tr><tr><td>C40.82</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of bone and articular cartilage of left limb</td></tr><tr><td>C40.9</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified bones and articular cartilage of limb</td></tr><tr><td>C40.90</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified bones and articular cartilage of unspecified limb</td></tr><tr><td>C40.91</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified bones and articular cartilage of right limb</td></tr><tr><td>C40.92</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified bones and articular cartilage of left limb</td></tr><tr><td>C41</td><td style=\"color: #cccccc\">Malignant neoplasm of bone and articular cartilage of other and unspecified sites</td></tr><tr><td>C41.0</td><td style=\"color: #cccccc\">Malignant neoplasm of bones of skull and face</td></tr><tr><td>C41.1</td><td style=\"color: #cccccc\">Malignant neoplasm of mandible</td></tr><tr><td>C41.2</td><td style=\"color: #cccccc\">Malignant neoplasm of vertebral column</td></tr><tr><td>C41.3</td><td style=\"color: #cccccc\">Malignant neoplasm of ribs, sternum and clavicle</td></tr><tr><td>C41.4</td><td style=\"color: #cccccc\">Malignant neoplasm of pelvic bones, sacrum and coccyx</td></tr><tr><td>C41.9</td><td style=\"color: #cccccc\">Malignant neoplasm of bone and articular cartilage, unspecified</td></tr><tr><td>C43</td><td style=\"color: #cccccc\">Malignant melanoma of skin</td></tr><tr><td>C43.0</td><td style=\"color: #cccccc\">Malignant melanoma of lip</td></tr><tr><td>C43.1</td><td style=\"color: #cccccc\">Malignant melanoma of eyelid, including canthus</td></tr><tr><td>C43.10</td><td style=\"color: #cccccc\">Malignant melanoma of unspecified eyelid, including canthus</td></tr><tr><td>C43.11</td><td style=\"color: #cccccc\">Malignant melanoma of right eyelid, including canthus</td></tr><tr><td>C43.111</td><td style=\"color: #cccccc\">Malignant melanoma of right upper eyelid, including canthus</td></tr><tr><td>C43.112</td><td style=\"color: #cccccc\">Malignant melanoma of right lower eyelid, including canthus</td></tr><tr><td>C43.12</td><td style=\"color: #cccccc\">Malignant melanoma of left eyelid, including canthus</td></tr><tr><td>C43.121</td><td style=\"color: #cccccc\">Malignant melanoma of left upper eyelid, including canthus</td></tr><tr><td>C43.122</td><td style=\"color: #cccccc\">Malignant melanoma of left lower eyelid, including canthus</td></tr><tr><td>C43.2</td><td style=\"color: #cccccc\">Malignant melanoma of ear and external auricular canal</td></tr><tr><td>C43.20</td><td style=\"color: #cccccc\">Malignant melanoma of unspecified ear and external auricular canal</td></tr><tr><td>C43.21</td><td style=\"color: #cccccc\">Malignant melanoma of right ear and external auricular canal</td></tr><tr><td>C43.22</td><td style=\"color: #cccccc\">Malignant melanoma of left ear and external auricular canal</td></tr><tr><td>C43.3</td><td style=\"color: #cccccc\">Malignant melanoma of other and unspecified parts of face</td></tr><tr><td>C43.30</td><td style=\"color: #cccccc\">Malignant melanoma of unspecified part of face</td></tr><tr><td>C43.31</td><td style=\"color: #cccccc\">Malignant melanoma of nose</td></tr><tr><td>C43.39</td><td style=\"color: #cccccc\">Malignant melanoma of other parts of face</td></tr><tr><td>C43.4</td><td style=\"color: #cccccc\">Malignant melanoma of scalp and neck</td></tr><tr><td>C43.5</td><td style=\"color: #cccccc\">Malignant melanoma of trunk</td></tr><tr><td>C43.51</td><td style=\"color: #cccccc\">Malignant melanoma of anal skin</td></tr><tr><td>C43.52</td><td style=\"color: #cccccc\">Malignant melanoma of skin of breast</td></tr><tr><td>C43.59</td><td style=\"color: #cccccc\">Malignant melanoma of other part of trunk</td></tr><tr><td>C43.6</td><td style=\"color: #cccccc\">Malignant melanoma of upper limb, including shoulder</td></tr><tr><td>C43.60</td><td style=\"color: #cccccc\">Malignant melanoma of unspecified upper limb, including shoulder</td></tr><tr><td>C43.61</td><td style=\"color: #cccccc\">Malignant melanoma of right upper limb, including shoulder</td></tr><tr><td>C43.62</td><td style=\"color: #cccccc\">Malignant melanoma of left upper limb, including shoulder</td></tr><tr><td>C43.7</td><td style=\"color: #cccccc\">Malignant melanoma of lower limb, including hip</td></tr><tr><td>C43.70</td><td style=\"color: #cccccc\">Malignant melanoma of unspecified lower limb, including hip</td></tr><tr><td>C43.71</td><td style=\"color: #cccccc\">Malignant melanoma of right lower limb, including hip</td></tr><tr><td>C43.72</td><td style=\"color: #cccccc\">Malignant melanoma of left lower limb, including hip</td></tr><tr><td>C43.8</td><td style=\"color: #cccccc\">Malignant melanoma of overlapping sites of skin</td></tr><tr><td>C43.9</td><td style=\"color: #cccccc\">Malignant melanoma of skin, unspecified</td></tr><tr><td>C44.13</td><td style=\"color: #cccccc\">Sebaceous cell carcinoma of skin of eyelid, including canthus</td></tr><tr><td>C44.131</td><td style=\"color: #cccccc\">Sebaceous cell carcinoma of skin of unspecified eyelid, including canthus</td></tr><tr><td>C44.132</td><td style=\"color: #cccccc\">Sebaceous cell carcinoma of skin of right eyelid, including canthus</td></tr><tr><td>C44.1321</td><td style=\"color: #cccccc\">Sebaceous cell carcinoma of skin of right upper eyelid, including canthus</td></tr><tr><td>C44.1322</td><td style=\"color: #cccccc\">Sebaceous cell carcinoma of skin of right lower eyelid, including canthus</td></tr><tr><td>C44.139</td><td style=\"color: #cccccc\">Sebaceous cell carcinoma of skin of left eyelid, including canthus</td></tr><tr><td>C44.1391</td><td style=\"color: #cccccc\">Sebaceous cell carcinoma of skin of left upper eyelid, including canthus</td></tr><tr><td>C44.1392</td><td style=\"color: #cccccc\">Sebaceous cell carcinoma of skin of left lower eyelid, including canthus</td></tr><tr><td>C44.90</td><td style=\"color: #cccccc\">Unspecified malignant neoplasm of skin, unspecified</td></tr><tr><td>C44.99</td><td style=\"color: #cccccc\">Other specified malignant neoplasm of skin, unspecified</td></tr><tr><td>C45</td><td style=\"color: #cccccc\">Mesothelioma</td></tr><tr><td>C45.0</td><td style=\"color: #cccccc\">Mesothelioma of pleura</td></tr><tr><td>C45.1</td><td style=\"color: #cccccc\">Mesothelioma of peritoneum</td></tr><tr><td>C45.2</td><td style=\"color: #cccccc\">Mesothelioma of pericardium</td></tr><tr><td>C45.7</td><td style=\"color: #cccccc\">Mesothelioma of other sites</td></tr><tr><td>C45.9</td><td style=\"color: #cccccc\">Mesothelioma, unspecified</td></tr><tr><td>C46</td><td style=\"color: #cccccc\">Kaposi's sarcoma</td></tr><tr><td>C46.0</td><td style=\"color: #cccccc\">Kaposi's sarcoma of skin</td></tr><tr><td>C46.1</td><td style=\"color: #cccccc\">Kaposi's sarcoma of soft tissue</td></tr><tr><td>C46.2</td><td style=\"color: #cccccc\">Kaposi's sarcoma of palate</td></tr><tr><td>C46.3</td><td style=\"color: #cccccc\">Kaposi's sarcoma of lymph nodes</td></tr><tr><td>C46.4</td><td style=\"color: #cccccc\">Kaposi's sarcoma of gastrointestinal sites</td></tr><tr><td>C46.5</td><td style=\"color: #cccccc\">Kaposi's sarcoma of lung</td></tr><tr><td>C46.50</td><td style=\"color: #cccccc\">Kaposi's sarcoma of unspecified lung</td></tr><tr><td>C46.51</td><td style=\"color: #cccccc\">Kaposi's sarcoma of right lung</td></tr><tr><td>C46.52</td><td style=\"color: #cccccc\">Kaposi's sarcoma of left lung</td></tr><tr><td>C46.7</td><td style=\"color: #cccccc\">Kaposi's sarcoma of other sites</td></tr><tr><td>C46.9</td><td style=\"color: #cccccc\">Kaposi's sarcoma, unspecified</td></tr><tr><td>C47</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves and autonomic nervous system</td></tr><tr><td>C47.0</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of head, face and neck</td></tr><tr><td>C47.1</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of upper limb, including shoulder</td></tr><tr><td>C47.10</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of unspecified upper limb, including shoulder</td></tr><tr><td>C47.11</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of right upper limb, including shoulder</td></tr><tr><td>C47.12</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of left upper limb, including shoulder</td></tr><tr><td>C47.2</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of lower limb, including hip</td></tr><tr><td>C47.20</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of unspecified lower limb, including hip</td></tr><tr><td>C47.21</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of right lower limb, including hip</td></tr><tr><td>C47.22</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of left lower limb, including hip</td></tr><tr><td>C47.3</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of thorax</td></tr><tr><td>C47.4</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of abdomen</td></tr><tr><td>C47.5</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of pelvis</td></tr><tr><td>C47.6</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves of trunk, unspecified</td></tr><tr><td>C47.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of peripheral nerves and autonomic nervous system</td></tr><tr><td>C47.9</td><td style=\"color: #cccccc\">Malignant neoplasm of peripheral nerves and autonomic nervous system, unspecified</td></tr><tr><td>C48</td><td style=\"color: #cccccc\">Malignant neoplasm of retroperitoneum and peritoneum</td></tr><tr><td>C48.0</td><td style=\"color: #cccccc\">Malignant neoplasm of retroperitoneum</td></tr><tr><td>C48.1</td><td style=\"color: #cccccc\">Malignant neoplasm of specified parts of peritoneum</td></tr><tr><td>C48.2</td><td style=\"color: #cccccc\">Malignant neoplasm of peritoneum, unspecified</td></tr><tr><td>C48.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of retroperitoneum and peritoneum</td></tr><tr><td>C49</td><td style=\"color: #cccccc\">Malignant neoplasm of other connective and soft tissue</td></tr><tr><td>C49.0</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of head, face and neck</td></tr><tr><td>C49.1</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of upper limb, including shoulder</td></tr><tr><td>C49.10</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of unspecified upper limb, including shoulder</td></tr><tr><td>C49.11</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of right upper limb, including shoulder</td></tr><tr><td>C49.12</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of left upper limb, including shoulder</td></tr><tr><td>C49.2</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of lower limb, including hip</td></tr><tr><td>C49.20</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of unspecified lower limb, including hip</td></tr><tr><td>C49.21</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of right lower limb, including hip</td></tr><tr><td>C49.22</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of left lower limb, including hip</td></tr><tr><td>C49.3</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of thorax</td></tr><tr><td>C49.4</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of abdomen</td></tr><tr><td>C49.5</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of pelvis</td></tr><tr><td>C49.6</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue of trunk, unspecified</td></tr><tr><td>C49.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of connective and soft tissue</td></tr><tr><td>C49.9</td><td style=\"color: #cccccc\">Malignant neoplasm of connective and soft tissue, unspecified</td></tr><tr><td>C49.A</td><td style=\"color: #cccccc\">Gastrointestinal stromal tumor</td></tr><tr><td>C49.A0</td><td style=\"color: #cccccc\">Gastrointestinal stromal tumor, unspecified site</td></tr><tr><td>C49.A1</td><td style=\"color: #cccccc\">Gastrointestinal stromal tumor of esophagus</td></tr><tr><td>C49.A2</td><td style=\"color: #cccccc\">Gastrointestinal stromal tumor of stomach</td></tr><tr><td>C49.A3</td><td style=\"color: #cccccc\">Gastrointestinal stromal tumor of small intestine</td></tr><tr><td>C49.A4</td><td style=\"color: #cccccc\">Gastrointestinal stromal tumor of large intestine</td></tr><tr><td>C49.A5</td><td style=\"color: #cccccc\">Gastrointestinal stromal tumor of rectum</td></tr><tr><td>C49.A9</td><td style=\"color: #cccccc\">Gastrointestinal stromal tumor of other sites</td></tr><tr><td>C4A</td><td style=\"color: #cccccc\">Merkel cell carcinoma</td></tr><tr><td>C4A.0</td><td style=\"color: #cccccc\">Merkel cell carcinoma of lip</td></tr><tr><td>C4A.1</td><td style=\"color: #cccccc\">Merkel cell carcinoma of eyelid, including canthus</td></tr><tr><td>C4A.10</td><td style=\"color: #cccccc\">Merkel cell carcinoma of unspecified eyelid, including canthus</td></tr><tr><td>C4A.11</td><td style=\"color: #cccccc\">Merkel cell carcinoma of right eyelid, including canthus</td></tr><tr><td>C4A.111</td><td style=\"color: #cccccc\">Merkel cell carcinoma of right upper eyelid, including canthus</td></tr><tr><td>C4A.112</td><td style=\"color: #cccccc\">Merkel cell carcinoma of right lower eyelid, including canthus</td></tr><tr><td>C4A.12</td><td style=\"color: #cccccc\">Merkel cell carcinoma of left eyelid, including canthus</td></tr><tr><td>C4A.121</td><td style=\"color: #cccccc\">Merkel cell carcinoma of left upper eyelid, including canthus</td></tr><tr><td>C4A.122</td><td style=\"color: #cccccc\">Merkel cell carcinoma of left lower eyelid, including canthus</td></tr><tr><td>C4A.2</td><td style=\"color: #cccccc\">Merkel cell carcinoma of ear and external auricular canal</td></tr><tr><td>C4A.20</td><td style=\"color: #cccccc\">Merkel cell carcinoma of unspecified ear and external auricular canal</td></tr><tr><td>C4A.21</td><td style=\"color: #cccccc\">Merkel cell carcinoma of right ear and external auricular canal</td></tr><tr><td>C4A.22</td><td style=\"color: #cccccc\">Merkel cell carcinoma of left ear and external auricular canal</td></tr><tr><td>C4A.3</td><td style=\"color: #cccccc\">Merkel cell carcinoma of other and unspecified parts of face</td></tr><tr><td>C4A.30</td><td style=\"color: #cccccc\">Merkel cell carcinoma of unspecified part of face</td></tr><tr><td>C4A.31</td><td style=\"color: #cccccc\">Merkel cell carcinoma of nose</td></tr><tr><td>C4A.39</td><td style=\"color: #cccccc\">Merkel cell carcinoma of other parts of face</td></tr><tr><td>C4A.4</td><td style=\"color: #cccccc\">Merkel cell carcinoma of scalp and neck</td></tr><tr><td>C4A.5</td><td style=\"color: #cccccc\">Merkel cell carcinoma of trunk</td></tr><tr><td>C4A.51</td><td style=\"color: #cccccc\">Merkel cell carcinoma of anal skin</td></tr><tr><td>C4A.52</td><td style=\"color: #cccccc\">Merkel cell carcinoma of skin of breast</td></tr><tr><td>C4A.59</td><td style=\"color: #cccccc\">Merkel cell carcinoma of other part of trunk</td></tr><tr><td>C4A.6</td><td style=\"color: #cccccc\">Merkel cell carcinoma of upper limb, including shoulder</td></tr><tr><td>C4A.60</td><td style=\"color: #cccccc\">Merkel cell carcinoma of unspecified upper limb, including shoulder</td></tr><tr><td>C4A.61</td><td style=\"color: #cccccc\">Merkel cell carcinoma of right upper limb, including shoulder</td></tr><tr><td>C4A.62</td><td style=\"color: #cccccc\">Merkel cell carcinoma of left upper limb, including shoulder</td></tr><tr><td>C4A.7</td><td style=\"color: #cccccc\">Merkel cell carcinoma of lower limb, including hip</td></tr><tr><td>C4A.70</td><td style=\"color: #cccccc\">Merkel cell carcinoma of unspecified lower limb, including hip</td></tr><tr><td>C4A.71</td><td style=\"color: #cccccc\">Merkel cell carcinoma of right lower limb, including hip</td></tr><tr><td>C4A.72</td><td style=\"color: #cccccc\">Merkel cell carcinoma of left lower limb, including hip</td></tr><tr><td>C4A.8</td><td style=\"color: #cccccc\">Merkel cell carcinoma of overlapping sites</td></tr><tr><td>C4A.9</td><td style=\"color: #cccccc\">Merkel cell carcinoma, unspecified</td></tr><tr><td>C50</td><td style=\"color: #cccccc\">Malignant neoplasm of breast</td></tr><tr><td>C50.0</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola</td></tr><tr><td>C50.01</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, female</td></tr><tr><td>C50.011</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, right female breast</td></tr><tr><td>C50.012</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, left female breast</td></tr><tr><td>C50.019</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, unspecified female breast</td></tr><tr><td>C50.02</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, male</td></tr><tr><td>C50.021</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, right male breast</td></tr><tr><td>C50.022</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, left male breast</td></tr><tr><td>C50.029</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, unspecified male breast</td></tr><tr><td>C50.1</td><td style=\"color: #cccccc\">Malignant neoplasm of central portion of breast</td></tr><tr><td>C50.11</td><td style=\"color: #cccccc\">Malignant neoplasm of central portion of breast, female</td></tr><tr><td>C50.111</td><td style=\"color: #cccccc\">Malignant neoplasm of central portion of right female breast</td></tr><tr><td>C50.112</td><td style=\"color: #cccccc\">Malignant neoplasm of central portion of left female breast</td></tr><tr><td>C50.119</td><td style=\"color: #cccccc\">Malignant neoplasm of central portion of unspecified female breast</td></tr><tr><td>C50.02</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, male</td></tr><tr><td>C50.021</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, right male breast</td></tr><tr><td>C50.022</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, left male breast</td></tr><tr><td>C50.029</td><td style=\"color: #cccccc\">Malignant neoplasm of nipple and areola, unspecified male breast</td></tr><tr><td>C50.2</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-inner quadrant of breast</td></tr><tr><td>C50.21</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-inner quadrant of breast, female</td></tr><tr><td>C50.211</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-inner quadrant of right female breast</td></tr><tr><td>C50.212</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-inner quadrant of left female breast</td></tr><tr><td>C50.219</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-inner quadrant of unspecified female breast</td></tr><tr><td>C50.22</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-inner quadrant of breast, male</td></tr><tr><td>C50.221</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-inner quadrant of right male breast</td></tr><tr><td>C50.222</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-inner quadrant of left male breast</td></tr><tr><td>C50.229</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-inner quadrant of unspecified male breast</td></tr><tr><td>C50.3</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-inner quadrant of breast</td></tr><tr><td>C50.31</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-inner quadrant of breast, female</td></tr><tr><td>C50.311</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-inner quadrant of right female breast</td></tr><tr><td>C50.312</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-inner quadrant of left female breast</td></tr><tr><td>C50.319</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-inner quadrant of unspecified female breast</td></tr><tr><td>C50.32</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-inner quadrant of breast, male</td></tr><tr><td>C50.321</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-inner quadrant of right male breast</td></tr><tr><td>C50.322</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-inner quadrant of left male breast</td></tr><tr><td>C50.329</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-inner quadrant of unspecified male breast</td></tr><tr><td>C50.4</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-outer quadrant of breast</td></tr><tr><td>C50.41</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-outer quadrant of breast, female</td></tr><tr><td>C50.411</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-outer quadrant of right female breast</td></tr><tr><td>C50.412</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-outer quadrant of left female breast</td></tr><tr><td>C50.419</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-outer quadrant of unspecified female breast</td></tr><tr><td>C50.42</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-outer quadrant of breast, male</td></tr><tr><td>C50.421</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-outer quadrant of right male breast</td></tr><tr><td>C50.422</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-outer quadrant of left male breast</td></tr><tr><td>C50.429</td><td style=\"color: #cccccc\">Malignant neoplasm of upper-outer quadrant of unspecified male breast</td></tr><tr><td>C50.5</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-outer quadrant of breast</td></tr><tr><td>C50.51</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-outer quadrant of breast, female</td></tr><tr><td>C50.511</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-outer quadrant of right female breast</td></tr><tr><td>C50.512</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-outer quadrant of left female breast</td></tr><tr><td>C50.519</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-outer quadrant of unspecified female breast</td></tr><tr><td>C50.52</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-outer quadrant of breast, male</td></tr><tr><td>C50.521</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-outer quadrant of right male breast</td></tr><tr><td>C50.529</td><td style=\"color: #cccccc\">Malignant neoplasm of lower-outer quadrant of unspecified male breast</td></tr><tr><td>C50.6</td><td style=\"color: #cccccc\">Malignant neoplasm of axillary tail of breast</td></tr><tr><td>C50.61</td><td style=\"color: #cccccc\">Malignant neoplasm of axillary tail of breast, female</td></tr><tr><td>C50.611</td><td style=\"color: #cccccc\">Malignant neoplasm of axillary tail of right female breast</td></tr><tr><td>C50.612</td><td style=\"color: #cccccc\">Malignant neoplasm of axillary tail of left female breast</td></tr><tr><td>C50.619</td><td style=\"color: #cccccc\">Malignant neoplasm of axillary tail of unspecified female breast</td></tr><tr><td>C50.62</td><td style=\"color: #cccccc\">Malignant neoplasm of axillary tail of breast, male</td></tr><tr><td>C50.621</td><td style=\"color: #cccccc\">Malignant neoplasm of axillary tail of right male breast</td></tr><tr><td>C50.622</td><td style=\"color: #cccccc\">Malignant neoplasm of axillary tail of left male breast</td></tr><tr><td>C50.629</td><td style=\"color: #cccccc\">Malignant neoplasm of axillary tail of unspecified male breast</td></tr><tr><td>C50.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of breast</td></tr><tr><td>C50.81</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of breast, female</td></tr><tr><td>C50.811</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of right female breast</td></tr><tr><td>C50.812</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of left female breast</td></tr><tr><td>C50.819</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of unspecified female breast</td></tr><tr><td>C50.82</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of breast, male</td></tr><tr><td>C50.821</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of right male breast</td></tr><tr><td>C50.822</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of left male breast</td></tr><tr><td>C50.829</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of unspecified male breast</td></tr><tr><td>C50.9</td><td style=\"color: #cccccc\">Malignant neoplasm of breast of unspecified site</td></tr><tr><td>C50.91</td><td style=\"color: #cccccc\">Malignant neoplasm of breast of unspecified site, female</td></tr><tr><td>C50.911</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of right female breast</td></tr><tr><td>C50.912</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of left female breast</td></tr><tr><td>C50.919</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of unspecified female breast</td></tr><tr><td>C50.92</td><td style=\"color: #cccccc\">Malignant neoplasm of breast of unspecified site, male</td></tr><tr><td>C50.921</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of right male breast</td></tr><tr><td>C50.922</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of left male breast</td></tr><tr><td>C50.929</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of unspecified male breast</td></tr><tr><td>C51</td><td style=\"color: #cccccc\">Malignant neoplasm of vulva</td></tr><tr><td>C51.0</td><td style=\"color: #cccccc\">Malignant neoplasm of labium majus</td></tr><tr><td>C51.1</td><td style=\"color: #cccccc\">Malignant neoplasm of labium minus</td></tr><tr><td>C51.2</td><td style=\"color: #cccccc\">Malignant neoplasm of clitoris</td></tr><tr><td>C51.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of vulva</td></tr><tr><td>C51.9</td><td style=\"color: #cccccc\">Malignant neoplasm of vulva, unspecified</td></tr><tr><td>C52</td><td style=\"color: #cccccc\">Malignant neoplasm of vagina</td></tr><tr><td>C53</td><td style=\"color: #cccccc\">Malignant neoplasm of cervix uteri</td></tr><tr><td>C53.0</td><td style=\"color: #cccccc\">Malignant neoplasm of endocervix</td></tr><tr><td>C53.1</td><td style=\"color: #cccccc\">Malignant neoplasm of exocervix</td></tr><tr><td>C53.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of cervix uteri</td></tr><tr><td>C53.9</td><td style=\"color: #cccccc\">Malignant neoplasm of cervix uteri, unspecified</td></tr><tr><td>C54</td><td style=\"color: #cccccc\">Malignant neoplasm of corpus uteri</td></tr><tr><td>C54.0</td><td style=\"color: #cccccc\">Malignant neoplasm of isthmus uteri</td></tr><tr><td>C54.1</td><td style=\"color: #cccccc\">Malignant neoplasm of endometrium</td></tr><tr><td>C54.2</td><td style=\"color: #cccccc\">Malignant neoplasm of myometrium</td></tr><tr><td>C54.3</td><td style=\"color: #cccccc\">Malignant neoplasm of fundus uteri</td></tr><tr><td>C54.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of corpus uteri</td></tr><tr><td>C54.9</td><td style=\"color: #cccccc\">Malignant neoplasm of corpus uteri, unspecified</td></tr><tr><td>C55</td><td style=\"color: #cccccc\">Malignant neoplasm of uterus, part unspecified</td></tr><tr><td>C56</td><td style=\"color: #cccccc\">Malignant neoplasm of ovary</td></tr><tr><td>C56.1</td><td style=\"color: #cccccc\">Malignant neoplasm of right ovary</td></tr><tr><td>C56.2</td><td style=\"color: #cccccc\">Malignant neoplasm of left ovary</td></tr><tr><td>C56.9</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified ovary</td></tr><tr><td>C57</td><td style=\"color: #cccccc\">Malignant neoplasm of other and unspecified female genital organs</td></tr><tr><td>C57.0</td><td style=\"color: #cccccc\">Malignant neoplasm of fallopian tube</td></tr><tr><td>C57.00</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified fallopian tube</td></tr><tr><td>C57.01</td><td style=\"color: #cccccc\">Malignant neoplasm of right fallopian tube</td></tr><tr><td>C57.02</td><td style=\"color: #cccccc\">Malignant neoplasm of left fallopian tube</td></tr><tr><td>C57.1</td><td style=\"color: #cccccc\">Malignant neoplasm of broad ligament</td></tr><tr><td>C57.10</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified broad ligament</td></tr><tr><td>C57.11</td><td style=\"color: #cccccc\">Malignant neoplasm of right broad ligament</td></tr><tr><td>C57.12</td><td style=\"color: #cccccc\">Malignant neoplasm of left broad ligament</td></tr><tr><td>C57.2</td><td style=\"color: #cccccc\">Malignant neoplasm of round ligament</td></tr><tr><td>C57.20</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified round ligament</td></tr><tr><td>C57.21</td><td style=\"color: #cccccc\">Malignant neoplasm of right round ligament</td></tr><tr><td>C57.22</td><td style=\"color: #cccccc\">Malignant neoplasm of left round ligament</td></tr><tr><td>C57.3</td><td style=\"color: #cccccc\">Malignant neoplasm of parametrium</td></tr><tr><td>C57.4</td><td style=\"color: #cccccc\">Malignant neoplasm of uterine adnexa, unspecified</td></tr><tr><td>C57.7</td><td style=\"color: #cccccc\">Malignant neoplasm of other specified female genital organs</td></tr><tr><td>C57.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of female genital organs</td></tr><tr><td>C57.9</td><td style=\"color: #cccccc\">Malignant neoplasm of female genital organ, unspecified</td></tr><tr><td>C58</td><td style=\"color: #cccccc\">Malignant neoplasm of placenta</td></tr><tr><td>C60</td><td style=\"color: #cccccc\">Malignant neoplasm of penis</td></tr><tr><td>C60.0</td><td style=\"color: #cccccc\">Malignant neoplasm of prepuce</td></tr><tr><td>C60.1</td><td style=\"color: #cccccc\">Malignant neoplasm of glans penis</td></tr><tr><td>C60.2</td><td style=\"color: #cccccc\">Malignant neoplasm of body of penis</td></tr><tr><td>C60.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of penis</td></tr><tr><td>C60.9</td><td style=\"color: #cccccc\">Malignant neoplasm of penis, unspecified</td></tr><tr><td>C61</td><td style=\"color: #cccccc\">Malignant neoplasm of prostate</td></tr><tr><td>C62</td><td style=\"color: #cccccc\">Malignant neoplasm of testis</td></tr><tr><td>C62.0</td><td style=\"color: #cccccc\">Malignant neoplasm of undescended testis</td></tr><tr><td>C62.00</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified undescended testis</td></tr><tr><td>C62.01</td><td style=\"color: #cccccc\">Malignant neoplasm of undescended right testis</td></tr><tr><td>C62.02</td><td style=\"color: #cccccc\">Malignant neoplasm of undescended left testis</td></tr><tr><td>C62.1</td><td style=\"color: #cccccc\">Malignant neoplasm of descended testis</td></tr><tr><td>C62.10</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified descended testis</td></tr><tr><td>C62.11</td><td style=\"color: #cccccc\">Malignant neoplasm of descended right testis</td></tr><tr><td>C62.12</td><td style=\"color: #cccccc\">Malignant neoplasm of descended left testis</td></tr><tr><td>C62.9</td><td style=\"color: #cccccc\">Malignant neoplasm of testis, unspecified whether descended or undescended</td></tr><tr><td>C62.90</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified testis, unspecified whether descended or undescended</td></tr><tr><td>C62.91</td><td style=\"color: #cccccc\">Malignant neoplasm of right testis, unspecified whether descended or undescended</td></tr><tr><td>C62.92</td><td style=\"color: #cccccc\">Malignant neoplasm of left testis, unspecified whether descended or undescended</td></tr><tr><td>C63</td><td style=\"color: #cccccc\">Malignant neoplasm of other and unspecified male genital organs</td></tr><tr><td>C63.00</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified epididymis</td></tr><tr><td>C63.01</td><td style=\"color: #cccccc\">Malignant neoplasm of right epididymis</td></tr><tr><td>C63.02</td><td style=\"color: #cccccc\">Malignant neoplasm of left epididymis</td></tr><tr><td>C63.1</td><td style=\"color: #cccccc\">Malignant neoplasm of spermatic cord</td></tr><tr><td>C63.10</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified spermatic cord</td></tr><tr><td>C63.11</td><td style=\"color: #cccccc\">Malignant neoplasm of right spermatic cord</td></tr><tr><td>C63.12</td><td style=\"color: #cccccc\">Malignant neoplasm of left spermatic cord</td></tr><tr><td>C63.2</td><td style=\"color: #cccccc\">Malignant neoplasm of scrotum</td></tr><tr><td>C63.7</td><td style=\"color: #cccccc\">Malignant neoplasm of other specified male genital organs</td></tr><tr><td>C63.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of male genital organs</td></tr><tr><td>C63.9</td><td style=\"color: #cccccc\">Malignant neoplasm of male genital organ, unspecified</td></tr><tr><td>C64</td><td style=\"color: #cccccc\">Malignant neoplasm of kidney, except renal pelvis</td></tr><tr><td>C64.1</td><td style=\"color: #cccccc\">Malignant neoplasm of right kidney, except renal pelvis</td></tr><tr><td>C64.2</td><td style=\"color: #cccccc\">Malignant neoplasm of left kidney, except renal pelvis</td></tr><tr><td>C64.9</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified kidney, except renal pelvis</td></tr><tr><td>C65</td><td style=\"color: #cccccc\">Malignant neoplasm of renal pelvis</td></tr><tr><td>C65.1</td><td style=\"color: #cccccc\">Malignant neoplasm of right renal pelvis</td></tr><tr><td>C65.2</td><td style=\"color: #cccccc\">Malignant neoplasm of left renal pelvis</td></tr><tr><td>C65.9</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified renal pelvis</td></tr><tr><td>C66</td><td style=\"color: #cccccc\">Malignant neoplasm of ureter</td></tr><tr><td>C66.1</td><td style=\"color: #cccccc\">Malignant neoplasm of right ureter</td></tr><tr><td>C66.2</td><td style=\"color: #cccccc\">Malignant neoplasm of left ureter</td></tr><tr><td>C66.9</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified ureter</td></tr><tr><td>C67</td><td style=\"color: #cccccc\">Malignant neoplasm of bladder</td></tr><tr><td>C67.0</td><td style=\"color: #cccccc\">Malignant neoplasm of trigone of bladder</td></tr><tr><td>C67.1</td><td style=\"color: #cccccc\">Malignant neoplasm of dome of bladder</td></tr><tr><td>C67.2</td><td style=\"color: #cccccc\">Malignant neoplasm of lateral wall of bladder</td></tr><tr><td>C67.3</td><td style=\"color: #cccccc\">Malignant neoplasm of anterior wall of bladder</td></tr><tr><td>C67.4</td><td style=\"color: #cccccc\">Malignant neoplasm of posterior wall of bladder</td></tr><tr><td>C67.5</td><td style=\"color: #cccccc\">Malignant neoplasm of bladder neck</td></tr><tr><td>C67.6</td><td style=\"color: #cccccc\">Malignant neoplasm of ureteric orifice</td></tr><tr><td>C67.7</td><td style=\"color: #cccccc\">Malignant neoplasm of urachus</td></tr><tr><td>C67.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of bladder</td></tr><tr><td>C67.9</td><td style=\"color: #cccccc\">Malignant neoplasm of bladder, unspecified</td></tr><tr><td>C68</td><td style=\"color: #cccccc\">Malignant neoplasm of other and unspecified urinary organs</td></tr><tr><td>C68.0</td><td style=\"color: #cccccc\">Malignant neoplasm of urethra</td></tr><tr><td>C68.1</td><td style=\"color: #cccccc\">Malignant neoplasm of paraurethral glands</td></tr><tr><td>C68.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of urinary organs</td></tr><tr><td>C68.9</td><td style=\"color: #cccccc\">Malignant neoplasm of urinary organ, unspecified</td></tr><tr><td>C69</td><td style=\"color: #cccccc\">Malignant neoplasm of eye and adnexa</td></tr><tr><td>C69.0</td><td style=\"color: #cccccc\">Malignant neoplasm of conjunctiva</td></tr><tr><td>C69.00</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified conjunctiva</td></tr><tr><td>C69.01</td><td style=\"color: #cccccc\">Malignant neoplasm of right conjunctiva</td></tr><tr><td>C69.02</td><td style=\"color: #cccccc\">Malignant neoplasm of left conjunctiva</td></tr><tr><td>C69.1</td><td style=\"color: #cccccc\">Malignant neoplasm of cornea</td></tr><tr><td>C69.10</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified cornea</td></tr><tr><td>C69.11</td><td style=\"color: #cccccc\">Malignant neoplasm of right cornea</td></tr><tr><td>C69.12</td><td style=\"color: #cccccc\">Malignant neoplasm of left cornea</td></tr><tr><td>C69.2</td><td style=\"color: #cccccc\">Malignant neoplasm of retina</td></tr><tr><td>C69.20</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified retina</td></tr><tr><td>C69.21</td><td style=\"color: #cccccc\">Malignant neoplasm of right retina</td></tr><tr><td>C69.22</td><td style=\"color: #cccccc\">Malignant neoplasm of left retina</td></tr><tr><td>C69.3</td><td style=\"color: #cccccc\">Malignant neoplasm of choroid</td></tr><tr><td>C69.30</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified choroid</td></tr><tr><td>C69.31</td><td style=\"color: #cccccc\">Malignant neoplasm of right choroid</td></tr><tr><td>C69.32</td><td style=\"color: #cccccc\">Malignant neoplasm of left choroid</td></tr><tr><td>C69.4</td><td style=\"color: #cccccc\">Malignant neoplasm of ciliary body</td></tr><tr><td>C69.40</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified ciliary body</td></tr><tr><td>C69.41</td><td style=\"color: #cccccc\">Malignant neoplasm of right ciliary body</td></tr><tr><td>C69.42</td><td style=\"color: #cccccc\">Malignant neoplasm of left ciliary body</td></tr><tr><td>C69.5</td><td style=\"color: #cccccc\">Malignant neoplasm of lacrimal gland and duct</td></tr><tr><td>C69.50</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified lacrimal gland and duct</td></tr><tr><td>C69.51</td><td style=\"color: #cccccc\">Malignant neoplasm of right lacrimal gland and duct</td></tr><tr><td>C69.52</td><td style=\"color: #cccccc\">Malignant neoplasm of left lacrimal gland and duct</td></tr><tr><td>C69.6</td><td style=\"color: #cccccc\">Malignant neoplasm of orbit</td></tr><tr><td>C69.60</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified orbit</td></tr><tr><td>C69.61</td><td style=\"color: #cccccc\">Malignant neoplasm of right orbit</td></tr><tr><td>C69.62</td><td style=\"color: #cccccc\">Malignant neoplasm of left orbit</td></tr><tr><td>C69.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of eye and adnexa</td></tr><tr><td>C69.80</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of unspecified eye and adnexa</td></tr><tr><td>C69.81</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of right eye and adnexa</td></tr><tr><td>C69.82</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of left eye and adnexa</td></tr><tr><td>C69.9</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of eye</td></tr><tr><td>C69.90</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of unspecified eye</td></tr><tr><td>C69.91</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of right eye</td></tr><tr><td>C69.92</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified site of left eye</td></tr><tr><td>C70</td><td style=\"color: #cccccc\">Malignant neoplasm of meninges</td></tr><tr><td>C70.0</td><td style=\"color: #cccccc\">Malignant neoplasm of cerebral meninges</td></tr><tr><td>C70.1</td><td style=\"color: #cccccc\">Malignant neoplasm of spinal meninges</td></tr><tr><td>C70.9</td><td style=\"color: #cccccc\">Malignant neoplasm of meninges, unspecified</td></tr><tr><td>C71</td><td style=\"color: #cccccc\">Malignant neoplasm of brain</td></tr><tr><td>C71.0</td><td style=\"color: #cccccc\">Malignant neoplasm of cerebrum, except lobes and ventricles</td></tr><tr><td>C71.1</td><td style=\"color: #cccccc\">Malignant neoplasm of frontal lobe</td></tr><tr><td>C71.2</td><td style=\"color: #cccccc\">Malignant neoplasm of temporal lobe</td></tr><tr><td>C71.3</td><td style=\"color: #cccccc\">Malignant neoplasm of parietal lobe</td></tr><tr><td>C71.4</td><td style=\"color: #cccccc\">Malignant neoplasm of occipital lobe</td></tr><tr><td>C71.5</td><td style=\"color: #cccccc\">Malignant neoplasm of cerebral ventricle</td></tr><tr><td>C71.6</td><td style=\"color: #cccccc\">Malignant neoplasm of cerebellum</td></tr><tr><td>C71.7</td><td style=\"color: #cccccc\">Malignant neoplasm of brain stem</td></tr><tr><td>C71.8</td><td style=\"color: #cccccc\">Malignant neoplasm of overlapping sites of brain</td></tr><tr><td>C71.9</td><td style=\"color: #cccccc\">Malignant neoplasm of brain, unspecified</td></tr><tr><td>C72</td><td style=\"color: #cccccc\">Malignant neoplasm of spinal cord, cranial nerves and other parts of central nervous system</td></tr><tr><td>C72.0</td><td style=\"color: #cccccc\">Malignant neoplasm of spinal cord</td></tr><tr><td>C72.1</td><td style=\"color: #cccccc\">Malignant neoplasm of cauda equina</td></tr><tr><td>C72.2</td><td style=\"color: #cccccc\">Malignant neoplasm of olfactory nerve</td></tr><tr><td>C72.20</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified olfactory nerve</td></tr><tr><td>C72.21</td><td style=\"color: #cccccc\">Malignant neoplasm of right olfactory nerve</td></tr><tr><td>C72.22</td><td style=\"color: #cccccc\">Malignant neoplasm of left olfactory nerve</td></tr><tr><td>C72.3</td><td style=\"color: #cccccc\">Malignant neoplasm of optic nerve</td></tr><tr><td>C72.30</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified optic nerve</td></tr><tr><td>C72.31</td><td style=\"color: #cccccc\">Malignant neoplasm of right optic nerve</td></tr><tr><td>C72.32</td><td style=\"color: #cccccc\">Malignant neoplasm of left optic nerve</td></tr><tr><td>C72.4</td><td style=\"color: #cccccc\">Malignant neoplasm of acoustic nerve</td></tr><tr><td>C72.40</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified acoustic nerve</td></tr><tr><td>C72.41</td><td style=\"color: #cccccc\">Malignant neoplasm of right acoustic nerve</td></tr><tr><td>C72.42</td><td style=\"color: #cccccc\">Malignant neoplasm of left acoustic nerve</td></tr><tr><td>C72.5</td><td style=\"color: #cccccc\">Malignant neoplasm of other and unspecified cranial nerves</td></tr><tr><td>C72.50</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified cranial nerve</td></tr><tr><td>C72.59</td><td style=\"color: #cccccc\">Malignant neoplasm of other cranial nerves</td></tr><tr><td>C72.9</td><td style=\"color: #cccccc\">Malignant neoplasm of central nervous system, unspecified</td></tr><tr><td>C73</td><td style=\"color: #cccccc\">Malignant neoplasm of thyroid gland</td></tr><tr><td>C74</td><td style=\"color: #cccccc\">Malignant neoplasm of adrenal gland</td></tr><tr><td>C74.0</td><td style=\"color: #cccccc\">Malignant neoplasm of cortex of adrenal gland</td></tr><tr><td>C74.00</td><td style=\"color: #cccccc\">Malignant neoplasm of cortex of unspecified adrenal gland</td></tr><tr><td>C74.01</td><td style=\"color: #cccccc\">Malignant neoplasm of cortex of right adrenal gland</td></tr><tr><td>C74.02</td><td style=\"color: #cccccc\">Malignant neoplasm of cortex of left adrenal gland</td></tr><tr><td>C74.1</td><td style=\"color: #cccccc\">Malignant neoplasm of medulla of adrenal gland</td></tr><tr><td>C74.10</td><td style=\"color: #cccccc\">Malignant neoplasm of medulla of unspecified adrenal gland</td></tr><tr><td>C74.11</td><td style=\"color: #cccccc\">Malignant neoplasm of medulla of right adrenal gland</td></tr><tr><td>C74.12</td><td style=\"color: #cccccc\">Malignant neoplasm of medulla of left adrenal gland</td></tr><tr><td>C74.9</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified part of adrenal gland</td></tr><tr><td>C74.90</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified part of unspecified adrenal gland</td></tr><tr><td>C74.91</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified part of right adrenal gland</td></tr><tr><td>C74.92</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified part of left adrenal gland</td></tr><tr><td>C75</td><td style=\"color: #cccccc\">Malignant neoplasm of other endocrine glands and related structures</td></tr><tr><td>C75.0</td><td style=\"color: #cccccc\">Malignant neoplasm of parathyroid gland</td></tr><tr><td>C75.1</td><td style=\"color: #cccccc\">Malignant neoplasm of pituitary gland</td></tr><tr><td>C75.2</td><td style=\"color: #cccccc\">Malignant neoplasm of craniopharyngeal duct</td></tr><tr><td>C75.3</td><td style=\"color: #cccccc\">Malignant neoplasm of pineal gland</td></tr><tr><td>C75.4</td><td style=\"color: #cccccc\">Malignant neoplasm of carotid body</td></tr><tr><td>C75.5</td><td style=\"color: #cccccc\">Malignant neoplasm of aortic body and other paraganglia</td></tr><tr><td>C75.8</td><td style=\"color: #cccccc\">Malignant neoplasm with pluriglandular involvement, unspecified</td></tr><tr><td>C75.9</td><td style=\"color: #cccccc\">Malignant neoplasm of endocrine gland, unspecified</td></tr><tr><td>C76</td><td style=\"color: #cccccc\">Malignant neoplasm of other and ill-defined sites</td></tr><tr><td>C76.0</td><td style=\"color: #cccccc\">Malignant neoplasm of head, face and neck</td></tr><tr><td>C76.1</td><td style=\"color: #cccccc\">Malignant neoplasm of thorax</td></tr><tr><td>C76.2</td><td style=\"color: #cccccc\">Malignant neoplasm of abdomen</td></tr><tr><td>C76.3</td><td style=\"color: #cccccc\">Malignant neoplasm of pelvis</td></tr><tr><td>C76.4</td><td style=\"color: #cccccc\">Malignant neoplasm of upper limb</td></tr><tr><td>C76.40</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified upper limb</td></tr><tr><td>C76.41</td><td style=\"color: #cccccc\">Malignant neoplasm of right upper limb</td></tr><tr><td>C76.42</td><td style=\"color: #cccccc\">Malignant neoplasm of left upper limb</td></tr><tr><td>C76.5</td><td style=\"color: #cccccc\">Malignant neoplasm of lower limb</td></tr><tr><td>C76.50</td><td style=\"color: #cccccc\">Malignant neoplasm of unspecified lower limb</td></tr><tr><td>C76.51</td><td style=\"color: #cccccc\">Malignant neoplasm of right lower limb</td></tr><tr><td>C76.52</td><td style=\"color: #cccccc\">Malignant neoplasm of left lower limb</td></tr><tr><td>C76.8</td><td style=\"color: #cccccc\">Malignant neoplasm of other specified ill-defined sites</td></tr><tr><td>C77</td><td style=\"color: #cccccc\">Secondary and unspecified malignant neoplasm of lymph nodes</td></tr><tr><td>C77.0</td><td style=\"color: #cccccc\">Secondary and unspecified malignant neoplasm of lymph nodes of head, face and neck</td></tr><tr><td>C77.1</td><td style=\"color: #cccccc\">Secondary and unspecified malignant neoplasm of intrathoracic lymph nodes</td></tr><tr><td>C77.2</td><td style=\"color: #cccccc\">Secondary and unspecified malignant neoplasm of intra-abdominal lymph nodes</td></tr><tr><td>C77.3</td><td style=\"color: #cccccc\">Secondary and unspecified malignant neoplasm of axilla and upper limb lymph nodes</td></tr><tr><td>C77.4</td><td style=\"color: #cccccc\">Secondary and unspecified malignant neoplasm of inguinal and lower limb lymph nodes</td></tr><tr><td>C77.5</td><td style=\"color: #cccccc\">Secondary and unspecified malignant neoplasm of intrapelvic lymph nodes</td></tr><tr><td>C77.8</td><td style=\"color: #cccccc\">Secondary and unspecified malignant neoplasm of lymph nodes of multiple regions</td></tr><tr><td>C77.9</td><td style=\"color: #cccccc\">Secondary and unspecified malignant neoplasm of lymph node, unspecified</td></tr><tr><td>C78</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of respiratory and digestive organs</td></tr><tr><td>C78.0</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of lung</td></tr><tr><td>C78.00</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of unspecified lung</td></tr><tr><td>C78.01</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of right lung</td></tr><tr><td>C78.02</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of left lung</td></tr><tr><td>C78.1</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of mediastinum</td></tr><tr><td>C78.2</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of pleura</td></tr><tr><td>C78.3</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other and unspecified respiratory organs</td></tr><tr><td>C78.30</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of unspecified respiratory organ</td></tr><tr><td>C78.39</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other respiratory organs</td></tr><tr><td>C78.4</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of small intestine</td></tr><tr><td>C78.5</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of large intestine and rectum</td></tr><tr><td>C78.6</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of retroperitoneum and peritoneum</td></tr><tr><td>C78.7</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of liver and intrahepatic bile duct</td></tr><tr><td>C78.8</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other and unspecified digestive organs</td></tr><tr><td>C78.80</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of unspecified digestive organ</td></tr><tr><td>C78.89</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other digestive organs</td></tr><tr><td>C79</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other and unspecified sites</td></tr><tr><td>C79.0</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of kidney and renal pelvis</td></tr><tr><td>C79.00</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of unspecified kidney and renal pelvis</td></tr><tr><td>C79.01</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of right kidney and renal pelvis</td></tr><tr><td>C79.02</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of left kidney and renal pelvis</td></tr><tr><td>C79.1</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of bladder and other and unspecified urinary organs</td></tr><tr><td>C79.10</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of unspecified urinary organs</td></tr><tr><td>C79.11</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of bladder</td></tr><tr><td>C79.19</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other urinary organs</td></tr><tr><td>C79.2</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of skin</td></tr><tr><td>C79.3</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of brain and cerebral meninges</td></tr><tr><td>C79.31</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of brain</td></tr><tr><td>C79.32</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of cerebral meninges</td></tr><tr><td>C79.4</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other and unspecified parts of nervous system</td></tr><tr><td>C79.40</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of unspecified part of nervous system</td></tr><tr><td>C79.49</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other parts of nervous system</td></tr><tr><td>C79.5</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of bone and bone marrow</td></tr><tr><td>C79.51</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of bone</td></tr><tr><td>C79.52</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of bone marrow</td></tr><tr><td>C79.6</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of ovary</td></tr><tr><td>C79.61</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of right ovary</td></tr><tr><td>C79.62</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of left ovary</td></tr><tr><td>C79.7</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of adrenal gland</td></tr><tr><td>C79.71</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of right adrenal gland</td></tr><tr><td>C79.72</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of left adrenal gland</td></tr><tr><td>C79.8</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other specified sites</td></tr><tr><td>C79.81</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of breast</td></tr><tr><td>C79.82</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of genital organs</td></tr><tr><td>C79.89</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of other specified sites</td></tr><tr><td>C79.9</td><td style=\"color: #cccccc\">Secondary malignant neoplasm of unspecified site</td></tr><tr><td>C7A</td><td style=\"color: #cccccc\">Malignant neuroendocrine tumors</td></tr><tr><td>C7A.0</td><td style=\"color: #cccccc\">Malignant carcinoid tumors</td></tr><tr><td>C7A.00</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of unspecified site</td></tr><tr><td>C7A.01</td><td style=\"color: #cccccc\">Malignant carcinoid tumors of the small intestine</td></tr><tr><td>C7A.010</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the duodenum</td></tr><tr><td>C7A.011</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the jejunum</td></tr><tr><td>C7A.012</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the ileum</td></tr><tr><td>C7A.019</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the small intestine, unspecified portion</td></tr><tr><td>C7A.02</td><td style=\"color: #cccccc\">Malignant carcinoid tumors of the appendix, large intestine, and rectum</td></tr><tr><td>C7A.020</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the appendix</td></tr><tr><td>C7A.021</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the cecum</td></tr><tr><td>C7A.022</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the ascending colon</td></tr><tr><td>C7A.023</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the transverse colon</td></tr><tr><td>C7A.024</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the descending colon</td></tr><tr><td>C7A.025</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the sigmoid colon</td></tr><tr><td>C7A.026</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the rectum</td></tr><tr><td>C7A.029</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the large intestine, unspecified portion</td></tr><tr><td>C7A.09</td><td style=\"color: #cccccc\">Malignant carcinoid tumors of other sites</td></tr><tr><td>C7A.090</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the bronchus and lung</td></tr><tr><td>C7A.091</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the thymus</td></tr><tr><td>C7A.092</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the stomach</td></tr><tr><td>C7A.093</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the kidney</td></tr><tr><td>C7A.094</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the foregut, unspecified</td></tr><tr><td>C7A.095</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the midgut, unspecified</td></tr><tr><td>C7A.096</td><td style=\"color: #cccccc\">Malignant carcinoid tumor of the hindgut, unspecified</td></tr><tr><td>C7A.098</td><td style=\"color: #cccccc\">Malignant carcinoid tumors of other sites</td></tr><tr><td>C7A.1</td><td style=\"color: #cccccc\">Malignant poorly differentiated neuroendocrine tumors</td></tr><tr><td>C7A.8</td><td style=\"color: #cccccc\">Other malignant neuroendocrine tumors</td></tr><tr><td>C7B</td><td style=\"color: #cccccc\">Secondary neuroendocrine tumors</td></tr><tr><td>C7B.0</td><td style=\"color: #cccccc\">Secondary carcinoid tumors</td></tr><tr><td>C7B.00</td><td style=\"color: #cccccc\">Secondary carcinoid tumors, unspecified site</td></tr><tr><td>C7B.01</td><td style=\"color: #cccccc\">Secondary carcinoid tumors of distant lymph nodes</td></tr><tr><td>C7B.02</td><td style=\"color: #cccccc\">Secondary carcinoid tumors of liver</td></tr><tr><td>C7B.03</td><td style=\"color: #cccccc\">Secondary carcinoid tumors of bone</td></tr><tr><td>C7B.04</td><td style=\"color: #cccccc\">Secondary carcinoid tumors of peritoneum</td></tr><tr><td>C7B.09</td><td style=\"color: #cccccc\">Secondary carcinoid tumors of other sites</td></tr><tr><td>C7B.1</td><td style=\"color: #cccccc\">Secondary Merkel cell carcinoma</td></tr><tr><td>C7B.8</td><td style=\"color: #cccccc\">Other secondary neuroendocrine tumors</td></tr><tr><td>C80</td><td style=\"color: #cccccc\">Malignant neoplasm without specification of site</td></tr><tr><td>C80.0</td><td style=\"color: #cccccc\">Disseminated malignant neoplasm, unspecified</td></tr><tr><td>C80.1</td><td style=\"color: #cccccc\">Malignant (primary) neoplasm, unspecified</td></tr><tr><td>C80.2</td><td style=\"color: #cccccc\">Malignant neoplasm associated with transplanted organ</td></tr><tr><td>C81</td><td style=\"color: #cccccc\">Hodgkin lymphoma</td></tr><tr><td>C81.0</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma</td></tr><tr><td>C81.00</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, unspecified site</td></tr><tr><td>C81.01</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C81.02</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C81.03</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C81.04</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C81.05</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C81.06</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C81.07</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, spleen</td></tr><tr><td>C81.08</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C81.09</td><td style=\"color: #cccccc\">Nodular lymphocyte predominant Hodgkin lymphoma, extranodal and solid organ sites</td></tr><tr><td>C81.1</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma</td></tr><tr><td>C81.10</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, unspecified site</td></tr><tr><td>C81.11</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C81.12</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C81.13</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C81.14</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C81.15</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C81.16</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C81.17</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, spleen</td></tr><tr><td>C81.18</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C81.19</td><td style=\"color: #cccccc\">Nodular sclerosis Hodgkin lymphoma, extranodal and solid organ sites</td></tr><tr><td>C81.2</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma</td></tr><tr><td>C81.20</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, unspecified site</td></tr><tr><td>C81.21</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C81.22</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C81.23</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C81.24</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C81.25</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C81.26</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C81.27</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, spleen</td></tr><tr><td>C81.28</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C81.29</td><td style=\"color: #cccccc\">Mixed cellularity Hodgkin lymphoma, extranodal and solid organ sites</td></tr><tr><td>C81.3</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma</td></tr><tr><td>C81.30</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, unspecified site</td></tr><tr><td>C81.31</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C81.32</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C81.33</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C81.34</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C81.35</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C81.36</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C81.37</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, spleen</td></tr><tr><td>C81.38</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C81.39</td><td style=\"color: #cccccc\">Lymphocyte depleted Hodgkin lymphoma, extranodal and solid organ sites</td></tr><tr><td>C81.4</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma</td></tr><tr><td>C81.40</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, unspecified site</td></tr><tr><td>C81.41</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C81.42</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C81.43</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C81.44</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C81.45</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C81.46</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C81.47</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, spleen</td></tr><tr><td>C81.48</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C81.49</td><td style=\"color: #cccccc\">Lymphocyte-rich Hodgkin lymphoma, extranodal and solid organ sites</td></tr><tr><td>C81.7</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma</td></tr><tr><td>C81.70</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, unspecified site</td></tr><tr><td>C81.71</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C81.72</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C81.73</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C81.74</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C81.75</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C81.76</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C81.77</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, spleen</td></tr><tr><td>C81.78</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C81.79</td><td style=\"color: #cccccc\">Other Hodgkin lymphoma, extranodal and solid organ sites</td></tr><tr><td>C81.9</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified</td></tr><tr><td>C81.90</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, unspecified site</td></tr><tr><td>C81.91</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, lymph nodes of head, face, and neck</td></tr><tr><td>C81.92</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, intrathoracic lymph nodes</td></tr><tr><td>C81.93</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, intra-abdominal lymph nodes</td></tr><tr><td>C81.94</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, lymph nodes of axilla and upper limb</td></tr><tr><td>C81.95</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C81.96</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, intrapelvic lymph nodes</td></tr><tr><td>C81.97</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, spleen</td></tr><tr><td>C81.98</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, lymph nodes of multiple sites</td></tr><tr><td>C81.99</td><td style=\"color: #cccccc\">Hodgkin lymphoma, unspecified, extranodal and solid organ sites</td></tr><tr><td>C82</td><td style=\"color: #cccccc\">Follicular lymphoma</td></tr><tr><td>C82.0</td><td style=\"color: #cccccc\">Follicular lymphoma grade I</td></tr><tr><td>C82.00</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, unspecified site</td></tr><tr><td>C82.01</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, lymph nodes of head, face, and neck</td></tr><tr><td>C82.02</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, intrathoracic lymph nodes</td></tr><tr><td>C82.03</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, intra-abdominal lymph nodes</td></tr><tr><td>C82.04</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, lymph nodes of axilla and upper limb</td></tr><tr><td>C82.05</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C82.06</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, intrapelvic lymph nodes</td></tr><tr><td>C82.07</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, spleen</td></tr><tr><td>C82.08</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, lymph nodes of multiple sites</td></tr><tr><td>C82.09</td><td style=\"color: #cccccc\">Follicular lymphoma grade I, extranodal and solid organ sites</td></tr><tr><td>C82.1</td><td style=\"color: #cccccc\">Follicular lymphoma grade II</td></tr><tr><td>C82.10</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, unspecified site</td></tr><tr><td>C82.11</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, lymph nodes of head, face, and neck</td></tr><tr><td>C82.12</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, intrathoracic lymph nodes</td></tr><tr><td>C82.13</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, intra-abdominal lymph nodes</td></tr><tr><td>C82.14</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, lymph nodes of axilla and upper limb</td></tr><tr><td>C82.15</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C82.16</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, intrapelvic lymph nodes</td></tr><tr><td>C82.17</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, spleen</td></tr><tr><td>C82.18</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, lymph nodes of multiple sites</td></tr><tr><td>C82.19</td><td style=\"color: #cccccc\">Follicular lymphoma grade II, extranodal and solid organ sites</td></tr><tr><td>C82.2</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified</td></tr><tr><td>C82.20</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, unspecified site</td></tr><tr><td>C82.21</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, lymph nodes of head, face, and neck</td></tr><tr><td>C82.22</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, intrathoracic lymph nodes</td></tr><tr><td>C82.23</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, intra-abdominal lymph nodes</td></tr><tr><td>C82.24</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, lymph nodes of axilla and upper limb</td></tr><tr><td>C82.25</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C82.26</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, intrapelvic lymph nodes</td></tr><tr><td>C82.27</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, spleen</td></tr><tr><td>C82.28</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, lymph nodes of multiple sites</td></tr><tr><td>C82.29</td><td style=\"color: #cccccc\">Follicular lymphoma grade III, unspecified, extranodal and solid organ sites</td></tr><tr><td>C82.3</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa</td></tr><tr><td>C82.30</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, unspecified site</td></tr><tr><td>C82.31</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, lymph nodes of head, face, and neck</td></tr><tr><td>C82.32</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, intrathoracic lymph nodes</td></tr><tr><td>C82.33</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, intra-abdominal lymph nodes</td></tr><tr><td>C82.34</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, lymph nodes of axilla and upper limb</td></tr><tr><td>C82.35</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C82.36</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, intrapelvic lymph nodes</td></tr><tr><td>C82.37</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, spleen</td></tr><tr><td>C82.38</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, lymph nodes of multiple sites</td></tr><tr><td>C82.39</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIa, extranodal and solid organ sites</td></tr><tr><td>C82.4</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb</td></tr><tr><td>C82.40</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, unspecified site</td></tr><tr><td>C82.41</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, lymph nodes of head, face, and neck</td></tr><tr><td>C82.42</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, intrathoracic lymph nodes</td></tr><tr><td>C82.43</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, intra-abdominal lymph nodes</td></tr><tr><td>C82.44</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, lymph nodes of axilla and upper limb</td></tr><tr><td>C82.45</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C82.46</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, intrapelvic lymph nodes</td></tr><tr><td>C82.47</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, spleen</td></tr><tr><td>C82.48</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, lymph nodes of multiple sites</td></tr><tr><td>C82.49</td><td style=\"color: #cccccc\">Follicular lymphoma grade IIIb, extranodal and solid organ sites</td></tr><tr><td>C82.5</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma</td></tr><tr><td>C82.50</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, unspecified site</td></tr><tr><td>C82.51</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C82.52</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C82.53</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C82.54</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C82.55</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C82.56</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C82.57</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, spleen</td></tr><tr><td>C82.58</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C82.59</td><td style=\"color: #cccccc\">Diffuse follicle center lymphoma, extranodal and solid organ sites</td></tr><tr><td>C82.6</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma</td></tr><tr><td>C82.60</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, unspecified site</td></tr><tr><td>C82.61</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C82.62</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C82.63</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C82.64</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C82.65</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C82.66</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C82.67</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, spleen</td></tr><tr><td>C82.68</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C82.69</td><td style=\"color: #cccccc\">Cutaneous follicle center lymphoma, extranodal and solid organ sites</td></tr><tr><td>C82.8</td><td style=\"color: #cccccc\">Other types of follicular lymphoma</td></tr><tr><td>C82.80</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, unspecified site</td></tr><tr><td>C82.81</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C82.82</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C82.83</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C82.84</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C82.85</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C82.86</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C82.87</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, spleen</td></tr><tr><td>C82.88</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C82.89</td><td style=\"color: #cccccc\">Other types of follicular lymphoma, extranodal and solid organ sites</td></tr><tr><td>C82.9</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified</td></tr><tr><td>C82.90</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, unspecified site</td></tr><tr><td>C82.91</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, lymph nodes of head, face, and neck</td></tr><tr><td>C82.92</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, intrathoracic lymph nodes</td></tr><tr><td>C82.93</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, intra-abdominal lymph nodes</td></tr><tr><td>C82.94</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, lymph nodes of axilla and upper limb</td></tr><tr><td>C82.95</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C82.96</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, intrapelvic lymph nodes</td></tr><tr><td>C82.97</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, spleen</td></tr><tr><td>C82.98</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, lymph nodes of multiple sites</td></tr><tr><td>C82.99</td><td style=\"color: #cccccc\">Follicular lymphoma, unspecified, extranodal and solid organ sites</td></tr><tr><td>C83</td><td style=\"color: #cccccc\">Non-follicular lymphoma</td></tr><tr><td>C83.0</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma</td></tr><tr><td>C83.01</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C83.02</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C83.03</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C83.04</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C83.05</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C83.06</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C83.07</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma, spleen</td></tr><tr><td>C83.08</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C83.09</td><td style=\"color: #cccccc\">Small cell B-cell lymphoma, extranodal and solid organ sites</td></tr><tr><td>C83.1</td><td style=\"color: #cccccc\">Mantle cell lymphoma</td></tr><tr><td>C83.10</td><td style=\"color: #cccccc\">Mantle cell lymphoma, unspecified site</td></tr><tr><td>C83.11</td><td style=\"color: #cccccc\">Mantle cell lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C83.12</td><td style=\"color: #cccccc\">Mantle cell lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C83.13</td><td style=\"color: #cccccc\">Mantle cell lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C83.14</td><td style=\"color: #cccccc\">Mantle cell lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C83.15</td><td style=\"color: #cccccc\">Mantle cell lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C83.16</td><td style=\"color: #cccccc\">Mantle cell lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C83.17</td><td style=\"color: #cccccc\">Mantle cell lymphoma, spleen</td></tr><tr><td>C83.18</td><td style=\"color: #cccccc\">Mantle cell lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C83.19</td><td style=\"color: #cccccc\">Mantle cell lymphoma, extranodal and solid organ sites</td></tr><tr><td>C83.3</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma</td></tr><tr><td>C83.30</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, unspecified site</td></tr><tr><td>C83.31</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C83.32</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C83.33</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C83.34</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C83.35</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C83.36</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C83.37</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, spleen</td></tr><tr><td>C83.38</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C83.39</td><td style=\"color: #cccccc\">Diffuse large B-cell lymphoma, extranodal and solid organ sites</td></tr><tr><td>C83.5</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma</td></tr><tr><td>C83.50</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, unspecified site</td></tr><tr><td>C83.51</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C83.52</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C83.53</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C83.54</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C83.55</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C83.56</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C83.57</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, spleen</td></tr><tr><td>C83.58</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C83.59</td><td style=\"color: #cccccc\">Lymphoblastic (diffuse) lymphoma, extranodal and solid organ sites</td></tr><tr><td>C83.7</td><td style=\"color: #cccccc\">Burkitt lymphoma</td></tr><tr><td>C83.70</td><td style=\"color: #cccccc\">Burkitt lymphoma, unspecified site</td></tr><tr><td>C83.71</td><td style=\"color: #cccccc\">Burkitt lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C83.72</td><td style=\"color: #cccccc\">Burkitt lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C83.73</td><td style=\"color: #cccccc\">Burkitt lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C83.74</td><td style=\"color: #cccccc\">Burkitt lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C83.75</td><td style=\"color: #cccccc\">Burkitt lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C83.76</td><td style=\"color: #cccccc\">Burkitt lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C83.77</td><td style=\"color: #cccccc\">Burkitt lymphoma, spleen</td></tr><tr><td>C83.78</td><td style=\"color: #cccccc\">Burkitt lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C83.79</td><td style=\"color: #cccccc\">Burkitt lymphoma, extranodal and solid organ sites</td></tr><tr><td>C83.8</td><td style=\"color: #cccccc\">Other non-follicular lymphoma</td></tr><tr><td>C83.80</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, unspecified site</td></tr><tr><td>C83.81</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C83.82</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C83.83</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C83.84</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C83.85</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, lymph nodes of inguinal region and lower limb</td></tr><tr><td>C83.86</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C83.87</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, spleen</td></tr><tr><td>C83.88</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C83.89</td><td style=\"color: #cccccc\">Other non-follicular lymphoma, extranodal and solid organ sites</td></tr><tr><td>C83.9</td><td style=\"color: #cccccc\">Non-follicular (diffuse) lymphoma, unspecified</td></tr><tr><td>C83.90</td><td style=\"color: #cccccc\">Non-follicular (diffuse) lymphoma, unspecified, unspecified site</td></tr><tr><td>C83.91</td><td style=\"color: #cccccc\">Non-follicular (diffuse) lymphoma, unspecified, lymph nodes of head, face, and neck</td></tr><tr><td>C83.92</td><td style=\"color: #cccccc\">Non-follic (diffuse) lymphoma, unsp, intrathorac lymph nodes</td></tr><tr><td>C83.93</td><td style=\"color: #cccccc\">Non-follic (diffuse) lymphoma, unsp, intra-abd lymph nodes</td></tr><tr><td>C83.94</td><td style=\"color: #cccccc\">Non-follic lymphoma, unsp, nodes of axilla and upper limb</td></tr><tr><td>C83.95</td><td style=\"color: #cccccc\">Non-follic lymph, unsp, nodes of ing region and lower limb</td></tr><tr><td>C83.96</td><td style=\"color: #cccccc\">Non-follic (diffuse) lymphoma, unsp, intrapelvic lymph nodes</td></tr><tr><td>C83.97</td><td style=\"color: #cccccc\">Non-follicular (diffuse) lymphoma, unspecified, spleen</td></tr><tr><td>C83.98</td><td style=\"color: #cccccc\">Non-follic (diffuse) lymphoma, unsp, lymph nodes mult site</td></tr><tr><td>C83.99</td><td style=\"color: #cccccc\">Non-follic lymphoma, unsp, extrnod and solid organ sites</td></tr><tr><td>C84</td><td style=\"color: #cccccc\">Mature T/NK-cell lymphomas</td></tr><tr><td>C84.0</td><td style=\"color: #cccccc\">Mycosis fungoides</td></tr><tr><td>C84.00</td><td style=\"color: #cccccc\">Mycosis fungoides, unspecified site</td></tr><tr><td>C84.01</td><td style=\"color: #cccccc\">Mycosis fungoides, lymph nodes of head, face, and neck</td></tr><tr><td>C84.02</td><td style=\"color: #cccccc\">Mycosis fungoides, intrathoracic lymph nodes</td></tr><tr><td>C84.03</td><td style=\"color: #cccccc\">Mycosis fungoides, intra-abdominal lymph nodes</td></tr><tr><td>C84.04</td><td style=\"color: #cccccc\">Mycosis fungoides, lymph nodes of axilla and upper limb</td></tr><tr><td>C84.05</td><td style=\"color: #cccccc\">Mycosis fungoides, nodes of inguinal region and lower limb</td></tr><tr><td>C84.06</td><td style=\"color: #cccccc\">Mycosis fungoides, intrapelvic lymph nodes</td></tr><tr><td>C84.07</td><td style=\"color: #cccccc\">Mycosis fungoides, spleen</td></tr><tr><td>C84.08</td><td style=\"color: #cccccc\">Mycosis fungoides, lymph nodes of multiple sites</td></tr><tr><td>C84.09</td><td style=\"color: #cccccc\">Mycosis fungoides, extranodal and solid organ sites</td></tr><tr><td>C84.1</td><td style=\"color: #cccccc\">Sezary disease</td></tr><tr><td>C84.10</td><td style=\"color: #cccccc\">Sezary disease, unspecified site</td></tr><tr><td>C84.11</td><td style=\"color: #cccccc\">Sezary disease, lymph nodes of head, face, and neck</td></tr><tr><td>C84.12</td><td style=\"color: #cccccc\">Sezary disease, intrathoracic lymph nodes</td></tr><tr><td>C84.13</td><td style=\"color: #cccccc\">Sezary disease, intra-abdominal lymph nodes</td></tr><tr><td>C84.14</td><td style=\"color: #cccccc\">Sezary disease, lymph nodes of axilla and upper limb</td></tr><tr><td>C84.15</td><td style=\"color: #cccccc\">Sezary disease, nodes of inguinal region and lower limb</td></tr><tr><td>C84.16</td><td style=\"color: #cccccc\">Sezary disease, intrapelvic lymph nodes</td></tr><tr><td>C84.17</td><td style=\"color: #cccccc\">Sezary disease, spleen</td></tr><tr><td>C84.18</td><td style=\"color: #cccccc\">Sezary disease, lymph nodes of multiple sites</td></tr><tr><td>C84.19</td><td style=\"color: #cccccc\">Sezary disease, extranodal and solid organ sites</td></tr><tr><td>C84.4</td><td style=\"color: #cccccc\">Peripheral T-cell lymphoma, not elsewhere classified</td></tr><tr><td>C84.40</td><td style=\"color: #cccccc\">Peripheral T-cell lymphoma, NEC, unspecified site</td></tr><tr><td>C84.41</td><td style=\"color: #cccccc\">Prph T-cell lymphoma, NEC, nodes of head, face, and neck</td></tr><tr><td>C84.42</td><td style=\"color: #cccccc\">Peripheral T-cell lymphoma, NEC, intrathoracic lymph nodes</td></tr><tr><td>C84.43</td><td style=\"color: #cccccc\">Peripheral T-cell lymphoma, NEC, intra-abdominal lymph nodes</td></tr><tr><td>C84.44</td><td style=\"color: #cccccc\">Prph T-cell lymphoma, NEC, nodes of axilla and upper limb</td></tr><tr><td>C84.45</td><td style=\"color: #cccccc\">Prph T-cell lymph, NEC, nodes of ing region and lower limb</td></tr><tr><td>C84.46</td><td style=\"color: #cccccc\">Peripheral T-cell lymphoma, NEC, intrapelvic lymph nodes</td></tr><tr><td>C84.47</td><td style=\"color: #cccccc\">Peripheral T-cell lymphoma, not elsewhere classified, spleen</td></tr><tr><td>C84.48</td><td style=\"color: #cccccc\">Peripheral T-cell lymphoma, NEC, lymph nodes mult site</td></tr><tr><td>C84.49</td><td style=\"color: #cccccc\">Prph T-cell lymphoma, NEC, extrnod and solid organ sites</td></tr><tr><td>C84.6</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-positive</td></tr><tr><td>C84.60</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-positive, unsp site</td></tr><tr><td>C84.61</td><td style=\"color: #cccccc\">Anaplstc lg cell lymph, ALK-pos, nodes of head, face, and nk</td></tr><tr><td>C84.62</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-pos, intrathorac nodes</td></tr><tr><td>C84.63</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-pos, intra-abd nodes</td></tr><tr><td>C84.64</td><td style=\"color: #cccccc\">Anaplstc lg cell lymph, ALK-pos, nodes of axla and upr limb</td></tr><tr><td>C84.65</td><td style=\"color: #cccccc\">Anaplstc lg cell lymph, ALK-pos, nodes of ing rgn &amp; low lmb</td></tr><tr><td>C84.66</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-pos, intrapelv nodes</td></tr><tr><td>C84.67</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-positive, spleen</td></tr><tr><td>C84.68</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-pos, nodes mult site</td></tr><tr><td>C84.69</td><td style=\"color: #cccccc\">Anaplstc lg cell lymph, ALK-pos, extrnod and solid org sites</td></tr><tr><td>C84.7</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-negative</td></tr><tr><td>C84.70</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-negative, unsp site</td></tr><tr><td>C84.71</td><td style=\"color: #cccccc\">Anaplstc lg cell lymph, ALK-neg, nodes of head, face, and nk</td></tr><tr><td>C84.72</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-neg, intrathorac nodes</td></tr><tr><td>C84.73</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-neg, intra-abd nodes</td></tr><tr><td>C84.74</td><td style=\"color: #cccccc\">Anaplstc lg cell lymph, ALK-neg, nodes of axla and upr limb</td></tr><tr><td>C84.75</td><td style=\"color: #cccccc\">Anaplstc lg cell lymph, ALK-neg, nodes of ing rgn &amp; low lmb</td></tr><tr><td>C84.76</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-neg, intrapelv nodes</td></tr><tr><td>C84.77</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-negative, spleen</td></tr><tr><td>C84.78</td><td style=\"color: #cccccc\">Anaplastic large cell lymphoma, ALK-neg, nodes mult site</td></tr><tr><td>C84.79</td><td style=\"color: #cccccc\">Anaplstc lg cell lymph, ALK-neg, extrnod and solid org sites</td></tr><tr><td>C84.9</td><td style=\"color: #cccccc\">Mature T/NK-cell lymphomas, unspecified</td></tr><tr><td>C84.90</td><td style=\"color: #cccccc\">Mature T/NK-cell lymphomas, unspecified, unspecified site</td></tr><tr><td>C84.91</td><td style=\"color: #cccccc\">Mature T/NK-cell lymph, unsp, nodes of head, face, and neck</td></tr><tr><td>C84.92</td><td style=\"color: #cccccc\">Mature T/NK-cell lymphomas, unsp, intrathoracic lymph nodes</td></tr><tr><td>C84.93</td><td style=\"color: #cccccc\">Mature T/NK-cell lymphomas, unsp, intra-abd lymph nodes</td></tr><tr><td>C84.94</td><td style=\"color: #cccccc\">Mature T/NK-cell lymph, unsp, nodes of axilla and upper limb</td></tr><tr><td>C84.95</td><td style=\"color: #cccccc\">Mature T/NK-cell lymph, unsp, nodes of ing rgn and low limb</td></tr><tr><td>C84.96</td><td style=\"color: #cccccc\">Mature T/NK-cell lymphomas, unsp, intrapelvic lymph nodes</td></tr><tr><td>C84.97</td><td style=\"color: #cccccc\">Mature T/NK-cell lymphomas, unspecified, spleen</td></tr><tr><td>C84.98</td><td style=\"color: #cccccc\">Mature T/NK-cell lymphomas, unsp, lymph nodes mult site</td></tr><tr><td>C84.99</td><td style=\"color: #cccccc\">Mature T/NK-cell lymph, unsp, extrnod and solid organ sites</td></tr><tr><td>C84.A</td><td style=\"color: #cccccc\">Cutaneous T-cell lymphoma, unspecified</td></tr><tr><td>C84.A0</td><td style=\"color: #cccccc\">Cutaneous T-cell lymphoma, unspecified, unspecified site</td></tr><tr><td>C84.A1</td><td style=\"color: #cccccc\">Cutan T-cell lymphoma, unsp nodes of head, face, and neck</td></tr><tr><td>C84.A2</td><td style=\"color: #cccccc\">Cutaneous T-cell lymphoma, unsp, intrathoracic lymph nodes</td></tr><tr><td>C84.A3</td><td style=\"color: #cccccc\">Cutaneous T-cell lymphoma, unsp, intra-abdominal lymph nodes</td></tr><tr><td>C84.A4</td><td style=\"color: #cccccc\">Cutan T-cell lymphoma, unsp, nodes of axilla and upper limb</td></tr><tr><td>C84.A5</td><td style=\"color: #cccccc\">Cutan T-cell lymph, unsp, nodes of ing region and lower limb</td></tr><tr><td>C84.A6</td><td style=\"color: #cccccc\">Cutaneous T-cell lymphoma, unsp, intrapelvic lymph nodes</td></tr><tr><td>C84.A7</td><td style=\"color: #cccccc\">Cutaneous T-cell lymphoma, unspecified, spleen</td></tr><tr><td>C84.A8</td><td style=\"color: #cccccc\">Cutaneous T-cell lymphoma, unsp, lymph nodes mult site</td></tr><tr><td>C84.A9</td><td style=\"color: #cccccc\">Cutan T-cell lymphoma, unsp, extrnod and solid organ sites</td></tr><tr><td>C84.Z</td><td style=\"color: #cccccc\">Other mature T/NK-cell lymphomas</td></tr><tr><td>C84.Z0</td><td style=\"color: #cccccc\">Other mature T/NK-cell lymphomas, unspecified site</td></tr><tr><td>C84.Z1</td><td style=\"color: #cccccc\">Oth mature T/NK-cell lymph, nodes of head, face, and neck</td></tr><tr><td>C84.Z2</td><td style=\"color: #cccccc\">Other mature T/NK-cell lymphomas, intrathoracic lymph nodes</td></tr><tr><td>C84.Z3</td><td style=\"color: #cccccc\">Oth mature T/NK-cell lymphomas, intra-abdominal lymph nodes</td></tr><tr><td>C84.Z4</td><td style=\"color: #cccccc\">Oth mature T/NK-cell lymph, nodes of axilla and upper limb</td></tr><tr><td>C84.Z5</td><td style=\"color: #cccccc\">Oth mature T/NK-cell lymph, nodes of ing rgn and lower limb</td></tr><tr><td>C84.Z6</td><td style=\"color: #cccccc\">Other mature T/NK-cell lymphomas, intrapelvic lymph nodes</td></tr><tr><td>C84.Z7</td><td style=\"color: #cccccc\">Other mature T/NK-cell lymphomas, spleen</td></tr><tr><td>C84.Z8</td><td style=\"color: #cccccc\">Oth mature T/NK-cell lymphomas, lymph nodes mult site</td></tr><tr><td>C84.Z9</td><td style=\"color: #cccccc\">Oth mature T/NK-cell lymph, extrnod and solid organ sites</td></tr><tr><td>C85</td><td style=\"color: #cccccc\">Oth and unspecified types of non-Hodgkin lymphoma</td></tr><tr><td>C85.1</td><td style=\"color: #cccccc\">Unspecified B-cell lymphoma</td></tr><tr><td>C85.10</td><td style=\"color: #cccccc\">Unspecified B-cell lymphoma, unspecified site</td></tr><tr><td>C85.11</td><td style=\"color: #cccccc\">Unsp B-cell lymphoma, lymph nodes of head, face, and neck</td></tr><tr><td>C85.12</td><td style=\"color: #cccccc\">Unspecified B-cell lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C85.13</td><td style=\"color: #cccccc\">Unspecified B-cell lymphoma, intra-abdominal lymph nodes</td></tr><tr><td>C85.14</td><td style=\"color: #cccccc\">Unsp B-cell lymphoma, lymph nodes of axilla and upper limb</td></tr><tr><td>C85.15</td><td style=\"color: #cccccc\">Unsp B-cell lymphoma, nodes of ing region and lower limb</td></tr><tr><td>C85.16</td><td style=\"color: #cccccc\">Unspecified B-cell lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C85.17</td><td style=\"color: #cccccc\">Unspecified B-cell lymphoma, spleen</td></tr><tr><td>C85.18</td><td style=\"color: #cccccc\">Unspecified B-cell lymphoma, lymph nodes of multiple sites</td></tr><tr><td>C85.19</td><td style=\"color: #cccccc\">Unsp B-cell lymphoma, extranodal and solid organ sites</td></tr><tr><td>C85.2</td><td style=\"color: #cccccc\">Mediastinal (thymic) large B-cell lymphoma</td></tr><tr><td>C85.20</td><td style=\"color: #cccccc\">Mediastinal (thymic) large B-cell lymphoma, unspecified site</td></tr><tr><td>C85.21</td><td style=\"color: #cccccc\">Mediastnl large B-cell lymph, nodes of head, face, and neck</td></tr><tr><td>C85.22</td><td style=\"color: #cccccc\">Mediastnl (thymic) large B-cell lymphoma, intrathorac nodes</td></tr><tr><td>C85.23</td><td style=\"color: #cccccc\">Mediastinal (thymic) large B-cell lymphoma, intra-abd nodes</td></tr><tr><td>C85.24</td><td style=\"color: #cccccc\">Mediastnl large B-cell lymph, nodes of axilla and upper limb</td></tr><tr><td>C85.25</td><td style=\"color: #cccccc\">Mediastnl lg B-cell lymph, nodes of ing rgn and lower limb</td></tr><tr><td>C85.26</td><td style=\"color: #cccccc\">Mediastinal (thymic) large B-cell lymphoma, intrapelv nodes</td></tr><tr><td>C85.27</td><td style=\"color: #cccccc\">Mediastinal (thymic) large B-cell lymphoma, spleen</td></tr><tr><td>C85.28</td><td style=\"color: #cccccc\">Mediastinal (thymic) large B-cell lymphoma, nodes mult site</td></tr><tr><td>C85.29</td><td style=\"color: #cccccc\">Mediastnl large B-cell lymph, extrnod and solid organ sites</td></tr><tr><td>C85.8</td><td style=\"color: #cccccc\">Other specified types of non-Hodgkin lymphoma</td></tr><tr><td>C85.80</td><td style=\"color: #cccccc\">Oth types of non-Hodgkin lymphoma, unspecified site</td></tr><tr><td>C85.81</td><td style=\"color: #cccccc\">Oth types of non-hodg lymph, nodes of head, face, and neck</td></tr><tr><td>C85.82</td><td style=\"color: #cccccc\">Oth types of non-Hodgkin lymphoma, intrathoracic lymph nodes</td></tr><tr><td>C85.83</td><td style=\"color: #cccccc\">Oth types of non-Hodgkin lymphoma, intra-abd lymph nodes</td></tr><tr><td>C85.84</td><td style=\"color: #cccccc\">Oth types of non-hodg lymph, nodes of axilla and upper limb</td></tr><tr><td>C85.85</td><td style=\"color: #cccccc\">Oth types of non-hodg lymph, nodes of ing rgn and lower limb</td></tr><tr><td>C85.86</td><td style=\"color: #cccccc\">Oth types of non-Hodgkin lymphoma, intrapelvic lymph nodes</td></tr><tr><td>C85.87</td><td style=\"color: #cccccc\">Other specified types of non-Hodgkin lymphoma, spleen</td></tr><tr><td>C85.88</td><td style=\"color: #cccccc\">Oth types of non-Hodgkin lymphoma, lymph nodes mult site</td></tr><tr><td>C85.89</td><td style=\"color: #cccccc\">Oth types of non-hodg lymph, extrnod and solid organ sites</td></tr><tr><td>C85.9</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unspecified</td></tr><tr><td>C85.90</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unspecified, unspecified site</td></tr><tr><td>C85.91</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unsp, nodes of head, face, and neck</td></tr><tr><td>C85.92</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unspecified, intrathoracic lymph nodes</td></tr><tr><td>C85.93</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unsp, intra-abdominal lymph nodes</td></tr><tr><td>C85.94</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unsp, nodes of axilla and upper limb</td></tr><tr><td>C85.95</td><td style=\"color: #cccccc\">Non-hodg lymphoma, unsp, nodes of ing region and lower limb</td></tr><tr><td>C85.96</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unspecified, intrapelvic lymph nodes</td></tr><tr><td>C85.97</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unspecified, spleen</td></tr><tr><td>C85.98</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unsp, lymph nodes of multiple sites</td></tr><tr><td>C85.99</td><td style=\"color: #cccccc\">Non-Hodgkin lymphoma, unsp, extranodal and solid organ sites</td></tr><tr><td>C86</td><td style=\"color: #cccccc\">Other specified types of T/NK-cell lymphoma</td></tr><tr><td>C86.0</td><td style=\"color: #cccccc\">Extranodal NK/T-cell lymphoma, nasal type</td></tr><tr><td>C86.1</td><td style=\"color: #cccccc\">Hepatosplenic T-cell lymphoma</td></tr><tr><td>C86.2</td><td style=\"color: #cccccc\">Enteropathy-type (intestinal) T-cell lymphoma</td></tr><tr><td>C86.3</td><td style=\"color: #cccccc\">Subcutaneous panniculitis-like T-cell lymphoma</td></tr><tr><td>C86.4</td><td style=\"color: #cccccc\">Blastic NK-cell lymphoma</td></tr><tr><td>C86.5</td><td style=\"color: #cccccc\">Angioimmunoblastic T-cell lymphoma</td></tr><tr><td>C86.6</td><td style=\"color: #cccccc\">Primary cutaneous CD30-positive T-cell proliferations</td></tr><tr><td>C88</td><td style=\"color: #cccccc\">Malig immunoproliferative dis and certain oth B-cell lymph</td></tr><tr><td>C88.0</td><td style=\"color: #cccccc\">Waldenstrom macroglobulinemia</td></tr><tr><td>C88.2</td><td style=\"color: #cccccc\">Heavy chain disease</td></tr><tr><td>C88.3</td><td style=\"color: #cccccc\">Immunoproliferative small intestinal disease</td></tr><tr><td>C88.4</td><td style=\"color: #cccccc\">Extrnod mrgnl zn B-cell lymph of mucosa-assoc lymphoid tiss</td></tr><tr><td>C88.8</td><td style=\"color: #cccccc\">Other malignant immunoproliferative diseases</td></tr><tr><td>C88.9</td><td style=\"color: #cccccc\">Malignant immunoproliferative disease, unspecified</td></tr><tr><td>C90</td><td style=\"color: #cccccc\">Multiple myeloma and malignant plasma cell neoplasms</td></tr><tr><td>C90.0</td><td style=\"color: #cccccc\">Multiple myeloma</td></tr><tr><td>C90.00</td><td style=\"color: #cccccc\">Multiple myeloma not having achieved remission</td></tr><tr><td>C90.01</td><td style=\"color: #cccccc\">Multiple myeloma in remission</td></tr><tr><td>C90.02</td><td style=\"color: #cccccc\">Multiple myeloma in relapse</td></tr><tr><td>C90.1</td><td style=\"color: #cccccc\">Plasma cell leukemia</td></tr><tr><td>C90.10</td><td style=\"color: #cccccc\">Plasma cell leukemia not having achieved remission</td></tr><tr><td>C90.11</td><td style=\"color: #cccccc\">Plasma cell leukemia in remission</td></tr><tr><td>C90.12</td><td style=\"color: #cccccc\">Plasma cell leukemia in relapse</td></tr><tr><td>C90.2</td><td style=\"color: #cccccc\">Extramedullary plasmacytoma</td></tr><tr><td>C90.20</td><td style=\"color: #cccccc\">Extramedullary plasmacytoma not having achieved remission</td></tr><tr><td>C90.21</td><td style=\"color: #cccccc\">Extramedullary plasmacytoma in remission</td></tr><tr><td>C90.22</td><td style=\"color: #cccccc\">Extramedullary plasmacytoma in relapse</td></tr><tr><td>C90.3</td><td style=\"color: #cccccc\">Solitary plasmacytoma</td></tr><tr><td>C90.30</td><td style=\"color: #cccccc\">Solitary plasmacytoma not having achieved remission</td></tr><tr><td>C90.31</td><td style=\"color: #cccccc\">Solitary plasmacytoma in remission</td></tr><tr><td>C90.32</td><td style=\"color: #cccccc\">Solitary plasmacytoma in relapse</td></tr><tr><td>C91</td><td style=\"color: #cccccc\">Lymphoid leukemia</td></tr><tr><td>C91.0</td><td style=\"color: #cccccc\">Acute lymphoblastic leukemia [ALL]</td></tr><tr><td>C91.00</td><td style=\"color: #cccccc\">Acute lymphoblastic leukemia not having achieved remission</td></tr><tr><td>C91.01</td><td style=\"color: #cccccc\">Acute lymphoblastic leukemia, in remission</td></tr><tr><td>C91.02</td><td style=\"color: #cccccc\">Acute lymphoblastic leukemia, in relapse</td></tr><tr><td>C91.1</td><td style=\"color: #cccccc\">Chronic lymphocytic leukemia of B-cell type</td></tr><tr><td>C91.10</td><td style=\"color: #cccccc\">Chronic lymphocytic leuk of B-cell type not achieve remis</td></tr><tr><td>C91.11</td><td style=\"color: #cccccc\">Chronic lymphocytic leukemia of B-cell type in remission</td></tr><tr><td>C91.12</td><td style=\"color: #cccccc\">Chronic lymphocytic leukemia of B-cell type in relapse</td></tr><tr><td>C91.3</td><td style=\"color: #cccccc\">Prolymphocytic leukemia of B-cell type</td></tr><tr><td>C91.30</td><td style=\"color: #cccccc\">Prolymphocytic leukemia of B-cell type not achieve remission</td></tr><tr><td>C91.31</td><td style=\"color: #cccccc\">Prolymphocytic leukemia of B-cell type, in remission</td></tr><tr><td>C91.32</td><td style=\"color: #cccccc\">Prolymphocytic leukemia of B-cell type, in relapse</td></tr><tr><td>C91.4</td><td style=\"color: #cccccc\">Hairy cell leukemia</td></tr><tr><td>C91.40</td><td style=\"color: #cccccc\">Hairy cell leukemia not having achieved remission</td></tr><tr><td>C91.41</td><td style=\"color: #cccccc\">Hairy cell leukemia, in remission</td></tr><tr><td>C91.42</td><td style=\"color: #cccccc\">Hairy cell leukemia, in relapse</td></tr><tr><td>C91.5</td><td style=\"color: #cccccc\">Adult T-cell lymphoma/leukemia (HTLV-1-associated)</td></tr><tr><td>C91.50</td><td style=\"color: #cccccc\">Adult T-cell lymph/leuk (HTLV-1-assoc) not achieve remission</td></tr><tr><td>C91.51</td><td style=\"color: #cccccc\">Adult T-cell lymphoma/leukemia (HTLV-1-assoc), in remission</td></tr><tr><td>C91.52</td><td style=\"color: #cccccc\">Adult T-cell lymphoma/leukemia (HTLV-1-assoc), in relapse</td></tr><tr><td>C91.6</td><td style=\"color: #cccccc\">Prolymphocytic leukemia of T-cell type</td></tr><tr><td>C91.60</td><td style=\"color: #cccccc\">Prolymphocytic leukemia of T-cell type not achieve remission</td></tr><tr><td>C91.61</td><td style=\"color: #cccccc\">Prolymphocytic leukemia of T-cell type, in remission</td></tr><tr><td>C91.62</td><td style=\"color: #cccccc\">Prolymphocytic leukemia of T-cell type, in relapse</td></tr><tr><td>C91.9</td><td style=\"color: #cccccc\">Lymphoid leukemia, unspecified</td></tr><tr><td>C91.90</td><td style=\"color: #cccccc\">Lymphoid leukemia, unspecified not having achieved remission</td></tr><tr><td>C91.91</td><td style=\"color: #cccccc\">Lymphoid leukemia, unspecified, in remission</td></tr><tr><td>C91.92</td><td style=\"color: #cccccc\">Lymphoid leukemia, unspecified, in relapse</td></tr><tr><td>C91.A</td><td style=\"color: #cccccc\">Mature B-cell leukemia Burkitt-type</td></tr><tr><td>C91.A0</td><td style=\"color: #cccccc\">Mature B-cell leukemia Burkitt-type not achieve remission</td></tr><tr><td>C91.A1</td><td style=\"color: #cccccc\">Mature B-cell leukemia Burkitt-type, in remission</td></tr><tr><td>C91.A2</td><td style=\"color: #cccccc\">Mature B-cell leukemia Burkitt-type, in relapse</td></tr><tr><td>C91.Z</td><td style=\"color: #cccccc\">Other lymphoid leukemia</td></tr><tr><td>C91.Z0</td><td style=\"color: #cccccc\">Other lymphoid leukemia not having achieved remission</td></tr><tr><td>C91.Z1</td><td style=\"color: #cccccc\">Other lymphoid leukemia, in remission</td></tr><tr><td>C91.Z2</td><td style=\"color: #cccccc\">Other lymphoid leukemia, in relapse</td></tr><tr><td>C92</td><td style=\"color: #cccccc\">Myeloid leukemia</td></tr><tr><td>C92.0</td><td style=\"color: #cccccc\">Acute myeloblastic leukemia</td></tr><tr><td>C92.00</td><td style=\"color: #cccccc\">Acute myeloblastic leukemia, not having achieved remission</td></tr><tr><td>C92.01</td><td style=\"color: #cccccc\">Acute myeloblastic leukemia, in remission</td></tr><tr><td>C92.02</td><td style=\"color: #cccccc\">Acute myeloblastic leukemia, in relapse</td></tr><tr><td>C92.1</td><td style=\"color: #cccccc\">Chronic myeloid leukemia, BCR/ABL-positive</td></tr><tr><td>C92.10</td><td style=\"color: #cccccc\">Chronic myeloid leuk, BCR/ABL-positive, not achieve remis</td></tr><tr><td>C92.11</td><td style=\"color: #cccccc\">Chronic myeloid leukemia, BCR/ABL-positive, in remission</td></tr><tr><td>C92.12</td><td style=\"color: #cccccc\">Chronic myeloid leukemia, BCR/ABL-positive, in relapse</td></tr><tr><td>C92.2</td><td style=\"color: #cccccc\">Atypical chronic myeloid leukemia, BCR/ABL-negative</td></tr><tr><td>C92.2</td><td style=\"color: #cccccc\">Atypical chronic myeloid leukemia, BCR/ABL-negative</td></tr><tr><td>C92.20</td><td style=\"color: #cccccc\">Atyp chronic myeloid leuk, BCR/ABL-neg, not achieve remis</td></tr><tr><td>C92.21</td><td style=\"color: #cccccc\">Atypical chronic myeloid leukemia, BCR/ABL-neg, in remission</td></tr><tr><td>C92.22</td><td style=\"color: #cccccc\">Atypical chronic myeloid leukemia, BCR/ABL-neg, in relapse</td></tr><tr><td>C92.3</td><td style=\"color: #cccccc\">Myeloid sarcoma</td></tr><tr><td>C92.30</td><td style=\"color: #cccccc\">Myeloid sarcoma, not having achieved remission</td></tr><tr><td>C92.31</td><td style=\"color: #cccccc\">Myeloid sarcoma, in remission</td></tr><tr><td>C92.32</td><td style=\"color: #cccccc\">Myeloid sarcoma, in relapse</td></tr><tr><td>C92.4</td><td style=\"color: #cccccc\">Acute promyelocytic leukemia</td></tr><tr><td>C92.40</td><td style=\"color: #cccccc\">Acute promyelocytic leukemia, not having achieved remission</td></tr><tr><td>C92.41</td><td style=\"color: #cccccc\">Acute promyelocytic leukemia, in remission</td></tr><tr><td>C92.42</td><td style=\"color: #cccccc\">Acute promyelocytic leukemia, in relapse</td></tr><tr><td>C92.5</td><td style=\"color: #cccccc\">Acute myelomonocytic leukemia</td></tr><tr><td>C92.50</td><td style=\"color: #cccccc\">Acute myelomonocytic leukemia, not having achieved remission</td></tr><tr><td>C92.51</td><td style=\"color: #cccccc\">Acute myelomonocytic leukemia, in remission</td></tr><tr><td>C92.52</td><td style=\"color: #cccccc\">Acute myelomonocytic leukemia, in relapse</td></tr><tr><td>C92.6</td><td style=\"color: #cccccc\">Acute myeloid leukemia with 11q23-abnormality</td></tr><tr><td>C92.60</td><td style=\"color: #cccccc\">Acute myeloid leukemia w 11q23-abnormality not achieve remis</td></tr><tr><td>C92.61</td><td style=\"color: #cccccc\">Acute myeloid leukemia with 11q23-abnormality in remission</td></tr><tr><td>C92.62</td><td style=\"color: #cccccc\">Acute myeloid leukemia with 11q23-abnormality in relapse</td></tr><tr><td>C92.9</td><td style=\"color: #cccccc\">Myeloid leukemia, unspecified</td></tr><tr><td>C92.90</td><td style=\"color: #cccccc\">Myeloid leukemia, unspecified, not having achieved remission</td></tr><tr><td>C92.91</td><td style=\"color: #cccccc\">Myeloid leukemia, unspecified in remission</td></tr><tr><td>C92.92</td><td style=\"color: #cccccc\">Myeloid leukemia, unspecified in relapse</td></tr><tr><td>C92.A</td><td style=\"color: #cccccc\">Acute myeloid leukemia with multilineage dysplasia</td></tr><tr><td>C92.A0</td><td style=\"color: #cccccc\">Acute myeloid leuk w multilin dysplasia, not achieve remis</td></tr><tr><td>C92.A1</td><td style=\"color: #cccccc\">Acute myeloid leukemia w multilin dysplasia, in remission</td></tr><tr><td>C92.A2</td><td style=\"color: #cccccc\">Acute myeloid leukemia w multilineage dysplasia, in relapse</td></tr><tr><td>C92.Z</td><td style=\"color: #cccccc\">Other myeloid leukemia</td></tr><tr><td>C92.Z0</td><td style=\"color: #cccccc\">Other myeloid leukemia not having achieved remission</td></tr><tr><td>C92.Z1</td><td style=\"color: #cccccc\">Other myeloid leukemia, in remission</td></tr><tr><td>C92.Z2</td><td style=\"color: #cccccc\">Other myeloid leukemia, in relapse</td></tr><tr><td>C93</td><td style=\"color: #cccccc\">Monocytic leukemia</td></tr><tr><td>C93.0</td><td style=\"color: #cccccc\">Acute monoblastic/monocytic leukemia</td></tr><tr><td>C93.00</td><td style=\"color: #cccccc\">Acute monoblastic/monocytic leukemia, not achieve remission</td></tr><tr><td>C93.01</td><td style=\"color: #cccccc\">Acute monoblastic/monocytic leukemia, in remission</td></tr><tr><td>C93.02</td><td style=\"color: #cccccc\">Acute monoblastic/monocytic leukemia, in relapse</td></tr><tr><td>C93.1</td><td style=\"color: #cccccc\">Chronic myelomonocytic leukemia</td></tr><tr><td>C93.10</td><td style=\"color: #cccccc\">Chronic myelomonocytic leukemia not achieve remission</td></tr><tr><td>C93.11</td><td style=\"color: #cccccc\">Chronic myelomonocytic leukemia, in remission</td></tr><tr><td>C93.12</td><td style=\"color: #cccccc\">Chronic myelomonocytic leukemia, in relapse</td></tr><tr><td>C93.3</td><td style=\"color: #cccccc\">Juvenile myelomonocytic leukemia</td></tr><tr><td>C93.30</td><td style=\"color: #cccccc\">Juvenile myelomonocytic leukemia, not achieve remission</td></tr><tr><td>C93.31</td><td style=\"color: #cccccc\">Juvenile myelomonocytic leukemia, in remission</td></tr><tr><td>C93.32</td><td style=\"color: #cccccc\">Juvenile myelomonocytic leukemia, in relapse</td></tr><tr><td>C93.9</td><td style=\"color: #cccccc\">Monocytic leukemia, unspecified</td></tr><tr><td>C93.90</td><td style=\"color: #cccccc\">Monocytic leukemia, unsp, not having achieved remission</td></tr><tr><td>C93.91</td><td style=\"color: #cccccc\">Monocytic leukemia, unspecified in remission</td></tr><tr><td>C93.92</td><td style=\"color: #cccccc\">Monocytic leukemia, unspecified in relapse</td></tr><tr><td>C93.Z</td><td style=\"color: #cccccc\">Other monocytic leukemia</td></tr><tr><td>C93.Z0</td><td style=\"color: #cccccc\">Other monocytic leukemia, not having achieved remission</td></tr><tr><td>C93.Z1</td><td style=\"color: #cccccc\">Other monocytic leukemia, in remission</td></tr><tr><td>C93.Z2</td><td style=\"color: #cccccc\">Other monocytic leukemia, in relapse</td></tr><tr><td>C94</td><td style=\"color: #cccccc\">Other leukemias of specified cell type</td></tr><tr><td>C94.0</td><td style=\"color: #cccccc\">Acute erythroid leukemia</td></tr><tr><td>C94.00</td><td style=\"color: #cccccc\">Acute erythroid leukemia, not having achieved remission</td></tr><tr><td>C94.01</td><td style=\"color: #cccccc\">Acute erythroid leukemia, in remission</td></tr><tr><td>C94.02</td><td style=\"color: #cccccc\">Acute erythroid leukemia, in relapse</td></tr><tr><td>C94.2</td><td style=\"color: #cccccc\">Acute megakaryoblastic leukemia</td></tr><tr><td>C94.20</td><td style=\"color: #cccccc\">Acute megakaryoblastic leukemia not achieve remission</td></tr><tr><td>C94.21</td><td style=\"color: #cccccc\">Acute megakaryoblastic leukemia, in remission</td></tr><tr><td>C94.22</td><td style=\"color: #cccccc\">Acute megakaryoblastic leukemia, in relapse</td></tr><tr><td>C94.3</td><td style=\"color: #cccccc\">Mast cell leukemia</td></tr><tr><td>C94.30</td><td style=\"color: #cccccc\">Mast cell leukemia not having achieved remission</td></tr><tr><td>C94.31</td><td style=\"color: #cccccc\">Mast cell leukemia, in remission</td></tr><tr><td>C94.32</td><td style=\"color: #cccccc\">Mast cell leukemia, in relapse</td></tr><tr><td>C94.4</td><td style=\"color: #cccccc\">Acute panmyelosis with myelofibrosis</td></tr><tr><td>C94.40</td><td style=\"color: #cccccc\">Acute panmyelosis w myelofibrosis not achieve remission</td></tr><tr><td>C94.41</td><td style=\"color: #cccccc\">Acute panmyelosis with myelofibrosis, in remission</td></tr><tr><td>C94.42</td><td style=\"color: #cccccc\">Acute panmyelosis with myelofibrosis, in relapse</td></tr><tr><td>C94.6</td><td style=\"color: #cccccc\">Myelodysplastic disease, not elsewhere classified</td></tr><tr><td>C94.8</td><td style=\"color: #cccccc\">Other specified leukemias</td></tr><tr><td>C94.80</td><td style=\"color: #cccccc\">Other specified leukemias not having achieved remission</td></tr><tr><td>C94.81</td><td style=\"color: #cccccc\">Other specified leukemias, in remission</td></tr><tr><td>C94.82</td><td style=\"color: #cccccc\">Other specified leukemias, in relapse</td></tr><tr><td>C95</td><td style=\"color: #cccccc\">Leukemia of unspecified cell type</td></tr><tr><td>C95.0</td><td style=\"color: #cccccc\">Acute leukemia of unspecified cell type</td></tr><tr><td>C95.00</td><td style=\"color: #cccccc\">Acute leukemia of unsp cell type not achieve remission</td></tr><tr><td>C95.01</td><td style=\"color: #cccccc\">Acute leukemia of unspecified cell type, in remission</td></tr><tr><td>C95.02</td><td style=\"color: #cccccc\">Acute leukemia of unspecified cell type, in relapse</td></tr><tr><td>C95.1</td><td style=\"color: #cccccc\">Chronic leukemia of unspecified cell type</td></tr><tr><td>C95.10</td><td style=\"color: #cccccc\">Chronic leukemia of unsp cell type not achieve remission</td></tr><tr><td>C95.11</td><td style=\"color: #cccccc\">Chronic leukemia of unspecified cell type, in remission</td></tr><tr><td>C95.12</td><td style=\"color: #cccccc\">Chronic leukemia of unspecified cell type, in relapse</td></tr><tr><td>C95.9</td><td style=\"color: #cccccc\">Leukemia, unspecified</td></tr><tr><td>C95.90</td><td style=\"color: #cccccc\">Leukemia, unspecified not having achieved remission</td></tr><tr><td>C95.91</td><td style=\"color: #cccccc\">Leukemia, unspecified, in remission</td></tr><tr><td>C95.92</td><td style=\"color: #cccccc\">Leukemia, unspecified, in relapse</td></tr><tr><td>C96</td><td style=\"color: #cccccc\">Oth &amp; unsp malig neoplm of lymphoid, hematpoetc and rel tiss</td></tr><tr><td>C96.0</td><td style=\"color: #cccccc\">Multifocal and multisystemic Langerhans-cell histiocytosis</td></tr><tr><td>C96.2</td><td style=\"color: #cccccc\">Malignant mast cell neoplasm</td></tr><tr><td>C96.20</td><td style=\"color: #cccccc\">Malignant mast cell neoplasm, unspecified</td></tr><tr><td>C96.21</td><td style=\"color: #cccccc\">Aggressive systemic mastocytosis</td></tr><tr><td>C96.22</td><td style=\"color: #cccccc\">Mast cell sarcoma</td></tr><tr><td>C96.29</td><td style=\"color: #cccccc\">Other malignant mast cell neoplasm</td></tr><tr><td>C96.4</td><td style=\"color: #cccccc\">Sarcoma of dendritic cells (accessory cells)</td></tr><tr><td>C96.5</td><td style=\"color: #cccccc\">Multifocal and unisystemic Langerhans-cell histiocytosis</td></tr><tr><td>C96.6</td><td style=\"color: #cccccc\">Unifocal Langerhans-cell histiocytosis</td></tr><tr><td>C96.9</td><td style=\"color: #cccccc\">Malig neoplm of lymphoid, hematpoetc and rel tissue, unsp</td></tr><tr><td>C96.A</td><td style=\"color: #cccccc\">Histiocytic sarcoma</td></tr><tr><td>C96.Z</td><td style=\"color: #cccccc\">Oth malig neoplm of lymphoid, hematpoetc and related tissue</td></tr><tr><td>D00</td><td style=\"color: #cccccc\">Carcinoma in situ of oral cavity, esophagus and stomach</td></tr><tr><td>D00.0</td><td style=\"color: #cccccc\">Carcinoma in situ of lip, oral cavity and pharynx</td></tr><tr><td>D00.00</td><td style=\"color: #cccccc\">Carcinoma in situ of oral cavity, unspecified site</td></tr><tr><td>D00.01</td><td style=\"color: #cccccc\">Carcinoma in situ of labial mucosa and vermilion border</td></tr><tr><td>D00.02</td><td style=\"color: #cccccc\">Carcinoma in situ of buccal mucosa</td></tr><tr><td>D00.03</td><td style=\"color: #cccccc\">Carcinoma in situ of gingiva and edentulous alveolar ridge</td></tr><tr><td>D00.04</td><td style=\"color: #cccccc\">Carcinoma in situ of soft palate</td></tr><tr><td>D00.05</td><td style=\"color: #cccccc\">Carcinoma in situ of hard palate</td></tr><tr><td>D00.06</td><td style=\"color: #cccccc\">Carcinoma in situ of floor of mouth</td></tr><tr><td>D00.07</td><td style=\"color: #cccccc\">Carcinoma in situ of tongue</td></tr><tr><td>D00.08</td><td style=\"color: #cccccc\">Carcinoma in situ of pharynx</td></tr><tr><td>D00.1</td><td style=\"color: #cccccc\">Carcinoma in situ of esophagus</td></tr><tr><td>D00.2</td><td style=\"color: #cccccc\">Carcinoma in situ of stomach</td></tr><tr><td>D01</td><td style=\"color: #cccccc\">Carcinoma in situ of other and unspecified digestive organs</td></tr><tr><td>D01.0</td><td style=\"color: #cccccc\">Carcinoma in situ of colon</td></tr><tr><td>D01.1</td><td style=\"color: #cccccc\">Carcinoma in situ of rectosigmoid junction</td></tr><tr><td>D01.2</td><td style=\"color: #cccccc\">Carcinoma in situ of rectum</td></tr><tr><td>D01.3</td><td style=\"color: #cccccc\">Carcinoma in situ of anus and anal canal</td></tr><tr><td>D01.4</td><td style=\"color: #cccccc\">Carcinoma in situ of other and unsp parts of intestine</td></tr><tr><td>D01.40</td><td style=\"color: #cccccc\">Carcinoma in situ of unspecified part of intestine</td></tr><tr><td>D01.49</td><td style=\"color: #cccccc\">Carcinoma in situ of other parts of intestine</td></tr><tr><td>D01.5</td><td style=\"color: #cccccc\">Carcinoma in situ of liver, gallbladder and bile ducts</td></tr><tr><td>D01.7</td><td style=\"color: #cccccc\">Carcinoma in situ of other specified digestive organs</td></tr><tr><td>D01.9</td><td style=\"color: #cccccc\">Carcinoma in situ of digestive organ, unspecified</td></tr><tr><td>D02</td><td style=\"color: #cccccc\">Carcinoma in situ of middle ear and respiratory system</td></tr><tr><td>D02.0</td><td style=\"color: #cccccc\">Carcinoma in situ of larynx</td></tr><tr><td>D02.1</td><td style=\"color: #cccccc\">Carcinoma in situ of trachea</td></tr><tr><td>D02.2</td><td style=\"color: #cccccc\">Carcinoma in situ of bronchus and lung</td></tr><tr><td>D02.20</td><td style=\"color: #cccccc\">Carcinoma in situ of unspecified bronchus and lung</td></tr><tr><td>D02.21</td><td style=\"color: #cccccc\">Carcinoma in situ of right bronchus and lung</td></tr><tr><td>D02.22</td><td style=\"color: #cccccc\">Carcinoma in situ of left bronchus and lung</td></tr><tr><td>D02.3</td><td style=\"color: #cccccc\">Carcinoma in situ of other parts of respiratory system</td></tr><tr><td>D02.4</td><td style=\"color: #cccccc\">Carcinoma in situ of respiratory system, unspecified</td></tr><tr><td>D03</td><td style=\"color: #cccccc\">Melanoma in situ</td></tr><tr><td>D03.0</td><td style=\"color: #cccccc\">Melanoma in situ of lip</td></tr><tr><td>D03.1</td><td style=\"color: #cccccc\">Melanoma in situ of eyelid, including canthus</td></tr><tr><td>D03.10</td><td style=\"color: #cccccc\">Melanoma in situ of unspecified eyelid, including canthus</td></tr><tr><td>D03.11</td><td style=\"color: #cccccc\">Melanoma in situ of right eyelid, including canthus</td></tr><tr><td>D03.111</td><td style=\"color: #cccccc\">Melanoma in situ of right upper eyelid, including canthus</td></tr><tr><td>D03.112</td><td style=\"color: #cccccc\">Melanoma in situ of right lower eyelid, including canthus</td></tr><tr><td>D03.12</td><td style=\"color: #cccccc\">Melanoma in situ of left eyelid, including canthus</td></tr><tr><td>D03.121</td><td style=\"color: #cccccc\">Melanoma in situ of left upper eyelid, including canthus</td></tr><tr><td>D03.122</td><td style=\"color: #cccccc\">Melanoma in situ of left lower eyelid, including canthus</td></tr><tr><td>D03.2</td><td style=\"color: #cccccc\">Melanoma in situ of ear and external auricular canal</td></tr><tr><td>D03.20</td><td style=\"color: #cccccc\">Melanoma in situ of unsp ear and external auricular canal</td></tr><tr><td>D03.21</td><td style=\"color: #cccccc\">Melanoma in situ of right ear and external auricular canal</td></tr><tr><td>D03.22</td><td style=\"color: #cccccc\">Melanoma in situ of left ear and external auricular canal</td></tr><tr><td>D03.3</td><td style=\"color: #cccccc\">Melanoma in situ of other and unspecified parts of face</td></tr><tr><td>D03.30</td><td style=\"color: #cccccc\">Melanoma in situ of unspecified part of face</td></tr><tr><td>D03.39</td><td style=\"color: #cccccc\">Melanoma in situ of other parts of face</td></tr><tr><td>D03.4</td><td style=\"color: #cccccc\">Melanoma in situ of scalp and neck</td></tr><tr><td>D03.5</td><td style=\"color: #cccccc\">Melanoma in situ of trunk</td></tr><tr><td>D03.51</td><td style=\"color: #cccccc\">Melanoma in situ of anal skin</td></tr><tr><td>D03.52</td><td style=\"color: #cccccc\">Melanoma in situ of breast (skin) (soft tissue)</td></tr><tr><td>D03.59</td><td style=\"color: #cccccc\">Melanoma in situ of other part of trunk</td></tr><tr><td>D03.6</td><td style=\"color: #cccccc\">Melanoma in situ of upper limb, including shoulder</td></tr><tr><td>D03.60</td><td style=\"color: #cccccc\">Melanoma in situ of unsp upper limb, including shoulder</td></tr><tr><td>D03.61</td><td style=\"color: #cccccc\">Melanoma in situ of right upper limb, including shoulder</td></tr><tr><td>D03.62</td><td style=\"color: #cccccc\">Melanoma in situ of left upper limb, including shoulder</td></tr><tr><td>D03.7</td><td style=\"color: #cccccc\">Melanoma in situ of lower limb, including hip</td></tr><tr><td>D03.70</td><td style=\"color: #cccccc\">Melanoma in situ of unspecified lower limb, including hip</td></tr><tr><td>D03.71</td><td style=\"color: #cccccc\">Melanoma in situ of right lower limb, including hip</td></tr><tr><td>D03.72</td><td style=\"color: #cccccc\">Melanoma in situ of left lower limb, including hip</td></tr><tr><td>D03.8</td><td style=\"color: #cccccc\">Melanoma in situ of other sites</td></tr><tr><td>D03.9</td><td style=\"color: #cccccc\">Melanoma in situ, unspecified</td></tr><tr><td>D05</td><td style=\"color: #cccccc\">Carcinoma in situ of breast</td></tr><tr><td>D05.0</td><td style=\"color: #cccccc\">Lobular carcinoma in situ of breast</td></tr><tr><td>D05.00</td><td style=\"color: #cccccc\">Lobular carcinoma in situ of unspecified breast</td></tr><tr><td>D05.01</td><td style=\"color: #cccccc\">Lobular carcinoma in situ of right breast</td></tr><tr><td>D05.02</td><td style=\"color: #cccccc\">Lobular carcinoma in situ of left breast</td></tr><tr><td>D05.1</td><td style=\"color: #cccccc\">Intraductal carcinoma in situ of breast</td></tr><tr><td>D05.10</td><td style=\"color: #cccccc\">Intraductal carcinoma in situ of unspecified breast</td></tr><tr><td>D05.11</td><td style=\"color: #cccccc\">Intraductal carcinoma in situ of right breast</td></tr><tr><td>D05.12</td><td style=\"color: #cccccc\">Intraductal carcinoma in situ of left breast</td></tr><tr><td>D05.8</td><td style=\"color: #cccccc\">Other specified type of carcinoma in situ of breast</td></tr><tr><td>D05.80</td><td style=\"color: #cccccc\">Oth type of carcinoma in situ of unspecified breast</td></tr><tr><td>D05.81</td><td style=\"color: #cccccc\">Other specified type of carcinoma in situ of right breast</td></tr><tr><td>D05.82</td><td style=\"color: #cccccc\">Other specified type of carcinoma in situ of left breast</td></tr><tr><td>D05.9</td><td style=\"color: #cccccc\">Unspecified type of carcinoma in situ of breast</td></tr><tr><td>D05.90</td><td style=\"color: #cccccc\">Unspecified type of carcinoma in situ of unspecified breast</td></tr><tr><td>D05.91</td><td style=\"color: #cccccc\">Unspecified type of carcinoma in situ of right breast</td></tr><tr><td>D05.92</td><td style=\"color: #cccccc\">Unspecified type of carcinoma in situ of left breast</td></tr><tr><td>D07</td><td style=\"color: #cccccc\">Carcinoma in situ of other and unspecified genital organs</td></tr><tr><td>D07.0</td><td style=\"color: #cccccc\">Carcinoma in situ of endometrium</td></tr><tr><td>D07.1</td><td style=\"color: #cccccc\">Carcinoma in situ of vulva</td></tr><tr><td>D07.2</td><td style=\"color: #cccccc\">Carcinoma in situ of vagina</td></tr><tr><td>D07.3</td><td style=\"color: #cccccc\">Carcinoma in situ of other and unsp female genital organs</td></tr><tr><td>D07.30</td><td style=\"color: #cccccc\">Carcinoma in situ of unspecified female genital organs</td></tr><tr><td>D07.39</td><td style=\"color: #cccccc\">Carcinoma in situ of other female genital organs</td></tr><tr><td>D07.4</td><td style=\"color: #cccccc\">Carcinoma in situ of penis</td></tr><tr><td>D07.6</td><td style=\"color: #cccccc\">Carcinoma in situ of other and unsp male genital organs</td></tr><tr><td>D07.60</td><td style=\"color: #cccccc\">Carcinoma in situ of unspecified male genital organs</td></tr><tr><td>D07.61</td><td style=\"color: #cccccc\">Carcinoma in situ of scrotum</td></tr><tr><td>D07.69</td><td style=\"color: #cccccc\">Carcinoma in situ of other male genital organs</td></tr><tr><td>D09</td><td style=\"color: #cccccc\">Carcinoma in situ of other and unspecified sites</td></tr><tr><td>D09.0</td><td style=\"color: #cccccc\">Carcinoma in situ of bladder</td></tr><tr><td>D09.1</td><td style=\"color: #cccccc\">Carcinoma in situ of other and unspecified urinary organs</td></tr><tr><td>D09.10</td><td style=\"color: #cccccc\">Carcinoma in situ of unspecified urinary organ</td></tr><tr><td>D09.19</td><td style=\"color: #cccccc\">Carcinoma in situ of other urinary organs</td></tr><tr><td>D09.2</td><td style=\"color: #cccccc\">Carcinoma in situ of eye</td></tr><tr><td>D09.20</td><td style=\"color: #cccccc\">Carcinoma in situ of unspecified eye</td></tr><tr><td>D09.21</td><td style=\"color: #cccccc\">Carcinoma in situ of right eye</td></tr><tr><td>D09.22</td><td style=\"color: #cccccc\">Carcinoma in situ of left eye</td></tr><tr><td>D09.3</td><td style=\"color: #cccccc\">Carcinoma in situ of thyroid and other endocrine glands</td></tr><tr><td>D09.8</td><td style=\"color: #cccccc\">Carcinoma in situ of other specified sites</td></tr><tr><td>D09.9</td><td style=\"color: #cccccc\">Carcinoma in situ, unspecified</td></tr><tr><td>D18.02</td><td style=\"color: #cccccc\">Hemangioma of intracranial structures</td></tr><tr><td>D32</td><td style=\"color: #cccccc\">Benign neoplasm of meninges</td></tr><tr><td>D32.0</td><td style=\"color: #cccccc\">Benign neoplasm of cerebral meninges</td></tr><tr><td>D32.1</td><td style=\"color: #cccccc\">Benign neoplasm of spinal meninges</td></tr><tr><td>D32.9</td><td style=\"color: #cccccc\">Benign neoplasm of meninges, unspecified</td></tr><tr><td>D33</td><td style=\"color: #cccccc\">Benign neoplasm of brain and oth prt central nervous system</td></tr><tr><td>D33.0</td><td style=\"color: #cccccc\">Benign neoplasm of brain, supratentorial</td></tr><tr><td>D33.1</td><td style=\"color: #cccccc\">Benign neoplasm of brain, infratentorial</td></tr><tr><td>D33.2</td><td style=\"color: #cccccc\">Benign neoplasm of brain, unspecified</td></tr><tr><td>D33.3</td><td style=\"color: #cccccc\">Benign neoplasm of cranial nerves</td></tr><tr><td>D33.4</td><td style=\"color: #cccccc\">Benign neoplasm of spinal cord</td></tr><tr><td>D33.7</td><td style=\"color: #cccccc\">Benign neoplasm of oth parts of central nervous system</td></tr><tr><td>D33.9</td><td style=\"color: #cccccc\">Benign neoplasm of central nervous system, unspecified</td></tr><tr><td>D35.2</td><td style=\"color: #cccccc\">Benign neoplasm of pituitary gland</td></tr><tr><td>D35.3</td><td style=\"color: #cccccc\">Benign neoplasm of craniopharyngeal duct</td></tr><tr><td>D35.4</td><td style=\"color: #cccccc\">Benign neoplasm of pineal gland</td></tr><tr><td>D42</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of meninges</td></tr><tr><td>D42.0</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of cerebral meninges</td></tr><tr><td>D42.1</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of spinal meninges</td></tr><tr><td>D42.9</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of meninges, unspecified</td></tr><tr><td>D43</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of brain and cnsl</td></tr><tr><td>D43.0</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of brain, supratentorial</td></tr><tr><td>D43.1</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of brain, infratentorial</td></tr><tr><td>D43.2</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of brain, unspecified</td></tr><tr><td>D43.3</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of cranial nerves</td></tr><tr><td>D43.4</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of spinal cord</td></tr><tr><td>D43.8</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of prt central nervous system</td></tr><tr><td>D43.9</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of cnsl, unsp</td></tr><tr><td>D44.3</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of pituitary gland</td></tr><tr><td>D44.4</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of craniopharyngeal duct</td></tr><tr><td>D44.5</td><td style=\"color: #cccccc\">Neoplasm of uncertain behavior of pineal gland</td></tr><tr><td>D45</td><td style=\"color: #cccccc\">Polycythemia vera</td></tr><tr><td>D46</td><td style=\"color: #cccccc\">Myelodysplastic syndromes</td></tr><tr><td>D46.0</td><td style=\"color: #cccccc\">Refractory anemia without ring sideroblasts, so stated</td></tr><tr><td>D46.1</td><td style=\"color: #cccccc\">Refractory anemia with ring sideroblasts</td></tr><tr><td>D46.2</td><td style=\"color: #cccccc\">Refractory anemia with excess of blasts [RAEB]</td></tr><tr><td>D46.20</td><td style=\"color: #cccccc\">Refractory anemia with excess of blasts, unspecified</td></tr><tr><td>D46.21</td><td style=\"color: #cccccc\">Refractory anemia with excess of blasts 1</td></tr><tr><td>D46.22</td><td style=\"color: #cccccc\">Refractory anemia with excess of blasts 2</td></tr><tr><td>D46.4</td><td style=\"color: #cccccc\">Refractory anemia, unspecified</td></tr><tr><td>D46.9</td><td style=\"color: #cccccc\">Myelodysplastic syndrome, unspecified</td></tr><tr><td>D46.A</td><td style=\"color: #cccccc\">Refractory cytopenia with multilineage dysplasia</td></tr><tr><td>D46.B</td><td style=\"color: #cccccc\">Refract cytopenia w multilin dysplasia and ring sideroblasts</td></tr><tr><td>D46.C</td><td style=\"color: #cccccc\">Myelodysplastic syndrome w isolated del(5q) chromsoml abnlt</td></tr><tr><td>D46.Z</td><td style=\"color: #cccccc\">Other myelodysplastic syndromes</td></tr><tr><td>D47.02</td><td style=\"color: #cccccc\">Systemic mastocytosis</td></tr><tr><td>D47.1</td><td style=\"color: #cccccc\">Chronic myeloproliferative disease</td></tr><tr><td>D47.3</td><td style=\"color: #cccccc\">Essential (hemorrhagic) thrombocythemia</td></tr><tr><td>D47.4</td><td style=\"color: #cccccc\">Osteomyelofibrosis</td></tr><tr><td>D47.9</td><td style=\"color: #cccccc\">Neoplm of uncrt behav of lymphoid,hematpoetc &amp; rel tiss,unsp</td></tr><tr><td>D47.Z</td><td style=\"color: #cccccc\">Oth neoplm of uncrt behav of lymphoid, hematpoetc &amp; rel tiss</td></tr><tr><td>D47.Z1</td><td style=\"color: #cccccc\">Post-transplant lymphoproliferative disorder (PTLD)</td></tr><tr><td>D47.Z9</td><td style=\"color: #cccccc\">Oth neoplm of uncrt behav of lymphoid, hematpoetc &amp; rel tiss</td></tr><tr><td>D49.6</td><td style=\"color: #cccccc\">Neoplasm of unspecified behavior of brain</td></tr><tr><td>D49.7</td><td style=\"color: #cccccc\">Neoplm of unsp behav of endo glands and oth prt nervous sys</td></tr><tr><td>D72.110</td><td style=\"color: #cccccc\">Idiopathic hypereosinophilic syndrome [IHES]</td></tr><tr><td>D72.111</td><td style=\"color: #cccccc\">Lymphocytic Variant Hypereosinophilic Syndrome [LHES]</td></tr><tr><td>D72.118</td><td style=\"color: #cccccc\">Other hypereosinophilic syndrome</td></tr><tr><td>D72.119</td><td style=\"color: #cccccc\">Hypereosinophilic syndrome [HES], unspecified</td></tr><tr><td>R85.614</td><td style=\"color: #cccccc\">Cytologic evidence of malignancy on smear of anus</td></tr><tr><td>R87.624</td><td style=\"color: #cccccc\">Cytologic evidence of malignancy on smear of vagina</td></tr></table></li></ul></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/artifact-author",
            "valueContactDetail" : {
              "name" : "Example Author"
            }
          }
        ],
        "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ValueSet/cancer-core-reportability-codes-example",
        "identifier" : [
          {
            "system" : "urn:ietf:rfc:3986",
            "value" : "urn:oid:2.16.840.1.113883.4.642.40.40.48.1"
          }
        ],
        "version" : "1.0.0",
        "name" : "CancerCoreReportabilityCodes",
        "title" : "Cancer Core Reportability Codes",
        "status" : "active",
        "experimental" : false,
        "date" : "2021-11-22",
        "publisher" : "HL7 International / Public Health",
        "contact" : [
          {
            "telecom" : [
              {
                "system" : "url",
                "value" : "http://www.hl7.org/Special/committees/pher"
              }
            ]
          }
        ],
        "description" : "The valueset contains SNOMED-CT and ICD-10-CM codes for Central Cancer Registry Reportability determination. These are just sample codes and the actual value set will be    published by the Central Cancer Registry.",
        "useContext" : [
          {
            "code" : {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-usage-context-type",
              "code" : "priority",
              "display" : "Priority"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-usage-context",
                  "code" : "triggering",
                  "display" : "Triggering"
                }
              ]
            }
          }
        ],
        "jurisdiction" : [
          {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "US"
              }
            ]
          }
        ],
        "copyright" : "This value set includes content from:\n  1. This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement.  2. ICD-9 and ICD-10 are copyrighted by the World Health Organization (WHO) which owns and publishes the classification. See https://www.who.int/classifications/icd/en. WHO has authorized the development of an adaptation of ICD-9 and ICD-10 to ICD-9-CM to ICD-10-CM for use in the United States for U.S. government purposes.\n",
        "compose" : {
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "109841003",
                  "display" : "Liver cell carcinoma (disorder)"
                },
                {
                  "code" : "94391008",
                  "display" : "Metastatic malignant neoplasm to lung (disorder)"
                },
                {
                  "code" : "417181009",
                  "display" : "Hormone receptor positive malignant neoplasm of breast (disorder)"
                },
                {
                  "code" : "424993006",
                  "display" : "Adenocarcinoma of lung, stage IV (disorder)"
                },
                {
                  "code" : "722546002",
                  "display" : "Probable rabies (situation)"
                }
              ]
            }
          ]
        },
        "expansion" : {
          "timestamp" : "2024-07-01T16:17:46-04:00",
          "contains" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "2024-03",
              "code" : "109841003"
            },
            {
              "system" : "http://snomed.info/sct",
              "version" : "2024-03",
              "code" : "94391008"
            },
            {
              "system" : "http://snomed.info/sct",
              "version" : "2024-03",
              "code" : "417181009"
            },
            {
              "system" : "http://snomed.info/sct",
              "version" : "2024-03",
              "code" : "424993006"
            },
            {
              "system" : "http://snomed.info/sct",
              "version" : "2024-03",
              "code" : "722546002"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/PlanDefinition/pccrre",
      "resource" : {
        "resourceType" : "PlanDefinition",
        "id" : "pccrre",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2020-11-29T02:03:28.045+00:00",
          "profile" : [
            "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-plandefinition"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PlanDefinition_pccrre\"> </a><p><b>CCRR PlanDefinition Example</b></p></div>"
        },
        "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/pccrre",
        "version" : "1.0",
        "name" : "CentralCancerRegistryReportingExample",
        "title" : "PlanDefinition Central Cancer Registry Reporting Example",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/plan-definition-type",
              "code" : "workflow-definition",
              "display" : "Workflow Definition"
            }
          ]
        },
        "status" : "draft",
        "experimental" : true,
        "date" : "2020-11-04T12:32:29.858-05:00",
        "publisher" : "HL7 Public Health Work Group",
        "description" : "This is the Healthcare Survey Reporting Knowledge Artifact",
        "effectivePeriod" : {
          "start" : "2021-11-01"
        },
        "relatedArtifact" : [
          {
            "type" : "depends-on",
            "label" : "Central Cancer Registry Trigger Codes",
            "resource" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ValueSet/cancer-core-reportability-codes-example"
          }
        ],
        "action" : [
          {
            "id" : "start-workflow",
            "description" : "This action represents the start of the reporting workflow in response to the encounter-close event",
            "textEquivalent" : "Start the reporting workflow in response to an encounter-close event",
            "code" : [
              {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                    "code" : "initiate-reporting-workflow"
                  }
                ]
              }
            ],
            "trigger" : [
              {
                "id" : "encounter-close",
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-named-eventtype-extension",
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-triggerdefinition-namedevents",
                          "code" : "encounter-close",
                          "display" : "Indicates the close of an encounter"
                        }
                      ]
                    }
                  }
                ],
                "type" : "named-event",
                "name" : "encounter-close"
              }
            ],
            "relatedAction" : [
              {
                "actionId" : "check-reportable",
                "relationship" : "before-start",
                "offsetDuration" : {
                  "value" : 72,
                  "system" : "http://unitsofmeasure.org",
                  "code" : "h"
                }
              }
            ]
          },
          {
            "id" : "check-reportable",
            "description" : "This action represents the check for suspected reportability of the cancer data.",
            "textEquivalent" : "Check Reportability and setup jobs for future reportability checks.",
            "code" : [
              {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                    "code" : "execute-reporting-workflow"
                  }
                ]
              }
            ],
            "action" : [
              {
                "id" : "is-encounter-reportable",
                "description" : "This action represents the check for reportability to create the patients eICR.",
                "textEquivalent" : "Check Trigger Codes based on RCTC Value sets.",
                "code" : [
                  {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                        "code" : "check-trigger-codes"
                      }
                    ]
                  }
                ],
                "condition" : [
                  {
                    "kind" : "applicability",
                    "expression" : {
                      "language" : "text/fhirpath",
                      "expression" : "%conditions.exists()"
                    }
                  }
                ],
                "input" : [
                  {
                    "id" : "conditions",
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-fhirquerypattern-extension",
                        "valueString" : "Condition?patient=Patient/{{context.patientId}}"
                      }
                    ],
                    "type" : "Condition",
                    "codeFilter" : [
                      {
                        "path" : "code",
                        "valueSet" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ValueSet/cancer-core-reportability-codes-example"
                      }
                    ]
                  }
                ],
                "relatedAction" : [
                  {
                    "actionId" : "report-cancer-data",
                    "relationship" : "before-start"
                  }
                ]
              },
              {
                "id" : "should-continue-reporting",
                "code" : [
                  {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                        "code" : "evaluate-condition"
                      }
                    ]
                  }
                ],
                "condition" : [
                  {
                    "kind" : "applicability",
                    "expression" : {
                      "language" : "text/fhirpath",
                      "expression" : "%patient.deceased[x] == null && (currentTime - previousReportSubmissionTime) < 7776000"
                    }
                  }
                ],
                "relatedAction" : [
                  {
                    "actionId" : "check-reportable",
                    "relationship" : "before-start",
                    "offsetDuration" : {
                      "value" : 6,
                      "system" : "http://unitsofmeasure.org",
                      "code" : "mo"
                    }
                  }
                ]
              }
            ]
          },
          {
            "id" : "report-cancer-data",
            "description" : "This action represents the creation, validation and submission of the cancer report.",
            "textEquivalent" : "Check Reportability and setup jobs for future reportability checks.",
            "code" : [
              {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                    "code" : "execute-reporting-workflow"
                  }
                ]
              }
            ],
            "action" : [
              {
                "id" : "create-cancer-report",
                "description" : "This action represents the creation of the cancer report.",
                "textEquivalent" : "Central Cancer Registry Report",
                "code" : [
                  {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                        "code" : "create-report"
                      }
                    ]
                  }
                ],
                "input" : [
                  {
                    "id" : "patient",
                    "type" : "Patient",
                    "profile" : [
                      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-patient"
                    ]
                  },
                  {
                    "id" : "condition",
                    "type" : "Condition",
                    "profile" : [
                      "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-primary-cancer-condition"
                    ]
                  },
                  {
                    "id" : "encounter",
                    "type" : "Encounter",
                    "profile" : [
                      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-encounter"
                    ]
                  },
                  {
                    "id" : "mr",
                    "type" : "MedicationRequest",
                    "profile" : [
                      "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-cancer-related-medication-request"
                    ]
                  },
                  {
                    "id" : "vitals",
                    "type" : "Observation",
                    "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
                  },
                  {
                    "id" : "labs",
                    "type" : "Observation",
                    "profile" : [
                      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0"
                    ]
                  }
                ],
                "output" : [
                  {
                    "id" : "cancer-report",
                    "type" : "Bundle",
                    "profile" : [
                      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-reporting-bundle"
                    ]
                  }
                ],
                "relatedAction" : [
                  {
                    "actionId" : "validate-report",
                    "relationship" : "before-start"
                  }
                ]
              },
              {
                "id" : "validate-cancer-report",
                "description" : "This action represents the validation of the cancer report.",
                "textEquivalent" : "Validate Report",
                "code" : [
                  {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                        "code" : "validate-report"
                      }
                    ]
                  }
                ],
                "input" : [
                  {
                    "id" : "created-cancer-report",
                    "type" : "Bundle",
                    "profile" : [
                      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-reporting-bundle"
                    ]
                  }
                ],
                "output" : [
                  {
                    "id" : "validated-cancer-report",
                    "type" : "Bundle",
                    "profile" : [
                      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-reporting-bundle"
                    ]
                  }
                ],
                "relatedAction" : [
                  {
                    "actionId" : "submit-report",
                    "relationship" : "before-start"
                  }
                ]
              },
              {
                "id" : "route-and-send-cancer-report",
                "description" : "This action represents the routing and sending of the cancer report.",
                "textEquivalent" : "Route and send cancer report",
                "code" : [
                  {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                        "code" : "submit-report"
                      }
                    ]
                  }
                ],
                "input" : [
                  {
                    "id" : "val-cancer-report",
                    "type" : "Bundle",
                    "profile" : [
                      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-reporting-bundle"
                    ]
                  }
                ]
              }
            ]
          }
        ]
      }
    }
  ]
}

```
