# Useful Downloads - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Useful Downloads**

## Useful Downloads

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Download

You can also download:

* [this entire guide](full-ig.zip)
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), [ttl](definitions.ttl.zip), or [csv](csvs.zip) format, or
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

#### Expansion Params

* Parameter: system-version
  * Value: SNOMED CT[US]

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.central-cancer-registry-reporting.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.central-cancer-registry-reporting.r4b)](package.r4b.tgz) are available.

#### Dependency Table














#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [Bundle/central-cancer-registry-reporting-specification-bundle-example](Bundle-central-cancer-registry-reporting-specification-bundle-example.md), [CancerCoreReportabilityCodes](ValueSet-cancer-core-reportability-codes.md)...Show 13 more,[CancerStatusEvidenceType](StructureDefinition-cancer-status-evidence-type.md),[CcrrComposition](StructureDefinition-ccrr-composition.md),[CentralCancerRegistryReporting](index.md),[CentralCancerRegistryReportingBundle](StructureDefinition-ccrr-reporting-bundle.md),[CentralCancerRegistryReportingContentBundle](StructureDefinition-ccrr-content-bundle.md),[CentralCancerRegistryReportingEHRCapabilityStatement](CapabilityStatement-central-cancer-registry-reporting-ehr.md),[CentralCancerRegistryReportingEncounter](StructureDefinition-central-cancer-registry-reporting-encounter.md),[CentralCancerRegistryReportingExample](PlanDefinition-plandefinition-central-cancer-registry-reporting-example.md),[CentralCancerRegistryReportingMessageHeader](StructureDefinition-central-cancer-registry-reporting-messageheader.md),[CentralCancerRegistryReportingOrganization](StructureDefinition-central-cancer-registry-reporting-organization.md),[CentralCancerRegistryReportingPatient](StructureDefinition-central-cancer-registry-reporting-patient.md),[CentralCancerRegistryReportingPlanDefinition](StructureDefinition-ccrr-plandefinition.md)and[CentralCancerRegistryReportingPrimaryCancerCondition](StructureDefinition-central-cancer-registry-primary-cancer-condition.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission.For information and exceptions regarding use of CDC material please see [https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html).

* [CDC Race and Ethnicity](http://terminology.hl7.org/6.5.0/CodeSystem-CDCREC.html): [Patient/example](Patient-example.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/ccrr-non-encounter-based-content-bundle-example](Bundle-ccrr-non-encounter-based-content-bundle-example.md), [MedicationAdministration/cancer-med-admin-docetaxel-example](MedicationAdministration-cancer-med-admin-docetaxel-example.md) and [Observation/odh-usual-work](Observation-odh-usual-work.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/ccrr-content-bundle-example](Bundle-ccrr-content-bundle-example.md), [Bundle/ccrr-encounter-based-content-bundle-example](Bundle-ccrr-encounter-based-content-bundle-example.md)...Show 9 more,[Bundle/ccrr-non-encounter-based-content-bundle-example](Bundle-ccrr-non-encounter-based-content-bundle-example.md),[Bundle/reporting-bundle-example](Bundle-reporting-bundle-example.md),[CcrrComposition](StructureDefinition-ccrr-composition.md),[Composition/ccrr-composition-example](Composition-ccrr-composition-example.md),[Observation/cancer-stage-group-example](Observation-cancer-stage-group-example.md),[Observation/non-smoker](Observation-non-smoker.md),[Observation/odh-usual-work](Observation-odh-usual-work.md),[Observation/tnm-clinical-primary-tumor-category-cT2](Observation-tnm-clinical-primary-tumor-category-cT2.md)and[Observation/tnm-clinical-regional-nodes-category-cN0](Observation-tnm-clinical-regional-nodes-category-cN0.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [Bundle/ccrr-content-bundle-example](Bundle-ccrr-content-bundle-example.md), [Bundle/ccrr-encounter-based-content-bundle-example](Bundle-ccrr-encounter-based-content-bundle-example.md)...Show 18 more,[Bundle/ccrr-non-encounter-based-content-bundle-example](Bundle-ccrr-non-encounter-based-content-bundle-example.md),[Bundle/reporting-bundle-example](Bundle-reporting-bundle-example.md),[CancerCoreReportabilityCodes](ValueSet-cancer-core-reportability-codes.md),[CancerStatusEvidenceType](StructureDefinition-cancer-status-evidence-type.md),[CcrrComposition](StructureDefinition-ccrr-composition.md),[Composition/ccrr-composition-example](Composition-ccrr-composition-example.md),[Condition/primary-cancer-condition-breast](Condition-primary-cancer-condition-breast.md),[Encounter/encounter-cancer-example](Encounter-encounter-cancer-example.md),[Encounter/encounter-cancer-example-radiation](Encounter-encounter-cancer-example-radiation.md),[Encounter/encounter-cancer-example-surgery](Encounter-encounter-cancer-example-surgery.md),[MedicationAdministration/cancer-med-admin-docetaxel-example](MedicationAdministration-cancer-med-admin-docetaxel-example.md),[Observation/cancer-stage-group-example](Observation-cancer-stage-group-example.md),[Observation/non-smoker](Observation-non-smoker.md),[Observation/tnm-clinical-distant-metastases-category-cM0](Observation-tnm-clinical-distant-metastases-category-cM0.md),[Observation/tnm-clinical-primary-tumor-category-cT2](Observation-tnm-clinical-primary-tumor-category-cT2.md),[Observation/tnm-clinical-regional-nodes-category-cN0](Observation-tnm-clinical-regional-nodes-category-cN0.md),[Procedure/cancer-related-surgical-procedure-lumpectomy](Procedure-cancer-related-surgical-procedure-lumpectomy.md)and[Procedure/radiotherapy-example](Procedure-radiotherapy-example.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-category.html): [Bundle/ccrr-content-bundle-example](Bundle-ccrr-content-bundle-example.md), [Bundle/ccrr-encounter-based-content-bundle-example](Bundle-ccrr-encounter-based-content-bundle-example.md)...Show 4 more,[Bundle/ccrr-non-encounter-based-content-bundle-example](Bundle-ccrr-non-encounter-based-content-bundle-example.md),[CentralCancerRegistryReportingPrimaryCancerCondition](StructureDefinition-central-cancer-registry-primary-cancer-condition.md),[Condition/primary-cancer-condition-breast](Condition-primary-cancer-condition-breast.md)and[Condition/problem-list-diabetes](Condition-problem-list-diabetes.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-clinical.html): [Bundle/ccrr-content-bundle-example](Bundle-ccrr-content-bundle-example.md), [Bundle/ccrr-encounter-based-content-bundle-example](Bundle-ccrr-encounter-based-content-bundle-example.md), [Bundle/ccrr-non-encounter-based-content-bundle-example](Bundle-ccrr-non-encounter-based-content-bundle-example.md), [Condition/primary-cancer-condition-breast](Condition-primary-cancer-condition-breast.md) and [Condition/problem-list-diabetes](Condition-problem-list-diabetes.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.1/CodeSystem-condition-ver-status.html): [Bundle/ccrr-content-bundle-example](Bundle-ccrr-content-bundle-example.md), [Bundle/ccrr-encounter-based-content-bundle-example](Bundle-ccrr-encounter-based-content-bundle-example.md), [Bundle/ccrr-non-encounter-based-content-bundle-example](Bundle-ccrr-non-encounter-based-content-bundle-example.md), [Condition/primary-cancer-condition-breast](Condition-primary-cancer-condition-breast.md) and [Condition/problem-list-diabetes](Condition-problem-list-diabetes.md)
* [Endpoint Connection Type](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html): [HealthCareSenderAndReceiver](Endpoint-example-healthcare-endpoint.md) and [PHAReceiver](Endpoint-example-ph-endpoint.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [Bundle/ccrr-content-bundle-example](Bundle-ccrr-content-bundle-example.md), [Observation/cancer-stage-group-example](Observation-cancer-stage-group-example.md)...Show 4 more,[Observation/non-smoker](Observation-non-smoker.md),[Observation/tnm-clinical-distant-metastases-category-cM0](Observation-tnm-clinical-distant-metastases-category-cM0.md),[Observation/tnm-clinical-primary-tumor-category-cT2](Observation-tnm-clinical-primary-tumor-category-cT2.md)and[Observation/tnm-clinical-regional-nodes-category-cN0](Observation-tnm-clinical-regional-nodes-category-cN0.md)
* [PlanDefinitionType](http://terminology.hl7.org/7.0.1/CodeSystem-plan-definition-type.html): [Bundle/central-cancer-registry-reporting-specification-bundle-example](Bundle-central-cancer-registry-reporting-specification-bundle-example.md), [CentralCancerRegistryReportingExample](PlanDefinition-plandefinition-central-cancer-registry-reporting-example.md) and [CentralCancerRegistryReportingPlanDefinition](StructureDefinition-ccrr-plandefinition.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [Patient/example](Patient-example.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [Encounter/encounter-cancer-example](Encounter-encounter-cancer-example.md), [Encounter/encounter-cancer-example-radiation](Encounter-encounter-cancer-example-radiation.md) and [Encounter/encounter-cancer-example-surgery](Encounter-encounter-cancer-example-surgery.md)
* [MaritalStatus](http://terminology.hl7.org/7.0.1/CodeSystem-v3-MaritalStatus.html): [Patient/example](Patient-example.md)
* [ParticipationType](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ParticipationType.html): [CentralCancerRegistryReportingEncounter](StructureDefinition-central-cancer-registry-reporting-encounter.md) and [Encounter/encounter-cancer-example](Encounter-encounter-cancer-example.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/6.5.0/CodeSystem-v3-rxNorm.html): [Bundle/ccrr-non-encounter-based-content-bundle-example](Bundle-ccrr-non-encounter-based-content-bundle-example.md) and [MedicationAdministration/cancer-med-admin-docetaxel-example](MedicationAdministration-cancer-med-admin-docetaxel-example.md)


