# Central Cancer Registry Reporting Organization - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Organization**

## Resource Profile: Central Cancer Registry Reporting Organization 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-organization | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CentralCancerRegistryReportingOrganization |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40.42.7 | | |

 
This profile represents the organization related to the cancer event. It is based on the US Core Organization. 

**Usages:**

* Refer to this Profile: [Central Cancer Registry Reporting Composition](StructureDefinition-ccrr-composition.md), [Central Cancer Registry Reporting Encounter](StructureDefinition-central-cancer-registry-reporting-encounter.md) and [Central Cancer Registry Reporting Patient](StructureDefinition-central-cancer-registry-reporting-patient.md)
* Examples for this Profile: [Cancer Organization](Organization-example-cancer-org.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.central-cancer-registry-reporting|current/StructureDefinition/central-cancer-registry-reporting-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-central-cancer-registry-reporting-organization.csv), [Excel](StructureDefinition-central-cancer-registry-reporting-organization.xlsx), [Schematron](StructureDefinition-central-cancer-registry-reporting-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "central-cancer-registry-reporting-organization",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2025-07-30T02:41:12.847+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-organization",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.40.42.7"
    }
  ],
  "version" : "2.0.0-ballot",
  "name" : "CentralCancerRegistryReportingOrganization",
  "title" : "Central Cancer Registry Reporting Organization",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15T16:01:21+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "This profile represents the organization related to the cancer event. It is based on the US Core Organization.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "short" : "Central Cancer Registry Reporting Organization",
        "definition" : "This profile is based on the Organization resource and establishes the core elements, extensions, vocabularies and value sets for representing an organization for central cancer registry reporting."
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:NPI",
        "path" : "Organization.identifier",
        "sliceName" : "NPI",
        "short" : "National Provider Identifier (NPI)",
        "min" : 1,
        "max" : "1",
        "patternIdentifier" : {
          "system" : "http://hl7.org/fhir/sid/us-npi"
        },
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:CLIA",
        "path" : "Organization.identifier",
        "sliceName" : "CLIA",
        "short" : "Clinical Laboratory Improvement Amendments (CLIA) Number for laboratories",
        "patternIdentifier" : {
          "system" : "urn:oid:2.16.840.1.113883.4.7"
        },
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:NAIC",
        "path" : "Organization.identifier",
        "sliceName" : "NAIC",
        "short" : "NAIC Code",
        "patternIdentifier" : {
          "system" : "urn:oid:2.16.840.1.113883.6.300"
        },
        "mustSupport" : true
      }
    ]
  }
}

```
