# Central Cancer Registry Reporting Composition - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Composition**

## Resource Profile: Central Cancer Registry Reporting Composition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-composition | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CcrrComposition |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40.42.3 | | |

 
This Composition profile is used to organize the central cancer registry report content. 

### Introduction

This profile is used to represent the Central Cancer Registry Report Composition resource. The Composition resource is used as part of the Central Cancer Registry Reporting Content Bundle. The Composition resource is used to organize the information into different sections so that the receiver of the data can consume the data easily.

#### Profiles from Other IGs used as part of the Composition

The content is made up data elements from the following profiles from the other IGs as direct references or as base profiles.

From the Cancer Pathology Data Sharing IG:

* [US Pathology Diagnostic Report](http://hl7.org/fhir/us/cancer-reporting/STU2/StructureDefinition-us-pathology-diagnostic-report.html)

From the mCODE IG:

* [mCODE Secondary Cancer Condition Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-secondary-cancer-condition.html)
* [mCODE TNM Stage Group Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-tnm-stage-group.html)
* [mCODE TNM Distant Metastases Category Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-tnm-distant-metastases-category.html)
* [mCODE TNM Primary Tumor Category Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-tnm-primary-tumor-category.html)
* [mCODE TNM Regional Nodes Category Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-tnm-regional-nodes-category.html)
* [mCODE Cancer-Related Medication Request Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-cancer-related-medication-request.html)
* [mCODE Cancer-Related Medication Administration Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-cancer-related-medication-administration.html)
* [mCODE Radiotherapy Course Summary Profile](http://hl7.org/fhir/us/mcode/STU4/StructureDefinition-mcode-radiotherapy-course-summary.html)

From ODH IG:

* [Occupation Data for Health Usual Work Profile](http://hl7.org/fhir/us/odh/STU1.3/StructureDefinition-odh-UsualWork.html)

From US Core IG:

* [US Core CarePlan Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-careplan.html)
* [US Core Condition Encounter Diagnosis Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-condition-encounter-diagnosis.html)
* [US Core Condition Problems and Health Concerns Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-condition-problems-health-concerns.html)
* [US Core DiagnosticReport Profile for Laboratory Results Reporting](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-lab.html)
* [US Core DiagnosticReport Profile for Report and Note Exchange](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-note.html)
* [US Core DocumentReference Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-documentreference.html)
* [US Core Encounter Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html)
* [US Core Laboratory Result Observation Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-observation-lab.html)
* [US Core Medication Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-medication.html)
* [US Core Patient Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)
* [US Core Practitioner Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)
* [US Core PractitionerRole Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitionerrole.html)
* [US Core Procedure Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-procedure.html)
* [US Core ServiceRequest Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-servicerequest.html)
* [US Core Smoking Status Observation Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-smokingstatus.html)
* [US Core Vital Signs Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-vital-signs.html)

#### Guidance on populating the data for each section:

The following guidance is provided to the implementers to identify the data of interest which needs to be extracted and populated in the various sections of the Composition.

* Encounter Section: Any relevant Encounter(s).
* Primary Cancer Condition Section: Condition with a category of "encounter-diagnosis" for the closed encounter with a Condition.code value that is on the reportability list. All Conditions that do not have a clinicalStatus of inactive can be considered to determine the primary cancer condition along with a verificationStatus of confirmed when populated.
* Secondary Cancer Condition Section: Condition with a category of "encounter-diagnosis" for the closed encounter with a Condition.code that is present in the Secondary Cancer Disorder Value Set. Conditions that do not have a clinicalStatus of inactive can be considered to determine the secondary cancer condition along with a verificationStatus of confirmed when populated.
* TNM Staging Section: Observation(s) with the TNM stage group, primary tumor, regional nodes, and distant metastases information having a status of final, amended, or corrected.
* Radiotherapy Course Summary Section: Procedures with the radiotherapy course summary information having a status of completed, not-done, stopped, entered-in-error, unknown and a category of 1217123003-Radiotherapy course of treatment (regime/therapy).
* Problems Section: Underlying medical conditions and active problems. All Conditions that do not have a clinicalStatus of inactive and have a verificationStatus of confirmed when populated.
* Medications Administered Section: Cancer-related medications administered during the closed encounter with a status of completed, on-hold, in-progress, stopped, or unknown.
* Medications Section: Medications referenced by MedicationRequest and MedicationAdministration.
* ODH Section: Usual Work information for the patient with a status of final.
* Results Section: Results linked to the encounter or ordered during the encounter or results received during the encounter with a status of final.
* Notes Section: DiagnosticReports and Documents created during the encounter with a status of current or final.
* Procedures Section: Procedures performed during the closed encounter limited to status of completed or unknown.
* Plan of Treatment Section: Cancer-related medications and services requested during the closed encounter with a status of active, completed, cancelled, entered-in-error, stopped, unknown and an intent of order. Care plans associated with the patient with status = active.
* Vital Signs: All vital signs for the encounter with status of final, corrected, unknown or amended.
* Social History Section: Smoking status associated with the patient with status of final.

**Usages:**

* Use this Profile: [Central Cancer Registry Reporting Content Bundle](StructureDefinition-ccrr-content-bundle.md)
* Examples for this Profile: [Composition/ccrr-composition-example](Composition-ccrr-composition-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.central-cancer-registry-reporting|current/StructureDefinition/ccrr-composition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ccrr-composition.csv), [Excel](StructureDefinition-ccrr-composition.xlsx), [Schematron](StructureDefinition-ccrr-composition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ccrr-composition",
  "meta" : {
    "versionId" : "77",
    "lastUpdated" : "2021-08-21T02:37:44.721+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ImplementationGuide/central-cancer-registry-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-composition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.40.42.3"
    }
  ],
  "version" : "2.0.0-ballot",
  "name" : "CcrrComposition",
  "title" : "Central Cancer Registry Reporting Composition",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15T16:01:21+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "This Composition profile is used to organize the central cancer registry report content.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Central Cancer Registry Composition Profile",
        "definition" : "The Central Cancer Registry Report Composition profile establishes the core elements, extensions, vocabularies and value sets for representing heath care survey report. ",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "Central Cancer Registry Report Composition identifier",
        "definition" : "Central Cancer Registry Report Composition identifier. This is equivalent to ClinicalDocument.setId in CDA. The identifier of the containing Bundle is equivalent to ClinicalDocument.id in CDA. ",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "fixedCode" : "final",
        "mustSupport" : true
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "short" : "Central Cancer Registry Report",
        "definition" : "The type of this Composition is a Central Cancer Registry Report",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72134-0"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "short" : "Patient who is the subject of the report.",
        "definition" : "This Patient profile represents the subject of the central cancer registry report.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0",
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-patient"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "short" : "Encounter related to the public health event",
        "definition" : "This Encounter profile represents the encounter related to the central cancer registry report.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0",
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-encounter"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "The author(s) of the document",
        "definition" : "It is possible to have multiple authors - especially in the case where the default author is the organization. ",
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|6.1.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0",
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-organization"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "fixedString" : "Central Cancer Registry Report",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceEncounterSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceEncounterSection",
        "short" : "Encounter Section",
        "definition" : "This section lists and describes all the patient's encounter information related to the encounter.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceEncounterSection.code",
        "path" : "Composition.section.code",
        "short" : "Encounter Section code",
        "definition" : "Encounter Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67781-5"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceEncounterSection.text",
        "path" : "Composition.section.text",
        "short" : "Encounter Section narrative",
        "definition" : "Encounter Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceEncounterSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceEncounterSection.entry:sliceEncounter",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceEncounter",
        "short" : "Encounter Entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceEncounterSection.entry:sliceEncounterDiagnosis",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceEncounterDiagnosis",
        "short" : "Encounter Diagnosis Entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:slicePrimaryCancerCondition",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "slicePrimaryCancerCondition",
        "short" : "Primary Cancer Condition Section",
        "definition" : "This section records the Primary Cancer Condition for the patient).",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:slicePrimaryCancerCondition.code",
        "path" : "Composition.section.code",
        "short" : "Primary Cancer Condition code",
        "definition" : "Primary Cancer Condition code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "363346000"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:slicePrimaryCancerCondition.text",
        "path" : "Composition.section.text",
        "short" : "Primary Cancer Condition narrative",
        "definition" : "Primary Cancer Condition narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:slicePrimaryCancerCondition.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-primary-cancer-condition"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceSecondaryCancerCondition",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceSecondaryCancerCondition",
        "short" : "Secondary Cancer Condition Section",
        "definition" : "This section records the Secondary Cancer Conditions for the patient).",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceSecondaryCancerCondition.code",
        "path" : "Composition.section.code",
        "short" : "Secondary Cancer Condition code",
        "definition" : "Secondary Cancer Condition code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "128462008"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceSecondaryCancerCondition.text",
        "path" : "Composition.section.text",
        "short" : "Secondary Cancer Condition narrative",
        "definition" : "Secondary Cancer Condition narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceSecondaryCancerCondition.entry",
        "path" : "Composition.section.entry",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-secondary-cancer-condition"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceTNMStaging",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceTNMStaging",
        "short" : "TNM Staging Section",
        "definition" : "This section records the TNM Staging information for the patient.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceTNMStaging.code",
        "path" : "Composition.section.code",
        "short" : "TNM Staging code",
        "definition" : "TNM Staging code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "21908-9"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceTNMStaging.text",
        "path" : "Composition.section.text",
        "short" : "TNM Staging narrative",
        "definition" : "TNM Staging narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceTNMStaging.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceTNMStaging.entry:sliceTNMStageGroup",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceTNMStageGroup",
        "short" : "TNM Stage Group Entry",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-tnm-stage-group",
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-tnm-distant-metastases-category",
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-tnm-primary-tumor-category",
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-tnm-regional-nodes-category"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceRadioTherapyCourseSummary",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceRadioTherapyCourseSummary",
        "short" : "Cancer Radio Therapy Course Summary",
        "definition" : "This section records the Cancer Radio Therapy Course Summary for the patient).",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceRadioTherapyCourseSummary.code",
        "path" : "Composition.section.code",
        "short" : "Cancer Radio Therapy Course Summary",
        "definition" : "Cancer Radio Therapy Course Summary code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1217123003"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceRadioTherapyCourseSummary.text",
        "path" : "Composition.section.text",
        "short" : "Cancer Radio Therapy Course Summary narrative",
        "definition" : "Cancer Radio Therapy Course Summary narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceRadioTherapyCourseSummary.entry",
        "path" : "Composition.section.entry",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-radiotherapy-course-summary"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceProblemSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceProblemSection",
        "short" : "Problem Section",
        "definition" : "This section lists and describes all the patient's current problems on the maintained problem list.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceProblemSection.code",
        "path" : "Composition.section.code",
        "short" : "Problem Section code",
        "definition" : "Problem Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11450-4"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceProblemSection.text",
        "path" : "Composition.section.text",
        "short" : "Problem Section narrative",
        "definition" : "Problem Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceProblemSection.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceMedicationsAdministeredSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceMedicationsAdministeredSection",
        "short" : "Medications Administered Section",
        "definition" : "The Medications Administered Section defines medications administered during the encounter.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceMedicationsAdministeredSection.code",
        "path" : "Composition.section.code",
        "short" : "Medications Administered Section code",
        "definition" : "Medications Administered Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29549-3"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceMedicationsAdministeredSection.text",
        "path" : "Composition.section.text",
        "short" : "Medications Administered Section narrative",
        "definition" : "Medications Administered Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceMedicationsAdministeredSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceMedicationsAdministeredSection.entry:sliceMedicationAdministration",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceMedicationAdministration",
        "short" : "Medication Administration Entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-cancer-related-medication-administration"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceMedicationsAdministeredSection.entry:sliceMedicationReferences",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceMedicationReferences",
        "short" : "Medication Reference Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceMedicationsSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceMedicationsSection",
        "short" : "Medications Section",
        "definition" : "The Medications Section contains a patient's current medications and pertinent medication history. At a minimum, the currently active medications are listed.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceMedicationsSection.code",
        "path" : "Composition.section.code",
        "short" : "Medications Section code",
        "definition" : "Medications Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10160-0"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceMedicationsSection.text",
        "path" : "Composition.section.text",
        "short" : "Medications Section narrative",
        "definition" : "Medications Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceMedicationsSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceMedicationsSection.entry:sliceMedicationAdministration",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceMedicationAdministration",
        "short" : "Medication Administration Entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-cancer-related-medication-administration"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceMedicationsSection.entry:sliceMedicationStatement",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceMedicationStatement",
        "short" : "Medication Statement Entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceMedicationsSection.entry:sliceMedicationReferences",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceMedicationReferences",
        "short" : "Medication Reference Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceODHSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceODHSection",
        "short" : "ODH Data",
        "definition" : "This section records the Occupational Data for Health (ODH) data for the patient).",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceODHSection.code",
        "path" : "Composition.section.code",
        "short" : "ODH Data code",
        "definition" : "ODH Data code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "74165-2"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceODHSection.text",
        "path" : "Composition.section.text",
        "short" : "ODH Data narrative",
        "definition" : "ODH Data narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceODHSection.entry",
        "path" : "Composition.section.entry",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/odh/StructureDefinition/odh-UsualWork"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceResultsSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceResultsSection",
        "short" : "Results Section",
        "definition" : "The Results Section contains observations of results generated by laboratories, imaging procedures, and other procedures. The scope includes observations such as hematology, chemistry, serology, virology, toxicology, microbiology, plain x-ray, ultrasound, CT, MRI, angiography, echocardiography, nuclear medicine, pathology, and procedure observations. The section often includes notable results such as abnormal values or relevant trends, and could contain all results for the period of time being documented.\n\nLaboratory results are typically generated by laboratories providing analytic services in areas such as chemistry, hematology, serology, histology, cytology, anatomic pathology, microbiology, and/or virology. These observations are based on analysis of specimens obtained from the patient and submitted to the laboratory. Imaging results are typically generated by a clinician reviewing the output of an imaging procedure, such as where a cardiologist reports the left ventricular ejection fraction based on the review of a cardiac echocardiogram.\n\nProcedure results are typically generated by a clinician to provide more granular information about component observations made during a procedure, such as where a gastroenterologist reports the size of a polyp observed during a colonoscopy.\n",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceResultsSection.code",
        "path" : "Composition.section.code",
        "short" : "Results Section code",
        "definition" : "Results Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "30954-2"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceResultsSection.text",
        "path" : "Composition.section.text",
        "short" : "Results Section narrative",
        "definition" : "Results Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceResultsSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceResultsSection.entry:sliceLabResultEntry",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceLabResultEntry",
        "short" : "Lab Result Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceResultsSection.entry:sliceDiagnosticResultEntry",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceDiagnosticResultEntry",
        "short" : "Diagnostic Result Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceNotesSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceNotesSection",
        "short" : "Clinical and Diagnostic Reports Section",
        "definition" : "The Notes Section contains clinical notes and diagnostic reports.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceNotesSection.code",
        "path" : "Composition.section.code",
        "short" : "Clinical Notes Section code",
        "definition" : "Clinical Notes Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "28650-0"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceNotesSection.text",
        "path" : "Composition.section.text",
        "short" : "Notes Section narrative",
        "definition" : "Notes Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceNotesSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceNotesSection.entry:sliceDocumentReferenceEntry",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceDocumentReferenceEntry",
        "short" : "Document Reference Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceNotesSection.entry:sliceDiagnosticReportEntry",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceDiagnosticReportEntry",
        "short" : "Diagnostic Report Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|6.1.0",
              "http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-diagnostic-report"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:slicePlanOfTreatmentSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "slicePlanOfTreatmentSection",
        "short" : "Plan of Treatment Section",
        "definition" : "This section, contains data that define pending orders, interventions, encounters, services, and procedures for the patient. It is limited to prospective, unfulfilled, or incomplete orders and requests only. All active, incomplete, or pending orders, appointments, referrals, procedures, services, or any other pending event of clinical significance to the current care of the patient should be listed. ",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:slicePlanOfTreatmentSection.code",
        "path" : "Composition.section.code",
        "short" : "Plan of Treatment code",
        "definition" : "Plan of Treatment code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18776-5"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:slicePlanOfTreatmentSection.text",
        "path" : "Composition.section.text",
        "short" : "Plan of Treatment narrative",
        "definition" : "Plan of Treatment narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:slicePlanOfTreatmentSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:slicePlanOfTreatmentSection.entry:sliceMedicationRequest",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceMedicationRequest",
        "short" : "Medication Request Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-cancer-related-medication-request"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:slicePlanOfTreatmentSection.entry:sliceMedicationReferences",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceMedicationReferences",
        "short" : "Medication Reference Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:slicePlanOfTreatmentSection.entry:sliceProcedureOrders",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceProcedureOrders",
        "short" : "Procedure Order Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:slicePlanOfTreatmentSection.entry:sliceCarePlanEntries",
        "path" : "Composition.section.entry",
        "sliceName" : "sliceCarePlanEntries",
        "short" : "CarePlan Entries",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceProceduresSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceProceduresSection",
        "short" : "This section describes all interventional, surgical, diagnostic, or therapeutic procedures or treatments pertinent to the patient historically at the time the document is generated.",
        "definition" : "This section describes all interventional, surgical, diagnostic, or therapeutic procedures or treatments pertinent to the patient historically at the time the document is generated. The section should include notable procedures, but can contain all procedures for the period of time being summarized.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceProceduresSection.code",
        "path" : "Composition.section.code",
        "short" : "Procedures Section code",
        "definition" : "Procedures Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "47519-4"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceProceduresSection.text",
        "path" : "Composition.section.text",
        "short" : "Procedures Section narrative",
        "definition" : "Procedures Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceProceduresSection.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceVitalSignsSection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceVitalSignsSection",
        "short" : "Vital Signs Section",
        "definition" : "The Vital Signs Section contains relevant vital signs for the eICR. The section should include notable vital signs such as the most recent, maximum and/or minimum, baseline, or relevant trends. Vital signs are represented in the same way as other results, but are aggregated into their own section to follow clinical conventions.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceVitalSignsSection.code",
        "path" : "Composition.section.code",
        "short" : "Vital Signs code",
        "definition" : "Vital Signs code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8716-3"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceVitalSignsSection.text",
        "path" : "Composition.section.text",
        "short" : "Vital Signs narrative",
        "definition" : "Vital Signs narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceVitalSignsSection.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-vital-signs|6.1.0"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceSocialHistorySection",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "sliceSocialHistorySection",
        "short" : "Social History Section",
        "definition" : "This section contains social history data that influence a patient’s physical, psychological or emotional health such as occupation, home environment, travel history, and disability status.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceSocialHistorySection.code",
        "path" : "Composition.section.code",
        "short" : "Social History Section code",
        "definition" : "Social History Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29762-2"
            }
          ]
        },
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Composition.section:sliceSocialHistorySection.text",
        "path" : "Composition.section.text",
        "short" : "Social History Section narrative",
        "definition" : "Social History Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sliceSocialHistorySection.entry",
        "path" : "Composition.section.entry",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
