# mCODE Radiotherapy Course Summary - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **mCODE Radiotherapy Course Summary - Example**

## Example Procedure: mCODE Radiotherapy Course Summary - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [mCODE Radiotherapy Course Summary](https://hl7.org/fhir/us/mcode/StructureDefinition-mcode-radiotherapy-course-summary.html)

**Procedure:** Radiotherapy Course Summary

**Status:** Completed

**Intent:** Curative (SNOMEDCT: 373808002)

**Modality:** External beam radiation therapy using photons (SNOMEDCT: 1156506007)

**Performed:** 2024-01-31 to 2024-03-31

**Subject:** [Patient-example: Amy Shaw](Patient-example.md)

**Reason:** Infiltrating duct carcinoma of breast 



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "radiotherapy-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-radiotherapy-course-summary"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-procedure-intent",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "373808002",
            "display" : "Curative - procedure intent"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-radiotherapy-modality",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "1156506007",
                "display" : "External beam radiation therapy using photons (procedure)"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-radiotherapy-technique",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "1156530009",
                "display" : "Volumetric Modulated Arc Therapy (procedure)"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-radiotherapy-modality-and-technique"
    }
  ],
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1217123003"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "performedPeriod" : {
    "start" : "2024-01-31",
    "end" : "2024-03-31"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/primary-cancer-condition-breast"
    }
  ]
}

```
