# Cancer-related Surgical Procedure - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Cancer-related Surgical Procedure - Example**

## Example Procedure: Cancer-related Surgical Procedure - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [US Core Procedure](https://hl7.org/fhir/us/core/StructureDefinition-us-core-procedure.html)

**Procedure:** Cancer-related-surgical-procedure-lumpectomy

**status**: Completed

**code**: Lumpectomy of left breast (procedure)

**subject**: [Amy V. Shaw](Patient-example.md)

**performed**: 2023-11-08

**reasonReference**: [Condition Infiltrating duct carcinoma of breast (disorder)](Condition-primary-cancer-condition-breast.md)

**bodySite**: Left breast structure (body structure)



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "cancer-related-surgical-procedure-lumpectomy",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|6.1.0"
    ]
  },
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "735085002",
        "display" : "Lumpectomy of left breast (procedure)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "performedDateTime" : "2023-11-08",
  "reasonReference" : [
    {
      "reference" : "Condition/primary-cancer-condition-breast"
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "80248007",
          "display" : "Left breast structure (body structure)"
        }
      ]
    }
  ]
}

```
