# CCRR PlanDefinition - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCRR PlanDefinition - Example**

## PlanDefinition: CCRR PlanDefinition - Example (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/plandefinition-central-cancer-registry-reporting-example | *Version*:2.0.0-ballot |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:CentralCancerRegistryReportingExample |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.40.40.34.1 | |

 
This is the Healthcare Survey Reporting Knowledge Artifact 

**CCRR PlanDefinition Example**



## Resource Content

```json
{
  "resourceType" : "PlanDefinition",
  "id" : "plandefinition-central-cancer-registry-reporting-example",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2020-11-29T02:03:28.045+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-plandefinition"
    ]
  },
  "url" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/plandefinition-central-cancer-registry-reporting-example",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.40.34.1"
    }
  ],
  "version" : "2.0.0-ballot",
  "name" : "CentralCancerRegistryReportingExample",
  "title" : "PlanDefinition Central Cancer Registry Reporting Example",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/plan-definition-type",
        "code" : "workflow-definition",
        "display" : "Workflow Definition"
      }
    ]
  },
  "status" : "draft",
  "experimental" : true,
  "date" : "2020-11-04T12:32:29.858-05:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        }
      ]
    }
  ],
  "description" : "This is the Healthcare Survey Reporting Knowledge Artifact",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "effectivePeriod" : {
    "start" : "2021-11-01"
  },
  "relatedArtifact" : [
    {
      "type" : "depends-on",
      "label" : "Central Cancer Registry Trigger Codes",
      "resource" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ValueSet/cancer-core-reportability-codes|2.0.0"
    }
  ],
  "action" : [
    {
      "id" : "start-workflow",
      "description" : "This action represents the start of the reporting workflow in response to the encounter-close event",
      "textEquivalent" : "Start the reporting workflow in response to an encounter-close event",
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "initiate-reporting-workflow"
            }
          ]
        }
      ],
      "trigger" : [
        {
          "id" : "encounter-close",
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-named-eventtype-extension",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-triggerdefinition-namedevents",
                    "code" : "encounter-close",
                    "display" : "Indicates the close of an encounter"
                  }
                ]
              }
            }
          ],
          "type" : "named-event",
          "name" : "encounter-close"
        }
      ],
      "relatedAction" : [
        {
          "actionId" : "check-reportable",
          "relationship" : "before-start",
          "offsetDuration" : {
            "value" : 72,
            "system" : "http://unitsofmeasure.org",
            "code" : "h"
          }
        }
      ]
    },
    {
      "id" : "check-reportable",
      "description" : "This action represents the check for suspected reportability of the cancer data.",
      "textEquivalent" : "Check Reportability and setup jobs for future reportability checks.",
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "execute-reporting-workflow"
            }
          ]
        }
      ],
      "action" : [
        {
          "id" : "is-encounter-reportable",
          "description" : "This action represents the check for reportability to create the patients eICR.",
          "textEquivalent" : "Check Trigger Codes based on RCTC Value sets.",
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                  "code" : "check-trigger-codes"
                }
              ]
            }
          ],
          "condition" : [
            {
              "kind" : "applicability",
              "expression" : {
                "language" : "text/fhirpath",
                "expression" : "%conditions.exists()"
              }
            }
          ],
          "input" : [
            {
              "id" : "conditions",
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-fhirquerypattern-extension",
                  "valueString" : "Condition?patient=Patient/{{context.patientId}}"
                }
              ],
              "type" : "Condition",
              "codeFilter" : [
                {
                  "path" : "code",
                  "valueSet" : "http://hl7.org/fhir/us/central-cancer-registry-reporting/ValueSet/cancer-core-reportability-codes|2.0.0"
                }
              ]
            }
          ],
          "relatedAction" : [
            {
              "actionId" : "report-cancer-data",
              "relationship" : "before-start"
            }
          ]
        },
        {
          "id" : "should-continue-reporting",
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                  "code" : "evaluate-condition"
                }
              ]
            }
          ],
          "condition" : [
            {
              "kind" : "applicability",
              "expression" : {
                "language" : "text/fhirpath",
                "expression" : "%patient.deceased[x] == null && (currentTime - previousReportSubmissionTime) < 7776000"
              }
            }
          ],
          "relatedAction" : [
            {
              "actionId" : "check-reportable",
              "relationship" : "before-start",
              "offsetDuration" : {
                "value" : 6,
                "system" : "http://unitsofmeasure.org",
                "code" : "mo"
              }
            }
          ]
        }
      ]
    },
    {
      "id" : "report-cancer-data",
      "description" : "This action represents the creation, validation and submission of the cancer report.",
      "textEquivalent" : "Check Reportability and setup jobs for future reportability checks.",
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "execute-reporting-workflow"
            }
          ]
        }
      ],
      "action" : [
        {
          "id" : "create-cancer-report",
          "description" : "This action represents the creation of the cancer report.",
          "textEquivalent" : "Central Cancer Registry Report",
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                  "code" : "create-report"
                }
              ]
            }
          ],
          "input" : [
            {
              "id" : "patient",
              "type" : "Patient",
              "profile" : [
                "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-patient"
              ]
            },
            {
              "id" : "condition",
              "type" : "Condition",
              "profile" : [
                "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-primary-cancer-condition"
              ]
            },
            {
              "id" : "encounter",
              "type" : "Encounter",
              "profile" : [
                "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-encounter"
              ]
            },
            {
              "id" : "mr",
              "type" : "MedicationRequest",
              "profile" : [
                "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-cancer-related-medication-request"
              ]
            },
            {
              "id" : "vitals",
              "type" : "Observation",
              "profile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
            },
            {
              "id" : "labs",
              "type" : "Observation",
              "profile" : [
                "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0"
              ]
            }
          ],
          "output" : [
            {
              "id" : "cancer-report",
              "type" : "Bundle",
              "profile" : [
                "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-reporting-bundle"
              ]
            }
          ],
          "relatedAction" : [
            {
              "actionId" : "validate-report",
              "relationship" : "before-start"
            }
          ]
        },
        {
          "id" : "validate-cancer-report",
          "description" : "This action represents the validation of the cancer report.",
          "textEquivalent" : "Validate Report",
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                  "code" : "validate-report"
                }
              ]
            }
          ],
          "input" : [
            {
              "id" : "created-cancer-report",
              "type" : "Bundle",
              "profile" : [
                "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-reporting-bundle"
              ]
            }
          ],
          "output" : [
            {
              "id" : "validated-cancer-report",
              "type" : "Bundle",
              "profile" : [
                "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-reporting-bundle"
              ]
            }
          ],
          "relatedAction" : [
            {
              "actionId" : "submit-report",
              "relationship" : "before-start"
            }
          ]
        },
        {
          "id" : "route-and-send-cancer-report",
          "description" : "This action represents the routing and sending of the cancer report.",
          "textEquivalent" : "Route and send cancer report",
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                  "code" : "submit-report"
                }
              ]
            }
          ],
          "input" : [
            {
              "id" : "val-cancer-report",
              "type" : "Bundle",
              "profile" : [
                "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-reporting-bundle"
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
