# Central Cancer Registry Reporting Patient - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Patient - Example**

## Example Patient: Central Cancer Registry Reporting Patient - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [Central Cancer Registry Reporting Patient](StructureDefinition-central-cancer-registry-reporting-patient.md)

**Patient:** Amy V. Baxter (formerly Amy V. Shaw)

**Identifiers:**

* Medical Record Number: 1032702 (system: http://CancerOrg.smarthealthit.org)
* Social Security Number: 11-222-3333

**Active:** true

**Gender:** female

**Birth Date:** 1987-02-20

**Marital Status:** Never Married

**Race:** White, American Indian or Alaska Native (Shoshone), Asian (Filipino)

**Ethnicity:** Hispanic or Latino (Mexican, Dominican)

**Birthplace:** Georgia, US

**Addresses:**

* 49 Meadow St, Mounds, OK 74047, US (2016-12-06 to 2020-07-22)
* 183 Mountain View St, Mounds, OK 74048, US (2020-07-22 to present)

**Telecom:**

* Phone: 555-555-5555 (home)
* Email: amy.shaw@example.com

**Languages:** English

**Managing Organization:** Cancer Organization (Organization/example-cancer-org)



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-patient"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2106-3",
            "display" : "White"
          }
        },
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "1002-5",
            "display" : "American Indian or Alaska Native"
          }
        },
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2028-9",
            "display" : "Asian"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "1586-7",
            "display" : "Shoshone"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2036-2",
            "display" : "Filipino"
          }
        },
        {
          "url" : "text",
          "valueString" : "Mixed"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
    },
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2135-2",
            "display" : "Hispanic or Latino"
          }
        },
        {
          "url" : "text",
          "valueString" : "Hispanic or Latino"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
      "valueAddress" : {
        "state" : "GA",
        "country" : "US"
      }
    }
  ],
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://example.org",
      "value" : "1032702"
    },
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "SS",
            "display" : "Social Security Number"
          }
        ],
        "text" : "Social Security Number"
      },
      "system" : "http://hl7.org/fhir/sid/us-ssn",
      "value" : "11-222-3333"
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "maiden",
      "family" : "Shaw",
      "given" : ["Amy", "V."],
      "period" : {
        "start" : "1987-02-20",
        "end" : "2020-07-22"
      }
    },
    {
      "family" : "Baxter",
      "given" : ["Amy", "V."],
      "suffix" : ["PharmD"],
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "amy.shaw@example.com"
    }
  ],
  "gender" : "female",
  "birthDate" : "1987-02-20",
  "deceasedBoolean" : false,
  "address" : [
    {
      "line" : ["49 Meadow St"],
      "city" : "Mounds",
      "state" : "OK",
      "postalCode" : "74047",
      "country" : "US",
      "period" : {
        "start" : "2016-12-06",
        "end" : "2020-07-22"
      }
    },
    {
      "line" : ["183 Mountain View St"],
      "city" : "Mounds",
      "state" : "OK",
      "postalCode" : "74048",
      "country" : "US",
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
        "code" : "S",
        "display" : "Never Married"
      }
    ]
  },
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en",
            "display" : "English"
          }
        ]
      }
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/example-cancer-org",
    "display" : "Cancer Organization"
  }
}

```
