# Central Cancer Registry Reporting Organization - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Organization - Example**

## Example Organization: Central Cancer Registry Reporting Organization - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [Central Cancer Registry Reporting Organization](StructureDefinition-central-cancer-registry-reporting-organization.md)

**Organization:** Cancer Organization

**Status:** Active

**Identifier (NPI):** 1063494177

**Address:** 1234 Main Street, Tulsa, OK 74126

**Phone:** (917)932-2000

**Endpoint:** Reference to Endpoint/example-healthcare-endpoint



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "example-cancer-org",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-organization"
    ]
  },
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1063494177"
    }
  ],
  "active" : true,
  "name" : "Cancer Organization",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(917)932-2000",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "text" : "1234 Main Street, Tulsa OK 74126",
      "line" : ["1234 Main Street"],
      "city" : "Tulsa",
      "state" : "OK",
      "postalCode" : "74126"
    }
  ],
  "endpoint" : [
    {
      "reference" : "Endpoint/example-healthcare-endpoint"
    }
  ]
}

```
