# mCODE TNM Clinical Regional Nodes Category - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **mCODE TNM Clinical Regional Nodes Category - Example**

## Example Observation: mCODE TNM Clinical Regional Nodes Category - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [mmCODE TNM Regional Nodes Category](https://hl7.org/fhir/us/mcode/StructureDefinition-mcode-tnm-regional-nodes-category.html)

**Observation:** TNM Clinical Regional Nodes Category (cN0)

**Status:** final

**Category:** Laboratory

**Code:** Regional lymph nodes.clinical [Class] Cancer (LOINC: 21906-3)

**Subject:** [Patient-example: Amy Shaw](Patient-example.md)

**Effective Date:** 2023-03-21

**Performer:** [Dr. Joseph Nichols (Practitioner/1)](Practitioner-1.md)

**Value:** cN0 (American Joint Committee on Cancer cN0 qualifier)

**Method:** American Joint Commission on Cancer, Cancer Staging Manual, 8th edition neoplasm staging system (tumor staging) (SNOMED CT: 897275008)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "tnm-clinical-regional-nodes-category-cN0",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-tnm-regional-nodes-category"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "21906-3",
        "display" : "Regional lymph nodes.clinical [Class] Cancer"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2023-03-21",
  "performer" : [
    {
      "reference" : "Practitioner/1"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1229967007",
        "display" : "American Joint Committee on Cancer cN0 (qualifier value)"
      }
    ]
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "897275008",
        "display" : "American Joint Committee on Cancer, Cancer Staging Manual, 8th edition tumor staging system"
      }
    ]
  }
}

```
