# mCODE Cancer Stage Group - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **mCODE Cancer Stage Group - Example**

## Example Observation: mCODE Cancer Stage Group - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [mCODE TNM Stage Group](https://hl7.org/fhir/us/mcode/StructureDefinition-mcode-tnm-stage-group.html)

**Observation:** cancer-stage-group-example

**status**: final

**code**: Stage group.clinical Cancer LOINC 21908-9

**subject**: [Patient-example: Amy Shaw](Patient-example.md)

**focus**: [primary-cancer-condition-breast](Condition-primary-cancer-condition-breast.md)

**effective**: 2023-03-21

**value**: American Joint Committee on Cancer stage IIA (qualifier value) SNOMED CT[Intl] 1222766008)

**method**: American Joint Commission on Cancer, Cancer Staging Manual, 8th edition neoplasm staging system (tumor staging) SNOMED CT[Intl] #897275008

**hasMember**: 

* [Observation/tnm-clinical-primary-tumor-category-cT2](Observation-tnm-clinical-primary-tumor-category-cT2.md)
* [Observation/tnm-clinical-regional-nodes-category-cN0](Observation-tnm-clinical-regional-nodes-category-cN0.md)
* [Observation/tnm-clinical-distant-metastases-category-cM0](Observation-tnm-clinical-distant-metastases-category-cM0.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "cancer-stage-group-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-tnm-stage-group"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "21908-9",
        "display" : "Stage group.clinical Cancer"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "focus" : [
    {
      "reference" : "Condition/primary-cancer-condition-breast"
    }
  ],
  "effectiveDateTime" : "2023-03-21",
  "performer" : [
    {
      "reference" : "Practitioner/1",
      "display" : "Joseph Nichols"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1222766008",
        "display" : "American Joint Committee on Cancer stage IIA (qualifier value)"
      }
    ]
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "897275008",
        "display" : "American Joint Committee on Cancer, Cancer Staging Manual, 8th edition tumor staging system"
      }
    ]
  },
  "hasMember" : [
    {
      "reference" : "Observation/tnm-clinical-primary-tumor-category-cT2"
    },
    {
      "reference" : "Observation/tnm-clinical-regional-nodes-category-cN0"
    },
    {
      "reference" : "Observation/tnm-clinical-distant-metastases-category-cM0"
    }
  ]
}

```
