# Central Cancer Registry Endpoint - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Endpoint - Example**

## Example Endpoint: Central Cancer Registry Endpoint - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Public Health Agency Receiver



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "example-ph-endpoint",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2020-11-29T02:03:28.045+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-endpoint"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/pha.org/identifiers",
      "value" : "pha-endpoint-id"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "PHAReceiver",
  "managingOrganization" : {
    "reference" : "Organization/example-pha-org"
  },
  "contact" : [
    {
      "system" : "email",
      "value" : "endpointmanager@example.org",
      "use" : "work"
    }
  ],
  "period" : {
    "start" : "2020-11-20"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/resource-types",
          "code" : "Bundle"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+xml", "application/fhir+json"],
  "address" : "http://example.org/pha.org/fhir"
}

```
