# Healthcare Organization Endpoint - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Healthcare Organization Endpoint - Example**

## Example Endpoint: Healthcare Organization Endpoint - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Healthcare Endpoint Sender and Receiver



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "example-healthcare-endpoint",
  "meta" : {
    "versionId" : "1",
    "lastUpdated" : "2020-11-29T02:03:28.045+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-endpoint"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/healthcare.org/endpoint-identifier",
      "value" : "healthcare-endpoint-id"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "HealthCareSenderAndReceiver",
  "managingOrganization" : {
    "reference" : "Organization/example-cancer-org"
  },
  "contact" : [
    {
      "system" : "email",
      "value" : "endpointmanager@example.healthcare.org",
      "use" : "work"
    }
  ],
  "period" : {
    "start" : "2020-11-20"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/resource-types",
          "code" : "Bundle"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+xml", "application/fhir+json"],
  "address" : "http://example.org/healthcare.org/fhir"
}

```
