# Central Cancer Registry Reporting Encounter - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Encounter - Example**

## Example Encounter: Central Cancer Registry Reporting Encounter - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [Central Cancer Registry Reporting Encounter](StructureDefinition-central-cancer-registry-reporting-encounter.md)

**Encounter:** encounter-cancer-example

**Identifier:** 9937012 (System: http://example.org)

**Status:** finished

**Class:** AMB (Ambulatory)

**Type:** Encounter for problem (procedure) (SNOMED CT: 185347001)

**Subject:** [Patient-example: Amy Shaw](Patient-example.md)

**Reason:** Referral by general physician (procedure) (SNOMED CT: 305970004)

**Participant:** [Joseph Nichols – Attender](Practitioner-1.md)

**Period:** 2023-03-21T17:00:14-05:00 to 2023-03-21T20:00:14-05:00

**Diagnosis:** [Primary Cancer Condition – Breast](Condition-primary-cancer-condition-breast.md)

**Service Provider:** [Cancer Organization](Organization-example-cancer-org.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "encounter-cancer-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-encounter"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org",
      "value" : "9937012"
    }
  ],
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "185347001",
          "display" : "Encounter for problem (procedure)"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "ATND",
              "display" : "attender"
            }
          ]
        }
      ],
      "individual" : {
        "reference" : "Practitioner/1",
        "display" : "Joseph Nichols"
      }
    }
  ],
  "period" : {
    "start" : "2023-03-21T17:00:14-05:00",
    "end" : "2023-03-21T20:00:14-05:00"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "305970004",
          "display" : "Referral by general physician (procedure)"
        }
      ]
    }
  ],
  "diagnosis" : [
    {
      "condition" : {
        "reference" : "Condition/primary-cancer-condition-breast"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/example-cancer-org",
    "display" : "Cancer Organization"
  }
}

```
