# Central Cancer Registry Reporting Encounter for Surgery - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Central Cancer Registry Reporting Encounter for Surgery - Example**

## Example Encounter: Central Cancer Registry Reporting Encounter for Surgery - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [Central Cancer Registry Reporting Encounter](StructureDefinition-central-cancer-registry-reporting-encounter.md)

**Encounter:** Surgery-Lumpectomy

**Identifier:** 9937013

**Status:** finished

**Class:** Ambulatory (AMB)

**Type:** Encounter for problem (procedure) [SNOMED CT: 185347001]

**Patient:** [Patient-example: Amy Shaw](Patient-example.md)

**Period:** November 8, 2024

**Reason for Encounter:** [Surgical Procedure - Lumpectomy](Procedure-cancer-related-surgical-procedure-lumpectomy.md)

**Associated Diagnosis:** [Primary Cancer Condition – Breast](Condition-primary-cancer-condition-breast.md)

**Service Provider:** [Cancer Organization](Organization-example-cancer-org.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "encounter-cancer-example-surgery",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/central-cancer-registry-reporting-encounter"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org",
      "value" : "9937013"
    }
  ],
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "185347001",
          "display" : "Encounter for problem (procedure)"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "period" : {
    "start" : "2023-11-08T17:00:14-05:00",
    "end" : "2023-11-08T20:00:14-05:00"
  },
  "reasonReference" : [
    {
      "reference" : "Procedure/cancer-related-surgical-procedure-lumpectomy"
    }
  ],
  "diagnosis" : [
    {
      "condition" : {
        "reference" : "Condition/primary-cancer-condition-breast"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/example-cancer-org",
    "display" : "Cancer Organization"
  }
}

```
