# CCRR Composition - Example - Central Cancer Registry Reporting Content IG v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CCRR Composition - Example**

## Example Composition: CCRR Composition - Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**Profile:** [Central Cancer Registry Reporting Composition](StructureDefinition-ccrr-composition.md)

## Central Cancer Registry Report

**Patient:** [Patient-example: Amy Shaw](Patient-example.md)

**Author:** [Practitioner 1: Dr. Nicholas Joseph](Practitioner-1.md)

**Date:** 2023-01-02

### Sections:

* **Primary Cancer Condition:** Infiltrating duct carcinoma of the left breast ([Condition/primary-cancer-condition-breast](Condition-primary-cancer-condition-breast.md))
* **TNM Staging:** Stage IIA (cT2, cN0, cM0) ([Observation/cancer-stage-group-example](Observation-cancer-stage-group-example.md))
* **Radiotherapy:** Completed external beam radiation therapy, photon modality, curative intent, Jan–Mar 2024 ([Procedure/radiotherapy-example](Procedure-radiotherapy-example.md))
* **Medications:** Cancer-related medication administration (Docetaxel) ([MedicationAdministration/cancer-med-admin-docetaxel-example](MedicationAdministration-cancer-med-admin-docetaxel-example.md))



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "ccrr-composition-example",
  "meta" : {
    "versionId" : "23",
    "lastUpdated" : "2021-08-19T22:06:32.441+00:00",
    "profile" : [
      "http://hl7.org/fhir/us/central-cancer-registry-reporting/StructureDefinition/ccrr-composition"
    ]
  },
  "identifier" : {
    "value" : "c03eab8c-11e8-4d0c-ad2a-b385395e27db"
  },
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "72134-0"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Amy Shaw"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-cancer-example",
    "display" : "Patient encounter procedure"
  },
  "date" : "2023-01-02T22:13:23Z",
  "author" : [
    {
      "reference" : "Practitioner/1",
      "display" : "Nicholas Joseph"
    }
  ],
  "title" : "Central Cancer Registry Report",
  "section" : [
    {
      "title" : "Primary Cancer Condition Section",
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "363346000",
            "display" : "Malignant neoplastic disease (disorder)"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n<p>Primary Cancer Condition Section</p></div>"
      },
      "entry" : [
        {
          "reference" : "Condition/primary-cancer-condition-breast"
        }
      ]
    },
    {
      "title" : "TNM Staging section",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "21908-9",
            "display" : "Stage group.clinical Cancer"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n<p>Cancer Stage Group</p></div>"
      },
      "entry" : [
        {
          "reference" : "Observation/cancer-stage-group-example"
        },
        {
          "reference" : "Observation/tnm-clinical-regional-nodes-category-cN0"
        },
        {
          "reference" : "Observation/tnm-clinical-primary-tumor-category-cT2"
        },
        {
          "reference" : "Observation/tnm-clinical-distant-metastases-category-cM0"
        }
      ]
    },
    {
      "title" : "Cancer Radio Therapy Course Summary section",
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "1217123003",
            "display" : "Radiotherapy course of treatment"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n<p>Cancer Radio Therapy Course Summary</p></div>"
      },
      "entry" : [
        {
          "reference" : "Procedure/radiotherapy-example"
        }
      ]
    },
    {
      "title" : "Medications Section",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "10160-0",
            "display" : "History of Medication use Narrative"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\n Medications section: cancer-related medication </div>"
      },
      "entry" : [
        {
          "reference" : "MedicationAdministration/cancer-med-admin-docetaxel-example"
        }
      ]
    }
  ]
}

```
