# US Pathology Form Category Codes - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Form Category Codes**

Publication Build: This will be filled in by the publication tooling

*  [Narrative Content](#) 
*  [XML](ValueSet-us-pathology-form-category-codes.xml.md) 
*  [JSON](ValueSet-us-pathology-form-category-codes.json.md) 
*  [TTL](ValueSet-us-pathology-form-category-codes.ttl.md) 

## ValueSet: US Pathology Form Category Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/ValueSet/us-pathology-form-category-codes | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologyFormCategoryCodes |

 
This ValueSet is composed of form category codes. 

 **References** 

* [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

### Logical Definition (CLD)

* Include all codes defined in [`http://hl7.org/fhir/us/cancer-reporting/CodeSystem/us-pathology-codesystem`](CodeSystem-us-pathology-codesystem.md)

 

### Expansion

Expansion performed internally based on [codesystem US Pathology Code System v2.0.0 (CodeSystem)](CodeSystem-us-pathology-codesystem.md)

This value set contains 2 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

