# US Pathology Specimen - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Specimen**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-us-pathology-specimen-definitions.md) 
*  [Mappings](StructureDefinition-us-pathology-specimen-mappings.md) 
*  [Examples](StructureDefinition-us-pathology-specimen-examples.md) 
*  [XML](StructureDefinition-us-pathology-specimen.profile.xml.md) 
*  [JSON](StructureDefinition-us-pathology-specimen.profile.json.md) 
*  [TTL](StructureDefinition-us-pathology-specimen.profile.ttl.md) 

## Resource Profile: US Pathology Specimen 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-specimen | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologySpecimen |

 
This Specimen profile defines a pathology specimen that is the focus of an eCP report. 

**Usages:**

* Use this Profile: [US Pathology Bundle](StructureDefinition-us-pathology-bundle.md)
* Refer to this Profile: [US Pathology Diagnostic Report](StructureDefinition-us-pathology-diagnostic-report.md) and [US Pathology Service Request](StructureDefinition-us-pathology-service-request.md)
* Examples for this Profile: [Specimen/specimen-breast](Specimen-specimen-breast.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.cancer-reporting|current/StructureDefinition/us-pathology-specimen)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Key Elements Table](#tabs-key) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [USCoreSpecimenProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-specimen.html) 

#### Terminology Bindings

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [USCoreSpecimenProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-specimen.html) 

**Summary**

Mandatory: 4 elements(2 nested mandatory elements)
 Must-Support: 10 elements

**Structures**

This structure refers to these other structures:

* [US Pathology Related Practitioner Role(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-related-practitioner-role)](StructureDefinition-us-pathology-related-practitioner-role.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 **Differential View** 

This structure is derived from [USCoreSpecimenProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-specimen.html) 

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [USCoreSpecimenProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-specimen.html) 

**Summary**

Mandatory: 4 elements(2 nested mandatory elements)
 Must-Support: 10 elements

**Structures**

This structure refers to these other structures:

* [US Pathology Related Practitioner Role(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-related-practitioner-role)](StructureDefinition-us-pathology-related-practitioner-role.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 

Other representations of profile: [CSV](StructureDefinition-us-pathology-specimen.csv), [Excel](StructureDefinition-us-pathology-specimen.xlsx), [Schematron](StructureDefinition-us-pathology-specimen.sch) 

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

