# US Pathology Service Request - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Service Request**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-us-pathology-service-request-definitions.md) 
*  [Mappings](StructureDefinition-us-pathology-service-request-mappings.md) 
*  [Examples](StructureDefinition-us-pathology-service-request-examples.md) 
*  [XML](StructureDefinition-us-pathology-service-request.profile.xml.md) 
*  [JSON](StructureDefinition-us-pathology-service-request.profile.json.md) 
*  [TTL](StructureDefinition-us-pathology-service-request.profile.ttl.md) 

## Resource Profile: US Pathology Service Request 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-service-request | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologyServiceRequest |

 
This ServiceRequest profile represents the request for analysis of a pathological sample. 

**Usages:**

* Use this Profile: [US Pathology Bundle](StructureDefinition-us-pathology-bundle.md)
* Refer to this Profile: [US Pathology Diagnostic Report](StructureDefinition-us-pathology-diagnostic-report.md)
* Examples for this Profile: [ServiceRequest/servicerequest-cancer-path](ServiceRequest-servicerequest-cancer-path.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.cancer-reporting|current/StructureDefinition/us-pathology-service-request)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Key Elements Table](#tabs-key) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [USCoreServiceRequestProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-servicerequest.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [USCoreServiceRequestProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-servicerequest.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 3 elements

**Structures**

This structure refers to these other structures:

* [US Core Encounter Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html)
* [US Pathology Specimen(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-specimen)](StructureDefinition-us-pathology-specimen.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 **Differential View** 

This structure is derived from [USCoreServiceRequestProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-servicerequest.html) 

#### Terminology Bindings (Differential)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [USCoreServiceRequestProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-servicerequest.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 3 elements

**Structures**

This structure refers to these other structures:

* [US Core Encounter Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html)
* [US Pathology Specimen(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-specimen)](StructureDefinition-us-pathology-specimen.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 

Other representations of profile: [CSV](StructureDefinition-us-pathology-service-request.csv), [Excel](StructureDefinition-us-pathology-service-request.xlsx), [Schematron](StructureDefinition-us-pathology-service-request.sch) 

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

