# US Pathology Related Practitioner Role - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Related Practitioner Role**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-us-pathology-related-practitioner-role-definitions.md) 
*  [Mappings](StructureDefinition-us-pathology-related-practitioner-role-mappings.md) 
*  [Examples](StructureDefinition-us-pathology-related-practitioner-role-examples.md) 
*  [XML](StructureDefinition-us-pathology-related-practitioner-role.profile.xml.md) 
*  [JSON](StructureDefinition-us-pathology-related-practitioner-role.profile.json.md) 
*  [TTL](StructureDefinition-us-pathology-related-practitioner-role.profile.ttl.md) 

## Resource Profile: US Pathology Related Practitioner Role 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-related-practitioner-role | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologyRelatedPractitionerRole |

 
This profile is built upon US Core PractitionerRole and defines pathology-related role codes for the following pathology-related practitioner roles included in NAACCR: Attending Doctor: PV1-7 Referring Doctor: PV1-8 Consulting Doctor: PV1-9 Admitting Doctor: PV1-17 Collecting Doctor: OBR-10 Ordering Doctor: OBR-16 Principal Results Interpretter: OBR-32 Pathology Responsible Observer: OBX-16 

**Usages:**

* Use this Profile: [US Pathology Bundle](StructureDefinition-us-pathology-bundle.md)
* Refer to this Profile: [US Pathology Composition Laboratory Report](StructureDefinition-us-pathology-composition.md), [US Pathology Diagnostic Report](StructureDefinition-us-pathology-diagnostic-report.md) and [US Pathology Specimen](StructureDefinition-us-pathology-specimen.md)
* Examples for this Profile: [PractitionerRole/practitionerrole-uspath-pathologist](PractitionerRole-practitionerrole-uspath-pathologist.md), [PractitionerRole/practitionerrole-uspath-practitioner-oncologist](PractitionerRole-practitionerrole-uspath-practitioner-oncologist.md) and [PractitionerRole/practitionerrole-uspath-surgeon](PractitionerRole-practitionerrole-uspath-surgeon.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.cancer-reporting|current/StructureDefinition/us-pathology-related-practitioner-role)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Key Elements Table](#tabs-key) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [USCorePractitionerRoleProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitionerrole.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [USCorePractitionerRoleProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitionerrole.html) 

**Summary**

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 **Differential View** 

This structure is derived from [USCorePractitionerRoleProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitionerrole.html) 

#### Terminology Bindings (Differential)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [USCorePractitionerRoleProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitionerrole.html) 

**Summary**

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 

Other representations of profile: [CSV](StructureDefinition-us-pathology-related-practitioner-role.csv), [Excel](StructureDefinition-us-pathology-related-practitioner-role.xlsx), [Schematron](StructureDefinition-us-pathology-related-practitioner-role.sch) 

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

