# US Pathology Diagnostic Report - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Diagnostic Report**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-us-pathology-diagnostic-report-definitions.md) 
*  [Mappings](StructureDefinition-us-pathology-diagnostic-report-mappings.md) 
*  [Examples](StructureDefinition-us-pathology-diagnostic-report-examples.md) 
*  [XML](StructureDefinition-us-pathology-diagnostic-report.profile.xml.md) 
*  [JSON](StructureDefinition-us-pathology-diagnostic-report.profile.json.md) 
*  [TTL](StructureDefinition-us-pathology-diagnostic-report.profile.ttl.md) 

## Resource Profile: US Pathology Diagnostic Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-diagnostic-report | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologyDiagnosticReport |

 
This DiagnosticReport Profile captures data for a report parsed from an eCP Form. 

It is expected that labs will populate dateTimes with the most specific time information known when sending to EHRs (YYYY-MM-DD).

**Usages:**

* Use this Profile: [US Pathology Bundle](StructureDefinition-us-pathology-bundle.md)
* Refer to this Profile: [US Pathology Composition Laboratory Report](StructureDefinition-us-pathology-composition.md)
* Examples for this Profile: [DiagnosticReport/diagnosticreport-breast-invasive-carcinoma](DiagnosticReport-diagnosticreport-breast-invasive-carcinoma.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.cancer-reporting|current/StructureDefinition/us-pathology-diagnostic-report)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Key Elements Table](#tabs-key) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [USCoreDiagnosticReportProfileNoteExchange](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-note.html) 

#### Constraints

#### Terminology Bindings

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [USCoreDiagnosticReportProfileNoteExchange](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-note.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 2 elements

**Structures**

This structure refers to these other structures:

* [US Pathology Service Request(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-service-request)](StructureDefinition-us-pathology-service-request.md)
* [US Core Practitioner Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)
* [US Core Organization Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)
* [US Pathology Related Practitioner Role(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-related-practitioner-role)](StructureDefinition-us-pathology-related-practitioner-role.md)
* [US Core CareTeam Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-careteam.html)
* [US Pathology Specimen(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-specimen)](StructureDefinition-us-pathology-specimen.md)
* [US Pathology Observation(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-observation)](StructureDefinition-us-pathology-observation.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 **Differential View** 

This structure is derived from [USCoreDiagnosticReportProfileNoteExchange](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-note.html) 

#### Constraints

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [USCoreDiagnosticReportProfileNoteExchange](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-note.html) 

**Summary**

Mandatory: 1 element
 Must-Support: 2 elements

**Structures**

This structure refers to these other structures:

* [US Pathology Service Request(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-service-request)](StructureDefinition-us-pathology-service-request.md)
* [US Core Practitioner Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-practitioner.html)
* [US Core Organization Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)
* [US Pathology Related Practitioner Role(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-related-practitioner-role)](StructureDefinition-us-pathology-related-practitioner-role.md)
* [US Core CareTeam Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-careteam.html)
* [US Pathology Specimen(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-specimen)](StructureDefinition-us-pathology-specimen.md)
* [US Pathology Observation(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-observation)](StructureDefinition-us-pathology-observation.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 

Other representations of profile: [CSV](StructureDefinition-us-pathology-diagnostic-report.csv), [Excel](StructureDefinition-us-pathology-diagnostic-report.xlsx), [Schematron](StructureDefinition-us-pathology-diagnostic-report.sch) 

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

