# US Pathology Composition Laboratory Report - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Composition Laboratory Report**

Publication Build: This will be filled in by the publication tooling

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-us-pathology-composition-definitions.md) 
*  [Mappings](StructureDefinition-us-pathology-composition-mappings.md) 
*  [Examples](StructureDefinition-us-pathology-composition-examples.md) 
*  [XML](StructureDefinition-us-pathology-composition.profile.xml.md) 
*  [JSON](StructureDefinition-us-pathology-composition.profile.json.md) 
*  [TTL](StructureDefinition-us-pathology-composition.profile.ttl.md) 

## Resource Profile: US Pathology Composition Laboratory Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-composition | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologyComposition |

 
This Composition profile represents a Laboratory Report for the Clinical Pathology Data Sharing Implementation Guide. 

## Introduction

This US Pathology Composition profile defines how to structure pathology reports based on CAP electronic Cancer Protocols (eCPs) within FHIR.

## Key Elements and Binding Requirements

* **extension:diagnosticReportReference**: 
* DiagnosticReport is bound to both the Observations AND the Composition through this extension
 
* **type**: 
* Bound to the CAP eCP Form Codes ValueSet
* Allows unique identification of the specific CAP Protocol
 
* **section.code**:
* Bound to the CAP eCP Section Codes ValueSet
* **section.entry**: 
* Each entry references a section in the report
 

**Usages:**

* Use this Profile: [US Pathology Bundle](StructureDefinition-us-pathology-bundle.md)
* Examples for this Profile: [Composition/composition-invasive-carcinoma-of-the-breast](Composition-composition-invasive-carcinoma-of-the-breast.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.cancer-reporting|current/StructureDefinition/us-pathology-composition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Key Elements Table](#tabs-key) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

**Summary**

Mandatory: 3 elements(2 nested mandatory elements)
 Must-Support: 1 element

**Structures**

This structure refers to these other structures:

* [US Pathology Diagnostic Report(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-diagnostic-report)](StructureDefinition-us-pathology-diagnostic-report.md)
* [US Core Patient Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)
* [US Core Encounter Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html)
* [US Pathology Related Practitioner Role(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-related-practitioner-role)](StructureDefinition-us-pathology-related-practitioner-role.md)
* [US Pathology Observation(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-observation)](StructureDefinition-us-pathology-observation.md)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/composition-diagnosticReportReference](StructureDefinition-composition-diagnosticReportReference.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 **Differential View** 

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

#### Terminology Bindings (Differential)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Composition](http://hl7.org/fhir/R4/composition.html) 

**Summary**

Mandatory: 3 elements(2 nested mandatory elements)
 Must-Support: 1 element

**Structures**

This structure refers to these other structures:

* [US Pathology Diagnostic Report(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-diagnostic-report)](StructureDefinition-us-pathology-diagnostic-report.md)
* [US Core Patient Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)
* [US Core Encounter Profile(http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html)
* [US Pathology Related Practitioner Role(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-related-practitioner-role)](StructureDefinition-us-pathology-related-practitioner-role.md)
* [US Pathology Observation(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-observation)](StructureDefinition-us-pathology-observation.md)

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/composition-diagnosticReportReference](StructureDefinition-composition-diagnosticReportReference.md)

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 

Other representations of profile: [CSV](StructureDefinition-us-pathology-composition.csv), [Excel](StructureDefinition-us-pathology-composition.xlsx), [Schematron](StructureDefinition-us-pathology-composition.sch) 

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-03 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

